/*
 * Decompiled with CFR 0.152.
 */
package xades4j.verification;

import java.util.Collection;
import org.w3c.dom.Element;
import xades4j.properties.AllDataObjsCommitmentTypeProperty;
import xades4j.properties.CommitmentTypeProperty;
import xades4j.properties.CommitmentTypePropertyBase;
import xades4j.properties.QualifyingProperty;
import xades4j.properties.data.CommitmentTypeData;
import xades4j.verification.CommitmentTypeVerificationException;
import xades4j.verification.QualifyingPropertyVerificationContext;
import xades4j.verification.QualifyingPropertyVerifier;
import xades4j.verification.RawDataObjectDesc;

class CommitmentTypeVerifier
implements QualifyingPropertyVerifier<CommitmentTypeData> {
    CommitmentTypeVerifier() {
    }

    @Override
    public QualifyingProperty verify(CommitmentTypeData propData, QualifyingPropertyVerificationContext ctx) throws CommitmentTypeVerificationException {
        CommitmentTypePropertyBase property;
        String uri = propData.getUri();
        String desc = propData.getDescription();
        Collection<String> objsReferences = propData.getObjReferences();
        if (objsReferences != null) {
            QualifyingPropertyVerificationContext.SignedObjectsData signedObjsData = ctx.getSignedObjectsData();
            CommitmentTypeProperty commitmentTypeProperty = new CommitmentTypeProperty(uri, desc);
            for (String objRef : objsReferences) {
                RawDataObjectDesc dataObj = signedObjsData.findSignedDataObject(objRef);
                if (null == dataObj) {
                    throw new CommitmentTypeVerificationException(objRef);
                }
                dataObj.withCommitmentType(commitmentTypeProperty);
            }
            property = commitmentTypeProperty;
        } else {
            property = new AllDataObjsCommitmentTypeProperty(uri, desc);
        }
        if (propData.getQualifiers() != null) {
            for (Object q : propData.getQualifiers()) {
                if (q instanceof String) {
                    property.withQualifier((String)q);
                    continue;
                }
                if (!(q instanceof Element)) continue;
                property.withQualifier((Element)q);
            }
        }
        return property;
    }
}

