/*
 * Decompiled with CFR 0.152.
 */
package xades4j.verification;

import com.google.inject.Inject;
import org.w3c.dom.Element;
import xades4j.properties.QualifyingProperty;
import xades4j.properties.SignatureTimeStampProperty;
import xades4j.properties.data.SignatureTimeStampData;
import xades4j.providers.TimeStampVerificationProvider;
import xades4j.utils.CannotAddDataToDigestInputException;
import xades4j.utils.DOMHelper;
import xades4j.utils.TimeStampDigestInput;
import xades4j.utils.TimeStampDigestInputFactory;
import xades4j.verification.QualifyingPropertyVerificationContext;
import xades4j.verification.TimeStampVerifierBase;

class SignatureTimeStampVerifier
extends TimeStampVerifierBase<SignatureTimeStampData> {
    @Inject
    public SignatureTimeStampVerifier(TimeStampVerificationProvider timeStampVerifier, TimeStampDigestInputFactory timeStampDigestInputFactory) {
        super(timeStampVerifier, timeStampDigestInputFactory, "SignatureTimeStamp");
    }

    @Override
    protected QualifyingProperty addPropSpecificTimeStampInputAndCreateProperty(SignatureTimeStampData propData, TimeStampDigestInput digestInput, QualifyingPropertyVerificationContext ctx) throws CannotAddDataToDigestInputException {
        Element sigValueElem = DOMHelper.getFirstDescendant(ctx.getSignature().getElement(), "http://www.w3.org/2000/09/xmldsig#", "SignatureValue");
        digestInput.addNode(sigValueElem);
        return new SignatureTimeStampProperty();
    }
}

