/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.signature;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.examples.signature.SigUtils;
import org.apache.pdfbox.examples.signature.cert.CertificateVerificationException;
import org.apache.pdfbox.examples.signature.cert.CertificateVerifier;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.encryption.SecurityProvider;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.util.Hex;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

public final class ShowSignature {
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");

    private ShowSignature() {
    }

    public static void main(String[] stringArray) throws IOException, TSPException, GeneralSecurityException, CertificateVerificationException {
        Security.addProvider(SecurityProvider.getProvider());
        ShowSignature showSignature = new ShowSignature();
        showSignature.showSignature(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showSignature(String[] stringArray) throws IOException, TSPException, GeneralSecurityException, CertificateVerificationException {
        if (stringArray.length != 2) {
            ShowSignature.usage();
        } else {
            String string = stringArray[0];
            File file = new File(stringArray[1]);
            try (PDDocument pDDocument = null;){
                pDDocument = PDDocument.load((File)file, (String)string);
                for (PDSignature pDSignature : pDDocument.getSignatureDictionaries()) {
                    String string2;
                    COSDictionary cOSDictionary = pDSignature.getCOSObject();
                    COSString cOSString = (COSString)cOSDictionary.getDictionaryObject(COSName.CONTENTS);
                    byte[] byArray = null;
                    try (FileInputStream fileInputStream = new FileInputStream(file);){
                        byArray = pDSignature.getSignedContent((InputStream)fileInputStream);
                    }
                    System.out.println("Signature found");
                    int[] nArray = pDSignature.getByteRange();
                    if (nArray.length != 4) {
                        System.err.println("Signature byteRange must have 4 items");
                    } else {
                        long l = file.length();
                        long l2 = (long)nArray[2] + (long)nArray[3];
                        int n = cOSString.getString().length() * 2 + 2;
                        if (l != l2 || nArray[0] != 0 || nArray[1] + n != nArray[2]) {
                            System.out.println("Signature does not cover whole document");
                        } else {
                            System.out.println("Signature covers whole document");
                        }
                    }
                    if (pDSignature.getName() != null) {
                        System.out.println("Name:     " + pDSignature.getName());
                    }
                    if (pDSignature.getSignDate() != null) {
                        System.out.println("Modified: " + this.sdf.format(pDSignature.getSignDate().getTime()));
                    }
                    if ((string2 = pDSignature.getSubFilter()) != null) {
                        Object object;
                        Object object2;
                        Object object3;
                        if (string2.equals("adbe.pkcs7.detached") || string2.equals("ETSI.CAdES.detached")) {
                            this.verifyPKCS7(byArray, cOSString, pDSignature);
                            continue;
                        }
                        if (string2.equals("adbe.pkcs7.sha1")) {
                            object3 = cOSString.getBytes();
                            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                            object2 = new ByteArrayInputStream((byte[])object3);
                            Collection<? extends Certificate> collection = certificateFactory.generateCertificates((InputStream)object2);
                            System.out.println("certs=" + collection);
                            object = MessageDigest.getInstance("SHA1").digest(byArray);
                            this.verifyPKCS7((byte[])object, cOSString, pDSignature);
                            continue;
                        }
                        if (string2.equals("adbe.x509.rsa_sha1")) {
                            object3 = (COSString)cOSDictionary.getDictionaryObject(COSName.CERT);
                            if (object3 == null) {
                                System.err.println("The /Cert certificate string is missing in the signature dictionary");
                                return;
                            }
                            byte[] byArray2 = object3.getBytes();
                            object2 = CertificateFactory.getInstance("X.509");
                            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
                            object = ((CertificateFactory)object2).generateCertificates(byteArrayInputStream);
                            System.out.println("certs=" + (Collection)object);
                            X509Certificate x509Certificate = (X509Certificate)object.iterator().next();
                            try {
                                if (pDSignature.getSignDate() != null) {
                                    x509Certificate.checkValidity(pDSignature.getSignDate().getTime());
                                    System.out.println("Certificate valid at signing time");
                                } else {
                                    System.err.println("Certificate cannot be verified without signing time");
                                }
                            }
                            catch (CertificateExpiredException certificateExpiredException) {
                                System.err.println("Certificate expired at signing time");
                            }
                            catch (CertificateNotYetValidException certificateNotYetValidException) {
                                System.err.println("Certificate not yet valid at signing time");
                            }
                            if (CertificateVerifier.isSelfSigned(x509Certificate)) {
                                System.err.println("Certificate is self-signed, LOL!");
                                continue;
                            }
                            System.out.println("Certificate is not self-signed");
                            if (pDSignature.getSignDate() == null) continue;
                            this.verifyCertificateChain((Store<X509CertificateHolder>)new JcaCertStore((Collection)object), x509Certificate, pDSignature.getSignDate().getTime());
                            continue;
                        }
                        if (string2.equals("ETSI.RFC3161")) {
                            this.verifyETSIdotRFC3161(byArray, cOSString);
                            continue;
                        }
                        System.err.println("Unknown certificate type: " + string2);
                        continue;
                    }
                    throw new IOException("Missing subfilter for cert dictionary");
                }
                this.analyseDSS(pDDocument);
            }
            System.out.println("Analyzed: " + stringArray[1]);
        }
    }

    private void verifyETSIdotRFC3161(byte[] byArray, COSString cOSString) throws CertificateException, CMSException, IOException, OperatorCreationException, TSPException, NoSuchAlgorithmException, CertificateVerificationException {
        TimeStampToken timeStampToken = new TimeStampToken(new CMSSignedData(cOSString.getBytes()));
        System.out.println("Time stamp gen time: " + timeStampToken.getTimeStampInfo().getGenTime());
        System.out.println("Time stamp tsa name: " + timeStampToken.getTimeStampInfo().getTsa().getName());
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(cOSString.getBytes());
        Collection<? extends Certificate> collection = certificateFactory.generateCertificates(byteArrayInputStream);
        System.out.println("certs=" + collection);
        String string = timeStampToken.getTimeStampInfo().getMessageImprintAlgOID().getId();
        if (Arrays.equals(MessageDigest.getInstance(string).digest(byArray), timeStampToken.getTimeStampInfo().getMessageImprintDigest())) {
            System.out.println("ETSI.RFC3161 timestamp signature verified");
        } else {
            System.err.println("ETSI.RFC3161 timestamp signature verification failed");
        }
        X509Certificate x509Certificate = (X509Certificate)collection.iterator().next();
        SigUtils.checkTimeStampCertificateUsage(x509Certificate);
        this.validateTimestampToken(timeStampToken);
        this.verifyCertificateChain((Store<X509CertificateHolder>)timeStampToken.getCertificates(), x509Certificate, timeStampToken.getTimeStampInfo().getGenTime());
    }

    private void verifyPKCS7(byte[] byArray, COSString cOSString, PDSignature pDSignature) throws CMSException, OperatorCreationException, IOException, GeneralSecurityException, TSPException, CertificateVerificationException {
        X509Certificate x509Certificate;
        X509CertificateHolder x509CertificateHolder;
        CMSProcessableByteArray cMSProcessableByteArray = new CMSProcessableByteArray(byArray);
        CMSSignedData cMSSignedData = new CMSSignedData((CMSProcessable)cMSProcessableByteArray, cOSString.getBytes());
        Store store = cMSSignedData.getCertificates();
        Collection collection = cMSSignedData.getSignerInfos().getSigners();
        SignerInformation signerInformation = (SignerInformation)collection.iterator().next();
        Collection collection2 = store.getMatches((Selector)signerInformation.getSID());
        X509CertificateHolder x509CertificateHolder2 = (X509CertificateHolder)collection2.iterator().next();
        X509Certificate x509Certificate2 = new JcaX509CertificateConverter().getCertificate(x509CertificateHolder2);
        System.out.println("certFromSignedData: " + x509Certificate2);
        SigUtils.checkCertificateUsage(x509Certificate2);
        TimeStampToken timeStampToken = this.extractTimeStampTokenFromSignerInformation(signerInformation);
        if (timeStampToken != null) {
            this.validateTimestampToken(timeStampToken);
            x509CertificateHolder = (X509CertificateHolder)timeStampToken.getCertificates().getMatches(null).iterator().next();
            x509Certificate = new JcaX509CertificateConverter().getCertificate(x509CertificateHolder);
            HashSet hashSet = new HashSet();
            hashSet.addAll(store.getMatches(null));
            hashSet.addAll(timeStampToken.getCertificates().getMatches(null));
            this.verifyCertificateChain((Store<X509CertificateHolder>)new CollectionStore(hashSet), x509Certificate, timeStampToken.getTimeStampInfo().getGenTime());
            SigUtils.checkTimeStampCertificateUsage(x509Certificate);
        }
        try {
            if (pDSignature.getSignDate() != null) {
                x509Certificate2.checkValidity(pDSignature.getSignDate().getTime());
                System.out.println("Certificate valid at signing time");
            } else {
                System.err.println("Certificate cannot be verified without signing time");
            }
        }
        catch (CertificateExpiredException certificateExpiredException) {
            System.err.println("Certificate expired at signing time");
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            System.err.println("Certificate not yet valid at signing time");
        }
        if (signerInformation.getSignedAttributes() != null && (x509CertificateHolder = signerInformation.getSignedAttributes().get(CMSAttributes.signingTime)) != null) {
            x509Certificate = Time.getInstance((Object)x509CertificateHolder.getAttrValues().getObjectAt(0));
            try {
                x509Certificate2.checkValidity(x509Certificate.getDate());
                System.out.println("Certificate valid at signing time: " + x509Certificate.getDate());
            }
            catch (CertificateExpiredException certificateExpiredException) {
                System.err.println("Certificate expired at signing time");
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                System.err.println("Certificate not yet valid at signing time");
            }
        }
        if (signerInformation.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(SecurityProvider.getProvider()).build(x509Certificate2))) {
            System.out.println("Signature verified");
        } else {
            System.out.println("Signature verification failed");
        }
        if (CertificateVerifier.isSelfSigned(x509Certificate2)) {
            System.err.println("Certificate is self-signed, LOL!");
        } else {
            System.out.println("Certificate is not self-signed");
            if (pDSignature.getSignDate() != null) {
                this.verifyCertificateChain((Store<X509CertificateHolder>)store, x509Certificate2, pDSignature.getSignDate().getTime());
            } else {
                System.err.println("Certificate cannot be verified without signing time");
            }
        }
    }

    private TimeStampToken extractTimeStampTokenFromSignerInformation(SignerInformation signerInformation) throws CMSException, IOException, TSPException {
        if (signerInformation.getUnsignedAttributes() == null) {
            return null;
        }
        AttributeTable attributeTable = signerInformation.getUnsignedAttributes();
        Attribute attribute = attributeTable.get(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken);
        if (attribute == null) {
            return null;
        }
        ASN1Object aSN1Object = (ASN1Object)attribute.getAttrValues().getObjectAt(0);
        CMSSignedData cMSSignedData = new CMSSignedData(aSN1Object.getEncoded());
        return new TimeStampToken(cMSSignedData);
    }

    private void verifyCertificateChain(Store<X509CertificateHolder> store, X509Certificate x509Certificate, Date date) throws CertificateVerificationException, CertificateException {
        Collection collection = store.getMatches(null);
        HashSet<X509Certificate> hashSet = new HashSet<X509Certificate>();
        JcaX509CertificateConverter jcaX509CertificateConverter = new JcaX509CertificateConverter();
        for (X509CertificateHolder x509CertificateHolder : collection) {
            X509Certificate x509Certificate2 = jcaX509CertificateConverter.getCertificate(x509CertificateHolder);
            if (x509Certificate2.equals(x509Certificate)) continue;
            hashSet.add(x509Certificate2);
        }
        CertificateVerifier.verifyCertificate(x509Certificate, hashSet, true, date);
    }

    private void validateTimestampToken(TimeStampToken timeStampToken) throws IOException, CertificateException, TSPException, OperatorCreationException {
        Collection collection = timeStampToken.getCertificates().getMatches((Selector)timeStampToken.getSID());
        X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)collection.iterator().next();
        X509Certificate x509Certificate = new JcaX509CertificateConverter().getCertificate(x509CertificateHolder);
        SignerInformationVerifier signerInformationVerifier = new JcaSimpleSignerInfoVerifierBuilder().setProvider(SecurityProvider.getProvider()).build(x509Certificate);
        timeStampToken.validate(signerInformationVerifier);
        System.out.println("TimeStampToken validated");
    }

    private void analyseDSS(PDDocument pDDocument) throws IOException {
        PDDocumentCatalog pDDocumentCatalog = pDDocument.getDocumentCatalog();
        COSBase cOSBase = pDDocumentCatalog.getCOSObject().getDictionaryObject("DSS");
        if (cOSBase instanceof COSDictionary) {
            COSBase cOSBase2;
            COSBase cOSBase3;
            COSDictionary cOSDictionary = (COSDictionary)cOSBase;
            System.out.println("DSS Dictionary: " + cOSDictionary);
            COSBase cOSBase4 = cOSDictionary.getDictionaryObject("Certs");
            if (cOSBase4 instanceof COSArray) {
                this.printStreamsFromArray((COSArray)cOSBase4, "Cert");
            }
            if ((cOSBase3 = cOSDictionary.getDictionaryObject("OCSPs")) instanceof COSArray) {
                this.printStreamsFromArray((COSArray)cOSBase3, "Ocsp");
            }
            if ((cOSBase2 = cOSDictionary.getDictionaryObject("CRLs")) instanceof COSArray) {
                this.printStreamsFromArray((COSArray)cOSBase2, "CRL");
            }
        }
    }

    private void printStreamsFromArray(COSArray cOSArray, String string) throws IOException {
        for (COSBase cOSBase : cOSArray) {
            COSObject cOSObject = (COSObject)cOSBase;
            if (!(cOSObject.getObject() instanceof COSStream)) continue;
            COSStream cOSStream = (COSStream)cOSObject.getObject();
            COSInputStream cOSInputStream = cOSStream.createInputStream();
            byte[] byArray = IOUtils.toByteArray((InputStream)cOSInputStream);
            cOSInputStream.close();
            System.out.println(string + " (" + cOSArray.indexOf((COSBase)cOSObject) + "): " + Hex.getString((byte[])byArray));
        }
    }

    private static void usage() {
        System.err.println("usage: java " + ShowSignature.class.getName() + " <password (usually empty)> <inputfile>");
    }
}

