/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.signature.cert;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.examples.signature.cert.CertificateVerificationException;
import org.apache.pdfbox.examples.signature.cert.CertificateVerifier;
import org.apache.pdfbox.examples.signature.cert.RevokedCertificateException;
import org.apache.pdfbox.pdmodel.encryption.SecurityProvider;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;

public final class CRLVerifier {
    private static final Log LOG = LogFactory.getLog(CRLVerifier.class);

    private CRLVerifier() {
    }

    public static void verifyCertificateCRLs(X509Certificate x509Certificate, Date date, Set<X509Certificate> set) throws CertificateVerificationException, RevokedCertificateException {
        try {
            Date date2 = Calendar.getInstance().getTime();
            Exception exception = null;
            List<String> list = CRLVerifier.getCrlDistributionPoints(x509Certificate);
            for (String string : list) {
                X509CRL x509CRL;
                LOG.info((Object)("Checking distribution point URL: " + string));
                try {
                    x509CRL = CRLVerifier.downloadCRL(string);
                }
                catch (Exception exception2) {
                    LOG.warn((Object)("Caught " + exception2.getClass().getSimpleName() + " downloading CRL, will try next distribution point if available"));
                    if (exception != null) continue;
                    exception = exception2;
                    continue;
                }
                Set<X509Certificate> set2 = CertificateVerifier.downloadExtraCertificates(x509CRL);
                set2.addAll(set);
                Certificate certificate = null;
                for (X509Certificate x509Certificate2 : set2) {
                    if (!x509CRL.getIssuerX500Principal().equals(x509Certificate2.getSubjectX500Principal())) continue;
                    certificate = x509Certificate2;
                    break;
                }
                if (certificate == null) {
                    throw new CertificateVerificationException("Certificate for " + x509CRL.getIssuerX500Principal() + "not found in certificate chain, so the CRL at " + string + " could not be verified");
                }
                x509CRL.verify(certificate.getPublicKey(), SecurityProvider.getProvider().getName());
                if (!x509CRL.getIssuerX500Principal().equals(x509Certificate.getIssuerX500Principal())) {
                    LOG.info((Object)"CRL issuer certificate is not identical to cert issuer, check needed");
                    CertificateVerifier.verifyCertificate((X509Certificate)certificate, set2, true, date2);
                    LOG.info((Object)"CRL issuer certificate checked successfully");
                } else {
                    LOG.info((Object)"CRL issuer certificate is identical to cert issuer, no extra check needed");
                }
                CRLVerifier.checkRevocation(x509CRL, x509Certificate, date, string);
                return;
            }
            if (exception != null) {
                throw exception;
            }
        }
        catch (CertificateVerificationException certificateVerificationException) {
            throw certificateVerificationException;
        }
        catch (RevokedCertificateException revokedCertificateException) {
            throw revokedCertificateException;
        }
        catch (Exception exception) {
            throw new CertificateVerificationException("Cannot verify CRL for certificate: " + x509Certificate.getSubjectX500Principal(), exception);
        }
    }

    public static void checkRevocation(X509CRL x509CRL, X509Certificate x509Certificate, Date date, String string) throws RevokedCertificateException {
        X509CRLEntry x509CRLEntry = x509CRL.getRevokedCertificate(x509Certificate);
        if (x509CRLEntry != null && x509CRLEntry.getRevocationDate().compareTo(date) <= 0) {
            throw new RevokedCertificateException("The certificate was revoked by CRL " + string + " on " + x509CRLEntry.getRevocationDate(), x509CRLEntry.getRevocationDate());
        }
        if (x509CRLEntry != null) {
            LOG.info((Object)("The certificate was revoked after signing by CRL " + string + " on " + x509CRLEntry.getRevocationDate()));
        } else {
            LOG.info((Object)("The certificate was not revoked by CRL " + string));
        }
    }

    private static X509CRL downloadCRL(String string) throws IOException, CertificateException, CRLException, CertificateVerificationException, NamingException {
        if (string.startsWith("http://") || string.startsWith("https://") || string.startsWith("ftp://")) {
            return CRLVerifier.downloadCRLFromWeb(string);
        }
        if (string.startsWith("ldap://")) {
            return CRLVerifier.downloadCRLFromLDAP(string);
        }
        throw new CertificateVerificationException("Can not download CRL from certificate distribution point: " + string);
    }

    private static X509CRL downloadCRLFromLDAP(String string) throws CertificateException, NamingException, CRLException, CertificateVerificationException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        hashtable.put("java.naming.provider.url", string);
        hashtable.put("com.sun.jndi.ldap.connect.timeout", "1000");
        InitialDirContext initialDirContext = new InitialDirContext(hashtable);
        Attributes attributes = initialDirContext.getAttributes("");
        Attribute attribute = attributes.get("certificateRevocationList;binary");
        byte[] byArray = (byte[])attribute.get();
        if (byArray == null || byArray.length == 0) {
            throw new CertificateVerificationException("Can not download CRL from: " + string);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        return (X509CRL)certificateFactory.generateCRL(byteArrayInputStream);
    }

    public static X509CRL downloadCRLFromWeb(String string) throws IOException, CertificateException, CRLException {
        try (InputStream inputStream = new URL(string).openStream();){
            X509CRL x509CRL = (X509CRL)CertificateFactory.getInstance("X.509").generateCRL(inputStream);
            return x509CRL;
        }
    }

    public static List<String> getCrlDistributionPoints(X509Certificate x509Certificate) throws IOException {
        byte[] byArray = x509Certificate.getExtensionValue(Extension.cRLDistributionPoints.getId());
        if (byArray == null) {
            return new ArrayList<String>();
        }
        ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(byArray));
        ASN1Primitive aSN1Primitive = aSN1InputStream.readObject();
        DEROctetString dEROctetString = (DEROctetString)aSN1Primitive;
        byte[] byArray2 = dEROctetString.getOctets();
        ASN1InputStream aSN1InputStream2 = new ASN1InputStream((InputStream)new ByteArrayInputStream(byArray2));
        ASN1Primitive aSN1Primitive2 = aSN1InputStream2.readObject();
        CRLDistPoint cRLDistPoint = CRLDistPoint.getInstance((Object)aSN1Primitive2);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DistributionPoint distributionPoint : cRLDistPoint.getDistributionPoints()) {
            DistributionPointName distributionPointName = distributionPoint.getDistributionPoint();
            if (distributionPointName == null || distributionPointName.getType() != 0) continue;
            for (GeneralName generalName : GeneralNames.getInstance((Object)distributionPointName.getName()).getNames()) {
                if (generalName.getTagNo() != 6) continue;
                String string = DERIA5String.getInstance((Object)generalName.getName()).getString();
                arrayList.add(string);
            }
        }
        return arrayList;
    }
}

