/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.signature.validation;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.examples.signature.validation.CertInformationCollector;
import org.apache.pdfbox.util.Hex;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;

public class CertInformationHelper {
    private static final Log LOG = LogFactory.getLog(CertInformationHelper.class);

    private CertInformationHelper() {
    }

    protected static String getSha1Hash(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            return Hex.getString((byte[])messageDigest.digest(byArray));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOG.error((Object)"No SHA-1 Algorithm found", (Throwable)noSuchAlgorithmException);
            return null;
        }
    }

    protected static void getAuthorityInfoExtensionValue(byte[] byArray, CertInformationCollector.CertSignatureInformation certSignatureInformation) throws IOException {
        ASN1Sequence aSN1Sequence = (ASN1Sequence)JcaX509ExtensionUtils.parseExtensionValue((byte[])byArray);
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            DEROctetString dEROctetString;
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)enumeration.nextElement();
            ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)aSN1Sequence2.getObjectAt(0);
            DERTaggedObject dERTaggedObject = (DERTaggedObject)aSN1Sequence2.getObjectAt(1);
            if (aSN1ObjectIdentifier.equals((Object)X509ObjectIdentifiers.id_ad_ocsp) && dERTaggedObject.getTagNo() == 6) {
                dEROctetString = (DEROctetString)dERTaggedObject.getObject();
                certSignatureInformation.setOcspUrl(new String(dEROctetString.getOctets()));
                continue;
            }
            if (!aSN1ObjectIdentifier.equals((Object)X509ObjectIdentifiers.id_ad_caIssuers)) continue;
            dEROctetString = (DEROctetString)dERTaggedObject.getObject();
            certSignatureInformation.setIssuerUrl(new String(dEROctetString.getOctets()));
        }
    }

    protected static String getCrlUrlFromExtensionValue(byte[] byArray) throws IOException {
        ASN1Sequence aSN1Sequence = (ASN1Sequence)JcaX509ExtensionUtils.parseExtensionValue((byte[])byArray);
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            DEROctetString dEROctetString;
            String string;
            DLSequence dLSequence = (DLSequence)enumeration.nextElement();
            DERTaggedObject dERTaggedObject = (DERTaggedObject)dLSequence.getObjectAt(0);
            dERTaggedObject = (DERTaggedObject)dERTaggedObject.getObject();
            if (!((dERTaggedObject = (DERTaggedObject)dERTaggedObject.getObject()).getObject() instanceof DEROctetString) || !(string = new String((dEROctetString = (DEROctetString)dERTaggedObject.getObject()).getOctets())).startsWith("http")) continue;
            return string;
        }
        return null;
    }
}

