/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.ant;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.renderers.CSVRenderer;
import net.sourceforge.pmd.renderers.EmacsRenderer;
import net.sourceforge.pmd.renderers.HTMLRenderer;
import net.sourceforge.pmd.renderers.PapariTextRenderer;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.renderers.SummaryHTMLRenderer;
import net.sourceforge.pmd.renderers.TextRenderer;
import net.sourceforge.pmd.renderers.VBHTMLRenderer;
import net.sourceforge.pmd.renderers.XMLRenderer;
import net.sourceforge.pmd.renderers.XSLTRenderer;
import net.sourceforge.pmd.renderers.YAHTMLRenderer;
import org.apache.tools.ant.BuildException;

public class Formatter {
    private File toFile;
    private String linkPrefix;
    private String linePrefix;
    private String type;
    private boolean toConsole;
    private boolean showSuppressed;
    private static final Map<String, RendererBuilder> renderersByCode = new HashMap<String, RendererBuilder>(8);
    private Writer writer;
    private Renderer renderer;

    public void setShowSuppressed(boolean value) {
        this.showSuppressed = value;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setLinkPrefix(String linkPrefix) {
        this.linkPrefix = linkPrefix;
    }

    public void setToFile(File toFile) {
        this.toFile = toFile;
    }

    public void setToConsole(boolean toConsole) {
        this.toConsole = toConsole;
    }

    public void setLinePrefix(String linePrefix) {
        this.linePrefix = linePrefix;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public void start(String baseDir) {
        try {
            if (this.toConsole) {
                this.writer = new BufferedWriter(new OutputStreamWriter(System.out));
            }
            if (this.toFile != null) {
                this.writer = this.getToFileWriter(baseDir);
            }
            this.renderer = this.getRenderer(this.toConsole);
            this.renderer.setWriter(this.writer);
            this.renderer.start();
        }
        catch (IOException ioe) {
            throw new BuildException(ioe.getMessage());
        }
    }

    public void end(Report errorReport) {
        try {
            this.renderer.renderFileReport(errorReport);
            this.renderer.end();
            this.writer.write(PMD.EOL);
            if (this.toConsole) {
                this.writer.flush();
            } else {
                this.writer.close();
            }
        }
        catch (IOException ioe) {
            throw new BuildException(ioe.getMessage());
        }
    }

    public boolean isNoOutputSupplied() {
        return this.toFile == null && !this.toConsole;
    }

    public String toString() {
        return "file = " + this.toFile + "; renderer = " + this.type;
    }

    private static String[] validRendererCodes() {
        return renderersByCode.keySet().toArray(new String[renderersByCode.size()]);
    }

    private static String unknownRendererMessage(String userSpecifiedType) {
        StringBuffer sb = new StringBuffer(100);
        sb.append("Formatter type must be one of: '");
        String[] typeCodes = Formatter.validRendererCodes();
        sb.append(typeCodes[0]);
        for (int i = 1; i < typeCodes.length; ++i) {
            sb.append("', '").append(typeCodes[i]);
        }
        sb.append("', or a class name; you specified: ");
        sb.append(userSpecifiedType);
        return sb.toString();
    }

    private Renderer fromClassname(String rendererClassname) {
        try {
            return (Renderer)Class.forName(rendererClassname).newInstance();
        }
        catch (Exception e) {
            throw new BuildException(Formatter.unknownRendererMessage(rendererClassname));
        }
    }

    private Renderer getRenderer(boolean consoleRenderer) {
        if ("".equals(this.type)) {
            throw new BuildException(Formatter.unknownRendererMessage("<unspecified>"));
        }
        RendererBuilder builder = renderersByCode.get(this.type);
        Renderer renderer = builder == null ? this.fromClassname(this.type) : builder.build(new String[]{this.linkPrefix, this.linePrefix});
        renderer.showSuppressedViolations(this.showSuppressed);
        return renderer;
    }

    private Writer getToFileWriter(String baseDir) throws IOException {
        if (!this.toFile.isAbsolute()) {
            return new BufferedWriter(new FileWriter(new File(baseDir + System.getProperty("file.separator") + this.toFile.getPath())));
        }
        return new BufferedWriter(new FileWriter(this.toFile));
    }

    static {
        renderersByCode.put("xml", new RendererBuilder(){

            public Renderer build(Object[] arg) {
                return new XMLRenderer();
            }
        });
        renderersByCode.put("betterhtml", new RendererBuilder(){

            public Renderer build(Object[] arg) {
                return new XSLTRenderer();
            }
        });
        renderersByCode.put("html", new RendererBuilder(){

            public Renderer build(Object[] arg) {
                return new HTMLRenderer((String)arg[0], (String)arg[1]);
            }
        });
        renderersByCode.put("summaryhtml", new RendererBuilder(){

            public Renderer build(Object[] arg) {
                return new SummaryHTMLRenderer((String)arg[0], (String)arg[1]);
            }
        });
        renderersByCode.put("papari", new RendererBuilder(){

            public Renderer build(Object[] arg) {
                return new PapariTextRenderer();
            }
        });
        renderersByCode.put("csv", new RendererBuilder(){

            public Renderer build(Object[] arg) {
                return new CSVRenderer();
            }
        });
        renderersByCode.put("emacs", new RendererBuilder(){

            public Renderer build(Object[] arg) {
                return new EmacsRenderer();
            }
        });
        renderersByCode.put("vbhtml", new RendererBuilder(){

            public Renderer build(Object[] arg) {
                return new VBHTMLRenderer();
            }
        });
        renderersByCode.put("yahtml", new RendererBuilder(){

            public Renderer build(Object[] arg) {
                return new YAHTMLRenderer();
            }
        });
        renderersByCode.put("text", new RendererBuilder(){

            public Renderer build(Object[] arg) {
                return new TextRenderer();
            }
        });
    }

    private static interface RendererBuilder {
        public Renderer build(Object[] var1);
    }
}

