/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2007-2015 Broad Institute
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package org.broad.igv.ui.supdiagram;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordSetBuilder;
import htsjdk.samtools.SAMTag;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.SAMAlignment;
import org.broad.igv.sam.SupplementaryGroup;

import javax.swing.*;
import java.awt.*;
import java.util.ArrayList;
import java.util.List;


public class SupplementaryAlignmentDiagramDialog extends JDialog {

    public static final Color ARC_HIGHLIGHT_COLOR = Color.CYAN;

    private final SupplementalAlignmentDiagram diagram;

    public SupplementaryAlignmentDiagramDialog(Frame frame, Alignment alignment, Dimension dimension) {
        super(frame);
        setSize(dimension);
        setLocationRelativeTo(frame);
        diagram = new SupplementalAlignmentDiagram(new SupplementaryGroup(alignment));
        this.add(diagram);

        //todo make this only on top of the parent window, not all applications?
        setAlwaysOnTop(true);
        setTitle("SAs for " + alignment.getReadName());
        setDefaultCloseOperation(DISPOSE_ON_CLOSE);

        diagram.setVisible(true);
    }


    //for quick component testing
    public static void main(String[] args){
        final SAMRecordSetBuilder samRecords = new SAMRecordSetBuilder();
        samRecords.addPair("read1", 13, 50255292, 50255400 );
        final List<SAMRecord> records = new ArrayList<>(samRecords.getRecords());

        final SAMRecord record = records.get(0);
        record.setAlignmentStart(10000);

        String read = "m141213_163442_00118_c100750562550000001823151707081585_s1_p0/6849/0_5821\t2064\t14\t50255292\t38\t1302S12M1I5M1I25M1D12M1I7M1I2M1I10M1D4M1I7M1I10M1I6M1I4M1D9M5I4M1I4M2I18M1I9M1I5M1I20M1I13M1I6M1I6M1I16M1I3M1I13M1D9M1I4M2I4M1D14M1I21M1I1M1D5M11I2M1I11M1D10M1I12M2I6M1D3M1D11M1D3M1I3M1I19M1I3M2I6M1I8M1D1M2I1M1I6M1I9M3I2M1I4M1I1M1I10M1D1M1I9M1D6M1D4M2D6M2D7M1D13M1I5M1D6M1D8M1I3M4I3M2D1M1D9M1D25M1I4M1D20M1I18M1I9M1D3M1I2M1I4M1I6M1I5M1I18M1I4M3I17M1I1M1I9M1I11M1I24M1I5M1D14M3I16M1I23M2I14M1I6M1I10M1I10M1I13M2I15M1D10M1I12M1I2M1I6M1I11M1I5M1I4M1I11M1I6M1I9M1I19M1I1M1I29M1D23M1D16M1I23M1D3M1I2M1D9M1I20M2I4M1D19M1I11M1D21M1I5M1I11M1I2M1D2M1D7M1D16M1I4M1I8M1D9M1D18M1I12M1I9M1D5M1D5M1I5M1I5M1I36M1D7M3145S\t*\t0\t0\tATTCAAGGCACCAGCAGATTCTTGTCTGAATAGGGCTTGCCCCTCAAAGATTGGTACCTATAAGGCTGAGGTTGGGTGGCTCATACCTGTAATCCCAGCACTTTGGCGAGGCCAAGGTCGGGGGGATCCTTGGCCCAGGAGATTCGACACCAGCCTGCGGCAACAAGGGAGACCTCAATCTTAAAAAAAAGATGGCACCTTATTGCAGTGTACCTCACGTGGCAACAGGGGCACTCATCCTCATTCATGACACAGAGGCCCCTCGTTGACTTCACTTCCTAAAGGCCACTCTTAAATACCATCCACACTGGGCTATTTAGGTTCCCATATATGAATGTGGGGATAATTAACTGTAGAACCATAGCAGCCGTAACTCATGAAAGAACATTAATAAGTTTAACACCTCAGTGAGTATTTGTTGAGTCGTAGGATTAACAGAACATAAGGTTATTTGTAACAAATTTTTTAAAAAGACCACCAAAAATGGTTTTAGTCATTACTAAACCAACAGTGTCAGCAGGAAAAAAAGAAAATAGTAATTACAGAATTCCCGTAAGACATTACCTGCCATAAACTGGAGCACACAATTCATAACTCAAGCTTGACATAAAAAAATGCTGGTGGCAAAAGTAAAATATTTTTATTGCCTCTATTTTAGCCGTTATTAAAAACATAAACAGGCTGGTGACATGGTGTCTTACAGCCTGTATCCCAACACTTTGGGAGGCCAAGGGCAGGCGGAATTCACGGAGATCAGGACGATTTCAAGACCAGCACTGGCCAACAATGGTTGAACCCCAATTCACCACTTAAAATACCAAAATAAGCCAGGCGTAGATGGCGCATTTGCTTAGTAATCCCAAGCTACTCAGAAGGCTGAGGCGGATAATTGCTTGAATCACGGGAGGTGGCAGGTTGCCAGTGAGCTGAGATTGTGCCACTTGCACTCCAGCCTGGGACAAGAGCCGAGCGACTGCCTCAAAAAAAAAAAAAAAAAAAAAAAAATTCAAAGAGAGGTAAATTTCATGTAAGAAGATATACAGCAAGGCGTGGGCTTGGCTGTACTAGTTAACAAAACAATATGTGTGTAGGCGATGTGTCTGTCTTAGCTGGAAAATATTCGTCAGTGGTTTTGTAACCAGGGTACTTGGCTCTTTAAATGGTGTACTCGATGTTCAACATTATGTACGACCATATTGGTGTATAGATCGTGAGTGTGTTAGGAGTGTGGATGAAATTTATTTGTGGGGTGTCTTCAACAGACTGTTTCCAATTATTCTCTGTGTTGGTTTTTTGTGTGTGTTGAGATGGAGTACTCGCATCTGTCGACCAGGCTGGAGTGCAATGCACAATCTCGGACTCACTGACACAGCTCTGCCTCCAGAGTTCACGACTATTCTGCCTTCAGCCTTCCCAGTAGCTGAGGGGGGACTAACAGAGGCGCTCACCACCACACCCAGGCTAATTTCTTTTGTTATTTTTTTAGTAGAGACAGCGGTTTCACCACGTATAGCCAGGCATGGTTCTCAATTTCCTGACCTTTGTTGATCTGCCTGCCTGGCCTCTCAAAAGATTGCTGGATTACAGGCGTGAAGCCACCGTGCCAGGCCTCTCATTCTTATCTTTTTTTTTATATTAACTCAGTTCCATCAGAATCCAAAGCCTCTCCGCTTAAAATGATACTTCCTAAAGCTCTGTAAACCAAATTGTTATCAGCTAATCGAAGTACTAACCATTCTATTTGGCTTAGCATAAGATACGTGTGTGGATGTGGTAGTGTCTCGTGGTGTGTGTTGGTTGTATTGTGATGGGGGGGTGTCACTTGTCTTGTGTGGTGTACTGTGGTGCCAGTGTGGTTCCTGACTCCAGGAGGGTAATCACCCTAATTAAGAAGCAGGAAGCCACAAAGTAGCCATACCTTAGTCATCATGTGGATCATCTTACAGCAAATCTCTGTTAACTTCATAACGTTATAAACCTCAAGGAACGGAGTATTCTATTTTCTTAATGTTGTCAGAGGCACCCTCTGTCCCACCTCTAGGTTTTCTGGGGCTGTTTCTTCACAGGTTTGGTCTTTGTTTTTCCTTGGTTCTTCCCCTTCTTCCCTTTTTTCTTCTTTGTTTGAACCTGACCAGACTTTAATTCAGTAGAGGAAAACATCAGTCCAGTGTTGTATTTTTCAATACTGTGGGAATATTTTTACAAGATGTATTGAATTGCCTGTCATACGGCATAGGCAGGTGGGCTAGATGGCCCATTTTGAAAAAGCAAAAGAAAAAAATTGTTTTTAGAATGTTATTTACCCCCAGCATACCTTCATGATAAGTTCACGGTCTTCTTCATCTGGTCTTTGTATTTTTCTTTCATTTTTTCATTTGACTCTTACAAATTCAGAAGATTTTGGTTGAATATTTCAGCAGCAAAAAAAATGTCAACAAATACTTTTGCAAGAAATGGTGTTACTTTATTATTCTCTGTCAAAATGCTTACTGAATAAGGCAACCATATATAATAAACATATTGAGGCTACAAGTTGGATAACTGAAGGTCCTTCATCTTCAGGAATTTACATAGGGTGGAGAGAAGATTACACAGAGAAGTTAAGAATACTTAACAAACATTAAAGAAACTGTTGAGGAAGAAATAAAGTAAAACAGTATTGGAAAAGCAGTCTAATCCTCCTGCCTCAGCCTCCGAGTAGCTGGGGACTACAAGCGCTGCTGCCATGCCCGGCTAATTTTCTGTTATTTTTTAGTAGAGATGGGGTTATTCCACTGTATTAGCCAGGATGGTCTCCAATCTCCTGACTTGTGATTGCCCGCCTCGCCTCCCAAATTGCTGCGGATTTAACAGCGATGAGCCACCACTGCACCGGCCAAAAGTTTTTAAAAAATATAGTCTCAAGAAAGCATAACCATACTGTTAGTTGTGTTTAACTACTAAAAAATGAGGGGGTCCAAAATTTGGACTTCTGAGCAACTAAACAAAATAGAAACATGATCGTTTATATGGATCTTTCCAATGAGCCTATTAACTTTTCTCCTTCTTTAAATCCAATGGTTTAATTTTCAATATTTTCATTTATCAAGTGATAACATTAAGTAAACAAAAATTAAAATCACATTTTTTACCTTAGGTTGTGAGCTGATTGTGTCCTCCAAAAGATAGTGATTGAGGACAATCTCCACGTTTACCTATGAAGTGTGGCCTTATTTGGTTGATAGTGTCTTTCAGATGTAAGCAAGTTAAAATGATATTCTATACTGGATTAGGGTGGGCCCTTAAATCCAACAACTTCTGACATTATGAGAAAGGCATGTTGGGAAGAACATCGAGACAGAAATACACAATTGAAACATGAAATTGTTGACAGAGCAGGACTTGCCATGCTCACTGTAGCCAGGAAATGCTGAGGACCACCCGCAGCCACAGGAAGCTCCACAGAGGACAAGAAGAATTTTCCTCTACCAAGAACCTTCAAGAAAAGCCAGGTTCTTGTGGTGGGCGTGCTTTCATTCATACTTGCAGGTCTTCAAAACTGTGAGGCAATAATTTCTGTTGCTTTTAAAGCCACTCGGTTTGTGGTCATTTGCCACGCGCCTAGGAATCAAAACTAACTATCAACTGGCCAACTTTCGGTTGTTTTTATTTATTTTTTATTTTCATTTTTATTTTATTTTTTTATTTGTTTGAGATGGAGTCTCCCTTGTTGCCCCAGCTGGAGTGCAGAGTGGGCTATGATCCTCAAGCTCACTTGCAACCCCATGGGCCTCCTGGGTTCAAGTGATTCTCCTTGCTCAGCTCCTGAGTAGCTGGGATATACAGGCACACGCCACCATGCGCGGCTAAATTTTTTGTATTTGAGTAGGACGAGGGGTTCACCTGTTGGCCCAAGGCTTTGGATTCTCGAAACTCCTGACGTCAAAAGTGGATCCGCCCACCTTGGCTTCCAAAAGTGCTGGATTTACAGGCGAAAAGCCACTGCACCCAGCCTGTTTTTAATTAACACCATTTTGGTTTGAAATGCTAGAAGGAATTGGGACATTTAACATATACTTTCATTAGAGAGTAATTTTTTTATTGTAAGATATTAATTTTCTGTTTTTCTTTTTCATCATCTCTTTTTTCTAAAGTTTTCAATGTTGAGCTTGTATATCTTTTTGCAATAACAAAAACTTTCATTTAAAAACACTATTGTCACCATTATTTAACATTTTTCTCGTAAGTTTCTAGCGGTAAGTGGCTAAGAAATGGATGTCGGGTTTGATTTTAACAGCTCCCTGGGTCGGGGAGAACAGGGTTGGACTTGAAATCACAGGAAACATGAATCTTCAGTCCCAAGCTGTGCCATTTCCAGCTGTATGATCTTGAGTAAGCCACTGAACTTTTCGTAAACCTCAAGTTTCCCCCACCTCCCTATGATGTTGTTTCTATTGGGCTCTTCAATTTTCTACCACCGTGTGCCCTTTAAAGAAGGATGAGAGCAAGAGGGAAACAAATGTCAAACATTAATTGCATTTTTAATACAGTTCACTGGAGGATGACCCTGGGGAAGAGGGATTGAGGGAAATCAATTCTGGTGATGAAAACAATAATCGAGAATTACAAGAAGGGTCACAGCTTTAAATCTGGATTAGAGAGAAAAATGCCTCTGCATTTTTCTTTGCCTTTGTGGGGTTCAGTCAGACTGTTACTTGATTCAATGTTTACTGTGATTCAAACAGTTCTGAGGGGAAATGCTTTGTGTGTCATCAACTATTACAGACACTGAGGGGACAGAGATGTTCCAGACATAACCCTGTTTTCCTTCATGTGGGCTTCTCTTGTGAGTGGGTGAAGGGTGGGGTCAAAGTACTAGATGGATTTTTTTTAAATTTTTTATATTGTACTTTAAGTTTTAGGGGTACATGTGCACAAATGTACAGGTTTGTTACATATATTTACATGTGCCCATGTTTGGTGTGCTGCAACCATTAACTCGTCAGTTAACATTTAGGGTTATAATCTCCTAATGCTATTCTACCCCGCTCCCGCACCCATAACAGGCTTCTGTTATTGATGTTTCCCTTTTCTGTGTCCATGTGTTTCTCATTGTTCAATTCCACCTGTTGAGTGAGACATGCCAGTGTTTTTGGTTTTTTGTCCTTGTTTGATGTTTGCGGAGAATGAATGGTTTTCCAGCTTCATCCATGTCCCTACAAAGACATGAAAATTCATTTAAGATGGATTTTTTTAAATGACAAAGCAGAATCAGAAAAAATGGCTAAGAGAGGATGAATTGGCTGAGCCTTCTTTTCCATGCATTGGTGTCACCTTTATAAAGGATTGTGAAAATGTCAAGGCAGGGCAGCTGATCTTTTATTTATTGGTTTTCATTACAGGTGGACCTGGCCAGAAGCCCTTGGGAAACTGGCGGTGCGCTACGGGTAATTTATTTCTAGGCACCTTCAAAGGAGAAAAGGGCAGTGTCCTCCCTTCTCAACTGGATATTGTGCTAGACCATAGTTGCATACCGCCCACAAGCCCCCAAGCATCAGCTGGCCTGGCATCCCTGCCCAGAAGGGCCCATTGCCACTGGTCTTTCCACAAAAACCTGAGCCTTAGGCCAAATTAAAAAGCCACTTGTAGGCATTTTTACCACTTGAATTTACAGCCAAGAGGAAAATCCAACCATGGGGAAAAAGATCCACTGGCTTTTGGCAATTTTCCAAACTTTAAAAACCCCCAAAAGGGCCAAAAAAGGCAAAAACTACCCCAAAGGCCAAAAAGGCTATTAGGAACATTACAAGGAAAAAAAGTCTTTGATATTTCTTTTCTTTGT\t*\tSA:Z:17,64042266,-,2676S17M1D10M1I14M1D26M1I2M1I20M2I1M1I23M1I11M1D8M1D10M1D16M1I3M1I3M1D1M1I4M1I11M1I2M1I6M1D10M1I11M1D3M1D11M1D8M3I2M1I14M1I7M4I12M1I3M1I9M1D13M1D23M1I4M1I13M1D12M1I38M1I11M1I5M1D11M1I17M1I14M1D12M1D8M1I2M1I3M1D12M1I2M2I8M1I19M1D1M2D11M1D25M1I2M1I21M1I28M1I4M1D4M1I1M2I4M1I22M1I5M1I3M1D3M1I9M2I6M1I9M1D2M1D4M1D11M1D2M1I18M1D2M1I13M1I23M1I17M1I7M1I2M1D4M1I21M1I25M1D12M1I3M1I29M1D2M1D1M1D6M1D8M1I8M1D17M1D13M1I54M1D5M1I4M1D12M2I1M1I3M1I5M1I3M1I7M1I9M1I1M2I25M1I2M1D5M1D18M1I27M1I2M1I8M1D9M1D3M1I11M1D6M1I2M1I4M2I3M2I5M1I13M2I4M1I30M1D3M1I9M1I30M2D4M1D4M1D9M1D5M1I5M1I3M2I6M1I15M1D20M1I3M1I13M5I18M2I10M1I7M1D1M1I38M1D39M1I5M1I6M1588S,36,188;chr14,50254065,-,2S19M1D7M1I2M1D8M2I9M1I8M1I1M1I6M1I2M1I2M1D32M1I12M1I7M1D5M1D9M1I15M1I7M1D11M1I5M1I28M1I13M1I12M1I15M1I2M1D1M1I6M1I19M1D2M1D1M1D5M1I8M1I9M1I22M1D3M2D6M1I6M1D5M1I9M1I2M1I1M1I22M2I10M1D12M1I6M1I24M1I4M1I5M2I4M1I5M4I2M1I6M1D8M1I10M2D7M1I8M1D18M1I7M1I4M1D5M1I9M1I2M1D6M1I12M1I18M1D27M1I1M1D7M1D1M1D11M1D15M1I13M1I1M1I3M1I9M1I6M1D23M1I9M1I1M1I3M1D12M1I1M2I12M1I9M1I4M1I2M1D6M1I1M1I33M1I9M2I5M1I8M1I20M1D18M1I10M1I6M1I22M1I16M1I6M3I3M2D9M5I23M1I3M1D10M1D21M1I5M1I7M1I8M1I14M7I8M4I1M1I15M1I5M3D31M1I15M1I26M4624S,38,166;chr8,123906302,+,157S3M1I2M1I8M1I2M1I2M1I3M1I4M1D14M1I2M2I3M1I1M1I7M1I5M1D13M2I3M1I7M1I2M1I9M2D5M1D11M1I2M1D10M2I4M1I3M1I5M1D5M1I4M1I3M1D4M1I5M1I45M1I4M1I12M1D3M1I1M1I4M2I27M1I3M1D4M1I3M1I5M1I2M1D4M1I6M1D13M1I12M1I9M1I11M1I18M2I4M1I12M1D7M1I40M2I3M1I1M1I8M1D26M1I6M1I15M1D3M2I16M2I7M1I5M1D8M1I6M1D16M1I22M1I6M1I3M1D1M1D3M1I10M1D6M1D10M1I1M1D16M1I3M1I1M1I3M1I35M1I5M1I33M1I13M1I22M2I22M1D5M1I1M1D4M1D21M1I15M1I3M1I5M1I9M1D3M1I10M1D13M1D2M1I4M1I3M1D8M2I5M1D2M3I3M1D20M2I10M1I16M1I5M1I1M2I4M2I2M1I14M1D22M1I7M1I4M1I13M1I1M1I5M1D5M1D22M1I7M1I13M1I17M1I15M1I26M1I1M1D11M2D8M1D20M1I7M1D4M1I8M1D8M4409S,30,166;chr8,126480844,-,4239S17M1D6M1I30M1I11M1D4M1I7M1I11M1I9M1I50M1I8M1I10M1411S,2,11;\tKB:f:24.508675\tSB:f:24.508675\tID:i:150690\tMD:Z:24C15G1^G31^C31^A101C24^T17^G36^G11T6^C28^C3^T11^G9A30A1^C19C0A3T4C1T2^A2T3A1T1^C3A2^A0C3^CC0A1T1A1^AA0T0A3T1^A0C14T0T1^A1C4^A0A0A2C9^GG1^A9^T29^C47^G13G92C2^C115A5^A125^C23^T11T10A16^G5^A33^A30^A39^A2^A7^A28^A9^C39^A5^A51^A7\tQE:i:2676\tXE:i:1426\tXI:f:0.8567\tNM:i:203\tXR:i:1374\tAS:i:1426\tQS:i:1302\tXS:i:0\tCV:f:23.60419\tSV:i:2";
        String saTag = "chr17,64042266,-,2676S17M1D10M1I14M1D26M1I2M1I20M2I1M1I23M1I11M1D8M1D10M1D16M1I3M1I3M1D1M1I4M1I11M1I2M1I6M1D10M1I11M1D3M1D11M1D8M3I2M1I14M1I7M4I12M1I3M1I9M1D13M1D23M1I4M1I13M1D12M1I38M1I11M1I5M1D11M1I17M1I14M1D12M1D8M1I2M1I3M1D12M1I2M2I8M1I19M1D1M2D11M1D25M1I2M1I21M1I28M1I4M1D4M1I1M2I4M1I22M1I5M1I3M1D3M1I9M2I6M1I9M1D2M1D4M1D11M1D2M1I18M1D2M1I13M1I23M1I17M1I7M1I2M1D4M1I21M1I25M1D12M1I3M1I29M1D2M1D1M1D6M1D8M1I8M1D17M1D13M1I54M1D5M1I4M1D12M2I1M1I3M1I5M1I3M1I7M1I9M1I1M2I25M1I2M1D5M1D18M1I27M1I2M1I8M1D9M1D3M1I11M1D6M1I2M1I4M2I3M2I5M1I13M2I4M1I30M1D3M1I9M1I30M2D4M1D4M1D9M1D5M1I5M1I3M2I6M1I15M1D20M1I3M1I13M5I18M2I10M1I7M1D1M1I38M1D39M1I5M1I6M1588S,36,188;14,50254065,-,2S19M1D7M1I2M1D8M2I9M1I8M1I1M1I6M1I2M1I2M1D32M1I12M1I7M1D5M1D9M1I15M1I7M1D11M1I5M1I28M1I13M1I12M1I15M1I2M1D1M1I6M1I19M1D2M1D1M1D5M1I8M1I9M1I22M1D3M2D6M1I6M1D5M1I9M1I2M1I1M1I22M2I10M1D12M1I6M1I24M1I4M1I5M2I4M1I5M4I2M1I6M1D8M1I10M2D7M1I8M1D18M1I7M1I4M1D5M1I9M1I2M1D6M1I12M1I18M1D27M1I1M1D7M1D1M1D11M1D15M1I13M1I1M1I3M1I9M1I6M1D23M1I9M1I1M1I3M1D12M1I1M2I12M1I9M1I4M1I2M1D6M1I1M1I33M1I9M2I5M1I8M1I20M1D18M1I10M1I6M1I22M1I16M1I6M3I3M2D9M5I23M1I3M1D10M1D21M1I5M1I7M1I8M1I14M7I8M4I1M1I15M1I5M3D31M1I15M1I26M4624S,38,166;8,123906302,+,157S3M1I2M1I8M1I2M1I2M1I3M1I4M1D14M1I2M2I3M1I1M1I7M1I5M1D13M2I3M1I7M1I2M1I9M2D5M1D11M1I2M1D10M2I4M1I3M1I5M1D5M1I4M1I3M1D4M1I5M1I45M1I4M1I12M1D3M1I1M1I4M2I27M1I3M1D4M1I3M1I5M1I2M1D4M1I6M1D13M1I12M1I9M1I11M1I18M2I4M1I12M1D7M1I40M2I3M1I1M1I8M1D26M1I6M1I15M1D3M2I16M2I7M1I5M1D8M1I6M1D16M1I22M1I6M1I3M1D1M1D3M1I10M1D6M1D10M1I1M1D16M1I3M1I1M1I3M1I35M1I5M1I33M1I13M1I22M2I22M1D5M1I1M1D4M1D21M1I15M1I3M1I5M1I9M1D3M1I10M1D13M1D2M1I4M1I3M1D8M2I5M1D2M3I3M1D20M2I10M1I16M1I5M1I1M2I4M2I2M1I14M1D22M1I7M1I4M1I13M1I1M1I5M1D5M1D22M1I7M1I13M1I17M1I15M1I26M1I1M1D11M2D8M1D20M1I7M1D4M1I8M1D8M4409S,30,166;8,126480844,-,4239S17M1D6M1I30M1I11M1D4M1I7M1I11M1I9M1I50M1I8M1I10M1411S,2,11";
        record.setAttribute(SAMTag.SA, "3,10000,+,100S50M50S,200,0;3,10000,-,50M250S,0,0");
        final Alignment samAlignment = new SAMAlignment(record);
        String read2 = "primary\t16\t2\t10000\t100\t200S100M\t*\t0\t0\t*\t*\tSA:Z:3,10000,+,100S50M50S,200,*;3,20000,+,50M250S,0,*;\tRG:Z:x\n";
        SupplementaryAlignmentDiagramDialog frame = new SupplementaryAlignmentDiagramDialog(null, samAlignment, new Dimension(500, 150));
        frame.setVisible(true);
    }
}
