/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.util;

import com.android.apksig.internal.util.ByteBufferDataSource;
import com.android.apksig.internal.util.FileChannelDataSource;
import com.android.apksig.util.DataSource;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public abstract class DataSources {
    private DataSources() {
    }

    public static DataSource asDataSource(ByteBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        return new ByteBufferDataSource(buffer);
    }

    public static DataSource asDataSource(RandomAccessFile file) {
        return DataSources.asDataSource(file.getChannel());
    }

    public static DataSource asDataSource(RandomAccessFile file, long offset, long size) {
        return DataSources.asDataSource(file.getChannel(), offset, size);
    }

    public static DataSource asDataSource(FileChannel channel) {
        if (channel == null) {
            throw new NullPointerException();
        }
        return new FileChannelDataSource(channel);
    }

    public static DataSource asDataSource(FileChannel channel, long offset, long size) {
        if (channel == null) {
            throw new NullPointerException();
        }
        return new FileChannelDataSource(channel, offset, size);
    }
}

