/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.device.debugger;

import jadx.gui.device.debugger.SmaliDebuggerException;

public enum RuntimeType {
    ARRAY(91, "[]"),
    BYTE(66, "byte"),
    CHAR(67, "char"),
    OBJECT(76, "object"),
    FLOAT(70, "float"),
    DOUBLE(68, "double"),
    INT(73, "int"),
    LONG(74, "long"),
    SHORT(83, "short"),
    VOID(86, "void"),
    BOOLEAN(90, "boolean"),
    STRING(115, "string"),
    THREAD(116, "thread"),
    THREAD_GROUP(103, "thread_group"),
    CLASS_LOADER(108, "class_loader"),
    CLASS_OBJECT(99, "class_object");

    private final int jdwpTag;
    private final String desc;

    private RuntimeType(int tag, String desc) {
        this.jdwpTag = tag;
        this.desc = desc;
    }

    public int getTag() {
        return this.jdwpTag;
    }

    public String getDesc() {
        return this.desc;
    }

    public static RuntimeType fromJdwpTag(int tag) throws SmaliDebuggerException {
        switch (tag) {
            case 91: {
                return ARRAY;
            }
            case 66: {
                return BYTE;
            }
            case 67: {
                return CHAR;
            }
            case 76: {
                return OBJECT;
            }
            case 70: {
                return FLOAT;
            }
            case 68: {
                return DOUBLE;
            }
            case 73: {
                return INT;
            }
            case 74: {
                return LONG;
            }
            case 83: {
                return SHORT;
            }
            case 86: {
                return VOID;
            }
            case 90: {
                return BOOLEAN;
            }
            case 115: {
                return STRING;
            }
            case 116: {
                return THREAD;
            }
            case 103: {
                return THREAD_GROUP;
            }
            case 108: {
                return CLASS_LOADER;
            }
            case 99: {
                return CLASS_OBJECT;
            }
        }
        throw new SmaliDebuggerException("Unexpected value: " + tag);
    }
}

