/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils;

import jadx.api.ICodeInfo;
import jadx.api.metadata.ICodeAnnotation;
import jadx.api.metadata.ICodeMetadata;
import jadx.api.metadata.ICodeNodeRef;
import jadx.api.metadata.annotations.InsnCodeOffset;
import jadx.gui.treemodel.JClass;
import jadx.gui.ui.codearea.AbstractCodeArea;
import java.util.Map;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaretPositionFix {
    private static final Logger LOG = LoggerFactory.getLogger(CaretPositionFix.class);
    private final AbstractCodeArea codeArea;
    private int linesCount;
    private int line;
    private int pos;
    private int lineOffset;
    private TokenInfo tokenInfo;
    private int javaNodePos = -1;
    private int codeRawOffset = -1;

    public CaretPositionFix(AbstractCodeArea codeArea) {
        this.codeArea = codeArea;
    }

    public void save() {
        try {
            ICodeMetadata metadata;
            ICodeAnnotation ann;
            this.linesCount = this.codeArea.getLineCount();
            this.pos = this.codeArea.getCaretPosition();
            this.line = this.codeArea.getLineOfOffset(this.pos);
            this.lineOffset = this.pos - this.codeArea.getLineStartOffset(this.line);
            this.tokenInfo = this.getTokenInfoByOffset(this.codeArea.getTokenListForLine(this.line), this.pos);
            ICodeInfo codeInfo = this.codeArea.getCodeInfo();
            if (codeInfo.hasMetadata() && (ann = (metadata = codeInfo.getCodeMetadata()).getAt(this.pos)) instanceof InsnCodeOffset) {
                this.codeRawOffset = ((InsnCodeOffset)ann).getOffset();
                ICodeNodeRef javaNode = metadata.getNodeAt(this.pos);
                if (javaNode != null) {
                    this.javaNodePos = javaNode.getDefPosition();
                }
            }
            LOG.debug("Saved position data: line={}, lineOffset={}, token={}, codeRawOffset={}, javaNodeLine={}", new Object[]{this.line, this.lineOffset, this.tokenInfo, this.codeRawOffset, this.javaNodePos});
        }
        catch (Exception e) {
            LOG.error("Failed to save caret position before refresh", (Throwable)e);
            this.line = -1;
        }
    }

    public void restore() {
        if (this.line == -1) {
            return;
        }
        try {
            int newPos = this.getNewPos();
            int newLine = this.codeArea.getLineOfOffset(newPos);
            Token token = this.codeArea.getTokenListForLine(newLine);
            int tokenPos = this.getOffsetFromTokenInfo(this.tokenInfo, token);
            if (tokenPos == -1) {
                int lineStartOffset = this.codeArea.getLineStartOffset(newLine);
                int lineEndOffset = this.codeArea.getLineEndOffset(newLine) - 1;
                int lineLength = lineEndOffset - lineStartOffset;
                tokenPos = this.lineOffset < lineLength ? lineStartOffset + this.lineOffset : lineEndOffset;
            }
            this.codeArea.setCaretPosition(tokenPos);
            LOG.debug("Restored caret position: {}", (Object)tokenPos);
        }
        catch (Exception e) {
            LOG.warn("Failed to restore caret position", (Throwable)e);
        }
    }

    private int getNewPos() throws BadLocationException {
        JClass cls;
        int newLinesCount = this.codeArea.getLineCount();
        if (this.linesCount == newLinesCount) {
            return this.pos;
        }
        ICodeInfo codeInfo = this.codeArea.getCodeInfo();
        if (this.javaNodePos != -1 && codeInfo.hasMetadata() && (cls = this.codeArea.getJClass()) != null) {
            ICodeMetadata codeMetadata = codeInfo.getCodeMetadata();
            for (Map.Entry entry : codeMetadata.getAsMap().entrySet()) {
                ICodeAnnotation ann;
                int annPos = (Integer)entry.getKey();
                if (annPos < this.javaNodePos || !((ann = (ICodeAnnotation)entry.getValue()) instanceof InsnCodeOffset) || ((InsnCodeOffset)ann).getOffset() != this.codeRawOffset) continue;
                return annPos;
            }
        }
        int newLine = this.line - (this.linesCount - newLinesCount);
        return this.codeArea.getLineStartOffset(newLine);
    }

    private TokenInfo getTokenInfoByOffset(Token token, int offset) {
        if (token == null) {
            return null;
        }
        int index = 1;
        while (token.getEndOffset() < offset) {
            if ((token = token.getNextToken()) == null) {
                return null;
            }
            ++index;
        }
        return new TokenInfo(index, token.getType());
    }

    private int getOffsetFromTokenInfo(TokenInfo tokenInfo, Token token) {
        if (tokenInfo == null || token == null) {
            return -1;
        }
        int index = tokenInfo.getIndex();
        if (index == -1) {
            return -1;
        }
        for (int i = 0; i < index; ++i) {
            if ((token = token.getNextToken()) != null) continue;
            return -1;
        }
        if (token.getType() != tokenInfo.getType()) {
            return -1;
        }
        return token.getOffset();
    }

    private static final class TokenInfo {
        private final int index;
        private final int type;

        public TokenInfo(int index, int type) {
            this.index = index;
            this.type = type;
        }

        public int getIndex() {
            return this.index;
        }

        public int getType() {
            return this.type;
        }

        public String toString() {
            return "Token{index=" + this.index + ", type=" + this.type + '}';
        }
    }
}

