
# Jamulus JSON-RPC Documentation

<!--
This file is automatically generated from the source code.
Do not edit this file manually.
See `tools/generate_json_rpc_docs.py` for details.
-->

A JSON-RPC interface is available for both Jamulus client and server to allow programmatic access.
To use the JSON-RPC interface, run Jamulus with the `--jsonrpcport <port> --jsonrpcsecretfile /file/with/a/secret.txt` options.
This will start a JSON-RPC server on the specified port on the localhost.

The file referenced by `--jsonrpcsecretfile` must contain a single line with a freely chosen string with at least 16 characters.
It can be generated like this:
```
$ openssl rand -base64 10 > /file/with/a/secret.txt
```

## Wire protocol

The JSON-RPC server is based on the [JSON-RPC 2.0](https://www.jsonrpc.org/specification) protocol, using [streaming newline-delimited JSON over TCP](https://clue.engineering/2018/introducing-reactphp-ndjson) as the transport. There are three main types of messages being exchanged:

- A **request** from the consumer to Jamulus.
- A **response** from Jamulus to the consumer.
- A **notification** from Jamulus to the consumer.

## Example

After opening a TCP connection to the JSON-RPC server, the connection must be authenticated:

```json
{"id":1,"jsonrpc":"2.0","method":"jamulus/apiAuth","params":{"secret": "...the secret from the file in --jsonrpcsecretfile..."}}
```

Request must be sent as a single line of JSON-encoded data, followed by a newline character. Jamulus will send back a **response** in the same manner:

```json
{"id":1,"jsonrpc":"2.0","result":"ok"}
```
After successful authentication, the following **request** can be sent:

```json
{"id":2,"jsonrpc":"2.0","method":"jamulus/getMode","params":{}}
```

The request must be sent as a single line of JSON-encoded data, followed by a newline character. Jamulus will send back a **response** in the same manner:

```json
{"id":2,"jsonrpc":"2.0","result":{"mode":"client"}}
```

Jamulus will also send **notifications** to the consumer:

```json
{"jsonrpc":"2.0","method":"jamulusclient/chatTextReceived","params":{"text":"<font color=\"mediumblue\">(01:23:45 AM) <b>user</b></font> test"}}
```

## Method reference
### jamulus/apiAuth

Authenticates the connection which is a requirement for calling further methods.

Parameters:

| Name | Type | Description |
| --- | --- | --- |
| params.secret | string | The preshared secret key. |

Results:

| Name | Type | Description |
| --- | --- | --- |
| result | string | "ok" on success |


### jamulus/getMode

Returns the current mode, i.e. whether Jamulus is running as a server or client.

Parameters:

| Name | Type | Description |
| --- | --- | --- |
| params | object | No parameters (empty object). |

Results:

| Name | Type | Description |
| --- | --- | --- |
| result.mode | string | The current mode (server or client). |


### jamulus/getVersion

Returns Jamulus version.

Parameters:

| Name | Type | Description |
| --- | --- | --- |
| params | object | No parameters (empty object). |

Results:

| Name | Type | Description |
| --- | --- | --- |
| result.version | string | The Jamulus version. |


### jamulusclient/getChannelInfo

Returns the client's profile information.

Parameters:

| Name | Type | Description |
| --- | --- | --- |
| params | object | No parameters (empty object). |

Results:

| Name | Type | Description |
| --- | --- | --- |
| result.id | number | The channel ID. |
| result.name | string | The musician’s name. |
| result.skillLevel | string | The musician’s skill level (beginner, intermediate, expert, or null). |
| result.countryId | number | The musician’s country ID (see QLocale::Country). |
| result.city | string | The musician’s city. |
| result.instrumentId | number | The musician’s instrument ID (see CInstPictures::GetTable). |
| result.skillLevel | string | Your skill level (beginner, intermediate, expert, or null). |


### jamulusclient/getClientInfo

Returns the client information.

Parameters:

| Name | Type | Description |
| --- | --- | --- |
| params | object | No parameters (empty object). |

Results:

| Name | Type | Description |
| --- | --- | --- |
| result.connected | boolean | Whether the client is connected to the server. |


### jamulusclient/getClientList

Returns the client list.

Parameters:

| Name | Type | Description |
| --- | --- | --- |
| params | object | No parameters (empty object). |

Results:

| Name | Type | Description |
| --- | --- | --- |
| result.clients | array | The client list. See jamulusclient/clientListReceived for the format. |


### jamulusclient/sendChatText

Sends a chat text message.

Parameters:

| Name | Type | Description |
| --- | --- | --- |
| params.chatText | string | The chat text message. |

Results:

| Name | Type | Description |
| --- | --- | --- |
| result | string | Always "ok". |


### jamulusclient/setName

Sets your name.

Parameters:

| Name | Type | Description |
| --- | --- | --- |
| params.name | string | The new name. |

Results:

| Name | Type | Description |
| --- | --- | --- |
| result | string | Always "ok". |


### jamulusclient/setSkillLevel

Sets your skill level.

Parameters:

| Name | Type | Description |
| --- | --- | --- |
| params.skillLevel | string | The new skill level (beginner, intermediate, expert, or null). |

Results:

| Name | Type | Description |
| --- | --- | --- |
| result | string | Always "ok". |


### jamulusserver/getClients

Returns the list of connected clients along with details about them.

Parameters:

| Name | Type | Description |
| --- | --- | --- |
| params | object | No parameters (empty object). |

Results:

| Name | Type | Description |
| --- | --- | --- |
| result.clients | array | The list of connected clients. |
| result.clients[*].id | number | The client’s channel id. |
| result.clients[*].address | string | The client’s address (ip:port). |
| result.clients[*].name | string | The client’s name. |
| result.clients[*].jitterBufferSize | number | The client’s jitter buffer size. |
| result.clients[*].channels | number | The number of audio channels of the client. |


### jamulusserver/getRecorderStatus

Returns the recorder state.

Parameters:

| Name | Type | Description |
| --- | --- | --- |
| params | object | No parameters (empty object). |

Results:

| Name | Type | Description |
| --- | --- | --- |
| result.initialised | boolean | True if the recorder is initialised. |
| result.errorMessage | string | The recorder error message, if any. |
| result.enabled | boolean | True if the recorder is enabled. |
| result.recordingDirectory | string | The recorder recording directory. |


### jamulusserver/getServerProfile

Returns the server registration profile and status.

Parameters:

| Name | Type | Description |
| --- | --- | --- |
| params | object | No parameters (empty object). |

Results:

| Name | Type | Description |
| --- | --- | --- |
| result.name | string | The server name. |
| result.city | string | The server city. |
| result.countryId | number | The server country ID (see QLocale::Country). |
| result.welcomeMessage | string | The server welcome message. |
| result.directoryServer | string | The directory server to which this server requested registration, or blank if none. |
| result.registrationStatus | string | The server registration status as string (see ESvrRegStatus and SerializeRegistrationStatus). |


### jamulusserver/restartRecording

Restarts the recording into a new directory.

Parameters:

| Name | Type | Description |
| --- | --- | --- |
| params | object | No parameters (empty object). |

Results:

| Name | Type | Description |
| --- | --- | --- |
| result | string | Always "acknowledged".   To check if the recording was restarted or if there is any error, call `jamulusserver/getRecorderStatus` again. |


### jamulusserver/setRecordingDirectory

Sets the server recording directory.

Parameters:

| Name | Type | Description |
| --- | --- | --- |
| params.recordingDirectory | string | The new recording directory. |

Results:

| Name | Type | Description |
| --- | --- | --- |
| result | string | Always "acknowledged".   To check if the directory was changed, call `jamulusserver/getRecorderStatus` again. |


### jamulusserver/setServerName

Sets the server name.

Parameters:

| Name | Type | Description |
| --- | --- | --- |
| params.serverName | string | The new server name. |

Results:

| Name | Type | Description |
| --- | --- | --- |
| result | string | Always "ok". |


### jamulusserver/setWelcomeMessage

Sets the server welcome message.

Parameters:

| Name | Type | Description |
| --- | --- | --- |
| params.welcomeMessage | string | The new welcome message. |

Results:

| Name | Type | Description |
| --- | --- | --- |
| result | string | Always "ok". |


### jamulusserver/startRecording

Starts the server recording.

Parameters:

| Name | Type | Description |
| --- | --- | --- |
| params | object | No parameters (empty object). |

Results:

| Name | Type | Description |
| --- | --- | --- |
| result | string | Always "acknowledged".   To check if the recording was enabled, call `jamulusserver/getRecorderStatus` again. |


### jamulusserver/stopRecording

Stops the server recording.

Parameters:

| Name | Type | Description |
| --- | --- | --- |
| params | object | No parameters (empty object). |

Results:

| Name | Type | Description |
| --- | --- | --- |
| result | string | Always "acknowledged".   To check if the recording was disabled, call `jamulusserver/getRecorderStatus` again. |


## Notification reference
### jamulusclient/channelLevelListReceived

Emitted when the channel level list is received.

Parameters:

| Name | Type | Description |
| --- | --- | --- |
| params.channelLevelList | array | The channel level list.   Each item corresponds to the respective client retrieved from the jamulusclient/clientListReceived notification. |
| params.channelLevelList[*] | number | The channel level, an integer between 0 and 9. |


### jamulusclient/chatTextReceived

Emitted when a chat text is received.

Parameters:

| Name | Type | Description |
| --- | --- | --- |
| params.chatText | string | The chat text. |


### jamulusclient/clientListReceived

Emitted when the client list is received.

Parameters:

| Name | Type | Description |
| --- | --- | --- |
| params.clients | array | The client list. |
| params.clients[*].id | number | The channel ID. |
| params.clients[*].name | string | The musician’s name. |
| params.clients[*].skillLevel | string | The musician’s skill level (beginner, intermediate, expert, or null). |
| params.clients[*].countryId | number | The musician’s country ID (see QLocale::Country). |
| params.clients[*].city | string | The musician’s city. |
| params.clients[*].instrumentId | number | The musician’s instrument ID (see CInstPictures::GetTable). |


### jamulusclient/connected

Emitted when the client is connected to the server.

Parameters:

| Name | Type | Description |
| --- | --- | --- |
| params.id | number | The channel ID assigned to the client. |


### jamulusclient/disconnected

Emitted when the client is disconnected from the server.

Parameters:

| Name | Type | Description |
| --- | --- | --- |
| params | object | No parameters (empty object). |


