/*
 * Copyright (c) AXA Group Operations Spain S.A.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

const { Among, BaseStemmer } = require('@nlpjs/core');
const TokenizerEn = require('./tokenizer-en');

/**
 * This class was automatically generated by a Snowball to JSX compiler
 * It implements the stemming algorithm defined by a snowball script.
 */
/* eslint-disable */
class StemmerEn extends BaseStemmer {
  constructor(container) {
    super(container);
    this.name = 'stemmer-en';
    this.B_Y_found = false;
    this.I_p2 = 0;
    this.I_p1 = 0;
  }

  getTokenizer() {
    if (!this.tokenizer) {
      this.tokenizer =
        this.container.get(`tokenizer-${this.name.slice(-2)}`) ||
        new TokenizerEn();
      if (this.tokenizer.constructor.name === 'Tokenizer') {
        this.tokenizer = new TokenizerEn();
      }
    }
    return this.tokenizer;
  }

  r_prelude() {
    let v_1;
    let v_2;
    let v_3;
    let v_4;
    let v_5;
    // (, line 25
    // unset Y_found, line 26
    this.B_Y_found = false;
    // do, line 27
    v_1 = this.cursor;
    let lab0 = true;
    while (lab0 == true) {
      lab0 = false;
      // (, line 27
      // [, line 27
      this.bra = this.cursor;
      // literal, line 27
      if (!this.eq_s("'")) {
        break;
      }
      // ], line 27
      this.ket = this.cursor;
      // delete, line 27
      if (!this.slice_del()) {
        return false;
      }
    }
    this.cursor = v_1;
    // do, line 28
    v_2 = this.cursor;
    let lab1 = true;
    while (lab1 == true) {
      lab1 = false;
      // (, line 28
      // [, line 28
      this.bra = this.cursor;
      // literal, line 28
      if (!this.eq_s('y')) {
        break;
      }
      // ], line 28
      this.ket = this.cursor;
      // <-, line 28
      if (!this.slice_from('Y')) {
        return false;
      }
      // set Y_found, line 28
      this.B_Y_found = true;
    }
    this.cursor = v_2;
    // do, line 29
    v_3 = this.cursor;
    let lab2 = true;
    while (lab2 == true) {
      lab2 = false;
      // repeat, line 29
      replab3: while (true) {
        v_4 = this.cursor;
        let lab4 = true;
        lab4: while (lab4 == true) {
          lab4 = false;
          // (, line 29
          // goto, line 29
          golab5: while (true) {
            v_5 = this.cursor;
            let lab6 = true;
            while (lab6 == true) {
              lab6 = false;
              // (, line 29
              if (!this.in_grouping(StemmerEn.g_v, 97, 121)) {
                break;
              }
              // [, line 29
              this.bra = this.cursor;
              // literal, line 29
              if (!this.eq_s('y')) {
                break;
              }
              // ], line 29
              this.ket = this.cursor;
              this.cursor = v_5;
              break golab5;
            }
            this.cursor = v_5;
            if (this.cursor >= this.limit) {
              break lab4;
            }
            this.cursor++;
          }
          // <-, line 29
          if (!this.slice_from('Y')) {
            return false;
          }
          // set Y_found, line 29
          this.B_Y_found = true;
          continue replab3;
        }
        this.cursor = v_4;
        break;
      }
    }
    this.cursor = v_3;
    return true;
  }

  r_mark_regions() {
    let v_1;
    let v_2;
    // (, line 32
    this.I_p1 = this.limit;
    this.I_p2 = this.limit;
    // do, line 35
    v_1 = this.cursor;
    let lab0 = true;
    lab0: while (lab0 == true) {
      lab0 = false;
      // (, line 35
      // or, line 41
      let lab1 = true;
      lab1: while (lab1 == true) {
        lab1 = false;
        v_2 = this.cursor;
        let lab2 = true;
        while (lab2 == true) {
          lab2 = false;
          // among, line 36
          if (this.find_among(StemmerEn.a_0, 3) == 0) {
            break;
          }
          break lab1;
        }
        this.cursor = v_2;
        // (, line 41
        // gopast, line 41
        golab3: while (true) {
          let lab4 = true;
          while (lab4 == true) {
            lab4 = false;
            if (!this.in_grouping(StemmerEn.g_v, 97, 121)) {
              break;
            }
            break golab3;
          }
          if (this.cursor >= this.limit) {
            break lab0;
          }
          this.cursor++;
        }
        // gopast, line 41
        golab5: while (true) {
          let lab6 = true;
          while (lab6 == true) {
            lab6 = false;
            if (!this.out_grouping(StemmerEn.g_v, 97, 121)) {
              break;
            }
            break golab5;
          }
          if (this.cursor >= this.limit) {
            break lab0;
          }
          this.cursor++;
        }
      }
      // setmark p1, line 42
      this.I_p1 = this.cursor;
      // gopast, line 43
      golab7: while (true) {
        let lab8 = true;
        while (lab8 == true) {
          lab8 = false;
          if (!this.in_grouping(StemmerEn.g_v, 97, 121)) {
            break;
          }
          break golab7;
        }
        if (this.cursor >= this.limit) {
          break lab0;
        }
        this.cursor++;
      }
      // gopast, line 43
      golab9: while (true) {
        let lab10 = true;
        while (lab10 == true) {
          lab10 = false;
          if (!this.out_grouping(StemmerEn.g_v, 97, 121)) {
            break;
          }
          break golab9;
        }
        if (this.cursor >= this.limit) {
          break lab0;
        }
        this.cursor++;
      }
      // setmark p2, line 43
      this.I_p2 = this.cursor;
    }
    this.cursor = v_1;
    return true;
  }

  r_shortv() {
    let v_1;
    // (, line 49
    // or, line 51
    let lab0 = true;
    lab0: while (lab0 == true) {
      lab0 = false;
      v_1 = this.limit - this.cursor;
      let lab1 = true;
      while (lab1 == true) {
        lab1 = false;
        // (, line 50
        if (!this.out_grouping_b(StemmerEn.g_v_WXY, 89, 121)) {
          break;
        }
        if (!this.in_grouping_b(StemmerEn.g_v, 97, 121)) {
          break;
        }
        if (!this.out_grouping_b(StemmerEn.g_v, 97, 121)) {
          break;
        }
        break lab0;
      }
      this.cursor = this.limit - v_1;
      // (, line 52
      if (!this.out_grouping_b(StemmerEn.g_v, 97, 121)) {
        return false;
      }
      if (!this.in_grouping_b(StemmerEn.g_v, 97, 121)) {
        return false;
      }
      // atlimit, line 52
      if (this.cursor > this.limit_backward) {
        return false;
      }
    }
    return true;
  }

  r_R1() {
    if (!(this.I_p1 <= this.cursor)) {
      return false;
    }
    return true;
  }

  r_R2() {
    if (!(this.I_p2 <= this.cursor)) {
      return false;
    }
    return true;
  }

  r_Step_1a() {
    let among_var;
    let v_1;
    let v_2;
    // (, line 58
    // try, line 59
    v_1 = this.limit - this.cursor;
    let lab0 = true;
    lab0: while (lab0 == true) {
      lab0 = false;
      // (, line 59
      // [, line 60
      this.ket = this.cursor;
      // substring, line 60
      among_var = this.find_among_b(StemmerEn.a_1, 3);
      if (among_var == 0) {
        this.cursor = this.limit - v_1;
        break;
      }
      // ], line 60
      this.bra = this.cursor;
      switch (among_var) {
        case 0:
          this.cursor = this.limit - v_1;
          break lab0;
        case 1:
          // (, line 62
          // delete, line 62
          if (!this.slice_del()) {
            return false;
          }
          break;
      }
    }
    // [, line 65
    this.ket = this.cursor;
    // substring, line 65
    among_var = this.find_among_b(StemmerEn.a_2, 6);
    if (among_var == 0) {
      return false;
    }
    // ], line 65
    this.bra = this.cursor;
    switch (among_var) {
      case 0:
        return false;
      case 1:
        // (, line 66
        // <-, line 66
        if (!this.slice_from('ss')) {
          return false;
        }
        break;
      case 2:
        // (, line 68
        // or, line 68
        var lab1 = true;
        lab1: while (lab1 == true) {
          lab1 = false;
          v_2 = this.limit - this.cursor;
          let lab2 = true;
          while (lab2 == true) {
            lab2 = false;
            // (, line 68
            // hop, line 68
            {
              const c = this.cursor - 2;
              if (this.limit_backward > c || c > this.limit) {
                break;
              }
              this.cursor = c;
            }
            // <-, line 68
            if (!this.slice_from('i')) {
              return false;
            }
            break lab1;
          }
          this.cursor = this.limit - v_2;
          // <-, line 68
          if (!this.slice_from('ie')) {
            return false;
          }
        }
        break;
      case 3:
        // (, line 69
        // next, line 69
        if (this.cursor <= this.limit_backward) {
          return false;
        }
        this.cursor--;
        // gopast, line 69
        golab3: while (true) {
          let lab4 = true;
          while (lab4 == true) {
            lab4 = false;
            if (!this.in_grouping_b(StemmerEn.g_v, 97, 121)) {
              break;
            }
            break golab3;
          }
          if (this.cursor <= this.limit_backward) {
            return false;
          }
          this.cursor--;
        }
        // delete, line 69
        if (!this.slice_del()) {
          return false;
        }
        break;
    }
    return true;
  }

  r_Step_1b() {
    let among_var;
    let v_1;
    let v_3;
    let v_4;
    // (, line 74
    // [, line 75
    this.ket = this.cursor;
    // substring, line 75
    among_var = this.find_among_b(StemmerEn.a_4, 6);
    if (among_var == 0) {
      return false;
    }
    // ], line 75
    this.bra = this.cursor;
    switch (among_var) {
      case 0:
        return false;
      case 1:
        // (, line 77
        // call R1, line 77
        if (!this.r_R1()) {
          return false;
        }
        // <-, line 77
        if (!this.slice_from('ee')) {
          return false;
        }
        break;
      case 2:
        // (, line 79
        // test, line 80
        v_1 = this.limit - this.cursor;
        // gopast, line 80
        golab0: while (true) {
          let lab1 = true;
          while (lab1 == true) {
            lab1 = false;
            if (!this.in_grouping_b(StemmerEn.g_v, 97, 121)) {
              break;
            }
            break golab0;
          }
          if (this.cursor <= this.limit_backward) {
            return false;
          }
          this.cursor--;
        }
        this.cursor = this.limit - v_1;
        // delete, line 80
        if (!this.slice_del()) {
          return false;
        }
        // test, line 81
        v_3 = this.limit - this.cursor;
        // substring, line 81
        among_var = this.find_among_b(StemmerEn.a_3, 13);
        if (among_var == 0) {
          return false;
        }
        this.cursor = this.limit - v_3;
        switch (among_var) {
          case 0:
            return false;
          case 1:
            // (, line 83
            // <+, line 83
            {
              var c = this.cursor;
              this.insert(this.cursor, this.cursor, 'e');
              this.cursor = c;
            }
            break;
          case 2:
            // (, line 86
            // [, line 86
            this.ket = this.cursor;
            // next, line 86
            if (this.cursor <= this.limit_backward) {
              return false;
            }
            this.cursor--;
            // ], line 86
            this.bra = this.cursor;
            // delete, line 86
            if (!this.slice_del()) {
              return false;
            }
            break;
          case 3:
            // (, line 87
            // atmark, line 87
            if (this.cursor != this.I_p1) {
              return false;
            }
            // test, line 87
            v_4 = this.limit - this.cursor;
            // call shortv, line 87
            if (!this.r_shortv()) {
              return false;
            }
            this.cursor = this.limit - v_4;
            // <+, line 87
            {
              var c = this.cursor;
              this.insert(this.cursor, this.cursor, 'e');
              this.cursor = c;
            }
            break;
        }
        break;
    }
    return true;
  }

  r_Step_1c() {
    let v_1;
    let v_2;
    // (, line 93
    // [, line 94
    this.ket = this.cursor;
    // or, line 94
    let lab0 = true;
    lab0: while (lab0 == true) {
      lab0 = false;
      v_1 = this.limit - this.cursor;
      let lab1 = true;
      while (lab1 == true) {
        lab1 = false;
        // literal, line 94
        if (!this.eq_s_b('y')) {
          break;
        }
        break lab0;
      }
      this.cursor = this.limit - v_1;
      // literal, line 94
      if (!this.eq_s_b('Y')) {
        return false;
      }
    }
    // ], line 94
    this.bra = this.cursor;
    if (!this.out_grouping_b(StemmerEn.g_v, 97, 121)) {
      return false;
    }
    // not, line 95
    {
      v_2 = this.limit - this.cursor;
      let lab2 = true;
      while (lab2 == true) {
        lab2 = false;
        // atlimit, line 95
        if (this.cursor > this.limit_backward) {
          break;
        }
        return false;
      }
      this.cursor = this.limit - v_2;
    }
    // <-, line 96
    if (!this.slice_from('i')) {
      return false;
    }
    return true;
  }

  r_Step_2() {
    let among_var;
    // (, line 99
    // [, line 100
    this.ket = this.cursor;
    // substring, line 100
    among_var = this.find_among_b(StemmerEn.a_5, 24);
    if (among_var == 0) {
      return false;
    }
    // ], line 100
    this.bra = this.cursor;
    // call R1, line 100
    if (!this.r_R1()) {
      return false;
    }
    switch (among_var) {
      case 0:
        return false;
      case 1:
        // (, line 101
        // <-, line 101
        if (!this.slice_from('tion')) {
          return false;
        }
        break;
      case 2:
        // (, line 102
        // <-, line 102
        if (!this.slice_from('ence')) {
          return false;
        }
        break;
      case 3:
        // (, line 103
        // <-, line 103
        if (!this.slice_from('ance')) {
          return false;
        }
        break;
      case 4:
        // (, line 104
        // <-, line 104
        if (!this.slice_from('able')) {
          return false;
        }
        break;
      case 5:
        // (, line 105
        // <-, line 105
        if (!this.slice_from('ent')) {
          return false;
        }
        break;
      case 6:
        // (, line 107
        // <-, line 107
        if (!this.slice_from('ize')) {
          return false;
        }
        break;
      case 7:
        // (, line 109
        // <-, line 109
        if (!this.slice_from('ate')) {
          return false;
        }
        break;
      case 8:
        // (, line 111
        // <-, line 111
        if (!this.slice_from('al')) {
          return false;
        }
        break;
      case 9:
        // (, line 112
        // <-, line 112
        if (!this.slice_from('ful')) {
          return false;
        }
        break;
      case 10:
        // (, line 114
        // <-, line 114
        if (!this.slice_from('ous')) {
          return false;
        }
        break;
      case 11:
        // (, line 116
        // <-, line 116
        if (!this.slice_from('ive')) {
          return false;
        }
        break;
      case 12:
        // (, line 118
        // <-, line 118
        if (!this.slice_from('ble')) {
          return false;
        }
        break;
      case 13:
        // (, line 119
        // literal, line 119
        if (!this.eq_s_b('l')) {
          return false;
        }
        // <-, line 119
        if (!this.slice_from('og')) {
          return false;
        }
        break;
      case 14:
        // (, line 120
        // <-, line 120
        if (!this.slice_from('ful')) {
          return false;
        }
        break;
      case 15:
        // (, line 121
        // <-, line 121
        if (!this.slice_from('less')) {
          return false;
        }
        break;
      case 16:
        // (, line 122
        if (!this.in_grouping_b(StemmerEn.g_valid_LI, 99, 116)) {
          return false;
        }
        // delete, line 122
        if (!this.slice_del()) {
          return false;
        }
        break;
    }
    return true;
  }

  r_Step_3() {
    let among_var;
    // (, line 126
    // [, line 127
    this.ket = this.cursor;
    // substring, line 127
    among_var = this.find_among_b(StemmerEn.a_6, 9);
    if (among_var == 0) {
      return false;
    }
    // ], line 127
    this.bra = this.cursor;
    // call R1, line 127
    if (!this.r_R1()) {
      return false;
    }
    switch (among_var) {
      case 0:
        return false;
      case 1:
        // (, line 128
        // <-, line 128
        if (!this.slice_from('tion')) {
          return false;
        }
        break;
      case 2:
        // (, line 129
        // <-, line 129
        if (!this.slice_from('ate')) {
          return false;
        }
        break;
      case 3:
        // (, line 130
        // <-, line 130
        if (!this.slice_from('al')) {
          return false;
        }
        break;
      case 4:
        // (, line 132
        // <-, line 132
        if (!this.slice_from('ic')) {
          return false;
        }
        break;
      case 5:
        // (, line 134
        // delete, line 134
        if (!this.slice_del()) {
          return false;
        }
        break;
      case 6:
        // (, line 136
        // call R2, line 136
        if (!this.r_R2()) {
          return false;
        }
        // delete, line 136
        if (!this.slice_del()) {
          return false;
        }
        break;
    }
    return true;
  }

  r_Step_4() {
    let among_var;
    let v_1;
    // (, line 140
    // [, line 141
    this.ket = this.cursor;
    // substring, line 141
    among_var = this.find_among_b(StemmerEn.a_7, 18);
    if (among_var == 0) {
      return false;
    }
    // ], line 141
    this.bra = this.cursor;
    // call R2, line 141
    if (!this.r_R2()) {
      return false;
    }
    switch (among_var) {
      case 0:
        return false;
      case 1:
        // (, line 144
        // delete, line 144
        if (!this.slice_del()) {
          return false;
        }
        break;
      case 2:
        // (, line 145
        // or, line 145
        var lab0 = true;
        lab0: while (lab0 == true) {
          lab0 = false;
          v_1 = this.limit - this.cursor;
          let lab1 = true;
          while (lab1 == true) {
            lab1 = false;
            // literal, line 145
            if (!this.eq_s_b('s')) {
              break;
            }
            break lab0;
          }
          this.cursor = this.limit - v_1;
          // literal, line 145
          if (!this.eq_s_b('t')) {
            return false;
          }
        }
        // delete, line 145
        if (!this.slice_del()) {
          return false;
        }
        break;
    }
    return true;
  }

  r_Step_5() {
    let among_var;
    let v_1;
    let v_2;
    // (, line 149
    // [, line 150
    this.ket = this.cursor;
    // substring, line 150
    among_var = this.find_among_b(StemmerEn.a_8, 2);
    if (among_var == 0) {
      return false;
    }
    // ], line 150
    this.bra = this.cursor;
    switch (among_var) {
      case 0:
        return false;
      case 1:
        // (, line 151
        // or, line 151
        var lab0 = true;
        lab0: while (lab0 == true) {
          lab0 = false;
          v_1 = this.limit - this.cursor;
          let lab1 = true;
          while (lab1 == true) {
            lab1 = false;
            // call R2, line 151
            if (!this.r_R2()) {
              break;
            }
            break lab0;
          }
          this.cursor = this.limit - v_1;
          // (, line 151
          // call R1, line 151
          if (!this.r_R1()) {
            return false;
          }
          // not, line 151
          {
            v_2 = this.limit - this.cursor;
            let lab2 = true;
            while (lab2 == true) {
              lab2 = false;
              // call shortv, line 151
              if (!this.r_shortv()) {
                break;
              }
              return false;
            }
            this.cursor = this.limit - v_2;
          }
        }
        // delete, line 151
        if (!this.slice_del()) {
          return false;
        }
        break;
      case 2:
        // (, line 152
        // call R2, line 152
        if (!this.r_R2()) {
          return false;
        }
        // literal, line 152
        if (!this.eq_s_b('l')) {
          return false;
        }
        // delete, line 152
        if (!this.slice_del()) {
          return false;
        }
        break;
    }
    return true;
  }

  r_exception2() {
    // (, line 156
    // [, line 158
    this.ket = this.cursor;
    // substring, line 158
    if (this.find_among_b(StemmerEn.a_9, 8) == 0) {
      return false;
    }
    // ], line 158
    this.bra = this.cursor;
    // atlimit, line 158
    if (this.cursor > this.limit_backward) {
      return false;
    }
    return true;
  }

  r_exception1() {
    let among_var;
    // (, line 168
    // [, line 170
    this.bra = this.cursor;
    // substring, line 170
    among_var = this.find_among(StemmerEn.a_10, 18);
    if (among_var == 0) {
      return false;
    }
    // ], line 170
    this.ket = this.cursor;
    // atlimit, line 170
    if (this.cursor < this.limit) {
      return false;
    }
    switch (among_var) {
      case 0:
        return false;
      case 1:
        // (, line 174
        // <-, line 174
        if (!this.slice_from('ski')) {
          return false;
        }
        break;
      case 2:
        // (, line 175
        // <-, line 175
        if (!this.slice_from('sky')) {
          return false;
        }
        break;
      case 3:
        // (, line 176
        // <-, line 176
        if (!this.slice_from('die')) {
          return false;
        }
        break;
      case 4:
        // (, line 177
        // <-, line 177
        if (!this.slice_from('lie')) {
          return false;
        }
        break;
      case 5:
        // (, line 178
        // <-, line 178
        if (!this.slice_from('tie')) {
          return false;
        }
        break;
      case 6:
        // (, line 182
        // <-, line 182
        if (!this.slice_from('idl')) {
          return false;
        }
        break;
      case 7:
        // (, line 183
        // <-, line 183
        if (!this.slice_from('gentl')) {
          return false;
        }
        break;
      case 8:
        // (, line 184
        // <-, line 184
        if (!this.slice_from('ugli')) {
          return false;
        }
        break;
      case 9:
        // (, line 185
        // <-, line 185
        if (!this.slice_from('earli')) {
          return false;
        }
        break;
      case 10:
        // (, line 186
        // <-, line 186
        if (!this.slice_from('onli')) {
          return false;
        }
        break;
      case 11:
        // (, line 187
        // <-, line 187
        if (!this.slice_from('singl')) {
          return false;
        }
        break;
    }
    return true;
  }

  r_postlude() {
    let v_1;
    let v_2;
    // (, line 203
    // Boolean test Y_found, line 203
    if (!this.B_Y_found) {
      return false;
    }
    // repeat, line 203
    replab0: while (true) {
      v_1 = this.cursor;
      let lab1 = true;
      lab1: while (lab1 == true) {
        lab1 = false;
        // (, line 203
        // goto, line 203
        golab2: while (true) {
          v_2 = this.cursor;
          let lab3 = true;
          while (lab3 == true) {
            lab3 = false;
            // (, line 203
            // [, line 203
            this.bra = this.cursor;
            // literal, line 203
            if (!this.eq_s('Y')) {
              break;
            }
            // ], line 203
            this.ket = this.cursor;
            this.cursor = v_2;
            break golab2;
          }
          this.cursor = v_2;
          if (this.cursor >= this.limit) {
            break lab1;
          }
          this.cursor++;
        }
        // <-, line 203
        if (!this.slice_from('y')) {
          return false;
        }
        continue replab0;
      }
      this.cursor = v_1;
      break;
    }
    return true;
  }

  innerStem() {
    let v_1;
    let v_2;
    let v_3;
    let v_4;
    let v_5;
    let v_6;
    let v_7;
    let v_8;
    let v_9;
    let v_10;
    let v_11;
    let v_12;
    let v_13;
    // (, line 205
    // or, line 207
    let lab0 = true;
    lab0: while (lab0 == true) {
      lab0 = false;
      v_1 = this.cursor;
      let lab1 = true;
      while (lab1 == true) {
        lab1 = false;
        // call exception1, line 207
        if (!this.r_exception1()) {
          break;
        }
        break lab0;
      }
      this.cursor = v_1;
      let lab2 = true;
      lab2: while (lab2 == true) {
        lab2 = false;
        // not, line 208
        {
          v_2 = this.cursor;
          let lab3 = true;
          while (lab3 == true) {
            lab3 = false;
            // hop, line 208
            {
              const c = this.cursor + 3;
              if (c < 0 || c > this.limit) {
                break;
              }
              this.cursor = c;
            }
            break lab2;
          }
          this.cursor = v_2;
        }
        break lab0;
      }
      this.cursor = v_1;
      // (, line 208
      // do, line 209
      v_3 = this.cursor;
      let lab4 = true;
      while (lab4 == true) {
        lab4 = false;
        // call prelude, line 209
        if (!this.r_prelude()) {
          break;
        }
      }
      this.cursor = v_3;
      // do, line 210
      v_4 = this.cursor;
      let lab5 = true;
      while (lab5 == true) {
        lab5 = false;
        // call mark_regions, line 210
        if (!this.r_mark_regions()) {
          break;
        }
      }
      this.cursor = v_4;
      // backwards, line 211
      this.limit_backward = this.cursor;
      this.cursor = this.limit;
      // (, line 211
      // do, line 213
      v_5 = this.limit - this.cursor;
      let lab6 = true;
      while (lab6 == true) {
        lab6 = false;
        // call Step_1a, line 213
        if (!this.r_Step_1a()) {
          break;
        }
      }
      this.cursor = this.limit - v_5;
      // or, line 215
      let lab7 = true;
      lab7: while (lab7 == true) {
        lab7 = false;
        v_6 = this.limit - this.cursor;
        let lab8 = true;
        while (lab8 == true) {
          lab8 = false;
          // call exception2, line 215
          if (!this.r_exception2()) {
            break;
          }
          break lab7;
        }
        this.cursor = this.limit - v_6;
        // (, line 215
        // do, line 217
        v_7 = this.limit - this.cursor;
        let lab9 = true;
        while (lab9 == true) {
          lab9 = false;
          // call Step_1b, line 217
          if (!this.r_Step_1b()) {
            break;
          }
        }
        this.cursor = this.limit - v_7;
        // do, line 218
        v_8 = this.limit - this.cursor;
        let lab10 = true;
        while (lab10 == true) {
          lab10 = false;
          // call Step_1c, line 218
          if (!this.r_Step_1c()) {
            break;
          }
        }
        this.cursor = this.limit - v_8;
        // do, line 220
        v_9 = this.limit - this.cursor;
        let lab11 = true;
        while (lab11 == true) {
          lab11 = false;
          // call Step_2, line 220
          if (!this.r_Step_2()) {
            break;
          }
        }
        this.cursor = this.limit - v_9;
        // do, line 221
        v_10 = this.limit - this.cursor;
        let lab12 = true;
        while (lab12 == true) {
          lab12 = false;
          // call Step_3, line 221
          if (!this.r_Step_3()) {
            break;
          }
        }
        this.cursor = this.limit - v_10;
        // do, line 222
        v_11 = this.limit - this.cursor;
        let lab13 = true;
        while (lab13 == true) {
          lab13 = false;
          // call Step_4, line 222
          if (!this.r_Step_4()) {
            break;
          }
        }
        this.cursor = this.limit - v_11;
        // do, line 224
        v_12 = this.limit - this.cursor;
        let lab14 = true;
        while (lab14 == true) {
          lab14 = false;
          // call Step_5, line 224
          if (!this.r_Step_5()) {
            break;
          }
        }
        this.cursor = this.limit - v_12;
      }
      this.cursor = this.limit_backward; // do, line 227
      v_13 = this.cursor;
      let lab15 = true;
      while (lab15 == true) {
        lab15 = false;
        // call postlude, line 227
        if (!this.r_postlude()) {
          break;
        }
      }
      this.cursor = v_13;
    }
    return true;
  }
}

StemmerEn.methodObject = new StemmerEn();

StemmerEn.a_0 = [
  new Among('arsen', -1, -1),
  new Among('commun', -1, -1),
  new Among('gener', -1, -1)
];

StemmerEn.a_1 = [
  new Among("'", -1, 1),
  new Among("'s'", 0, 1),
  new Among("'s", -1, 1)
];

StemmerEn.a_2 = [
  new Among('ied', -1, 2),
  new Among('s', -1, 3),
  new Among('ies', 1, 2),
  new Among('sses', 1, 1),
  new Among('ss', 1, -1),
  new Among('us', 1, -1)
];

StemmerEn.a_3 = [
  new Among('', -1, 3),
  new Among('bb', 0, 2),
  new Among('dd', 0, 2),
  new Among('ff', 0, 2),
  new Among('gg', 0, 2),
  new Among('bl', 0, 1),
  new Among('mm', 0, 2),
  new Among('nn', 0, 2),
  new Among('pp', 0, 2),
  new Among('rr', 0, 2),
  new Among('at', 0, 1),
  new Among('tt', 0, 2),
  new Among('iz', 0, 1)
];

StemmerEn.a_4 = [
  new Among('ed', -1, 2),
  new Among('eed', 0, 1),
  new Among('ing', -1, 2),
  new Among('edly', -1, 2),
  new Among('eedly', 3, 1),
  new Among('ingly', -1, 2)
];

StemmerEn.a_5 = [
  new Among('anci', -1, 3),
  new Among('enci', -1, 2),
  new Among('ogi', -1, 13),
  new Among('li', -1, 16),
  new Among('bli', 3, 12),
  new Among('abli', 4, 4),
  new Among('alli', 3, 8),
  new Among('fulli', 3, 14),
  new Among('lessli', 3, 15),
  new Among('ousli', 3, 10),
  new Among('entli', 3, 5),
  new Among('aliti', -1, 8),
  new Among('biliti', -1, 12),
  new Among('iviti', -1, 11),
  new Among('tional', -1, 1),
  new Among('ational', 14, 7),
  new Among('alism', -1, 8),
  new Among('ation', -1, 7),
  new Among('ization', 17, 6),
  new Among('izer', -1, 6),
  new Among('ator', -1, 7),
  new Among('iveness', -1, 11),
  new Among('fulness', -1, 9),
  new Among('ousness', -1, 10)
];

StemmerEn.a_6 = [
  new Among('icate', -1, 4),
  new Among('ative', -1, 6),
  new Among('alize', -1, 3),
  new Among('iciti', -1, 4),
  new Among('ical', -1, 4),
  new Among('tional', -1, 1),
  new Among('ational', 5, 2),
  new Among('ful', -1, 5),
  new Among('ness', -1, 5)
];

StemmerEn.a_7 = [
  new Among('ic', -1, 1),
  new Among('ance', -1, 1),
  new Among('ence', -1, 1),
  new Among('able', -1, 1),
  new Among('ible', -1, 1),
  new Among('ate', -1, 1),
  new Among('ive', -1, 1),
  new Among('ize', -1, 1),
  new Among('iti', -1, 1),
  new Among('al', -1, 1),
  new Among('ism', -1, 1),
  new Among('ion', -1, 2),
  new Among('er', -1, 1),
  new Among('ous', -1, 1),
  new Among('ant', -1, 1),
  new Among('ent', -1, 1),
  new Among('ment', 15, 1),
  new Among('ement', 16, 1)
];

StemmerEn.a_8 = [new Among('e', -1, 1), new Among('l', -1, 2)];

StemmerEn.a_9 = [
  new Among('succeed', -1, -1),
  new Among('proceed', -1, -1),
  new Among('exceed', -1, -1),
  new Among('canning', -1, -1),
  new Among('inning', -1, -1),
  new Among('earring', -1, -1),
  new Among('herring', -1, -1),
  new Among('outing', -1, -1)
];

StemmerEn.a_10 = [
  new Among('andes', -1, -1),
  new Among('atlas', -1, -1),
  new Among('bias', -1, -1),
  new Among('cosmos', -1, -1),
  new Among('dying', -1, 3),
  new Among('early', -1, 9),
  new Among('gently', -1, 7),
  new Among('howe', -1, -1),
  new Among('idly', -1, 6),
  new Among('lying', -1, 4),
  new Among('news', -1, -1),
  new Among('only', -1, 10),
  new Among('singly', -1, 11),
  new Among('skies', -1, 2),
  new Among('skis', -1, 1),
  new Among('sky', -1, -1),
  new Among('tying', -1, 5),
  new Among('ugly', -1, 8)
];

StemmerEn.g_v = [17, 65, 16, 1];

StemmerEn.g_v_WXY = [1, 17, 65, 208, 1];

StemmerEn.g_valid_LI = [55, 141, 2];

module.exports = StemmerEn;
