/*
 * J721S2 Clocks Info
 *
 * Copyright (C) 2022 Texas Instruments Incorporated - https://www.ti.com/
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <tisci.h>
#include <socinfo.h>

struct ti_sci_clocks_info j721s2_clocks_info[] = {
	{4, 0, "DEV_A72SS0_ARM_CLK_CLK", "Input clock"},
	{4, 1, "DEV_A72SS0_MSMC_CLK", "Input clock"},
	{4, 2, "DEV_A72SS0_PLL_CTRL_CLK", "Input clock"},
	{4, 6, "DEV_A72SS0_A72_DIVH_CLK8_OBSCLK_OUT_CLK", "Output clock"},
	{202, 0, "DEV_A72SS0_CORE0_ARM_CLK_CLK", "Input clock"},
	{203, 0, "DEV_A72SS0_CORE1_ARM_CLK_CLK", "Input clock"},
	{134, 0, "DEV_AGGR_ATB0_DBG_CLK", "Input clock"},
	{2, 0, "DEV_ATL0_ATL_IO_PORT_ATCLK_OUT", "Output clock"},
	{2, 1, "DEV_ATL0_ATL_IO_PORT_ATCLK_OUT_1", "Output clock"},
	{2, 2, "DEV_ATL0_ATL_IO_PORT_ATCLK_OUT_2", "Output clock"},
	{2, 3, "DEV_ATL0_ATL_IO_PORT_ATCLK_OUT_3", "Output clock"},
	{2, 4, "DEV_ATL0_ATL_CLK", "Input muxed clock"},
	{2, 5, "DEV_ATL0_ATL_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT1_CLK", "Parent input clock option to DEV_ATL0_ATL_CLK"},
	{2, 6, "DEV_ATL0_ATL_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_ATL0_ATL_CLK"},
	{2, 9, "DEV_ATL0_ATL_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT7_CLK", "Parent input clock option to DEV_ATL0_ATL_CLK"},
	{2, 10, "DEV_ATL0_ATL_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_ATL0_ATL_CLK"},
	{2, 11, "DEV_ATL0_ATL_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_ATL0_ATL_CLK"},
	{2, 13, "DEV_ATL0_VBUS_CLK", "Input clock"},
	{2, 14, "DEV_ATL0_ATL_IO_PORT_AWS", "Input muxed clock"},
	{2, 15, "DEV_ATL0_ATL_IO_PORT_AWS_PARENT_MCASP_MAIN_0_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS"},
	{2, 16, "DEV_ATL0_ATL_IO_PORT_AWS_PARENT_MCASP_MAIN_1_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS"},
	{2, 17, "DEV_ATL0_ATL_IO_PORT_AWS_PARENT_MCASP_MAIN_2_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS"},
	{2, 18, "DEV_ATL0_ATL_IO_PORT_AWS_PARENT_MCASP_MAIN_3_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS"},
	{2, 19, "DEV_ATL0_ATL_IO_PORT_AWS_PARENT_MCASP_MAIN_4_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS"},
	{2, 27, "DEV_ATL0_ATL_IO_PORT_AWS_PARENT_MCASP_MAIN_0_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS"},
	{2, 28, "DEV_ATL0_ATL_IO_PORT_AWS_PARENT_MCASP_MAIN_1_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS"},
	{2, 29, "DEV_ATL0_ATL_IO_PORT_AWS_PARENT_MCASP_MAIN_2_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS"},
	{2, 30, "DEV_ATL0_ATL_IO_PORT_AWS_PARENT_MCASP_MAIN_3_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS"},
	{2, 31, "DEV_ATL0_ATL_IO_PORT_AWS_PARENT_MCASP_MAIN_4_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS"},
	{2, 39, "DEV_ATL0_ATL_IO_PORT_AWS_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS"},
	{2, 40, "DEV_ATL0_ATL_IO_PORT_AWS_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS"},
	{2, 47, "DEV_ATL0_ATL_IO_PORT_AWS_1", "Input muxed clock"},
	{2, 48, "DEV_ATL0_ATL_IO_PORT_AWS_1_PARENT_MCASP_MAIN_0_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_1"},
	{2, 49, "DEV_ATL0_ATL_IO_PORT_AWS_1_PARENT_MCASP_MAIN_1_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_1"},
	{2, 50, "DEV_ATL0_ATL_IO_PORT_AWS_1_PARENT_MCASP_MAIN_2_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_1"},
	{2, 51, "DEV_ATL0_ATL_IO_PORT_AWS_1_PARENT_MCASP_MAIN_3_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_1"},
	{2, 52, "DEV_ATL0_ATL_IO_PORT_AWS_1_PARENT_MCASP_MAIN_4_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_1"},
	{2, 60, "DEV_ATL0_ATL_IO_PORT_AWS_1_PARENT_MCASP_MAIN_0_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_1"},
	{2, 61, "DEV_ATL0_ATL_IO_PORT_AWS_1_PARENT_MCASP_MAIN_1_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_1"},
	{2, 62, "DEV_ATL0_ATL_IO_PORT_AWS_1_PARENT_MCASP_MAIN_2_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_1"},
	{2, 63, "DEV_ATL0_ATL_IO_PORT_AWS_1_PARENT_MCASP_MAIN_3_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_1"},
	{2, 64, "DEV_ATL0_ATL_IO_PORT_AWS_1_PARENT_MCASP_MAIN_4_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_1"},
	{2, 72, "DEV_ATL0_ATL_IO_PORT_AWS_1_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_1"},
	{2, 73, "DEV_ATL0_ATL_IO_PORT_AWS_1_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_1"},
	{2, 80, "DEV_ATL0_ATL_IO_PORT_AWS_2", "Input muxed clock"},
	{2, 81, "DEV_ATL0_ATL_IO_PORT_AWS_2_PARENT_MCASP_MAIN_0_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_2"},
	{2, 82, "DEV_ATL0_ATL_IO_PORT_AWS_2_PARENT_MCASP_MAIN_1_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_2"},
	{2, 83, "DEV_ATL0_ATL_IO_PORT_AWS_2_PARENT_MCASP_MAIN_2_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_2"},
	{2, 84, "DEV_ATL0_ATL_IO_PORT_AWS_2_PARENT_MCASP_MAIN_3_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_2"},
	{2, 85, "DEV_ATL0_ATL_IO_PORT_AWS_2_PARENT_MCASP_MAIN_4_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_2"},
	{2, 93, "DEV_ATL0_ATL_IO_PORT_AWS_2_PARENT_MCASP_MAIN_0_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_2"},
	{2, 94, "DEV_ATL0_ATL_IO_PORT_AWS_2_PARENT_MCASP_MAIN_1_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_2"},
	{2, 95, "DEV_ATL0_ATL_IO_PORT_AWS_2_PARENT_MCASP_MAIN_2_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_2"},
	{2, 96, "DEV_ATL0_ATL_IO_PORT_AWS_2_PARENT_MCASP_MAIN_3_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_2"},
	{2, 97, "DEV_ATL0_ATL_IO_PORT_AWS_2_PARENT_MCASP_MAIN_4_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_2"},
	{2, 105, "DEV_ATL0_ATL_IO_PORT_AWS_2_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_2"},
	{2, 106, "DEV_ATL0_ATL_IO_PORT_AWS_2_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_2"},
	{2, 113, "DEV_ATL0_ATL_IO_PORT_AWS_3", "Input muxed clock"},
	{2, 114, "DEV_ATL0_ATL_IO_PORT_AWS_3_PARENT_MCASP_MAIN_0_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_3"},
	{2, 115, "DEV_ATL0_ATL_IO_PORT_AWS_3_PARENT_MCASP_MAIN_1_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_3"},
	{2, 116, "DEV_ATL0_ATL_IO_PORT_AWS_3_PARENT_MCASP_MAIN_2_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_3"},
	{2, 117, "DEV_ATL0_ATL_IO_PORT_AWS_3_PARENT_MCASP_MAIN_3_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_3"},
	{2, 118, "DEV_ATL0_ATL_IO_PORT_AWS_3_PARENT_MCASP_MAIN_4_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_3"},
	{2, 126, "DEV_ATL0_ATL_IO_PORT_AWS_3_PARENT_MCASP_MAIN_0_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_3"},
	{2, 127, "DEV_ATL0_ATL_IO_PORT_AWS_3_PARENT_MCASP_MAIN_1_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_3"},
	{2, 128, "DEV_ATL0_ATL_IO_PORT_AWS_3_PARENT_MCASP_MAIN_2_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_3"},
	{2, 129, "DEV_ATL0_ATL_IO_PORT_AWS_3_PARENT_MCASP_MAIN_3_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_3"},
	{2, 130, "DEV_ATL0_ATL_IO_PORT_AWS_3_PARENT_MCASP_MAIN_4_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_3"},
	{2, 138, "DEV_ATL0_ATL_IO_PORT_AWS_3_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_3"},
	{2, 139, "DEV_ATL0_ATL_IO_PORT_AWS_3_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_3"},
	{2, 146, "DEV_ATL0_ATL_IO_PORT_BWS", "Input muxed clock"},
	{2, 147, "DEV_ATL0_ATL_IO_PORT_BWS_PARENT_MCASP_MAIN_0_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS"},
	{2, 148, "DEV_ATL0_ATL_IO_PORT_BWS_PARENT_MCASP_MAIN_1_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS"},
	{2, 149, "DEV_ATL0_ATL_IO_PORT_BWS_PARENT_MCASP_MAIN_2_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS"},
	{2, 150, "DEV_ATL0_ATL_IO_PORT_BWS_PARENT_MCASP_MAIN_3_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS"},
	{2, 151, "DEV_ATL0_ATL_IO_PORT_BWS_PARENT_MCASP_MAIN_4_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS"},
	{2, 159, "DEV_ATL0_ATL_IO_PORT_BWS_PARENT_MCASP_MAIN_0_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS"},
	{2, 160, "DEV_ATL0_ATL_IO_PORT_BWS_PARENT_MCASP_MAIN_1_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS"},
	{2, 161, "DEV_ATL0_ATL_IO_PORT_BWS_PARENT_MCASP_MAIN_2_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS"},
	{2, 162, "DEV_ATL0_ATL_IO_PORT_BWS_PARENT_MCASP_MAIN_3_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS"},
	{2, 163, "DEV_ATL0_ATL_IO_PORT_BWS_PARENT_MCASP_MAIN_4_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS"},
	{2, 171, "DEV_ATL0_ATL_IO_PORT_BWS_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS"},
	{2, 172, "DEV_ATL0_ATL_IO_PORT_BWS_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS"},
	{2, 179, "DEV_ATL0_ATL_IO_PORT_BWS_1", "Input muxed clock"},
	{2, 180, "DEV_ATL0_ATL_IO_PORT_BWS_1_PARENT_MCASP_MAIN_0_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_1"},
	{2, 181, "DEV_ATL0_ATL_IO_PORT_BWS_1_PARENT_MCASP_MAIN_1_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_1"},
	{2, 182, "DEV_ATL0_ATL_IO_PORT_BWS_1_PARENT_MCASP_MAIN_2_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_1"},
	{2, 183, "DEV_ATL0_ATL_IO_PORT_BWS_1_PARENT_MCASP_MAIN_3_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_1"},
	{2, 184, "DEV_ATL0_ATL_IO_PORT_BWS_1_PARENT_MCASP_MAIN_4_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_1"},
	{2, 192, "DEV_ATL0_ATL_IO_PORT_BWS_1_PARENT_MCASP_MAIN_0_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_1"},
	{2, 193, "DEV_ATL0_ATL_IO_PORT_BWS_1_PARENT_MCASP_MAIN_1_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_1"},
	{2, 194, "DEV_ATL0_ATL_IO_PORT_BWS_1_PARENT_MCASP_MAIN_2_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_1"},
	{2, 195, "DEV_ATL0_ATL_IO_PORT_BWS_1_PARENT_MCASP_MAIN_3_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_1"},
	{2, 196, "DEV_ATL0_ATL_IO_PORT_BWS_1_PARENT_MCASP_MAIN_4_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_1"},
	{2, 204, "DEV_ATL0_ATL_IO_PORT_BWS_1_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_1"},
	{2, 205, "DEV_ATL0_ATL_IO_PORT_BWS_1_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_1"},
	{2, 212, "DEV_ATL0_ATL_IO_PORT_BWS_2", "Input muxed clock"},
	{2, 213, "DEV_ATL0_ATL_IO_PORT_BWS_2_PARENT_MCASP_MAIN_0_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_2"},
	{2, 214, "DEV_ATL0_ATL_IO_PORT_BWS_2_PARENT_MCASP_MAIN_1_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_2"},
	{2, 215, "DEV_ATL0_ATL_IO_PORT_BWS_2_PARENT_MCASP_MAIN_2_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_2"},
	{2, 216, "DEV_ATL0_ATL_IO_PORT_BWS_2_PARENT_MCASP_MAIN_3_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_2"},
	{2, 217, "DEV_ATL0_ATL_IO_PORT_BWS_2_PARENT_MCASP_MAIN_4_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_2"},
	{2, 225, "DEV_ATL0_ATL_IO_PORT_BWS_2_PARENT_MCASP_MAIN_0_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_2"},
	{2, 226, "DEV_ATL0_ATL_IO_PORT_BWS_2_PARENT_MCASP_MAIN_1_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_2"},
	{2, 227, "DEV_ATL0_ATL_IO_PORT_BWS_2_PARENT_MCASP_MAIN_2_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_2"},
	{2, 228, "DEV_ATL0_ATL_IO_PORT_BWS_2_PARENT_MCASP_MAIN_3_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_2"},
	{2, 229, "DEV_ATL0_ATL_IO_PORT_BWS_2_PARENT_MCASP_MAIN_4_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_2"},
	{2, 237, "DEV_ATL0_ATL_IO_PORT_BWS_2_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_2"},
	{2, 238, "DEV_ATL0_ATL_IO_PORT_BWS_2_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_2"},
	{2, 245, "DEV_ATL0_ATL_IO_PORT_BWS_3", "Input muxed clock"},
	{2, 246, "DEV_ATL0_ATL_IO_PORT_BWS_3_PARENT_MCASP_MAIN_0_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_3"},
	{2, 247, "DEV_ATL0_ATL_IO_PORT_BWS_3_PARENT_MCASP_MAIN_1_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_3"},
	{2, 248, "DEV_ATL0_ATL_IO_PORT_BWS_3_PARENT_MCASP_MAIN_2_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_3"},
	{2, 249, "DEV_ATL0_ATL_IO_PORT_BWS_3_PARENT_MCASP_MAIN_3_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_3"},
	{2, 250, "DEV_ATL0_ATL_IO_PORT_BWS_3_PARENT_MCASP_MAIN_4_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_3"},
	{2, 258, "DEV_ATL0_ATL_IO_PORT_BWS_3_PARENT_MCASP_MAIN_0_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_3"},
	{2, 259, "DEV_ATL0_ATL_IO_PORT_BWS_3_PARENT_MCASP_MAIN_1_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_3"},
	{2, 260, "DEV_ATL0_ATL_IO_PORT_BWS_3_PARENT_MCASP_MAIN_2_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_3"},
	{2, 261, "DEV_ATL0_ATL_IO_PORT_BWS_3_PARENT_MCASP_MAIN_3_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_3"},
	{2, 262, "DEV_ATL0_ATL_IO_PORT_BWS_3_PARENT_MCASP_MAIN_4_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_3"},
	{2, 270, "DEV_ATL0_ATL_IO_PORT_BWS_3_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_3"},
	{2, 271, "DEV_ATL0_ATL_IO_PORT_BWS_3_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_3"},
	{157, 1, "DEV_BOARD0_DSI0_TXCLKN_IN", "Input clock"},
	{157, 2, "DEV_BOARD0_I2C4_SCL_OUT", "Output clock"},
	{157, 4, "DEV_BOARD0_CSI0_TXCLKN_IN", "Input clock"},
	{157, 5, "DEV_BOARD0_CSI0_RXCLKP_OUT", "Output clock"},
	{157, 6, "DEV_BOARD0_HYP0_TXPMCLK_IN", "Input clock"},
	{157, 7, "DEV_BOARD0_MCAN1_RX_OUT", "Output clock"},
	{157, 8, "DEV_BOARD0_MCAN17_RX_OUT", "Output clock"},
	{157, 9, "DEV_BOARD0_MMC1_CLK_IN", "Input clock"},
	{157, 10, "DEV_BOARD0_MCU_OBSCLK0_IN", "Input muxed clock"},
	{157, 11, "DEV_BOARD0_MCU_OBSCLK0_IN_PARENT_MCU_OBSCLK_DIV_OUT0", "Parent input clock option to DEV_BOARD0_MCU_OBSCLK0_IN"},
	{157, 12, "DEV_BOARD0_MCU_OBSCLK0_IN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_BOARD0_MCU_OBSCLK0_IN"},
	{157, 43, "DEV_BOARD0_I2C0_SCL_IN", "Input clock"},
	{157, 44, "DEV_BOARD0_SPI7_CLK_OUT", "Output clock"},
	{157, 45, "DEV_BOARD0_MCU_CPTS0_RFT_CLK_OUT", "Output clock"},
	{157, 46, "DEV_BOARD0_MCASP3_ACLKR_IN", "Input clock"},
	{157, 47, "DEV_BOARD0_AUDIO_EXT_REFCLK1_OUT", "Output clock"},
	{157, 48, "DEV_BOARD0_MCU_OSPI0_DQS_OUT", "Output clock"},
	{157, 49, "DEV_BOARD0_HYP0_TXFLCLK_OUT", "Output clock"},
	{157, 50, "DEV_BOARD0_MCU_OSPI0_LBCLKO_OUT", "Output clock"},
	{157, 51, "DEV_BOARD0_MCASP3_ACLKX_IN", "Input clock"},
	{157, 52, "DEV_BOARD0_HYP0_RXPMCLK_OUT", "Output clock"},
	{157, 54, "DEV_BOARD0_MCASP1_ACLKX_IN", "Input clock"},
	{157, 55, "DEV_BOARD0_MCU_SPI1_CLK_IN", "Input clock"},
	{157, 56, "DEV_BOARD0_MCAN9_RX_OUT", "Output clock"},
	{157, 57, "DEV_BOARD0_I2C6_SCL_OUT", "Output clock"},
	{157, 58, "DEV_BOARD0_MCU_SPI0_CLK_OUT", "Output clock"},
	{157, 59, "DEV_BOARD0_OBSCLK1_IN", "Input clock"},
	{157, 60, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 61, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 62, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 63, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 64, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 65, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV1_16FFT_MAIN_5_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 66, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV0_16FFT_MAIN_6_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 67, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV0_16FFT_MAIN_26_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 72, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV0_16FFT_MAIN_12_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 73, "DEV_BOARD0_OBSCLK1_IN_PARENT_OBSCLK1_MUX_OUT0", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 74, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV2_16FFT_MAIN_14_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 76, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV1_16FFT_MAIN_16_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 77, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV1_16FFT_MAIN_17_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 79, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV1_16FFT_MAIN_19_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 85, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV1_16FFT_MAIN_25_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 86, "DEV_BOARD0_OBSCLK1_IN_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 87, "DEV_BOARD0_OBSCLK1_IN_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 88, "DEV_BOARD0_OBSCLK1_IN_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 89, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT0_CLK_DUP0", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 90, "DEV_BOARD0_OBSCLK1_IN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 91, "DEV_BOARD0_OBSCLK1_IN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 92, "DEV_BOARD0_MCU_OSPI1_LBCLKO_OUT", "Output clock"},
	{157, 93, "DEV_BOARD0_MCASP3_ACLKX_OUT", "Output clock"},
	{157, 95, "DEV_BOARD0_MCASP2_AFSR_OUT", "Output clock"},
	{157, 96, "DEV_BOARD0_TRC_CLK_IN", "Input clock"},
	{157, 100, "DEV_BOARD0_CSI1_RXCLKN_OUT", "Output clock"},
	{157, 102, "DEV_BOARD0_MCASP0_ACLKX_OUT", "Output clock"},
	{157, 103, "DEV_BOARD0_MCU_OSPI0_CLK_IN", "Input clock"},
	{157, 105, "DEV_BOARD0_GPMC0_FCLK_MUX_IN", "Input clock"},
	{157, 106, "DEV_BOARD0_MCU_SPI0_CLK_IN", "Input clock"},
	{157, 108, "DEV_BOARD0_MCU_RGMII1_RXC_OUT", "Output clock"},
	{157, 109, "DEV_BOARD0_MCASP0_AFSR_OUT", "Output clock"},
	{157, 110, "DEV_BOARD0_CSI1_RXCLKP_OUT", "Output clock"},
	{157, 111, "DEV_BOARD0_MCU_SYSCLKOUT0_IN", "Input clock"},
	{157, 112, "DEV_BOARD0_SPI5_CLK_OUT", "Output clock"},
	{157, 113, "DEV_BOARD0_MCU_RMII1_REF_CLK_OUT", "Output clock"},
	{157, 114, "DEV_BOARD0_SPI0_CLK_OUT", "Output clock"},
	{157, 116, "DEV_BOARD0_SPI6_CLK_OUT", "Output clock"},
	{157, 117, "DEV_BOARD0_I2C1_SCL_IN", "Input clock"},
	{157, 118, "DEV_BOARD0_DSI1_TXCLKP_IN", "Input clock"},
	{157, 119, "DEV_BOARD0_MCAN0_RX_OUT", "Output clock"},
	{157, 120, "DEV_BOARD0_MCASP0_ACLKR_OUT", "Output clock"},
	{157, 121, "DEV_BOARD0_RMII_REF_CLK_OUT", "Output clock"},
	{157, 123, "DEV_BOARD0_MCAN14_RX_OUT", "Output clock"},
	{157, 125, "DEV_BOARD0_MCU_I2C0_SCL_OUT", "Output clock"},
	{157, 126, "DEV_BOARD0_SPI6_CLK_IN", "Input clock"},
	{157, 128, "DEV_BOARD0_MCASP3_AFSX_OUT", "Output clock"},
	{157, 129, "DEV_BOARD0_MCU_SPI1_CLK_OUT", "Output clock"},
	{157, 130, "DEV_BOARD0_SERDES0_REFCLK_P_IN", "Input clock"},
	{157, 131, "DEV_BOARD0_SERDES0_REFCLK_P_OUT", "Output clock"},
	{157, 132, "DEV_BOARD0_MCASP1_ACLKR_IN", "Input clock"},
	{157, 134, "DEV_BOARD0_MCASP1_AFSX_OUT", "Output clock"},
	{157, 135, "DEV_BOARD0_SPI1_CLK_OUT", "Output clock"},
	{157, 136, "DEV_BOARD0_I2C3_SCL_IN", "Input clock"},
	{157, 137, "DEV_BOARD0_MCU_I2C0_SCL_IN", "Input clock"},
	{157, 138, "DEV_BOARD0_HYP1_TXPMCLK_IN", "Input clock"},
	{157, 139, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN", "Input muxed clock"},
	{157, 140, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_0_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 141, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_1_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 142, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_2_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 143, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_3_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 144, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_4_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 152, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_0_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 153, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_1_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 154, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_2_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 155, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_3_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 156, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_4_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 164, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 165, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 166, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 167, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 168, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 173, "DEV_BOARD0_MCASP2_ACLKX_OUT", "Output clock"},
	{157, 175, "DEV_BOARD0_MMC1_CLKLB_OUT", "Output clock"},
	{157, 176, "DEV_BOARD0_WKUP_I2C0_SCL_OUT", "Output clock"},
	{157, 177, "DEV_BOARD0_SYSCLKOUT0_IN", "Input clock"},
	{157, 178, "DEV_BOARD0_I2C1_SCL_OUT", "Output clock"},
	{157, 179, "DEV_BOARD0_MCU_OSPI0_LBCLKO_IN", "Input clock"},
	{157, 180, "DEV_BOARD0_SPI3_CLK_IN", "Input clock"},
	{157, 181, "DEV_BOARD0_MCAN13_RX_OUT", "Output clock"},
	{157, 182, "DEV_BOARD0_WKUP_I2C0_SCL_IN", "Input clock"},
	{157, 183, "DEV_BOARD0_DSI1_TXCLKN_IN", "Input clock"},
	{157, 184, "DEV_BOARD0_CPTS0_RFT_CLK_OUT", "Output clock"},
	{157, 185, "DEV_BOARD0_MCU_I2C1_SCL_OUT", "Output clock"},
	{157, 186, "DEV_BOARD0_MCASP0_ACLKR_IN", "Input clock"},
	{157, 187, "DEV_BOARD0_MCU_OSPI1_LBCLKO_IN", "Input clock"},
	{157, 188, "DEV_BOARD0_MCASP0_AFSX_OUT", "Output clock"},
	{157, 190, "DEV_BOARD0_MCU_I3C0_SDA_OUT", "Output clock"},
	{157, 191, "DEV_BOARD0_MCASP0_ACLKX_IN", "Input clock"},
	{157, 192, "DEV_BOARD0_AUDIO_EXT_REFCLK0_OUT", "Output clock"},
	{157, 193, "DEV_BOARD0_MCAN3_RX_OUT", "Output clock"},
	{157, 194, "DEV_BOARD0_MMC1_CLKLB_IN", "Input clock"},
	{157, 195, "DEV_BOARD0_MCASP2_ACLKR_OUT", "Output clock"},
	{157, 198, "DEV_BOARD0_HFOSC1_CLK_OUT", "Output clock"},
	{157, 199, "DEV_BOARD0_MCASP1_ACLKR_OUT", "Output clock"},
	{157, 200, "DEV_BOARD0_MCAN4_RX_OUT", "Output clock"},
	{157, 201, "DEV_BOARD0_MCASP4_ACLKX_OUT", "Output clock"},
	{157, 202, "DEV_BOARD0_CSI1_TXCLKP_IN", "Input clock"},
	{157, 203, "DEV_BOARD0_MCASP3_AFSR_OUT", "Output clock"},
	{157, 204, "DEV_BOARD0_LED_CLK_OUT", "Output clock"},
	{157, 206, "DEV_BOARD0_MCAN7_RX_OUT", "Output clock"},
	{157, 207, "DEV_BOARD0_MCU_MDIO0_MDC_IN", "Input clock"},
	{157, 209, "DEV_BOARD0_MCASP4_ACLKR_IN", "Input clock"},
	{157, 210, "DEV_BOARD0_I2C2_SCL_IN", "Input clock"},
	{157, 212, "DEV_BOARD0_SPI1_CLK_IN", "Input clock"},
	{157, 213, "DEV_BOARD0_HYP1_RXPMCLK_OUT", "Output clock"},
	{157, 214, "DEV_BOARD0_MCU_HYPERBUS0_CK_IN", "Input clock"},
	{157, 215, "DEV_BOARD0_MCASP2_AFSX_OUT", "Output clock"},
	{157, 216, "DEV_BOARD0_MCASP3_ACLKR_OUT", "Output clock"},
	{157, 217, "DEV_BOARD0_MCAN15_RX_OUT", "Output clock"},
	{157, 218, "DEV_BOARD0_SPI0_CLK_IN", "Input clock"},
	{157, 219, "DEV_BOARD0_MCAN12_RX_OUT", "Output clock"},
	{157, 220, "DEV_BOARD0_MCASP2_ACLKR_IN", "Input clock"},
	{157, 221, "DEV_BOARD0_MCU_CLKOUT0_IN", "Input muxed clock"},
	{157, 222, "DEV_BOARD0_MCU_CLKOUT0_IN_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT0_CLK5", "Parent input clock option to DEV_BOARD0_MCU_CLKOUT0_IN"},
	{157, 223, "DEV_BOARD0_MCU_CLKOUT0_IN_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT0_CLK10", "Parent input clock option to DEV_BOARD0_MCU_CLKOUT0_IN"},
	{157, 224, "DEV_BOARD0_MCU_OSPI1_DQS_OUT", "Output clock"},
	{157, 226, "DEV_BOARD0_CSI0_RXCLKN_OUT", "Output clock"},
	{157, 227, "DEV_BOARD0_TCK_OUT", "Output clock"},
	{157, 228, "DEV_BOARD0_CSI1_TXCLKN_IN", "Input clock"},
	{157, 229, "DEV_BOARD0_MCU_MCAN0_RX_OUT", "Output clock"},
	{157, 230, "DEV_BOARD0_MCASP4_AFSR_OUT", "Output clock"},
	{157, 231, "DEV_BOARD0_MCU_HYPERBUS0_CKN_IN", "Input clock"},
	{157, 232, "DEV_BOARD0_MCASP4_ACLKR_OUT", "Output clock"},
	{157, 233, "DEV_BOARD0_MCAN11_RX_OUT", "Output clock"},
	{157, 234, "DEV_BOARD0_I2C5_SCL_IN", "Input clock"},
	{157, 235, "DEV_BOARD0_MCU_I2C1_SCL_IN", "Input clock"},
	{157, 236, "DEV_BOARD0_I2C0_SCL_OUT", "Output clock"},
	{157, 237, "DEV_BOARD0_MCAN6_RX_OUT", "Output clock"},
	{157, 238, "DEV_BOARD0_MCU_I3C0_SCL_IN", "Input clock"},
	{157, 239, "DEV_BOARD0_MMC1_CLK_OUT", "Output clock"},
	{157, 240, "DEV_BOARD0_VOUT0_EXTPCLKIN_OUT", "Output clock"},
	{157, 241, "DEV_BOARD0_EXT_REFCLK1_OUT", "Output clock"},
	{157, 242, "DEV_BOARD0_I2C5_SCL_OUT", "Output clock"},
	{157, 243, "DEV_BOARD0_MCAN16_RX_OUT", "Output clock"},
	{157, 244, "DEV_BOARD0_MCU_RGMII1_TXC_IN", "Input clock"},
	{157, 245, "DEV_BOARD0_MCASP4_ACLKX_IN", "Input clock"},
	{157, 246, "DEV_BOARD0_GPMC0_CLKOUT_IN", "Input clock"},
	{157, 247, "DEV_BOARD0_GPMC0_CLK_OUT", "Output clock"},
	{157, 248, "DEV_BOARD0_I2C6_SCL_IN", "Input clock"},
	{157, 249, "DEV_BOARD0_I2C4_SCL_IN", "Input clock"},
	{157, 250, "DEV_BOARD0_SERDES0_REFCLK_N_IN", "Input clock"},
	{157, 251, "DEV_BOARD0_OBSCLK0_IN", "Input clock"},
	{157, 252, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 253, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 254, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 255, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 256, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 257, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV1_16FFT_MAIN_5_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 258, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV0_16FFT_MAIN_6_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 259, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV0_16FFT_MAIN_26_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 264, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV0_16FFT_MAIN_12_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 265, "DEV_BOARD0_OBSCLK0_IN_PARENT_OBSCLK1_MUX_OUT0", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 266, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV2_16FFT_MAIN_14_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 268, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV1_16FFT_MAIN_16_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 269, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV1_16FFT_MAIN_17_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 271, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV1_16FFT_MAIN_19_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 277, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV1_16FFT_MAIN_25_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 278, "DEV_BOARD0_OBSCLK0_IN_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 279, "DEV_BOARD0_OBSCLK0_IN_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 280, "DEV_BOARD0_OBSCLK0_IN_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 281, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT0_CLK_DUP0", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 282, "DEV_BOARD0_OBSCLK0_IN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 283, "DEV_BOARD0_OBSCLK0_IN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 284, "DEV_BOARD0_MCAN2_RX_OUT", "Output clock"},
	{157, 285, "DEV_BOARD0_MCASP2_ACLKX_IN", "Input clock"},
	{157, 287, "DEV_BOARD0_MCU_EXT_REFCLK0_OUT", "Output clock"},
	{157, 288, "DEV_BOARD0_MCASP1_ACLKX_OUT", "Output clock"},
	{157, 289, "DEV_BOARD0_SPI2_CLK_OUT", "Output clock"},
	{157, 290, "DEV_BOARD0_HYP0_RXFLCLK_IN", "Input clock"},
	{157, 291, "DEV_BOARD0_SPI3_CLK_OUT", "Output clock"},
	{157, 292, "DEV_BOARD0_MCASP1_AFSR_OUT", "Output clock"},
	{157, 293, "DEV_BOARD0_I2C2_SCL_OUT", "Output clock"},
	{157, 294, "DEV_BOARD0_MCAN10_RX_OUT", "Output clock"},
	{157, 295, "DEV_BOARD0_MCAN5_RX_OUT", "Output clock"},
	{157, 296, "DEV_BOARD0_MCU_I3C0_SCL_OUT", "Output clock"},
	{157, 297, "DEV_BOARD0_MCU_MCAN1_RX_OUT", "Output clock"},
	{157, 299, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN", "Input muxed clock"},
	{157, 300, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_0_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 301, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_1_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 302, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_2_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 303, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_3_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 304, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_4_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 312, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_0_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 313, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_1_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 314, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_2_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 315, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_3_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 316, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_4_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 324, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 325, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 326, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 327, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 328, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 333, "DEV_BOARD0_HYP1_TXFLCLK_OUT", "Output clock"},
	{157, 334, "DEV_BOARD0_SPI5_CLK_IN", "Input clock"},
	{157, 335, "DEV_BOARD0_I2C3_SCL_OUT", "Output clock"},
	{157, 336, "DEV_BOARD0_MCAN8_RX_OUT", "Output clock"},
	{157, 338, "DEV_BOARD0_RGMII1_RXC_OUT", "Output clock"},
	{157, 339, "DEV_BOARD0_SERDES0_REFCLK_N_OUT", "Output clock"},
	{157, 340, "DEV_BOARD0_CSI0_TXCLKP_IN", "Input clock"},
	{157, 341, "DEV_BOARD0_SPI7_CLK_IN", "Input clock"},
	{157, 342, "DEV_BOARD0_RGMII1_TXC_IN", "Input clock"},
	{157, 343, "DEV_BOARD0_HYP1_RXFLCLK_IN", "Input clock"},
	{157, 344, "DEV_BOARD0_MDIO1_MDC_IN", "Input clock"},
	{157, 345, "DEV_BOARD0_SPI2_CLK_IN", "Input clock"},
	{157, 346, "DEV_BOARD0_DSI0_TXCLKP_IN", "Input clock"},
	{157, 347, "DEV_BOARD0_MCASP4_AFSX_OUT", "Output clock"},
	{157, 352, "DEV_BOARD0_VOUT0_PCLK_IN", "Input clock"},
	{150, 0, "DEV_CMPEVENT_INTRTR0_INTR_CLK", "Input clock"},
	{179, 0, "DEV_CODEC0_VPU_PCLK_CLK", "Input clock"},
	{179, 1, "DEV_CODEC0_VPU_BCLK_CLK", "Input clock"},
	{179, 2, "DEV_CODEC0_VPU_CCLK_CLK", "Input clock"},
	{179, 3, "DEV_CODEC0_VPU_ACLK_CLK", "Input clock"},
	{8, 0, "DEV_COMPUTE_CLUSTER0_C71SS0_0_C7X_CLK", "Input clock"},
	{8, 1, "DEV_COMPUTE_CLUSTER0_C71SS0_0_PLL_CTRL_CLK", "Input clock"},
	{8, 3, "DEV_COMPUTE_CLUSTER0_C71SS0_0_C7X_DIVH_CLK4_OBSCLK_OUT_CLK", "Output clock"},
	{11, 0, "DEV_COMPUTE_CLUSTER0_C71SS1_0_C7X_CLK", "Input clock"},
	{11, 1, "DEV_COMPUTE_CLUSTER0_C71SS1_0_PLL_CTRL_CLK", "Input clock"},
	{14, 1, "DEV_COMPUTE_CLUSTER0_CLEC_CLK1_CLK", "Input clock"},
	{15, 1, "DEV_COMPUTE_CLUSTER0_CORE_CORE_CLK1_CLK", "Input clock"},
	{15, 2, "DEV_COMPUTE_CLUSTER0_CORE_CORE_PSIL_LEAF_CLK", "Input clock"},
	{18, 0, "DEV_COMPUTE_CLUSTER0_DEBUG_WRAP_0_CLK1_CLK_CLK", "Input clock"},
	{18, 1, "DEV_COMPUTE_CLUSTER0_DEBUG_WRAP_0_CLK2_CLK_CLK", "Input clock"},
	{25, 0, "DEV_COMPUTE_CLUSTER0_EN_MSMC_DOMAIN_0_MSMC_CLK1_CLK", "Input clock"},
	{26, 0, "DEV_COMPUTE_CLUSTER0_GIC500SS_VCLK_CLK", "Input clock"},
	{27, 3, "DEV_COMPUTE_CLUSTER0_PBIST_WRAP_0_DIVP_CLK1_CLK_CLK", "Input clock"},
	{27, 4, "DEV_COMPUTE_CLUSTER0_PBIST_WRAP_0_DIVH_CLK2_CLK_CLK", "Input clock"},
	{28, 0, "DEV_CPSW1_MDIO_MDCLK_O", "Output clock"},
	{28, 1, "DEV_CPSW1_CPTS_GENF0", "Output clock"},
	{28, 3, "DEV_CPSW1_CPTS_RFT_CLK", "Input muxed clock"},
	{28, 4, "DEV_CPSW1_CPTS_RFT_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT1_CLK", "Parent input clock option to DEV_CPSW1_CPTS_RFT_CLK"},
	{28, 5, "DEV_CPSW1_CPTS_RFT_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_CPSW1_CPTS_RFT_CLK"},
	{28, 6, "DEV_CPSW1_CPTS_RFT_CLK_PARENT_BOARD_0_MCU_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_CPSW1_CPTS_RFT_CLK"},
	{28, 7, "DEV_CPSW1_CPTS_RFT_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_CPSW1_CPTS_RFT_CLK"},
	{28, 8, "DEV_CPSW1_CPTS_RFT_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_CPSW1_CPTS_RFT_CLK"},
	{28, 9, "DEV_CPSW1_CPTS_RFT_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_CPSW1_CPTS_RFT_CLK"},
	{28, 10, "DEV_CPSW1_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT2_MAIN_0_IP2_LN0_TXMCLK", "Parent input clock option to DEV_CPSW1_CPTS_RFT_CLK"},
	{28, 11, "DEV_CPSW1_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT2_MAIN_0_IP2_LN1_TXMCLK", "Parent input clock option to DEV_CPSW1_CPTS_RFT_CLK"},
	{28, 12, "DEV_CPSW1_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT2_MAIN_0_IP2_LN2_TXMCLK", "Parent input clock option to DEV_CPSW1_CPTS_RFT_CLK"},
	{28, 13, "DEV_CPSW1_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT2_MAIN_0_IP2_LN3_TXMCLK", "Parent input clock option to DEV_CPSW1_CPTS_RFT_CLK"},
	{28, 18, "DEV_CPSW1_CPTS_RFT_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_CPSW1_CPTS_RFT_CLK"},
	{28, 19, "DEV_CPSW1_CPTS_RFT_CLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_CPSW1_CPTS_RFT_CLK"},
	{28, 20, "DEV_CPSW1_GMII1_MR_CLK", "Input clock"},
	{28, 21, "DEV_CPSW1_GMII_RFT_CLK", "Input clock"},
	{28, 22, "DEV_CPSW1_RGMII1_RXC_I", "Input clock"},
	{28, 26, "DEV_CPSW1_RMII_MHZ_50_CLK", "Input clock"},
	{28, 27, "DEV_CPSW1_RGMII1_TXC_O", "Output clock"},
	{28, 28, "DEV_CPSW1_CPPI_CLK_CLK", "Input clock"},
	{28, 29, "DEV_CPSW1_RGMII_MHZ_5_CLK", "Input clock"},
	{28, 30, "DEV_CPSW1_GMII1_MT_CLK", "Input clock"},
	{28, 32, "DEV_CPSW1_RGMII_MHZ_50_CLK", "Input clock"},
	{28, 33, "DEV_CPSW1_RGMII_MHZ_250_CLK", "Input clock"},
	{36, 0, "DEV_CPT2_AGGR0_VCLK_CLK", "Input clock"},
	{30, 0, "DEV_CPT2_AGGR1_VCLK_CLK", "Input clock"},
	{32, 0, "DEV_CPT2_AGGR2_VCLK_CLK", "Input clock"},
	{34, 0, "DEV_CPT2_AGGR3_VCLK_CLK", "Input clock"},
	{33, 0, "DEV_CPT2_AGGR4_VCLK_CLK", "Input clock"},
	{31, 0, "DEV_CPT2_AGGR5_VCLK_CLK", "Input clock"},
	{136, 0, "DEV_CSI_PSILSS0_MAIN_CLK", "Input clock"},
	{38, 0, "DEV_CSI_RX_IF0_PPI_D_RX_ULPS_ESC", "Input clock"},
	{38, 1, "DEV_CSI_RX_IF0_VBUS_CLK_CLK", "Input clock"},
	{38, 2, "DEV_CSI_RX_IF0_PPI_RX_BYTE_CLK", "Input clock"},
	{38, 3, "DEV_CSI_RX_IF0_MAIN_CLK_CLK", "Input clock"},
	{38, 4, "DEV_CSI_RX_IF0_VP_CLK_CLK", "Input clock"},
	{39, 0, "DEV_CSI_RX_IF1_PPI_D_RX_ULPS_ESC", "Input clock"},
	{39, 1, "DEV_CSI_RX_IF1_VBUS_CLK_CLK", "Input clock"},
	{39, 2, "DEV_CSI_RX_IF1_PPI_RX_BYTE_CLK", "Input clock"},
	{39, 3, "DEV_CSI_RX_IF1_MAIN_CLK_CLK", "Input clock"},
	{39, 4, "DEV_CSI_RX_IF1_VP_CLK_CLK", "Input clock"},
	{40, 1, "DEV_CSI_TX_IF_V2_0_VBUS_CLK_CLK", "Input clock"},
	{40, 2, "DEV_CSI_TX_IF_V2_0_MAIN_CLK_CLK", "Input clock"},
	{40, 3, "DEV_CSI_TX_IF_V2_0_DPHY_TXBYTECLKHS_CL_CLK", "Input clock"},
	{40, 5, "DEV_CSI_TX_IF_V2_0_ESC_CLK_CLK", "Input clock"},
	{41, 1, "DEV_CSI_TX_IF_V2_1_VBUS_CLK_CLK", "Input clock"},
	{41, 2, "DEV_CSI_TX_IF_V2_1_MAIN_CLK_CLK", "Input clock"},
	{41, 3, "DEV_CSI_TX_IF_V2_1_DPHY_TXBYTECLKHS_CL_CLK", "Input clock"},
	{41, 5, "DEV_CSI_TX_IF_V2_1_ESC_CLK_CLK", "Input clock"},
	{43, 0, "DEV_DCC0_DCC_CLKSRC0_CLK", "Input clock"},
	{43, 1, "DEV_DCC0_DCC_CLKSRC1_CLK", "Input clock"},
	{43, 2, "DEV_DCC0_DCC_CLKSRC2_CLK", "Input clock"},
	{43, 3, "DEV_DCC0_DCC_CLKSRC3_CLK", "Input clock"},
	{43, 4, "DEV_DCC0_DCC_CLKSRC4_CLK", "Input clock"},
	{43, 5, "DEV_DCC0_DCC_CLKSRC5_CLK", "Input clock"},
	{43, 6, "DEV_DCC0_DCC_CLKSRC6_CLK", "Input clock"},
	{43, 7, "DEV_DCC0_DCC_CLKSRC7_CLK", "Input clock"},
	{43, 8, "DEV_DCC0_DCC_INPUT00_CLK", "Input clock"},
	{43, 9, "DEV_DCC0_DCC_INPUT01_CLK", "Input clock"},
	{43, 10, "DEV_DCC0_DCC_INPUT02_CLK", "Input clock"},
	{43, 11, "DEV_DCC0_DCC_INPUT10_CLK", "Input clock"},
	{43, 12, "DEV_DCC0_VBUS_CLK", "Input clock"},
	{44, 0, "DEV_DCC1_DCC_CLKSRC0_CLK", "Input clock"},
	{44, 1, "DEV_DCC1_DCC_CLKSRC1_CLK", "Input clock"},
	{44, 2, "DEV_DCC1_DCC_CLKSRC2_CLK", "Input clock"},
	{44, 3, "DEV_DCC1_DCC_CLKSRC3_CLK", "Input clock"},
	{44, 4, "DEV_DCC1_DCC_CLKSRC4_CLK", "Input clock"},
	{44, 5, "DEV_DCC1_DCC_CLKSRC5_CLK", "Input clock"},
	{44, 6, "DEV_DCC1_DCC_CLKSRC6_CLK", "Input clock"},
	{44, 7, "DEV_DCC1_DCC_CLKSRC7_CLK", "Input clock"},
	{44, 8, "DEV_DCC1_DCC_INPUT00_CLK", "Input clock"},
	{44, 9, "DEV_DCC1_DCC_INPUT01_CLK", "Input clock"},
	{44, 10, "DEV_DCC1_DCC_INPUT02_CLK", "Input clock"},
	{44, 11, "DEV_DCC1_DCC_INPUT10_CLK", "Input clock"},
	{44, 12, "DEV_DCC1_VBUS_CLK", "Input clock"},
	{45, 0, "DEV_DCC2_DCC_CLKSRC0_CLK", "Input clock"},
	{45, 1, "DEV_DCC2_DCC_CLKSRC1_CLK", "Input clock"},
	{45, 3, "DEV_DCC2_DCC_CLKSRC3_CLK", "Input clock"},
	{45, 4, "DEV_DCC2_DCC_CLKSRC4_CLK", "Input clock"},
	{45, 5, "DEV_DCC2_DCC_CLKSRC5_CLK", "Input clock"},
	{45, 6, "DEV_DCC2_DCC_CLKSRC6_CLK", "Input clock"},
	{45, 7, "DEV_DCC2_DCC_CLKSRC7_CLK", "Input clock"},
	{45, 8, "DEV_DCC2_DCC_INPUT00_CLK", "Input clock"},
	{45, 9, "DEV_DCC2_DCC_INPUT01_CLK", "Input clock"},
	{45, 10, "DEV_DCC2_DCC_INPUT02_CLK", "Input clock"},
	{45, 11, "DEV_DCC2_DCC_INPUT10_CLK", "Input clock"},
	{45, 12, "DEV_DCC2_VBUS_CLK", "Input clock"},
	{46, 0, "DEV_DCC3_DCC_CLKSRC0_CLK", "Input clock"},
	{46, 1, "DEV_DCC3_DCC_CLKSRC1_CLK", "Input clock"},
	{46, 2, "DEV_DCC3_DCC_CLKSRC2_CLK", "Input clock"},
	{46, 5, "DEV_DCC3_DCC_CLKSRC5_CLK", "Input clock"},
	{46, 6, "DEV_DCC3_DCC_CLKSRC6_CLK", "Input clock"},
	{46, 7, "DEV_DCC3_DCC_CLKSRC7_CLK", "Input clock"},
	{46, 8, "DEV_DCC3_DCC_INPUT00_CLK", "Input clock"},
	{46, 9, "DEV_DCC3_DCC_INPUT01_CLK", "Input clock"},
	{46, 10, "DEV_DCC3_DCC_INPUT02_CLK", "Input clock"},
	{46, 11, "DEV_DCC3_DCC_INPUT10_CLK", "Input clock"},
	{46, 12, "DEV_DCC3_VBUS_CLK", "Input clock"},
	{47, 0, "DEV_DCC4_DCC_CLKSRC0_CLK", "Input clock"},
	{47, 2, "DEV_DCC4_DCC_CLKSRC2_CLK", "Input clock"},
	{47, 3, "DEV_DCC4_DCC_CLKSRC3_CLK", "Input clock"},
	{47, 4, "DEV_DCC4_DCC_CLKSRC4_CLK", "Input clock"},
	{47, 5, "DEV_DCC4_DCC_CLKSRC5_CLK", "Input clock"},
	{47, 7, "DEV_DCC4_DCC_CLKSRC7_CLK", "Input clock"},
	{47, 8, "DEV_DCC4_DCC_INPUT00_CLK", "Input clock"},
	{47, 9, "DEV_DCC4_DCC_INPUT01_CLK", "Input clock"},
	{47, 10, "DEV_DCC4_DCC_INPUT02_CLK", "Input clock"},
	{47, 11, "DEV_DCC4_DCC_INPUT10_CLK", "Input clock"},
	{47, 12, "DEV_DCC4_VBUS_CLK", "Input clock"},
	{48, 1, "DEV_DCC5_DCC_CLKSRC1_CLK", "Input clock"},
	{48, 2, "DEV_DCC5_DCC_CLKSRC2_CLK", "Input clock"},
	{48, 3, "DEV_DCC5_DCC_CLKSRC3_CLK", "Input clock"},
	{48, 4, "DEV_DCC5_DCC_CLKSRC4_CLK", "Input clock"},
	{48, 6, "DEV_DCC5_DCC_CLKSRC6_CLK", "Input clock"},
	{48, 7, "DEV_DCC5_DCC_CLKSRC7_CLK", "Input clock"},
	{48, 8, "DEV_DCC5_DCC_INPUT00_CLK", "Input clock"},
	{48, 9, "DEV_DCC5_DCC_INPUT01_CLK", "Input clock"},
	{48, 10, "DEV_DCC5_DCC_INPUT02_CLK", "Input clock"},
	{48, 11, "DEV_DCC5_DCC_INPUT10_CLK", "Input clock"},
	{48, 12, "DEV_DCC5_VBUS_CLK", "Input clock"},
	{49, 0, "DEV_DCC6_DCC_CLKSRC0_CLK", "Input clock"},
	{49, 1, "DEV_DCC6_DCC_CLKSRC1_CLK", "Input clock"},
	{49, 2, "DEV_DCC6_DCC_CLKSRC2_CLK", "Input clock"},
	{49, 3, "DEV_DCC6_DCC_CLKSRC3_CLK", "Input clock"},
	{49, 4, "DEV_DCC6_DCC_CLKSRC4_CLK", "Input clock"},
	{49, 5, "DEV_DCC6_DCC_CLKSRC5_CLK", "Input clock"},
	{49, 6, "DEV_DCC6_DCC_CLKSRC6_CLK", "Input clock"},
	{49, 7, "DEV_DCC6_DCC_CLKSRC7_CLK", "Input clock"},
	{49, 8, "DEV_DCC6_DCC_INPUT00_CLK", "Input clock"},
	{49, 9, "DEV_DCC6_DCC_INPUT01_CLK", "Input clock"},
	{49, 10, "DEV_DCC6_DCC_INPUT02_CLK", "Input clock"},
	{49, 11, "DEV_DCC6_DCC_INPUT10_CLK", "Input clock"},
	{49, 12, "DEV_DCC6_VBUS_CLK", "Input clock"},
	{50, 0, "DEV_DCC7_DCC_CLKSRC0_CLK", "Input clock"},
	{50, 1, "DEV_DCC7_DCC_CLKSRC1_CLK", "Input clock"},
	{50, 2, "DEV_DCC7_DCC_CLKSRC2_CLK", "Input clock"},
	{50, 5, "DEV_DCC7_DCC_CLKSRC5_CLK", "Input clock"},
	{50, 6, "DEV_DCC7_DCC_CLKSRC6_CLK", "Input clock"},
	{50, 7, "DEV_DCC7_DCC_CLKSRC7_CLK", "Input clock"},
	{50, 8, "DEV_DCC7_DCC_INPUT00_CLK", "Input clock"},
	{50, 9, "DEV_DCC7_DCC_INPUT01_CLK", "Input clock"},
	{50, 10, "DEV_DCC7_DCC_INPUT02_CLK", "Input clock"},
	{50, 11, "DEV_DCC7_DCC_INPUT10_CLK", "Input clock"},
	{50, 12, "DEV_DCC7_VBUS_CLK", "Input clock"},
	{51, 0, "DEV_DCC8_DCC_CLKSRC0_CLK", "Input clock"},
	{51, 1, "DEV_DCC8_DCC_CLKSRC1_CLK", "Input clock"},
	{51, 2, "DEV_DCC8_DCC_CLKSRC2_CLK", "Input clock"},
	{51, 3, "DEV_DCC8_DCC_CLKSRC3_CLK", "Input clock"},
	{51, 4, "DEV_DCC8_DCC_CLKSRC4_CLK", "Input clock"},
	{51, 6, "DEV_DCC8_DCC_CLKSRC6_CLK", "Input clock"},
	{51, 7, "DEV_DCC8_DCC_CLKSRC7_CLK", "Input clock"},
	{51, 8, "DEV_DCC8_DCC_INPUT00_CLK", "Input clock"},
	{51, 9, "DEV_DCC8_DCC_INPUT01_CLK", "Input clock"},
	{51, 10, "DEV_DCC8_DCC_INPUT02_CLK", "Input clock"},
	{51, 11, "DEV_DCC8_DCC_INPUT10_CLK", "Input clock"},
	{51, 12, "DEV_DCC8_VBUS_CLK", "Input clock"},
	{52, 0, "DEV_DCC9_DCC_CLKSRC0_CLK", "Input clock"},
	{52, 1, "DEV_DCC9_DCC_CLKSRC1_CLK", "Input clock"},
	{52, 2, "DEV_DCC9_DCC_CLKSRC2_CLK", "Input clock"},
	{52, 3, "DEV_DCC9_DCC_CLKSRC3_CLK", "Input clock"},
	{52, 4, "DEV_DCC9_DCC_CLKSRC4_CLK", "Input clock"},
	{52, 5, "DEV_DCC9_DCC_CLKSRC5_CLK", "Input clock"},
	{52, 6, "DEV_DCC9_DCC_CLKSRC6_CLK", "Input clock"},
	{52, 8, "DEV_DCC9_DCC_INPUT00_CLK", "Input clock"},
	{52, 9, "DEV_DCC9_DCC_INPUT01_CLK", "Input clock"},
	{52, 10, "DEV_DCC9_DCC_INPUT02_CLK", "Input clock"},
	{52, 11, "DEV_DCC9_DCC_INPUT10_CLK", "Input clock"},
	{52, 12, "DEV_DCC9_VBUS_CLK", "Input clock"},
	{138, 0, "DEV_DDR0_DDRSS_DDR_PLL_CLK", "Input clock"},
	{138, 1, "DEV_DDR0_DDRSS_VBUS_CLK", "Input clock"},
	{138, 2, "DEV_DDR0_PLL_CTRL_CLK", "Input clock"},
	{138, 7, "DEV_DDR0_DDRSS_CFG_CLK", "Input clock"},
	{139, 0, "DEV_DDR1_DDRSS_DDR_PLL_CLK", "Input clock"},
	{139, 1, "DEV_DDR1_DDRSS_VBUS_CLK", "Input clock"},
	{139, 2, "DEV_DDR1_PLL_CTRL_CLK", "Input clock"},
	{139, 7, "DEV_DDR1_DDRSS_CFG_CLK", "Input clock"},
	{57, 1, "DEV_DEBUGSS_WRAP0_ATB_CLK", "Input clock"},
	{57, 16, "DEV_DEBUGSS_WRAP0_CSTPIU_TRACECLK", "Output clock"},
	{57, 17, "DEV_DEBUGSS_WRAP0_CORE_CLK", "Input clock"},
	{57, 28, "DEV_DEBUGSS_WRAP0_TREXPT_CLK", "Input clock"},
	{57, 41, "DEV_DEBUGSS_WRAP0_JTAG_TCK", "Input clock"},
	{137, 0, "DEV_DEBUGSUSPENDRTR0_INTR_CLK", "Input clock"},
	{58, 0, "DEV_DMPAC0_CLK", "Input clock"},
	{62, 0, "DEV_DMPAC0_SDE_0_CLK", "Input clock"},
	{374, 0, "DEV_DMPAC0_UTC_0_PSIL_LEAF_CLK", "Input clock"},
	{140, 0, "DEV_DMPAC_VPAC_PSILSS0_MAIN_CLK", "Input clock"},
	{152, 0, "DEV_DPHY_RX0_IO_RX_CL_L_M", "Input clock"},
	{152, 1, "DEV_DPHY_RX0_PPI_RX_BYTE_CLK", "Output clock"},
	{152, 2, "DEV_DPHY_RX0_MAIN_CLK_CLK", "Input clock"},
	{152, 3, "DEV_DPHY_RX0_IO_RX_CL_L_P", "Input clock"},
	{152, 4, "DEV_DPHY_RX0_JTAG_TCK", "Input clock"},
	{152, 8, "DEV_DPHY_RX0_PPI_D_RX_ULPS_ESC", "Output clock"},
	{153, 0, "DEV_DPHY_RX1_IO_RX_CL_L_M", "Input clock"},
	{153, 1, "DEV_DPHY_RX1_PPI_RX_BYTE_CLK", "Output clock"},
	{153, 2, "DEV_DPHY_RX1_MAIN_CLK_CLK", "Input clock"},
	{153, 3, "DEV_DPHY_RX1_IO_RX_CL_L_P", "Input clock"},
	{153, 4, "DEV_DPHY_RX1_JTAG_TCK", "Input clock"},
	{153, 8, "DEV_DPHY_RX1_PPI_D_RX_ULPS_ESC", "Output clock"},
	{363, 1, "DEV_DPHY_TX0_IP2_PPI_TXBYTECLKHS_CL_CLK", "Output clock"},
	{363, 2, "DEV_DPHY_TX0_IP1_PPI_TXBYTECLKHS_CL_CLK", "Output clock"},
	{363, 5, "DEV_DPHY_TX0_CLK", "Input clock"},
	{363, 8, "DEV_DPHY_TX0_PSM_CLK", "Input clock"},
	{363, 12, "DEV_DPHY_TX0_CK_M", "Output clock"},
	{363, 14, "DEV_DPHY_TX0_DPHY_REF_CLK", "Input muxed clock"},
	{363, 15, "DEV_DPHY_TX0_DPHY_REF_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_DPHY_TX0_DPHY_REF_CLK"},
	{363, 16, "DEV_DPHY_TX0_DPHY_REF_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_DPHY_TX0_DPHY_REF_CLK"},
	{363, 17, "DEV_DPHY_TX0_DPHY_REF_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT4_CLK", "Parent input clock option to DEV_DPHY_TX0_DPHY_REF_CLK"},
	{363, 18, "DEV_DPHY_TX0_DPHY_REF_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT4_CLK", "Parent input clock option to DEV_DPHY_TX0_DPHY_REF_CLK"},
	{363, 19, "DEV_DPHY_TX0_TAP_TCK", "Input clock"},
	{363, 20, "DEV_DPHY_TX0_CK_P", "Output clock"},
	{363, 22, "DEV_DPHY_TX0_IP1_PPI_M_TXCLKESC_CLK", "Input clock"},
	{363, 23, "DEV_DPHY_TX0_IP1_PPI_M_RXCLKESC_CLK", "Output clock"},
	{363, 24, "DEV_DPHY_TX0_IP2_PPI_M_TXCLKESC_CLK", "Input clock"},
	{364, 1, "DEV_DPHY_TX1_IP2_PPI_TXBYTECLKHS_CL_CLK", "Output clock"},
	{364, 2, "DEV_DPHY_TX1_IP1_PPI_TXBYTECLKHS_CL_CLK", "Output clock"},
	{364, 5, "DEV_DPHY_TX1_CLK", "Input clock"},
	{364, 8, "DEV_DPHY_TX1_PSM_CLK", "Input clock"},
	{364, 12, "DEV_DPHY_TX1_CK_M", "Output clock"},
	{364, 14, "DEV_DPHY_TX1_DPHY_REF_CLK", "Input muxed clock"},
	{364, 15, "DEV_DPHY_TX1_DPHY_REF_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_DPHY_TX1_DPHY_REF_CLK"},
	{364, 16, "DEV_DPHY_TX1_DPHY_REF_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_DPHY_TX1_DPHY_REF_CLK"},
	{364, 17, "DEV_DPHY_TX1_DPHY_REF_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT4_CLK", "Parent input clock option to DEV_DPHY_TX1_DPHY_REF_CLK"},
	{364, 18, "DEV_DPHY_TX1_DPHY_REF_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT4_CLK", "Parent input clock option to DEV_DPHY_TX1_DPHY_REF_CLK"},
	{364, 19, "DEV_DPHY_TX1_TAP_TCK", "Input clock"},
	{364, 20, "DEV_DPHY_TX1_CK_P", "Output clock"},
	{364, 22, "DEV_DPHY_TX1_IP1_PPI_M_TXCLKESC_CLK", "Input clock"},
	{364, 23, "DEV_DPHY_TX1_IP1_PPI_M_RXCLKESC_CLK", "Output clock"},
	{158, 0, "DEV_DSS0_DSS_FUNC_CLK", "Input clock"},
	{158, 1, "DEV_DSS0_DSS_INST0_DPI_0_IN_CLK", "Input clock"},
	{158, 2, "DEV_DSS0_DSS_INST0_DPI_0_IN_2X_CLK", "Input muxed clock"},
	{158, 3, "DEV_DSS0_DSS_INST0_DPI_0_IN_2X_CLK_PARENT_HSDIV1_16FFT_MAIN_16_HSDIVOUT0_CLK", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_0_IN_2X_CLK"},
	{158, 4, "DEV_DSS0_DSS_INST0_DPI_0_IN_2X_CLK_PARENT_DPI_1_PCLK_SEL_OUT0", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_0_IN_2X_CLK"},
	{158, 5, "DEV_DSS0_DSS_INST0_DPI_1_IN_2X_CLK", "Input muxed clock"},
	{158, 6, "DEV_DSS0_DSS_INST0_DPI_1_IN_2X_CLK_PARENT_HSDIV1_16FFT_MAIN_17_HSDIVOUT0_CLK", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_1_IN_2X_CLK"},
	{158, 7, "DEV_DSS0_DSS_INST0_DPI_1_IN_2X_CLK_PARENT_DPI0_EXT_CLKSEL_OUT0", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_1_IN_2X_CLK"},
	{158, 8, "DEV_DSS0_DSS_INST0_DPI_1_IN_2X_CLK_PARENT_DPI0_EXT_CLKSEL_OUT0_DUP0", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_1_IN_2X_CLK"},
	{158, 9, "DEV_DSS0_DSS_INST0_DPI_1_IN_2X_CLK_PARENT_HSDIV1_16FFT_MAIN_16_HSDIVOUT0_CLK", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_1_IN_2X_CLK"},
	{158, 10, "DEV_DSS0_DSS_INST0_DPI_2_IN_CLK", "Input muxed clock"},
	{158, 11, "DEV_DSS0_DSS_INST0_DPI_2_IN_CLK_PARENT_HSDIV1_16FFT_MAIN_16_HSDIVOUT0_CLK", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_2_IN_CLK"},
	{158, 12, "DEV_DSS0_DSS_INST0_DPI_2_IN_CLK_PARENT_HSDIV1_16FFT_MAIN_17_HSDIVOUT0_CLK", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_2_IN_CLK"},
	{158, 13, "DEV_DSS0_DSS_INST0_DPI_2_IN_CLK_PARENT_DPI0_EXT_CLKSEL_OUT0", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_2_IN_CLK"},
	{158, 14, "DEV_DSS0_DSS_INST0_DPI_2_IN_2X_CLK", "Input muxed clock"},
	{158, 15, "DEV_DSS0_DSS_INST0_DPI_2_IN_2X_CLK_PARENT_HSDIV1_16FFT_MAIN_16_HSDIVOUT0_CLK", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_2_IN_2X_CLK"},
	{158, 16, "DEV_DSS0_DSS_INST0_DPI_2_IN_2X_CLK_PARENT_HSDIV1_16FFT_MAIN_17_HSDIVOUT0_CLK", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_2_IN_2X_CLK"},
	{158, 17, "DEV_DSS0_DSS_INST0_DPI_2_IN_2X_CLK_PARENT_DPI0_EXT_CLKSEL_OUT0", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_2_IN_2X_CLK"},
	{158, 18, "DEV_DSS0_DSS_INST0_DPI_3_IN_2X_CLK", "Input muxed clock"},
	{158, 19, "DEV_DSS0_DSS_INST0_DPI_3_IN_2X_CLK_PARENT_HSDIV1_16FFT_MAIN_16_HSDIVOUT1_CLK", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_3_IN_2X_CLK"},
	{158, 20, "DEV_DSS0_DSS_INST0_DPI_3_IN_2X_CLK_PARENT_HSDIV1_16FFT_MAIN_17_HSDIVOUT1_CLK", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_3_IN_2X_CLK"},
	{158, 21, "DEV_DSS0_DSS_INST0_DPI_3_IN_2X_CLK_PARENT_HSDIV1_16FFT_MAIN_17_HSDIVOUT1_CLK_DUP0", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_3_IN_2X_CLK"},
	{158, 22, "DEV_DSS0_DSS_INST0_DPI_3_IN_2X_CLK_PARENT_DPI0_EXT_CLKSEL_OUT0", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_3_IN_2X_CLK"},
	{158, 23, "DEV_DSS0_DSS_INST0_DPI_3_IN_2X_CLK_PARENT_DPI0_EXT_CLKSEL_OUT0_DUP0", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_3_IN_2X_CLK"},
	{158, 24, "DEV_DSS0_DSS_INST0_PARA_1_OUT_CLK", "Output clock"},
	{158, 25, "DEV_DSS0_DSS_INST0_PARA_3_OUT_CLK", "Output clock"},
	{158, 26, "DEV_DSS0_DSS_INST0_DPI_0_OUT_CLK", "Output clock"},
	{158, 27, "DEV_DSS0_DSS_INST0_DPI_1_OUT_CLK", "Output clock"},
	{158, 28, "DEV_DSS0_DSS_INST0_DPI_2_OUT_CLK", "Output clock"},
	{158, 29, "DEV_DSS0_DSS_INST0_DPI_3_OUT_CLK", "Output clock"},
	{158, 30, "DEV_DSS0_DSS_INST0_DPI_0_OUT_2X_CLK", "Output clock"},
	{154, 0, "DEV_DSS_DSI0_PLL_CTRL_CLK", "Input clock"},
	{154, 1, "DEV_DSS_DSI0_SYS_CLK", "Input clock"},
	{154, 2, "DEV_DSS_DSI0_DPHY_0_RX_ESC_CLK", "Input clock"},
	{154, 3, "DEV_DSS_DSI0_DPHY_0_TX_ESC_CLK", "Input clock"},
	{154, 4, "DEV_DSS_DSI0_DPI_0_CLK", "Input clock"},
	{154, 5, "DEV_DSS_DSI0_PPI_0_TXBYTECLKHS_CL_CLK", "Input clock"},
	{155, 0, "DEV_DSS_DSI1_PLL_CTRL_CLK", "Input clock"},
	{155, 1, "DEV_DSS_DSI1_SYS_CLK", "Input clock"},
	{155, 2, "DEV_DSS_DSI1_DPHY_0_RX_ESC_CLK", "Input clock"},
	{155, 3, "DEV_DSS_DSI1_DPHY_0_TX_ESC_CLK", "Input clock"},
	{155, 4, "DEV_DSS_DSI1_DPI_0_CLK", "Input clock"},
	{155, 5, "DEV_DSS_DSI1_PPI_0_TXBYTECLKHS_CL_CLK", "Input clock"},
	{156, 0, "DEV_DSS_EDP0_PHY_LN0_RXCLK", "Input clock"},
	{156, 1, "DEV_DSS_EDP0_PHY_LN2_TXCLK", "Output clock"},
	{156, 2, "DEV_DSS_EDP0_PHY_LN3_RXFCLK", "Input clock"},
	{156, 3, "DEV_DSS_EDP0_PHY_LN2_TXMCLK", "Input clock"},
	{156, 4, "DEV_DSS_EDP0_PHY_LN3_REFCLK", "Input clock"},
	{156, 6, "DEV_DSS_EDP0_DPI_2_2X_CLK", "Input clock"},
	{156, 7, "DEV_DSS_EDP0_PHY_LN0_TXCLK", "Output clock"},
	{156, 8, "DEV_DSS_EDP0_PHY_LN2_TXFCLK", "Input clock"},
	{156, 9, "DEV_DSS_EDP0_DPI_3_CLK", "Input clock"},
	{156, 10, "DEV_DSS_EDP0_PHY_LN1_RXCLK", "Input clock"},
	{156, 11, "DEV_DSS_EDP0_PHY_LN1_TXCLK", "Output clock"},
	{156, 12, "DEV_DSS_EDP0_PHY_LN1_RXFCLK", "Input clock"},
	{156, 13, "DEV_DSS_EDP0_DPI_5_CLK", "Input clock"},
	{156, 14, "DEV_DSS_EDP0_PHY_LN2_RXCLK", "Input clock"},
	{156, 16, "DEV_DSS_EDP0_PHY_LN1_TXMCLK", "Input clock"},
	{156, 18, "DEV_DSS_EDP0_DPI_2_CLK", "Input clock"},
	{156, 19, "DEV_DSS_EDP0_DPTX_MOD_CLK", "Input clock"},
	{156, 20, "DEV_DSS_EDP0_PHY_LN1_REFCLK", "Input clock"},
	{156, 21, "DEV_DSS_EDP0_PHY_LN1_TXFCLK", "Input clock"},
	{156, 22, "DEV_DSS_EDP0_PHY_LN0_RXFCLK", "Input clock"},
	{156, 24, "DEV_DSS_EDP0_PHY_LN3_TXMCLK", "Input clock"},
	{156, 25, "DEV_DSS_EDP0_PLL_CTRL_CLK", "Input clock"},
	{156, 26, "DEV_DSS_EDP0_PHY_LN0_TXFCLK", "Input clock"},
	{156, 27, "DEV_DSS_EDP0_PHY_LN3_TXFCLK", "Input clock"},
	{156, 28, "DEV_DSS_EDP0_PHY_LN3_TXCLK", "Output clock"},
	{156, 29, "DEV_DSS_EDP0_PHY_LN2_REFCLK", "Input clock"},
	{156, 30, "DEV_DSS_EDP0_DPI_4_CLK", "Input clock"},
	{156, 31, "DEV_DSS_EDP0_PHY_LN0_TXMCLK", "Input clock"},
	{156, 33, "DEV_DSS_EDP0_PHY_LN0_REFCLK", "Input clock"},
	{156, 34, "DEV_DSS_EDP0_PHY_LN3_RXCLK", "Input clock"},
	{156, 35, "DEV_DSS_EDP0_AIF_I2S_CLK", "Input clock"},
	{156, 36, "DEV_DSS_EDP0_PHY_LN2_RXFCLK", "Input clock"},
	{92, 0, "DEV_ECAP0_VBUS_CLK", "Input clock"},
	{93, 0, "DEV_ECAP1_VBUS_CLK", "Input clock"},
	{94, 0, "DEV_ECAP2_VBUS_CLK", "Input clock"},
	{95, 0, "DEV_ELM0_VBUSP_CLK", "Input clock"},
	{160, 0, "DEV_EPWM0_VBUSP_CLK", "Input clock"},
	{161, 0, "DEV_EPWM1_VBUSP_CLK", "Input clock"},
	{162, 0, "DEV_EPWM2_VBUSP_CLK", "Input clock"},
	{163, 0, "DEV_EPWM3_VBUSP_CLK", "Input clock"},
	{164, 0, "DEV_EPWM4_VBUSP_CLK", "Input clock"},
	{165, 0, "DEV_EPWM5_VBUSP_CLK", "Input clock"},
	{100, 0, "DEV_EQEP0_VBUS_CLK", "Input clock"},
	{101, 0, "DEV_EQEP1_VBUS_CLK", "Input clock"},
	{102, 0, "DEV_EQEP2_VBUS_CLK", "Input clock"},
	{103, 0, "DEV_ESM0_CLK", "Input clock"},
	{111, 0, "DEV_GPIO0_MMR_CLK", "Input clock"},
	{112, 0, "DEV_GPIO2_MMR_CLK", "Input clock"},
	{113, 0, "DEV_GPIO4_MMR_CLK", "Input clock"},
	{114, 0, "DEV_GPIO6_MMR_CLK", "Input clock"},
	{148, 0, "DEV_GPIOMUX_INTRTR0_INTR_CLK", "Input clock"},
	{117, 0, "DEV_GPMC0_VBUSM_CLK", "Input clock"},
	{117, 1, "DEV_GPMC0_PO_GPMC_DEV_CLK", "Output clock"},
	{117, 2, "DEV_GPMC0_FUNC_CLK", "Input muxed clock"},
	{117, 3, "DEV_GPMC0_FUNC_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT3_CLK", "Parent input clock option to DEV_GPMC0_FUNC_CLK"},
	{117, 4, "DEV_GPMC0_FUNC_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT1_CLK6", "Parent input clock option to DEV_GPMC0_FUNC_CLK"},
	{117, 5, "DEV_GPMC0_FUNC_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT1_CLK4", "Parent input clock option to DEV_GPMC0_FUNC_CLK"},
	{117, 6, "DEV_GPMC0_FUNC_CLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK4", "Parent input clock option to DEV_GPMC0_FUNC_CLK"},
	{117, 7, "DEV_GPMC0_PI_GPMC_RET_CLK", "Input clock"},
	{61, 0, "DEV_GTC0_VBUSP_CLK", "Input clock"},
	{61, 1, "DEV_GTC0_GTC_CLK", "Input muxed clock"},
	{61, 2, "DEV_GTC0_GTC_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT1_CLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 3, "DEV_GTC0_GTC_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 4, "DEV_GTC0_GTC_CLK_PARENT_BOARD_0_MCU_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 5, "DEV_GTC0_GTC_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 6, "DEV_GTC0_GTC_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 7, "DEV_GTC0_GTC_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 8, "DEV_GTC0_GTC_CLK_PARENT_WIZ16B8M4CT2_MAIN_0_IP2_LN0_TXMCLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 9, "DEV_GTC0_GTC_CLK_PARENT_WIZ16B8M4CT2_MAIN_0_IP2_LN1_TXMCLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 10, "DEV_GTC0_GTC_CLK_PARENT_WIZ16B8M4CT2_MAIN_0_IP2_LN2_TXMCLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 11, "DEV_GTC0_GTC_CLK_PARENT_WIZ16B8M4CT2_MAIN_0_IP2_LN3_TXMCLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 16, "DEV_GTC0_GTC_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 17, "DEV_GTC0_GTC_CLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{214, 0, "DEV_I2C0_PORSCL", "Output clock"},
	{214, 1, "DEV_I2C0_PISYS_CLK", "Input clock"},
	{214, 2, "DEV_I2C0_CLK", "Input clock"},
	{214, 3, "DEV_I2C0_PISCL", "Input clock"},
	{215, 0, "DEV_I2C1_PORSCL", "Output clock"},
	{215, 1, "DEV_I2C1_PISYS_CLK", "Input clock"},
	{215, 2, "DEV_I2C1_CLK", "Input clock"},
	{215, 3, "DEV_I2C1_PISCL", "Input clock"},
	{216, 0, "DEV_I2C2_PORSCL", "Output clock"},
	{216, 1, "DEV_I2C2_PISYS_CLK", "Input clock"},
	{216, 2, "DEV_I2C2_CLK", "Input clock"},
	{216, 3, "DEV_I2C2_PISCL", "Input clock"},
	{217, 0, "DEV_I2C3_PORSCL", "Output clock"},
	{217, 1, "DEV_I2C3_PISYS_CLK", "Input clock"},
	{217, 2, "DEV_I2C3_CLK", "Input clock"},
	{217, 3, "DEV_I2C3_PISCL", "Input clock"},
	{218, 0, "DEV_I2C4_PORSCL", "Output clock"},
	{218, 1, "DEV_I2C4_PISYS_CLK", "Input clock"},
	{218, 2, "DEV_I2C4_CLK", "Input clock"},
	{218, 3, "DEV_I2C4_PISCL", "Input clock"},
	{219, 0, "DEV_I2C5_PORSCL", "Output clock"},
	{219, 1, "DEV_I2C5_PISYS_CLK", "Input clock"},
	{219, 2, "DEV_I2C5_CLK", "Input clock"},
	{219, 3, "DEV_I2C5_PISCL", "Input clock"},
	{220, 0, "DEV_I2C6_PORSCL", "Output clock"},
	{220, 1, "DEV_I2C6_PISYS_CLK", "Input clock"},
	{220, 2, "DEV_I2C6_CLK", "Input clock"},
	{220, 3, "DEV_I2C6_PISCL", "Input clock"},
	{130, 0, "DEV_J7AEP_GPU_BXS464_WRAP0_GPU_SS_0_PLL_CTRL_CLK", "Input clock"},
	{130, 1, "DEV_J7AEP_GPU_BXS464_WRAP0_GPU_SS_0_GPU_PLL_CLK", "Input clock"},
	{131, 0, "DEV_J7AM_32_64_ATB_FUNNEL0_DBG_CLK", "Input clock"},
	{132, 0, "DEV_J7AM_32_64_ATB_FUNNEL1_DBG_CLK", "Input clock"},
	{133, 0, "DEV_J7AM_32_64_ATB_FUNNEL2_DBG_CLK", "Input clock"},
	{135, 0, "DEV_J7AM_BOLT_PGD0_WKUP_OSC0_CLK", "Input clock"},
	{141, 0, "DEV_J7AM_HWA_ATB_FUNNEL0_DBG_CLK", "Input clock"},
	{142, 0, "DEV_J7AM_MAIN_16FF0_WKUP_OSC0_CLK", "Input clock"},
	{144, 0, "DEV_J7AM_PULSAR_ATB_FUNNEL0_DBG_CLK", "Input clock"},
	{120, 0, "DEV_LED0_VBUS_CLK", "Input clock"},
	{120, 1, "DEV_LED0_LED_CLK", "Input clock"},
	{121, 0, "DEV_MAIN2MCU_LVL_INTRTR0_INTR_CLK", "Input clock"},
	{122, 0, "DEV_MAIN2MCU_PLS_INTRTR0_INTR_CLK", "Input clock"},
	{182, 0, "DEV_MCAN0_MCANSS_HCLK_CLK", "Input clock"},
	{182, 1, "DEV_MCAN0_MCANSS_CCLK_CLK", "Input muxed clock"},
	{182, 2, "DEV_MCAN0_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN0_MCANSS_CCLK_CLK"},
	{182, 3, "DEV_MCAN0_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN0_MCANSS_CCLK_CLK"},
	{182, 4, "DEV_MCAN0_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN0_MCANSS_CCLK_CLK"},
	{182, 5, "DEV_MCAN0_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN0_MCANSS_CCLK_CLK"},
	{182, 6, "DEV_MCAN0_MCANSS_CAN_RXD", "Input clock"},
	{183, 0, "DEV_MCAN1_MCANSS_HCLK_CLK", "Input clock"},
	{183, 1, "DEV_MCAN1_MCANSS_CCLK_CLK", "Input muxed clock"},
	{183, 2, "DEV_MCAN1_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN1_MCANSS_CCLK_CLK"},
	{183, 3, "DEV_MCAN1_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN1_MCANSS_CCLK_CLK"},
	{183, 4, "DEV_MCAN1_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN1_MCANSS_CCLK_CLK"},
	{183, 5, "DEV_MCAN1_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN1_MCANSS_CCLK_CLK"},
	{183, 6, "DEV_MCAN1_MCANSS_CAN_RXD", "Input clock"},
	{192, 0, "DEV_MCAN10_MCANSS_HCLK_CLK", "Input clock"},
	{192, 1, "DEV_MCAN10_MCANSS_CCLK_CLK", "Input muxed clock"},
	{192, 2, "DEV_MCAN10_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN10_MCANSS_CCLK_CLK"},
	{192, 3, "DEV_MCAN10_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN10_MCANSS_CCLK_CLK"},
	{192, 4, "DEV_MCAN10_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN10_MCANSS_CCLK_CLK"},
	{192, 5, "DEV_MCAN10_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN10_MCANSS_CCLK_CLK"},
	{192, 6, "DEV_MCAN10_MCANSS_CAN_RXD", "Input clock"},
	{193, 0, "DEV_MCAN11_MCANSS_HCLK_CLK", "Input clock"},
	{193, 1, "DEV_MCAN11_MCANSS_CCLK_CLK", "Input muxed clock"},
	{193, 2, "DEV_MCAN11_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN11_MCANSS_CCLK_CLK"},
	{193, 3, "DEV_MCAN11_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN11_MCANSS_CCLK_CLK"},
	{193, 4, "DEV_MCAN11_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN11_MCANSS_CCLK_CLK"},
	{193, 5, "DEV_MCAN11_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN11_MCANSS_CCLK_CLK"},
	{193, 6, "DEV_MCAN11_MCANSS_CAN_RXD", "Input clock"},
	{194, 0, "DEV_MCAN12_MCANSS_HCLK_CLK", "Input clock"},
	{194, 1, "DEV_MCAN12_MCANSS_CCLK_CLK", "Input muxed clock"},
	{194, 2, "DEV_MCAN12_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN12_MCANSS_CCLK_CLK"},
	{194, 3, "DEV_MCAN12_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN12_MCANSS_CCLK_CLK"},
	{194, 4, "DEV_MCAN12_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN12_MCANSS_CCLK_CLK"},
	{194, 5, "DEV_MCAN12_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN12_MCANSS_CCLK_CLK"},
	{194, 6, "DEV_MCAN12_MCANSS_CAN_RXD", "Input clock"},
	{195, 0, "DEV_MCAN13_MCANSS_HCLK_CLK", "Input clock"},
	{195, 1, "DEV_MCAN13_MCANSS_CCLK_CLK", "Input muxed clock"},
	{195, 2, "DEV_MCAN13_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN13_MCANSS_CCLK_CLK"},
	{195, 3, "DEV_MCAN13_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN13_MCANSS_CCLK_CLK"},
	{195, 4, "DEV_MCAN13_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN13_MCANSS_CCLK_CLK"},
	{195, 5, "DEV_MCAN13_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN13_MCANSS_CCLK_CLK"},
	{195, 6, "DEV_MCAN13_MCANSS_CAN_RXD", "Input clock"},
	{197, 0, "DEV_MCAN14_MCANSS_HCLK_CLK", "Input clock"},
	{197, 1, "DEV_MCAN14_MCANSS_CCLK_CLK", "Input muxed clock"},
	{197, 2, "DEV_MCAN14_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN14_MCANSS_CCLK_CLK"},
	{197, 3, "DEV_MCAN14_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN14_MCANSS_CCLK_CLK"},
	{197, 4, "DEV_MCAN14_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN14_MCANSS_CCLK_CLK"},
	{197, 5, "DEV_MCAN14_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN14_MCANSS_CCLK_CLK"},
	{197, 6, "DEV_MCAN14_MCANSS_CAN_RXD", "Input clock"},
	{199, 0, "DEV_MCAN15_MCANSS_HCLK_CLK", "Input clock"},
	{199, 1, "DEV_MCAN15_MCANSS_CCLK_CLK", "Input muxed clock"},
	{199, 2, "DEV_MCAN15_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN15_MCANSS_CCLK_CLK"},
	{199, 3, "DEV_MCAN15_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN15_MCANSS_CCLK_CLK"},
	{199, 4, "DEV_MCAN15_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN15_MCANSS_CCLK_CLK"},
	{199, 5, "DEV_MCAN15_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN15_MCANSS_CCLK_CLK"},
	{199, 6, "DEV_MCAN15_MCANSS_CAN_RXD", "Input clock"},
	{201, 0, "DEV_MCAN16_MCANSS_HCLK_CLK", "Input clock"},
	{201, 1, "DEV_MCAN16_MCANSS_CCLK_CLK", "Input muxed clock"},
	{201, 2, "DEV_MCAN16_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN16_MCANSS_CCLK_CLK"},
	{201, 3, "DEV_MCAN16_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN16_MCANSS_CCLK_CLK"},
	{201, 4, "DEV_MCAN16_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN16_MCANSS_CCLK_CLK"},
	{201, 5, "DEV_MCAN16_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN16_MCANSS_CCLK_CLK"},
	{201, 6, "DEV_MCAN16_MCANSS_CAN_RXD", "Input clock"},
	{206, 0, "DEV_MCAN17_MCANSS_HCLK_CLK", "Input clock"},
	{206, 1, "DEV_MCAN17_MCANSS_CCLK_CLK", "Input muxed clock"},
	{206, 2, "DEV_MCAN17_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN17_MCANSS_CCLK_CLK"},
	{206, 3, "DEV_MCAN17_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN17_MCANSS_CCLK_CLK"},
	{206, 4, "DEV_MCAN17_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN17_MCANSS_CCLK_CLK"},
	{206, 5, "DEV_MCAN17_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN17_MCANSS_CCLK_CLK"},
	{206, 6, "DEV_MCAN17_MCANSS_CAN_RXD", "Input clock"},
	{184, 0, "DEV_MCAN2_MCANSS_HCLK_CLK", "Input clock"},
	{184, 1, "DEV_MCAN2_MCANSS_CCLK_CLK", "Input muxed clock"},
	{184, 2, "DEV_MCAN2_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN2_MCANSS_CCLK_CLK"},
	{184, 3, "DEV_MCAN2_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN2_MCANSS_CCLK_CLK"},
	{184, 4, "DEV_MCAN2_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN2_MCANSS_CCLK_CLK"},
	{184, 5, "DEV_MCAN2_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN2_MCANSS_CCLK_CLK"},
	{184, 6, "DEV_MCAN2_MCANSS_CAN_RXD", "Input clock"},
	{185, 0, "DEV_MCAN3_MCANSS_HCLK_CLK", "Input clock"},
	{185, 1, "DEV_MCAN3_MCANSS_CCLK_CLK", "Input muxed clock"},
	{185, 2, "DEV_MCAN3_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN3_MCANSS_CCLK_CLK"},
	{185, 3, "DEV_MCAN3_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN3_MCANSS_CCLK_CLK"},
	{185, 4, "DEV_MCAN3_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN3_MCANSS_CCLK_CLK"},
	{185, 5, "DEV_MCAN3_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN3_MCANSS_CCLK_CLK"},
	{185, 6, "DEV_MCAN3_MCANSS_CAN_RXD", "Input clock"},
	{186, 0, "DEV_MCAN4_MCANSS_HCLK_CLK", "Input clock"},
	{186, 1, "DEV_MCAN4_MCANSS_CCLK_CLK", "Input muxed clock"},
	{186, 2, "DEV_MCAN4_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN4_MCANSS_CCLK_CLK"},
	{186, 3, "DEV_MCAN4_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN4_MCANSS_CCLK_CLK"},
	{186, 4, "DEV_MCAN4_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN4_MCANSS_CCLK_CLK"},
	{186, 5, "DEV_MCAN4_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN4_MCANSS_CCLK_CLK"},
	{186, 6, "DEV_MCAN4_MCANSS_CAN_RXD", "Input clock"},
	{187, 0, "DEV_MCAN5_MCANSS_HCLK_CLK", "Input clock"},
	{187, 1, "DEV_MCAN5_MCANSS_CCLK_CLK", "Input muxed clock"},
	{187, 2, "DEV_MCAN5_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN5_MCANSS_CCLK_CLK"},
	{187, 3, "DEV_MCAN5_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN5_MCANSS_CCLK_CLK"},
	{187, 4, "DEV_MCAN5_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN5_MCANSS_CCLK_CLK"},
	{187, 5, "DEV_MCAN5_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN5_MCANSS_CCLK_CLK"},
	{187, 6, "DEV_MCAN5_MCANSS_CAN_RXD", "Input clock"},
	{188, 0, "DEV_MCAN6_MCANSS_HCLK_CLK", "Input clock"},
	{188, 1, "DEV_MCAN6_MCANSS_CCLK_CLK", "Input muxed clock"},
	{188, 2, "DEV_MCAN6_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN6_MCANSS_CCLK_CLK"},
	{188, 3, "DEV_MCAN6_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN6_MCANSS_CCLK_CLK"},
	{188, 4, "DEV_MCAN6_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN6_MCANSS_CCLK_CLK"},
	{188, 5, "DEV_MCAN6_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN6_MCANSS_CCLK_CLK"},
	{188, 6, "DEV_MCAN6_MCANSS_CAN_RXD", "Input clock"},
	{189, 0, "DEV_MCAN7_MCANSS_HCLK_CLK", "Input clock"},
	{189, 1, "DEV_MCAN7_MCANSS_CCLK_CLK", "Input muxed clock"},
	{189, 2, "DEV_MCAN7_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN7_MCANSS_CCLK_CLK"},
	{189, 3, "DEV_MCAN7_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN7_MCANSS_CCLK_CLK"},
	{189, 4, "DEV_MCAN7_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN7_MCANSS_CCLK_CLK"},
	{189, 5, "DEV_MCAN7_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN7_MCANSS_CCLK_CLK"},
	{189, 6, "DEV_MCAN7_MCANSS_CAN_RXD", "Input clock"},
	{190, 0, "DEV_MCAN8_MCANSS_HCLK_CLK", "Input clock"},
	{190, 1, "DEV_MCAN8_MCANSS_CCLK_CLK", "Input muxed clock"},
	{190, 2, "DEV_MCAN8_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN8_MCANSS_CCLK_CLK"},
	{190, 3, "DEV_MCAN8_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN8_MCANSS_CCLK_CLK"},
	{190, 4, "DEV_MCAN8_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN8_MCANSS_CCLK_CLK"},
	{190, 5, "DEV_MCAN8_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN8_MCANSS_CCLK_CLK"},
	{190, 6, "DEV_MCAN8_MCANSS_CAN_RXD", "Input clock"},
	{191, 0, "DEV_MCAN9_MCANSS_HCLK_CLK", "Input clock"},
	{191, 1, "DEV_MCAN9_MCANSS_CCLK_CLK", "Input muxed clock"},
	{191, 2, "DEV_MCAN9_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN9_MCANSS_CCLK_CLK"},
	{191, 3, "DEV_MCAN9_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN9_MCANSS_CCLK_CLK"},
	{191, 4, "DEV_MCAN9_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN9_MCANSS_CCLK_CLK"},
	{191, 5, "DEV_MCAN9_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN9_MCANSS_CCLK_CLK"},
	{191, 6, "DEV_MCAN9_MCANSS_CAN_RXD", "Input clock"},
	{209, 0, "DEV_MCASP0_AUX_CLK", "Input muxed clock"},
	{209, 1, "DEV_MCASP0_AUX_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP0_AUX_CLK"},
	{209, 2, "DEV_MCASP0_AUX_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCASP0_AUX_CLK"},
	{209, 5, "DEV_MCASP0_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP0_AUX_CLK"},
	{209, 6, "DEV_MCASP0_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP0_AUX_CLK"},
	{209, 7, "DEV_MCASP0_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP0_AUX_CLK"},
	{209, 8, "DEV_MCASP0_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP0_AUX_CLK"},
	{209, 9, "DEV_MCASP0_MCASP_AFSX_POUT", "Output clock"},
	{209, 10, "DEV_MCASP0_MCASP_AHCLKR_POUT", "Output clock"},
	{209, 11, "DEV_MCASP0_MCASP_AHCLKR_PIN", "Input muxed clock"},
	{209, 12, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{209, 13, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{209, 14, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{209, 15, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{209, 20, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{209, 21, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{209, 22, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{209, 23, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{209, 28, "DEV_MCASP0_MCASP_ACLKX_POUT", "Output clock"},
	{209, 29, "DEV_MCASP0_MCASP_AFSR_POUT", "Output clock"},
	{209, 30, "DEV_MCASP0_VBUSP_CLK", "Input clock"},
	{209, 31, "DEV_MCASP0_MCASP_ACLKR_POUT", "Output clock"},
	{209, 32, "DEV_MCASP0_MCASP_AHCLKX_POUT", "Output clock"},
	{209, 33, "DEV_MCASP0_MCASP_ACLKX_PIN", "Input clock"},
	{209, 34, "DEV_MCASP0_MCASP_AHCLKX_PIN", "Input muxed clock"},
	{209, 35, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{209, 36, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{209, 37, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{209, 38, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{209, 43, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{209, 44, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{209, 45, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{209, 46, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{209, 51, "DEV_MCASP0_MCASP_ACLKR_PIN", "Input clock"},
	{210, 0, "DEV_MCASP1_AUX_CLK", "Input muxed clock"},
	{210, 1, "DEV_MCASP1_AUX_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP1_AUX_CLK"},
	{210, 2, "DEV_MCASP1_AUX_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCASP1_AUX_CLK"},
	{210, 5, "DEV_MCASP1_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP1_AUX_CLK"},
	{210, 6, "DEV_MCASP1_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP1_AUX_CLK"},
	{210, 7, "DEV_MCASP1_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP1_AUX_CLK"},
	{210, 8, "DEV_MCASP1_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP1_AUX_CLK"},
	{210, 9, "DEV_MCASP1_MCASP_AFSX_POUT", "Output clock"},
	{210, 10, "DEV_MCASP1_MCASP_AHCLKR_POUT", "Output clock"},
	{210, 11, "DEV_MCASP1_MCASP_AHCLKR_PIN", "Input muxed clock"},
	{210, 12, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{210, 13, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{210, 14, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{210, 15, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{210, 20, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{210, 21, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{210, 22, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{210, 23, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{210, 28, "DEV_MCASP1_MCASP_ACLKX_POUT", "Output clock"},
	{210, 29, "DEV_MCASP1_MCASP_AFSR_POUT", "Output clock"},
	{210, 30, "DEV_MCASP1_VBUSP_CLK", "Input clock"},
	{210, 31, "DEV_MCASP1_MCASP_ACLKR_POUT", "Output clock"},
	{210, 32, "DEV_MCASP1_MCASP_AHCLKX_POUT", "Output clock"},
	{210, 33, "DEV_MCASP1_MCASP_ACLKX_PIN", "Input clock"},
	{210, 34, "DEV_MCASP1_MCASP_AHCLKX_PIN", "Input muxed clock"},
	{210, 35, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{210, 36, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{210, 37, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{210, 38, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{210, 43, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{210, 44, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{210, 45, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{210, 46, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{210, 51, "DEV_MCASP1_MCASP_ACLKR_PIN", "Input clock"},
	{211, 0, "DEV_MCASP2_AUX_CLK", "Input muxed clock"},
	{211, 1, "DEV_MCASP2_AUX_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP2_AUX_CLK"},
	{211, 2, "DEV_MCASP2_AUX_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCASP2_AUX_CLK"},
	{211, 5, "DEV_MCASP2_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP2_AUX_CLK"},
	{211, 6, "DEV_MCASP2_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP2_AUX_CLK"},
	{211, 7, "DEV_MCASP2_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP2_AUX_CLK"},
	{211, 8, "DEV_MCASP2_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP2_AUX_CLK"},
	{211, 9, "DEV_MCASP2_MCASP_AFSX_POUT", "Output clock"},
	{211, 10, "DEV_MCASP2_MCASP_AHCLKR_POUT", "Output clock"},
	{211, 11, "DEV_MCASP2_MCASP_AHCLKR_PIN", "Input muxed clock"},
	{211, 12, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{211, 13, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{211, 14, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{211, 15, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{211, 20, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{211, 21, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{211, 22, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{211, 23, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{211, 28, "DEV_MCASP2_MCASP_ACLKX_POUT", "Output clock"},
	{211, 29, "DEV_MCASP2_MCASP_AFSR_POUT", "Output clock"},
	{211, 30, "DEV_MCASP2_VBUSP_CLK", "Input clock"},
	{211, 31, "DEV_MCASP2_MCASP_ACLKR_POUT", "Output clock"},
	{211, 32, "DEV_MCASP2_MCASP_AHCLKX_POUT", "Output clock"},
	{211, 33, "DEV_MCASP2_MCASP_ACLKX_PIN", "Input clock"},
	{211, 34, "DEV_MCASP2_MCASP_AHCLKX_PIN", "Input muxed clock"},
	{211, 35, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{211, 36, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{211, 37, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{211, 38, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{211, 43, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{211, 44, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{211, 45, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{211, 46, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{211, 51, "DEV_MCASP2_MCASP_ACLKR_PIN", "Input clock"},
	{212, 0, "DEV_MCASP3_AUX_CLK", "Input muxed clock"},
	{212, 1, "DEV_MCASP3_AUX_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP3_AUX_CLK"},
	{212, 2, "DEV_MCASP3_AUX_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCASP3_AUX_CLK"},
	{212, 5, "DEV_MCASP3_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP3_AUX_CLK"},
	{212, 6, "DEV_MCASP3_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP3_AUX_CLK"},
	{212, 7, "DEV_MCASP3_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP3_AUX_CLK"},
	{212, 8, "DEV_MCASP3_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP3_AUX_CLK"},
	{212, 9, "DEV_MCASP3_MCASP_AFSX_POUT", "Output clock"},
	{212, 10, "DEV_MCASP3_MCASP_AHCLKR_POUT", "Output clock"},
	{212, 11, "DEV_MCASP3_MCASP_AHCLKR_PIN", "Input muxed clock"},
	{212, 12, "DEV_MCASP3_MCASP_AHCLKR_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKR_PIN"},
	{212, 13, "DEV_MCASP3_MCASP_AHCLKR_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKR_PIN"},
	{212, 14, "DEV_MCASP3_MCASP_AHCLKR_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKR_PIN"},
	{212, 15, "DEV_MCASP3_MCASP_AHCLKR_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKR_PIN"},
	{212, 20, "DEV_MCASP3_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKR_PIN"},
	{212, 21, "DEV_MCASP3_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKR_PIN"},
	{212, 22, "DEV_MCASP3_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKR_PIN"},
	{212, 23, "DEV_MCASP3_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKR_PIN"},
	{212, 28, "DEV_MCASP3_MCASP_ACLKX_POUT", "Output clock"},
	{212, 29, "DEV_MCASP3_MCASP_AFSR_POUT", "Output clock"},
	{212, 30, "DEV_MCASP3_VBUSP_CLK", "Input clock"},
	{212, 31, "DEV_MCASP3_MCASP_ACLKR_POUT", "Output clock"},
	{212, 32, "DEV_MCASP3_MCASP_AHCLKX_POUT", "Output clock"},
	{212, 33, "DEV_MCASP3_MCASP_ACLKX_PIN", "Input clock"},
	{212, 34, "DEV_MCASP3_MCASP_AHCLKX_PIN", "Input muxed clock"},
	{212, 35, "DEV_MCASP3_MCASP_AHCLKX_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKX_PIN"},
	{212, 36, "DEV_MCASP3_MCASP_AHCLKX_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKX_PIN"},
	{212, 37, "DEV_MCASP3_MCASP_AHCLKX_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKX_PIN"},
	{212, 38, "DEV_MCASP3_MCASP_AHCLKX_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKX_PIN"},
	{212, 43, "DEV_MCASP3_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKX_PIN"},
	{212, 44, "DEV_MCASP3_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKX_PIN"},
	{212, 45, "DEV_MCASP3_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKX_PIN"},
	{212, 46, "DEV_MCASP3_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKX_PIN"},
	{212, 51, "DEV_MCASP3_MCASP_ACLKR_PIN", "Input clock"},
	{213, 0, "DEV_MCASP4_AUX_CLK", "Input muxed clock"},
	{213, 1, "DEV_MCASP4_AUX_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP4_AUX_CLK"},
	{213, 2, "DEV_MCASP4_AUX_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCASP4_AUX_CLK"},
	{213, 5, "DEV_MCASP4_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP4_AUX_CLK"},
	{213, 6, "DEV_MCASP4_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP4_AUX_CLK"},
	{213, 7, "DEV_MCASP4_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP4_AUX_CLK"},
	{213, 8, "DEV_MCASP4_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP4_AUX_CLK"},
	{213, 9, "DEV_MCASP4_MCASP_AFSX_POUT", "Output clock"},
	{213, 10, "DEV_MCASP4_MCASP_AHCLKR_POUT", "Output clock"},
	{213, 11, "DEV_MCASP4_MCASP_AHCLKR_PIN", "Input muxed clock"},
	{213, 12, "DEV_MCASP4_MCASP_AHCLKR_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKR_PIN"},
	{213, 13, "DEV_MCASP4_MCASP_AHCLKR_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKR_PIN"},
	{213, 14, "DEV_MCASP4_MCASP_AHCLKR_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKR_PIN"},
	{213, 15, "DEV_MCASP4_MCASP_AHCLKR_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKR_PIN"},
	{213, 20, "DEV_MCASP4_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKR_PIN"},
	{213, 21, "DEV_MCASP4_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKR_PIN"},
	{213, 22, "DEV_MCASP4_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKR_PIN"},
	{213, 23, "DEV_MCASP4_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKR_PIN"},
	{213, 28, "DEV_MCASP4_MCASP_ACLKX_POUT", "Output clock"},
	{213, 29, "DEV_MCASP4_MCASP_AFSR_POUT", "Output clock"},
	{213, 30, "DEV_MCASP4_VBUSP_CLK", "Input clock"},
	{213, 31, "DEV_MCASP4_MCASP_ACLKR_POUT", "Output clock"},
	{213, 32, "DEV_MCASP4_MCASP_AHCLKX_POUT", "Output clock"},
	{213, 33, "DEV_MCASP4_MCASP_ACLKX_PIN", "Input clock"},
	{213, 34, "DEV_MCASP4_MCASP_AHCLKX_PIN", "Input muxed clock"},
	{213, 35, "DEV_MCASP4_MCASP_AHCLKX_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKX_PIN"},
	{213, 36, "DEV_MCASP4_MCASP_AHCLKX_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKX_PIN"},
	{213, 37, "DEV_MCASP4_MCASP_AHCLKX_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKX_PIN"},
	{213, 38, "DEV_MCASP4_MCASP_AHCLKX_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKX_PIN"},
	{213, 43, "DEV_MCASP4_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKX_PIN"},
	{213, 44, "DEV_MCASP4_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKX_PIN"},
	{213, 45, "DEV_MCASP4_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKX_PIN"},
	{213, 46, "DEV_MCASP4_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKX_PIN"},
	{213, 51, "DEV_MCASP4_MCASP_ACLKR_PIN", "Input clock"},
	{339, 0, "DEV_MCSPI0_IO_CLKSPIO_CLK", "Output clock"},
	{339, 1, "DEV_MCSPI0_VBUSP_CLK", "Input clock"},
	{339, 2, "DEV_MCSPI0_CLKSPIREF_CLK", "Input clock"},
	{339, 3, "DEV_MCSPI0_IO_CLKSPII_CLK", "Input muxed clock"},
	{339, 4, "DEV_MCSPI0_IO_CLKSPII_CLK_PARENT_BOARD_0_SPI0_CLK_OUT", "Parent input clock option to DEV_MCSPI0_IO_CLKSPII_CLK"},
	{339, 5, "DEV_MCSPI0_IO_CLKSPII_CLK_PARENT_SPI_MAIN_0_IO_CLKSPIO_CLK", "Parent input clock option to DEV_MCSPI0_IO_CLKSPII_CLK"},
	{340, 0, "DEV_MCSPI1_IO_CLKSPIO_CLK", "Output clock"},
	{340, 1, "DEV_MCSPI1_VBUSP_CLK", "Input clock"},
	{340, 2, "DEV_MCSPI1_CLKSPIREF_CLK", "Input clock"},
	{340, 3, "DEV_MCSPI1_IO_CLKSPII_CLK", "Input muxed clock"},
	{340, 4, "DEV_MCSPI1_IO_CLKSPII_CLK_PARENT_BOARD_0_SPI1_CLK_OUT", "Parent input clock option to DEV_MCSPI1_IO_CLKSPII_CLK"},
	{340, 5, "DEV_MCSPI1_IO_CLKSPII_CLK_PARENT_SPI_MAIN_1_IO_CLKSPIO_CLK", "Parent input clock option to DEV_MCSPI1_IO_CLKSPII_CLK"},
	{341, 0, "DEV_MCSPI2_IO_CLKSPIO_CLK", "Output clock"},
	{341, 1, "DEV_MCSPI2_VBUSP_CLK", "Input clock"},
	{341, 2, "DEV_MCSPI2_CLKSPIREF_CLK", "Input clock"},
	{341, 3, "DEV_MCSPI2_IO_CLKSPII_CLK", "Input muxed clock"},
	{341, 4, "DEV_MCSPI2_IO_CLKSPII_CLK_PARENT_BOARD_0_SPI2_CLK_OUT", "Parent input clock option to DEV_MCSPI2_IO_CLKSPII_CLK"},
	{341, 5, "DEV_MCSPI2_IO_CLKSPII_CLK_PARENT_SPI_MAIN_2_IO_CLKSPIO_CLK", "Parent input clock option to DEV_MCSPI2_IO_CLKSPII_CLK"},
	{342, 0, "DEV_MCSPI3_IO_CLKSPIO_CLK", "Output clock"},
	{342, 1, "DEV_MCSPI3_VBUSP_CLK", "Input clock"},
	{342, 2, "DEV_MCSPI3_CLKSPIREF_CLK", "Input clock"},
	{342, 3, "DEV_MCSPI3_IO_CLKSPII_CLK", "Input muxed clock"},
	{342, 4, "DEV_MCSPI3_IO_CLKSPII_CLK_PARENT_SPI_MAIN_3_IO_CLKSPIO_CLK", "Parent input clock option to DEV_MCSPI3_IO_CLKSPII_CLK"},
	{342, 5, "DEV_MCSPI3_IO_CLKSPII_CLK_PARENT_SPI3_CLK_LPBK_MUX_OUT0", "Parent input clock option to DEV_MCSPI3_IO_CLKSPII_CLK"},
	{343, 0, "DEV_MCSPI4_IO_CLKSPIO_CLK", "Output clock"},
	{343, 1, "DEV_MCSPI4_VBUSP_CLK", "Input clock"},
	{343, 2, "DEV_MCSPI4_CLKSPIREF_CLK", "Input clock"},
	{343, 3, "DEV_MCSPI4_IO_CLKSPII_CLK", "Input clock"},
	{344, 0, "DEV_MCSPI5_IO_CLKSPIO_CLK", "Output clock"},
	{344, 1, "DEV_MCSPI5_VBUSP_CLK", "Input clock"},
	{344, 2, "DEV_MCSPI5_CLKSPIREF_CLK", "Input clock"},
	{344, 3, "DEV_MCSPI5_IO_CLKSPII_CLK", "Input muxed clock"},
	{344, 4, "DEV_MCSPI5_IO_CLKSPII_CLK_PARENT_BOARD_0_SPI5_CLK_OUT", "Parent input clock option to DEV_MCSPI5_IO_CLKSPII_CLK"},
	{344, 5, "DEV_MCSPI5_IO_CLKSPII_CLK_PARENT_SPI_MAIN_5_IO_CLKSPIO_CLK", "Parent input clock option to DEV_MCSPI5_IO_CLKSPII_CLK"},
	{345, 0, "DEV_MCSPI6_IO_CLKSPIO_CLK", "Output clock"},
	{345, 1, "DEV_MCSPI6_VBUSP_CLK", "Input clock"},
	{345, 2, "DEV_MCSPI6_CLKSPIREF_CLK", "Input clock"},
	{345, 3, "DEV_MCSPI6_IO_CLKSPII_CLK", "Input muxed clock"},
	{345, 4, "DEV_MCSPI6_IO_CLKSPII_CLK_PARENT_BOARD_0_SPI6_CLK_OUT", "Parent input clock option to DEV_MCSPI6_IO_CLKSPII_CLK"},
	{345, 5, "DEV_MCSPI6_IO_CLKSPII_CLK_PARENT_SPI_MAIN_6_IO_CLKSPIO_CLK", "Parent input clock option to DEV_MCSPI6_IO_CLKSPII_CLK"},
	{346, 0, "DEV_MCSPI7_IO_CLKSPIO_CLK", "Output clock"},
	{346, 1, "DEV_MCSPI7_VBUSP_CLK", "Input clock"},
	{346, 2, "DEV_MCSPI7_CLKSPIREF_CLK", "Input clock"},
	{346, 3, "DEV_MCSPI7_IO_CLKSPII_CLK", "Input muxed clock"},
	{346, 4, "DEV_MCSPI7_IO_CLKSPII_CLK_PARENT_BOARD_0_SPI7_CLK_OUT", "Parent input clock option to DEV_MCSPI7_IO_CLKSPII_CLK"},
	{346, 5, "DEV_MCSPI7_IO_CLKSPII_CLK_PARENT_SPI_MAIN_7_IO_CLKSPIO_CLK", "Parent input clock option to DEV_MCSPI7_IO_CLKSPII_CLK"},
	{0, 0, "DEV_MCU_ADC12FC_16FFC0_ADC_CLK", "Input muxed clock"},
	{0, 1, "DEV_MCU_ADC12FC_16FFC0_ADC_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_ADC12FC_16FFC0_ADC_CLK"},
	{0, 2, "DEV_MCU_ADC12FC_16FFC0_ADC_CLK_PARENT_HSDIV4_16FFT_MCU_1_HSDIVOUT1_CLK", "Parent input clock option to DEV_MCU_ADC12FC_16FFC0_ADC_CLK"},
	{0, 3, "DEV_MCU_ADC12FC_16FFC0_ADC_CLK_PARENT_HSDIV1_16FFT_MCU_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_MCU_ADC12FC_16FFC0_ADC_CLK"},
	{0, 4, "DEV_MCU_ADC12FC_16FFC0_ADC_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_ADC12FC_16FFC0_ADC_CLK"},
	{0, 5, "DEV_MCU_ADC12FC_16FFC0_VBUS_CLK", "Input clock"},
	{0, 6, "DEV_MCU_ADC12FC_16FFC0_SYS_CLK", "Input clock"},
	{1, 0, "DEV_MCU_ADC12FC_16FFC1_ADC_CLK", "Input muxed clock"},
	{1, 1, "DEV_MCU_ADC12FC_16FFC1_ADC_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_ADC12FC_16FFC1_ADC_CLK"},
	{1, 2, "DEV_MCU_ADC12FC_16FFC1_ADC_CLK_PARENT_HSDIV4_16FFT_MCU_1_HSDIVOUT1_CLK", "Parent input clock option to DEV_MCU_ADC12FC_16FFC1_ADC_CLK"},
	{1, 3, "DEV_MCU_ADC12FC_16FFC1_ADC_CLK_PARENT_HSDIV1_16FFT_MCU_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_MCU_ADC12FC_16FFC1_ADC_CLK"},
	{1, 4, "DEV_MCU_ADC12FC_16FFC1_ADC_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_ADC12FC_16FFC1_ADC_CLK"},
	{1, 5, "DEV_MCU_ADC12FC_16FFC1_VBUS_CLK", "Input clock"},
	{1, 6, "DEV_MCU_ADC12FC_16FFC1_SYS_CLK", "Input clock"},
	{29, 0, "DEV_MCU_CPSW0_MDIO_MDCLK_O", "Output clock"},
	{29, 1, "DEV_MCU_CPSW0_CPTS_GENF0", "Output clock"},
	{29, 3, "DEV_MCU_CPSW0_CPTS_RFT_CLK", "Input muxed clock"},
	{29, 4, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT1_CLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{29, 5, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{29, 6, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_BOARD_0_MCU_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{29, 7, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{29, 8, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{29, 9, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{29, 10, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT2_MAIN_0_IP2_LN0_TXMCLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{29, 11, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT2_MAIN_0_IP2_LN1_TXMCLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{29, 12, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT2_MAIN_0_IP2_LN2_TXMCLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{29, 13, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT2_MAIN_0_IP2_LN3_TXMCLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{29, 18, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{29, 19, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK2", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{29, 20, "DEV_MCU_CPSW0_GMII1_MR_CLK", "Input clock"},
	{29, 21, "DEV_MCU_CPSW0_GMII_RFT_CLK", "Input clock"},
	{29, 22, "DEV_MCU_CPSW0_RGMII1_RXC_I", "Input clock"},
	{29, 26, "DEV_MCU_CPSW0_RMII_MHZ_50_CLK", "Input clock"},
	{29, 27, "DEV_MCU_CPSW0_RGMII1_TXC_O", "Output clock"},
	{29, 28, "DEV_MCU_CPSW0_CPPI_CLK_CLK", "Input clock"},
	{29, 29, "DEV_MCU_CPSW0_RGMII_MHZ_5_CLK", "Input clock"},
	{29, 30, "DEV_MCU_CPSW0_GMII1_MT_CLK", "Input clock"},
	{29, 32, "DEV_MCU_CPSW0_RGMII_MHZ_50_CLK", "Input clock"},
	{29, 33, "DEV_MCU_CPSW0_RGMII_MHZ_250_CLK", "Input clock"},
	{37, 0, "DEV_MCU_CPT2_AGGR0_VCLK_CLK", "Input clock"},
	{53, 0, "DEV_MCU_DCC0_DCC_CLKSRC0_CLK", "Input clock"},
	{53, 1, "DEV_MCU_DCC0_DCC_CLKSRC1_CLK", "Input clock"},
	{53, 2, "DEV_MCU_DCC0_DCC_CLKSRC2_CLK", "Input clock"},
	{53, 3, "DEV_MCU_DCC0_DCC_CLKSRC3_CLK", "Input clock"},
	{53, 4, "DEV_MCU_DCC0_DCC_CLKSRC4_CLK", "Input clock"},
	{53, 5, "DEV_MCU_DCC0_DCC_CLKSRC5_CLK", "Input clock"},
	{53, 6, "DEV_MCU_DCC0_DCC_CLKSRC6_CLK", "Input clock"},
	{53, 7, "DEV_MCU_DCC0_DCC_CLKSRC7_CLK", "Input clock"},
	{53, 8, "DEV_MCU_DCC0_DCC_INPUT00_CLK", "Input clock"},
	{53, 9, "DEV_MCU_DCC0_DCC_INPUT01_CLK", "Input clock"},
	{53, 10, "DEV_MCU_DCC0_DCC_INPUT02_CLK", "Input clock"},
	{53, 11, "DEV_MCU_DCC0_DCC_INPUT10_CLK", "Input clock"},
	{53, 12, "DEV_MCU_DCC0_VBUS_CLK", "Input clock"},
	{54, 0, "DEV_MCU_DCC1_DCC_CLKSRC0_CLK", "Input clock"},
	{54, 1, "DEV_MCU_DCC1_DCC_CLKSRC1_CLK", "Input clock"},
	{54, 2, "DEV_MCU_DCC1_DCC_CLKSRC2_CLK", "Input clock"},
	{54, 3, "DEV_MCU_DCC1_DCC_CLKSRC3_CLK", "Input clock"},
	{54, 4, "DEV_MCU_DCC1_DCC_CLKSRC4_CLK", "Input clock"},
	{54, 5, "DEV_MCU_DCC1_DCC_CLKSRC5_CLK", "Input clock"},
	{54, 6, "DEV_MCU_DCC1_DCC_CLKSRC6_CLK", "Input clock"},
	{54, 7, "DEV_MCU_DCC1_DCC_CLKSRC7_CLK", "Input clock"},
	{54, 8, "DEV_MCU_DCC1_DCC_INPUT00_CLK", "Input clock"},
	{54, 9, "DEV_MCU_DCC1_DCC_INPUT01_CLK", "Input clock"},
	{54, 10, "DEV_MCU_DCC1_DCC_INPUT02_CLK", "Input clock"},
	{54, 11, "DEV_MCU_DCC1_DCC_INPUT10_CLK", "Input clock"},
	{54, 12, "DEV_MCU_DCC1_VBUS_CLK", "Input clock"},
	{55, 0, "DEV_MCU_DCC2_DCC_CLKSRC0_CLK", "Input clock"},
	{55, 1, "DEV_MCU_DCC2_DCC_CLKSRC1_CLK", "Input clock"},
	{55, 2, "DEV_MCU_DCC2_DCC_CLKSRC2_CLK", "Input clock"},
	{55, 3, "DEV_MCU_DCC2_DCC_CLKSRC3_CLK", "Input clock"},
	{55, 4, "DEV_MCU_DCC2_DCC_CLKSRC4_CLK", "Input clock"},
	{55, 6, "DEV_MCU_DCC2_DCC_CLKSRC6_CLK", "Input clock"},
	{55, 7, "DEV_MCU_DCC2_DCC_CLKSRC7_CLK", "Input clock"},
	{55, 8, "DEV_MCU_DCC2_DCC_INPUT00_CLK", "Input clock"},
	{55, 9, "DEV_MCU_DCC2_DCC_INPUT01_CLK", "Input clock"},
	{55, 10, "DEV_MCU_DCC2_DCC_INPUT02_CLK", "Input clock"},
	{55, 11, "DEV_MCU_DCC2_DCC_INPUT10_CLK", "Input clock"},
	{55, 12, "DEV_MCU_DCC2_VBUS_CLK", "Input clock"},
	{105, 0, "DEV_MCU_ESM0_CLK", "Input clock"},
	{107, 0, "DEV_MCU_FSS0_FSAS_0_GCLK", "Input clock"},
	{108, 1, "DEV_MCU_FSS0_HYPERBUS1P0_0_HPB_CLKX2_INV_CLK", "Input clock"},
	{108, 2, "DEV_MCU_FSS0_HYPERBUS1P0_0_HPB_CLKX1_INV_CLK", "Input clock"},
	{108, 3, "DEV_MCU_FSS0_HYPERBUS1P0_0_HPB_CLKX1_CLK", "Input clock"},
	{108, 6, "DEV_MCU_FSS0_HYPERBUS1P0_0_HPB_CLKX2_CLK", "Input clock"},
	{108, 7, "DEV_MCU_FSS0_HYPERBUS1P0_0_HPB_OUT_CLK_N", "Output clock"},
	{108, 8, "DEV_MCU_FSS0_HYPERBUS1P0_0_HPB_OUT_CLK_P", "Output clock"},
	{108, 11, "DEV_MCU_FSS0_HYPERBUS1P0_0_CBA_CLK", "Input clock"},
	{109, 0, "DEV_MCU_FSS0_OSPI_0_OSPI_ICLK_CLK", "Input muxed clock"},
	{109, 1, "DEV_MCU_FSS0_OSPI_0_OSPI_ICLK_CLK_PARENT_BOARD_0_MCU_OSPI0_DQS_OUT", "Parent input clock option to DEV_MCU_FSS0_OSPI_0_OSPI_ICLK_CLK"},
	{109, 2, "DEV_MCU_FSS0_OSPI_0_OSPI_ICLK_CLK_PARENT_FSS_MCU_0_OSPI_0_OSPI_OCLK_CLK", "Parent input clock option to DEV_MCU_FSS0_OSPI_0_OSPI_ICLK_CLK"},
	{109, 3, "DEV_MCU_FSS0_OSPI_0_OSPI_HCLK_CLK", "Input clock"},
	{109, 4, "DEV_MCU_FSS0_OSPI_0_OSPI_OCLK_CLK", "Output clock"},
	{109, 5, "DEV_MCU_FSS0_OSPI_0_OSPI_RCLK_CLK", "Input muxed clock"},
	{109, 6, "DEV_MCU_FSS0_OSPI_0_OSPI_RCLK_CLK_PARENT_HSDIV4_16FFT_MCU_1_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCU_FSS0_OSPI_0_OSPI_RCLK_CLK"},
	{109, 7, "DEV_MCU_FSS0_OSPI_0_OSPI_RCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCU_FSS0_OSPI_0_OSPI_RCLK_CLK"},
	{109, 8, "DEV_MCU_FSS0_OSPI_0_OSPI_DQS_CLK", "Input clock"},
	{109, 9, "DEV_MCU_FSS0_OSPI_0_OSPI_PCLK_CLK", "Input clock"},
	{110, 0, "DEV_MCU_FSS0_OSPI_1_OSPI_ICLK_CLK", "Input muxed clock"},
	{110, 1, "DEV_MCU_FSS0_OSPI_1_OSPI_ICLK_CLK_PARENT_BOARD_0_MCU_OSPI1_DQS_OUT", "Parent input clock option to DEV_MCU_FSS0_OSPI_1_OSPI_ICLK_CLK"},
	{110, 2, "DEV_MCU_FSS0_OSPI_1_OSPI_ICLK_CLK_PARENT_FSS_MCU_0_OSPI_1_OSPI_OCLK_CLK", "Parent input clock option to DEV_MCU_FSS0_OSPI_1_OSPI_ICLK_CLK"},
	{110, 3, "DEV_MCU_FSS0_OSPI_1_OSPI_HCLK_CLK", "Input clock"},
	{110, 4, "DEV_MCU_FSS0_OSPI_1_OSPI_OCLK_CLK", "Output clock"},
	{110, 5, "DEV_MCU_FSS0_OSPI_1_OSPI_RCLK_CLK", "Input muxed clock"},
	{110, 6, "DEV_MCU_FSS0_OSPI_1_OSPI_RCLK_CLK_PARENT_HSDIV4_16FFT_MCU_1_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCU_FSS0_OSPI_1_OSPI_RCLK_CLK"},
	{110, 7, "DEV_MCU_FSS0_OSPI_1_OSPI_RCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCU_FSS0_OSPI_1_OSPI_RCLK_CLK"},
	{110, 8, "DEV_MCU_FSS0_OSPI_1_OSPI_DQS_CLK", "Input clock"},
	{110, 9, "DEV_MCU_FSS0_OSPI_1_OSPI_PCLK_CLK", "Input clock"},
	{221, 0, "DEV_MCU_I2C0_PORSCL", "Output clock"},
	{221, 1, "DEV_MCU_I2C0_PISYS_CLK", "Input clock"},
	{221, 2, "DEV_MCU_I2C0_CLK", "Input clock"},
	{221, 3, "DEV_MCU_I2C0_PISCL", "Input clock"},
	{222, 0, "DEV_MCU_I2C1_PORSCL", "Output clock"},
	{222, 1, "DEV_MCU_I2C1_PISYS_CLK", "Input clock"},
	{222, 2, "DEV_MCU_I2C1_CLK", "Input clock"},
	{222, 3, "DEV_MCU_I2C1_PISCL", "Input clock"},
	{118, 0, "DEV_MCU_I3C0_I3C_SCL_DI", "Input clock"},
	{118, 1, "DEV_MCU_I3C0_I3C_SCL_DO", "Output clock"},
	{118, 2, "DEV_MCU_I3C0_I3C_SCLK_CLK", "Input clock"},
	{118, 3, "DEV_MCU_I3C0_I3C_PCLK_CLK", "Input clock"},
	{118, 4, "DEV_MCU_I3C0_I3C_SDA_DI", "Input clock"},
	{119, 2, "DEV_MCU_I3C1_I3C_SCLK_CLK", "Input clock"},
	{119, 3, "DEV_MCU_I3C1_I3C_PCLK_CLK", "Input clock"},
	{207, 0, "DEV_MCU_MCAN0_MCANSS_HCLK_CLK", "Input clock"},
	{207, 1, "DEV_MCU_MCAN0_MCANSS_CCLK_CLK", "Input muxed clock"},
	{207, 2, "DEV_MCU_MCAN0_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT3_CLK", "Parent input clock option to DEV_MCU_MCAN0_MCANSS_CCLK_CLK"},
	{207, 3, "DEV_MCU_MCAN0_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_MCAN0_MCANSS_CCLK_CLK"},
	{207, 4, "DEV_MCU_MCAN0_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MCU_1_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_MCAN0_MCANSS_CCLK_CLK"},
	{207, 5, "DEV_MCU_MCAN0_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_MCAN0_MCANSS_CCLK_CLK"},
	{207, 6, "DEV_MCU_MCAN0_MCANSS_CAN_RXD", "Input clock"},
	{208, 0, "DEV_MCU_MCAN1_MCANSS_HCLK_CLK", "Input clock"},
	{208, 1, "DEV_MCU_MCAN1_MCANSS_CCLK_CLK", "Input muxed clock"},
	{208, 2, "DEV_MCU_MCAN1_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT3_CLK", "Parent input clock option to DEV_MCU_MCAN1_MCANSS_CCLK_CLK"},
	{208, 3, "DEV_MCU_MCAN1_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_MCAN1_MCANSS_CCLK_CLK"},
	{208, 4, "DEV_MCU_MCAN1_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MCU_1_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_MCAN1_MCANSS_CCLK_CLK"},
	{208, 5, "DEV_MCU_MCAN1_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_MCAN1_MCANSS_CCLK_CLK"},
	{208, 6, "DEV_MCU_MCAN1_MCANSS_CAN_RXD", "Input clock"},
	{347, 0, "DEV_MCU_MCSPI0_IO_CLKSPIO_CLK", "Output clock"},
	{347, 1, "DEV_MCU_MCSPI0_VBUSP_CLK", "Input clock"},
	{347, 2, "DEV_MCU_MCSPI0_CLKSPIREF_CLK", "Input clock"},
	{347, 3, "DEV_MCU_MCSPI0_IO_CLKSPII_CLK", "Input muxed clock"},
	{347, 4, "DEV_MCU_MCSPI0_IO_CLKSPII_CLK_PARENT_BOARD_0_MCU_SPI0_CLK_OUT", "Parent input clock option to DEV_MCU_MCSPI0_IO_CLKSPII_CLK"},
	{347, 5, "DEV_MCU_MCSPI0_IO_CLKSPII_CLK_PARENT_SPI_MCU_0_IO_CLKSPIO_CLK", "Parent input clock option to DEV_MCU_MCSPI0_IO_CLKSPII_CLK"},
	{348, 0, "DEV_MCU_MCSPI1_IO_CLKSPIO_CLK", "Output clock"},
	{348, 1, "DEV_MCU_MCSPI1_VBUSP_CLK", "Input clock"},
	{348, 2, "DEV_MCU_MCSPI1_CLKSPIREF_CLK", "Input clock"},
	{348, 3, "DEV_MCU_MCSPI1_IO_CLKSPII_CLK", "Input muxed clock"},
	{348, 4, "DEV_MCU_MCSPI1_IO_CLKSPII_CLK_PARENT_SPI_MAIN_3_IO_CLKSPIO_CLK", "Parent input clock option to DEV_MCU_MCSPI1_IO_CLKSPII_CLK"},
	{348, 5, "DEV_MCU_MCSPI1_IO_CLKSPII_CLK_PARENT_MCU_SPI1_CLK_LPBK_MUX_OUT0", "Parent input clock option to DEV_MCU_MCSPI1_IO_CLKSPII_CLK"},
	{349, 0, "DEV_MCU_MCSPI2_IO_CLKSPIO_CLK", "Output clock"},
	{349, 1, "DEV_MCU_MCSPI2_VBUSP_CLK", "Input clock"},
	{349, 2, "DEV_MCU_MCSPI2_CLKSPIREF_CLK", "Input clock"},
	{349, 3, "DEV_MCU_MCSPI2_IO_CLKSPII_CLK", "Input clock"},
	{268, 0, "DEV_MCU_NAVSS0_INTR_ROUTER_0_INTR_CLK", "Input clock"},
	{269, 0, "DEV_MCU_NAVSS0_MCRC_0_CLK", "Input clock"},
	{270, 0, "DEV_MCU_NAVSS0_MODSS_VD2CLK", "Input clock"},
	{271, 0, "DEV_MCU_NAVSS0_PROXY0_CLK_CLK", "Input clock"},
	{272, 0, "DEV_MCU_NAVSS0_RINGACC0_SYS_CLK", "Input clock"},
	{273, 0, "DEV_MCU_NAVSS0_UDMAP_0_SYS_CLK", "Input clock"},
	{274, 0, "DEV_MCU_NAVSS0_UDMASS_VD2CLK", "Input clock"},
	{275, 0, "DEV_MCU_NAVSS0_UDMASS_INTA_0_SYS_CLK", "Input clock"},
	{176, 0, "DEV_MCU_PBIST0_CLK6_CLK", "Input clock"},
	{176, 1, "DEV_MCU_PBIST0_CLK8_CLK", "Input clock"},
	{176, 3, "DEV_MCU_PBIST0_CLK3_CLK", "Input clock"},
	{176, 4, "DEV_MCU_PBIST0_CLK7_CLK", "Input clock"},
	{176, 6, "DEV_MCU_PBIST0_CLK4_CLK", "Input clock"},
	{176, 7, "DEV_MCU_PBIST0_CLK5_CLK", "Input clock"},
	{176, 8, "DEV_MCU_PBIST0_CLK1_CLK", "Input clock"},
	{176, 9, "DEV_MCU_PBIST0_CLK2_CLK", "Input clock"},
	{177, 0, "DEV_MCU_PBIST1_CLK6_CLK", "Input clock"},
	{177, 1, "DEV_MCU_PBIST1_CLK8_CLK", "Input clock"},
	{177, 3, "DEV_MCU_PBIST1_CLK3_CLK", "Input clock"},
	{177, 4, "DEV_MCU_PBIST1_CLK7_CLK", "Input clock"},
	{177, 6, "DEV_MCU_PBIST1_CLK4_CLK", "Input clock"},
	{177, 7, "DEV_MCU_PBIST1_CLK5_CLK", "Input clock"},
	{177, 8, "DEV_MCU_PBIST1_CLK1_CLK", "Input clock"},
	{177, 9, "DEV_MCU_PBIST1_CLK2_CLK", "Input clock"},
	{178, 1, "DEV_MCU_PBIST2_CLK8_CLK", "Input clock"},
	{284, 0, "DEV_MCU_R5FSS0_CORE0_CPU_CLK", "Input muxed clock"},
	{284, 1, "DEV_MCU_R5FSS0_CORE0_CPU_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_MCU_R5FSS0_CORE0_CPU_CLK"},
	{284, 2, "DEV_MCU_R5FSS0_CORE0_CPU_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK3", "Parent input clock option to DEV_MCU_R5FSS0_CORE0_CPU_CLK"},
	{284, 3, "DEV_MCU_R5FSS0_CORE0_INTERFACE_CLK", "Input clock"},
	{284, 4, "DEV_MCU_R5FSS0_CORE0_INTERFACE_PHASE", "Input clock"},
	{285, 0, "DEV_MCU_R5FSS0_CORE1_CPU_CLK", "Input muxed clock"},
	{285, 1, "DEV_MCU_R5FSS0_CORE1_CPU_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_MCU_R5FSS0_CORE1_CPU_CLK"},
	{285, 2, "DEV_MCU_R5FSS0_CORE1_CPU_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK3", "Parent input clock option to DEV_MCU_R5FSS0_CORE1_CPU_CLK"},
	{285, 3, "DEV_MCU_R5FSS0_CORE1_INTERFACE_CLK", "Input clock"},
	{285, 4, "DEV_MCU_R5FSS0_CORE1_INTERFACE_PHASE", "Input clock"},
	{295, 0, "DEV_MCU_RTI0_VBUSP_CLK", "Input clock"},
	{295, 1, "DEV_MCU_RTI0_RTI_CLK", "Input muxed clock"},
	{295, 2, "DEV_MCU_RTI0_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_RTI0_RTI_CLK"},
	{295, 3, "DEV_MCU_RTI0_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_MCU_RTI0_RTI_CLK"},
	{295, 4, "DEV_MCU_RTI0_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_RTI0_RTI_CLK"},
	{295, 5, "DEV_MCU_RTI0_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_RTI0_RTI_CLK"},
	{296, 0, "DEV_MCU_RTI1_VBUSP_CLK", "Input clock"},
	{296, 1, "DEV_MCU_RTI1_RTI_CLK", "Input muxed clock"},
	{296, 2, "DEV_MCU_RTI1_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_RTI1_RTI_CLK"},
	{296, 3, "DEV_MCU_RTI1_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_MCU_RTI1_RTI_CLK"},
	{296, 4, "DEV_MCU_RTI1_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_RTI1_RTI_CLK"},
	{296, 5, "DEV_MCU_RTI1_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_RTI1_RTI_CLK"},
	{35, 0, "DEV_MCU_TIMER0_TIMER_PWM", "Output clock"},
	{35, 1, "DEV_MCU_TIMER0_TIMER_TCLK_CLK", "Input muxed clock"},
	{35, 2, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 3, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK16", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 4, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 5, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 6, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 7, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 8, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MCU_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 9, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 10, "DEV_MCU_TIMER0_TIMER_HCLK_CLK", "Input clock"},
	{83, 1, "DEV_MCU_TIMER1_TIMER_TCLK_CLK", "Input muxed clock"},
	{83, 2, "DEV_MCU_TIMER1_TIMER_TCLK_CLK_PARENT_MCU_TIMER_CLKSEL_OUT1", "Parent input clock option to DEV_MCU_TIMER1_TIMER_TCLK_CLK"},
	{83, 3, "DEV_MCU_TIMER1_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MCU_0_TIMER_PWM", "Parent input clock option to DEV_MCU_TIMER1_TIMER_TCLK_CLK"},
	{83, 10, "DEV_MCU_TIMER1_TIMER_HCLK_CLK", "Input clock"},
	{84, 0, "DEV_MCU_TIMER2_TIMER_PWM", "Output clock"},
	{84, 1, "DEV_MCU_TIMER2_TIMER_TCLK_CLK", "Input muxed clock"},
	{84, 2, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{84, 3, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK16", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{84, 4, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{84, 5, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{84, 6, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{84, 7, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{84, 8, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MCU_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{84, 9, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{84, 10, "DEV_MCU_TIMER2_TIMER_HCLK_CLK", "Input clock"},
	{85, 1, "DEV_MCU_TIMER3_TIMER_TCLK_CLK", "Input muxed clock"},
	{85, 2, "DEV_MCU_TIMER3_TIMER_TCLK_CLK_PARENT_MCU_TIMER_CLKSEL_OUT3", "Parent input clock option to DEV_MCU_TIMER3_TIMER_TCLK_CLK"},
	{85, 3, "DEV_MCU_TIMER3_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MCU_2_TIMER_PWM", "Parent input clock option to DEV_MCU_TIMER3_TIMER_TCLK_CLK"},
	{85, 10, "DEV_MCU_TIMER3_TIMER_HCLK_CLK", "Input clock"},
	{86, 0, "DEV_MCU_TIMER4_TIMER_PWM", "Output clock"},
	{86, 1, "DEV_MCU_TIMER4_TIMER_TCLK_CLK", "Input muxed clock"},
	{86, 2, "DEV_MCU_TIMER4_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER4_TIMER_TCLK_CLK"},
	{86, 3, "DEV_MCU_TIMER4_TIMER_TCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK16", "Parent input clock option to DEV_MCU_TIMER4_TIMER_TCLK_CLK"},
	{86, 4, "DEV_MCU_TIMER4_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_TIMER4_TIMER_TCLK_CLK"},
	{86, 5, "DEV_MCU_TIMER4_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_TIMER4_TIMER_TCLK_CLK"},
	{86, 6, "DEV_MCU_TIMER4_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER4_TIMER_TCLK_CLK"},
	{86, 7, "DEV_MCU_TIMER4_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_MCU_TIMER4_TIMER_TCLK_CLK"},
	{86, 8, "DEV_MCU_TIMER4_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MCU_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER4_TIMER_TCLK_CLK"},
	{86, 9, "DEV_MCU_TIMER4_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_TIMER4_TIMER_TCLK_CLK"},
	{86, 10, "DEV_MCU_TIMER4_TIMER_HCLK_CLK", "Input clock"},
	{87, 1, "DEV_MCU_TIMER5_TIMER_TCLK_CLK", "Input muxed clock"},
	{87, 2, "DEV_MCU_TIMER5_TIMER_TCLK_CLK_PARENT_MCU_TIMER_CLKSEL_OUT5", "Parent input clock option to DEV_MCU_TIMER5_TIMER_TCLK_CLK"},
	{87, 3, "DEV_MCU_TIMER5_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MCU_4_TIMER_PWM", "Parent input clock option to DEV_MCU_TIMER5_TIMER_TCLK_CLK"},
	{87, 10, "DEV_MCU_TIMER5_TIMER_HCLK_CLK", "Input clock"},
	{88, 0, "DEV_MCU_TIMER6_TIMER_PWM", "Output clock"},
	{88, 1, "DEV_MCU_TIMER6_TIMER_TCLK_CLK", "Input muxed clock"},
	{88, 2, "DEV_MCU_TIMER6_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER6_TIMER_TCLK_CLK"},
	{88, 3, "DEV_MCU_TIMER6_TIMER_TCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK16", "Parent input clock option to DEV_MCU_TIMER6_TIMER_TCLK_CLK"},
	{88, 4, "DEV_MCU_TIMER6_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_TIMER6_TIMER_TCLK_CLK"},
	{88, 5, "DEV_MCU_TIMER6_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_TIMER6_TIMER_TCLK_CLK"},
	{88, 6, "DEV_MCU_TIMER6_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER6_TIMER_TCLK_CLK"},
	{88, 7, "DEV_MCU_TIMER6_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_MCU_TIMER6_TIMER_TCLK_CLK"},
	{88, 8, "DEV_MCU_TIMER6_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MCU_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER6_TIMER_TCLK_CLK"},
	{88, 9, "DEV_MCU_TIMER6_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_TIMER6_TIMER_TCLK_CLK"},
	{88, 10, "DEV_MCU_TIMER6_TIMER_HCLK_CLK", "Input clock"},
	{89, 1, "DEV_MCU_TIMER7_TIMER_TCLK_CLK", "Input muxed clock"},
	{89, 2, "DEV_MCU_TIMER7_TIMER_TCLK_CLK_PARENT_MCU_TIMER_CLKSEL_OUT7", "Parent input clock option to DEV_MCU_TIMER7_TIMER_TCLK_CLK"},
	{89, 3, "DEV_MCU_TIMER7_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MCU_6_TIMER_PWM", "Parent input clock option to DEV_MCU_TIMER7_TIMER_TCLK_CLK"},
	{89, 10, "DEV_MCU_TIMER7_TIMER_HCLK_CLK", "Input clock"},
	{90, 0, "DEV_MCU_TIMER8_TIMER_PWM", "Output clock"},
	{90, 1, "DEV_MCU_TIMER8_TIMER_TCLK_CLK", "Input muxed clock"},
	{90, 2, "DEV_MCU_TIMER8_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER8_TIMER_TCLK_CLK"},
	{90, 3, "DEV_MCU_TIMER8_TIMER_TCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK16", "Parent input clock option to DEV_MCU_TIMER8_TIMER_TCLK_CLK"},
	{90, 4, "DEV_MCU_TIMER8_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_TIMER8_TIMER_TCLK_CLK"},
	{90, 5, "DEV_MCU_TIMER8_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_TIMER8_TIMER_TCLK_CLK"},
	{90, 6, "DEV_MCU_TIMER8_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER8_TIMER_TCLK_CLK"},
	{90, 7, "DEV_MCU_TIMER8_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_MCU_TIMER8_TIMER_TCLK_CLK"},
	{90, 8, "DEV_MCU_TIMER8_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MCU_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER8_TIMER_TCLK_CLK"},
	{90, 9, "DEV_MCU_TIMER8_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_TIMER8_TIMER_TCLK_CLK"},
	{90, 10, "DEV_MCU_TIMER8_TIMER_HCLK_CLK", "Input clock"},
	{91, 1, "DEV_MCU_TIMER9_TIMER_TCLK_CLK", "Input muxed clock"},
	{91, 2, "DEV_MCU_TIMER9_TIMER_TCLK_CLK_PARENT_MCU_TIMER_CLKSEL_OUT9", "Parent input clock option to DEV_MCU_TIMER9_TIMER_TCLK_CLK"},
	{91, 3, "DEV_MCU_TIMER9_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MCU_8_TIMER_PWM", "Parent input clock option to DEV_MCU_TIMER9_TIMER_TCLK_CLK"},
	{91, 10, "DEV_MCU_TIMER9_TIMER_HCLK_CLK", "Input clock"},
	{149, 2, "DEV_MCU_UART0_VBUSP_CLK", "Input clock"},
	{149, 3, "DEV_MCU_UART0_FCLK_CLK", "Input muxed clock"},
	{149, 4, "DEV_MCU_UART0_FCLK_CLK_PARENT_HSDIV4_16FFT_MCU_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_MCU_UART0_FCLK_CLK"},
	{149, 5, "DEV_MCU_UART0_FCLK_CLK_PARENT_POSTDIV3_16FFT_MAIN_1_HSDIVOUT5_CLK", "Parent input clock option to DEV_MCU_UART0_FCLK_CLK"},
	{98, 1, "DEV_MMCSD0_EMMCSS_XIN_CLK", "Input muxed clock"},
	{98, 2, "DEV_MMCSD0_EMMCSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD0_EMMCSS_XIN_CLK"},
	{98, 3, "DEV_MMCSD0_EMMCSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD0_EMMCSS_XIN_CLK"},
	{98, 4, "DEV_MMCSD0_EMMCSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD0_EMMCSS_XIN_CLK"},
	{98, 5, "DEV_MMCSD0_EMMCSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD0_EMMCSS_XIN_CLK"},
	{98, 7, "DEV_MMCSD0_EMMCSS_VBUS_CLK", "Input clock"},
	{99, 1, "DEV_MMCSD1_EMMCSDSS_XIN_CLK", "Input muxed clock"},
	{99, 2, "DEV_MMCSD1_EMMCSDSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD1_EMMCSDSS_XIN_CLK"},
	{99, 3, "DEV_MMCSD1_EMMCSDSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD1_EMMCSDSS_XIN_CLK"},
	{99, 4, "DEV_MMCSD1_EMMCSDSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD1_EMMCSDSS_XIN_CLK"},
	{99, 5, "DEV_MMCSD1_EMMCSDSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD1_EMMCSDSS_XIN_CLK"},
	{99, 6, "DEV_MMCSD1_EMMCSDSS_IO_CLK_O", "Output clock"},
	{99, 7, "DEV_MMCSD1_EMMCSDSS_IO_CLK_I", "Input clock"},
	{99, 8, "DEV_MMCSD1_EMMCSDSS_VBUS_CLK", "Input clock"},
	{224, 0, "DEV_NAVSS0_CPTS0_GENF2", "Output clock"},
	{224, 1, "DEV_NAVSS0_CPTS0_GENF3", "Output clock"},
	{225, 0, "DEV_NAVSS0_BCDMA_0_CLK", "Input clock"},
	{226, 0, "DEV_NAVSS0_CPTS_0_TS_GENF0", "Output clock"},
	{226, 2, "DEV_NAVSS0_CPTS_0_TS_GENF1", "Output clock"},
	{226, 4, "DEV_NAVSS0_CPTS_0_VBUSP_GCLK", "Input clock"},
	{226, 5, "DEV_NAVSS0_CPTS_0_RCLK", "Input muxed clock"},
	{226, 6, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT1_CLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{226, 7, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{226, 8, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_BOARD_0_MCU_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{226, 9, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{226, 10, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{226, 11, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{226, 12, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_WIZ16B8M4CT2_MAIN_0_IP2_LN0_TXMCLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{226, 13, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_WIZ16B8M4CT2_MAIN_0_IP2_LN1_TXMCLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{226, 14, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_WIZ16B8M4CT2_MAIN_0_IP2_LN2_TXMCLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{226, 15, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_WIZ16B8M4CT2_MAIN_0_IP2_LN3_TXMCLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{226, 20, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{226, 21, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{227, 0, "DEV_NAVSS0_INTR_0_INTR_CLK", "Input clock"},
	{228, 0, "DEV_NAVSS0_MAILBOX1_0_VCLK_CLK", "Input clock"},
	{229, 0, "DEV_NAVSS0_MAILBOX1_1_VCLK_CLK", "Input clock"},
	{238, 0, "DEV_NAVSS0_MAILBOX1_10_VCLK_CLK", "Input clock"},
	{239, 0, "DEV_NAVSS0_MAILBOX1_11_VCLK_CLK", "Input clock"},
	{230, 0, "DEV_NAVSS0_MAILBOX1_2_VCLK_CLK", "Input clock"},
	{231, 0, "DEV_NAVSS0_MAILBOX1_3_VCLK_CLK", "Input clock"},
	{232, 0, "DEV_NAVSS0_MAILBOX1_4_VCLK_CLK", "Input clock"},
	{233, 0, "DEV_NAVSS0_MAILBOX1_5_VCLK_CLK", "Input clock"},
	{234, 0, "DEV_NAVSS0_MAILBOX1_6_VCLK_CLK", "Input clock"},
	{235, 0, "DEV_NAVSS0_MAILBOX1_7_VCLK_CLK", "Input clock"},
	{236, 0, "DEV_NAVSS0_MAILBOX1_8_VCLK_CLK", "Input clock"},
	{237, 0, "DEV_NAVSS0_MAILBOX1_9_VCLK_CLK", "Input clock"},
	{240, 0, "DEV_NAVSS0_MAILBOX_0_VCLK_CLK", "Input clock"},
	{241, 0, "DEV_NAVSS0_MAILBOX_1_VCLK_CLK", "Input clock"},
	{250, 0, "DEV_NAVSS0_MAILBOX_10_VCLK_CLK", "Input clock"},
	{251, 0, "DEV_NAVSS0_MAILBOX_11_VCLK_CLK", "Input clock"},
	{242, 0, "DEV_NAVSS0_MAILBOX_2_VCLK_CLK", "Input clock"},
	{243, 0, "DEV_NAVSS0_MAILBOX_3_VCLK_CLK", "Input clock"},
	{244, 0, "DEV_NAVSS0_MAILBOX_4_VCLK_CLK", "Input clock"},
	{245, 0, "DEV_NAVSS0_MAILBOX_5_VCLK_CLK", "Input clock"},
	{246, 0, "DEV_NAVSS0_MAILBOX_6_VCLK_CLK", "Input clock"},
	{247, 0, "DEV_NAVSS0_MAILBOX_7_VCLK_CLK", "Input clock"},
	{248, 0, "DEV_NAVSS0_MAILBOX_8_VCLK_CLK", "Input clock"},
	{249, 0, "DEV_NAVSS0_MAILBOX_9_VCLK_CLK", "Input clock"},
	{252, 0, "DEV_NAVSS0_MCRC_0_CLK", "Input clock"},
	{253, 0, "DEV_NAVSS0_MODSS_VD2CLK", "Input clock"},
	{254, 0, "DEV_NAVSS0_MODSS_INTA_0_SYS_CLK", "Input clock"},
	{255, 0, "DEV_NAVSS0_MODSS_INTA_1_SYS_CLK", "Input clock"},
	{256, 0, "DEV_NAVSS0_PROXY_0_CLK_CLK", "Input clock"},
	{257, 0, "DEV_NAVSS0_PVU_0_CLK_CLK", "Input clock"},
	{258, 0, "DEV_NAVSS0_PVU_1_CLK_CLK", "Input clock"},
	{259, 0, "DEV_NAVSS0_RINGACC_0_SYS_CLK", "Input clock"},
	{260, 0, "DEV_NAVSS0_SPINLOCK_0_CLK", "Input clock"},
	{261, 0, "DEV_NAVSS0_TIMERMGR_0_EON_TICK_EVT", "Input clock"},
	{261, 1, "DEV_NAVSS0_TIMERMGR_0_VCLK_CLK", "Input clock"},
	{262, 0, "DEV_NAVSS0_TIMERMGR_1_EON_TICK_EVT", "Input clock"},
	{262, 1, "DEV_NAVSS0_TIMERMGR_1_VCLK_CLK", "Input clock"},
	{263, 0, "DEV_NAVSS0_UDMAP_0_SYS_CLK", "Input clock"},
	{264, 0, "DEV_NAVSS0_UDMASS_VD2CLK", "Input clock"},
	{265, 0, "DEV_NAVSS0_UDMASS_INTA_0_SYS_CLK", "Input clock"},
	{266, 0, "DEV_NAVSS0_VIRTSS_VD2CLK", "Input clock"},
	{171, 1, "DEV_PBIST0_CLK8_CLK", "Input clock"},
	{172, 1, "DEV_PBIST1_CLK8_CLK", "Input clock"},
	{175, 1, "DEV_PBIST10_CLK8_CLK", "Input clock"},
	{168, 4, "DEV_PBIST11_CLK7_CLK", "Input clock"},
	{174, 1, "DEV_PBIST2_CLK8_CLK", "Input clock"},
	{170, 1, "DEV_PBIST3_CLK8_CLK", "Input clock"},
	{173, 1, "DEV_PBIST4_CLK8_CLK", "Input clock"},
	{167, 1, "DEV_PBIST5_CLK8_CLK", "Input clock"},
	{276, 0, "DEV_PCIE1_PCIE_LANE0_TXMCLK", "Input clock"},
	{276, 1, "DEV_PCIE1_PCIE_LANE0_TXFCLK", "Input clock"},
	{276, 2, "DEV_PCIE1_PCIE_LANE0_RXFCLK", "Input clock"},
	{276, 3, "DEV_PCIE1_PCIE_LANE0_TXCLK", "Output clock"},
	{276, 4, "DEV_PCIE1_PCIE_LANE3_RXFCLK", "Input clock"},
	{276, 5, "DEV_PCIE1_PCIE_LANE3_RXCLK", "Input clock"},
	{276, 6, "DEV_PCIE1_PCIE_LANE2_RXFCLK", "Input clock"},
	{276, 7, "DEV_PCIE1_PCIE_LANE1_TXCLK", "Output clock"},
	{276, 8, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK", "Input muxed clock"},
	{276, 9, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT1_CLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{276, 10, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{276, 11, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_MCU_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{276, 12, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{276, 13, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{276, 14, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{276, 15, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT2_MAIN_0_IP2_LN0_TXMCLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{276, 16, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT2_MAIN_0_IP2_LN1_TXMCLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{276, 17, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT2_MAIN_0_IP2_LN2_TXMCLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{276, 18, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT2_MAIN_0_IP2_LN3_TXMCLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{276, 23, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{276, 24, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{276, 26, "DEV_PCIE1_PCIE_LANE3_TXMCLK", "Input clock"},
	{276, 27, "DEV_PCIE1_PCIE_LANE2_RXCLK", "Input clock"},
	{276, 28, "DEV_PCIE1_PCIE_LANE1_RXFCLK", "Input clock"},
	{276, 29, "DEV_PCIE1_PCIE_LANE0_RXCLK", "Input clock"},
	{276, 30, "DEV_PCIE1_PCIE_LANE2_REFCLK", "Input clock"},
	{276, 31, "DEV_PCIE1_PCIE_LANE3_REFCLK", "Input clock"},
	{276, 32, "DEV_PCIE1_PCIE_LANE2_TXMCLK", "Input clock"},
	{276, 33, "DEV_PCIE1_PCIE_LANE1_REFCLK", "Input clock"},
	{276, 34, "DEV_PCIE1_PCIE_LANE2_TXFCLK", "Input clock"},
	{276, 35, "DEV_PCIE1_PCIE_PM_CLK", "Input clock"},
	{276, 36, "DEV_PCIE1_PCIE_LANE1_TXFCLK", "Input clock"},
	{276, 37, "DEV_PCIE1_PCIE_LANE1_TXMCLK", "Input clock"},
	{276, 38, "DEV_PCIE1_PCIE_LANE0_REFCLK", "Input clock"},
	{276, 39, "DEV_PCIE1_PCIE_LANE1_RXCLK", "Input clock"},
	{276, 40, "DEV_PCIE1_PCIE_LANE3_TXFCLK", "Input clock"},
	{276, 41, "DEV_PCIE1_PCIE_CBA_CLK", "Input clock"},
	{276, 42, "DEV_PCIE1_PCIE_LANE2_TXCLK", "Output clock"},
	{276, 43, "DEV_PCIE1_PCIE_LANE3_TXCLK", "Output clock"},
	{143, 0, "DEV_PSC0_SLOW_CLK", "Input clock"},
	{143, 1, "DEV_PSC0_CLK", "Input clock"},
	{279, 0, "DEV_R5FSS0_CORE0_CPU_CLK", "Input clock"},
	{279, 1, "DEV_R5FSS0_CORE0_INTERFACE_CLK", "Input clock"},
	{280, 0, "DEV_R5FSS0_CORE1_CPU_CLK", "Input clock"},
	{280, 1, "DEV_R5FSS0_CORE1_INTERFACE_CLK", "Input clock"},
	{281, 0, "DEV_R5FSS1_CORE0_CPU_CLK", "Input clock"},
	{281, 1, "DEV_R5FSS1_CORE0_INTERFACE_CLK", "Input clock"},
	{282, 0, "DEV_R5FSS1_CORE1_CPU_CLK", "Input clock"},
	{282, 1, "DEV_R5FSS1_CORE1_INTERFACE_CLK", "Input clock"},
	{286, 0, "DEV_RTI0_VBUSP_CLK", "Input clock"},
	{286, 1, "DEV_RTI0_RTI_CLK", "Input muxed clock"},
	{286, 2, "DEV_RTI0_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{286, 3, "DEV_RTI0_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{286, 4, "DEV_RTI0_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{286, 5, "DEV_RTI0_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{286, 6, "DEV_RTI0_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{286, 7, "DEV_RTI0_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{286, 8, "DEV_RTI0_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{286, 9, "DEV_RTI0_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{287, 0, "DEV_RTI1_VBUSP_CLK", "Input clock"},
	{287, 1, "DEV_RTI1_RTI_CLK", "Input muxed clock"},
	{287, 2, "DEV_RTI1_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{287, 3, "DEV_RTI1_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{287, 4, "DEV_RTI1_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{287, 5, "DEV_RTI1_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{287, 6, "DEV_RTI1_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{287, 7, "DEV_RTI1_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{287, 8, "DEV_RTI1_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{287, 9, "DEV_RTI1_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{290, 0, "DEV_RTI15_VBUSP_CLK", "Input clock"},
	{290, 1, "DEV_RTI15_RTI_CLK", "Input muxed clock"},
	{290, 2, "DEV_RTI15_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI15_RTI_CLK"},
	{290, 3, "DEV_RTI15_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI15_RTI_CLK"},
	{290, 4, "DEV_RTI15_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI15_RTI_CLK"},
	{290, 5, "DEV_RTI15_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI15_RTI_CLK"},
	{290, 6, "DEV_RTI15_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI15_RTI_CLK"},
	{290, 7, "DEV_RTI15_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI15_RTI_CLK"},
	{290, 8, "DEV_RTI15_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI15_RTI_CLK"},
	{290, 9, "DEV_RTI15_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI15_RTI_CLK"},
	{288, 0, "DEV_RTI16_VBUSP_CLK", "Input clock"},
	{288, 1, "DEV_RTI16_RTI_CLK", "Input muxed clock"},
	{288, 2, "DEV_RTI16_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI16_RTI_CLK"},
	{288, 3, "DEV_RTI16_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI16_RTI_CLK"},
	{288, 4, "DEV_RTI16_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI16_RTI_CLK"},
	{288, 5, "DEV_RTI16_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI16_RTI_CLK"},
	{288, 6, "DEV_RTI16_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI16_RTI_CLK"},
	{288, 7, "DEV_RTI16_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI16_RTI_CLK"},
	{288, 8, "DEV_RTI16_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI16_RTI_CLK"},
	{288, 9, "DEV_RTI16_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI16_RTI_CLK"},
	{289, 0, "DEV_RTI17_VBUSP_CLK", "Input clock"},
	{289, 1, "DEV_RTI17_RTI_CLK", "Input muxed clock"},
	{289, 2, "DEV_RTI17_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI17_RTI_CLK"},
	{289, 3, "DEV_RTI17_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI17_RTI_CLK"},
	{289, 4, "DEV_RTI17_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI17_RTI_CLK"},
	{289, 5, "DEV_RTI17_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI17_RTI_CLK"},
	{289, 6, "DEV_RTI17_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI17_RTI_CLK"},
	{289, 7, "DEV_RTI17_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI17_RTI_CLK"},
	{289, 8, "DEV_RTI17_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI17_RTI_CLK"},
	{289, 9, "DEV_RTI17_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI17_RTI_CLK"},
	{291, 0, "DEV_RTI28_VBUSP_CLK", "Input clock"},
	{291, 1, "DEV_RTI28_RTI_CLK", "Input muxed clock"},
	{291, 2, "DEV_RTI28_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI28_RTI_CLK"},
	{291, 3, "DEV_RTI28_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI28_RTI_CLK"},
	{291, 4, "DEV_RTI28_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI28_RTI_CLK"},
	{291, 5, "DEV_RTI28_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI28_RTI_CLK"},
	{291, 6, "DEV_RTI28_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI28_RTI_CLK"},
	{291, 7, "DEV_RTI28_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI28_RTI_CLK"},
	{291, 8, "DEV_RTI28_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI28_RTI_CLK"},
	{291, 9, "DEV_RTI28_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI28_RTI_CLK"},
	{292, 0, "DEV_RTI29_VBUSP_CLK", "Input clock"},
	{292, 1, "DEV_RTI29_RTI_CLK", "Input muxed clock"},
	{292, 2, "DEV_RTI29_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI29_RTI_CLK"},
	{292, 3, "DEV_RTI29_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI29_RTI_CLK"},
	{292, 4, "DEV_RTI29_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI29_RTI_CLK"},
	{292, 5, "DEV_RTI29_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI29_RTI_CLK"},
	{292, 6, "DEV_RTI29_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI29_RTI_CLK"},
	{292, 7, "DEV_RTI29_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI29_RTI_CLK"},
	{292, 8, "DEV_RTI29_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI29_RTI_CLK"},
	{292, 9, "DEV_RTI29_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI29_RTI_CLK"},
	{293, 0, "DEV_RTI30_VBUSP_CLK", "Input clock"},
	{293, 1, "DEV_RTI30_RTI_CLK", "Input muxed clock"},
	{293, 2, "DEV_RTI30_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI30_RTI_CLK"},
	{293, 3, "DEV_RTI30_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI30_RTI_CLK"},
	{293, 4, "DEV_RTI30_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI30_RTI_CLK"},
	{293, 5, "DEV_RTI30_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI30_RTI_CLK"},
	{293, 6, "DEV_RTI30_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI30_RTI_CLK"},
	{293, 7, "DEV_RTI30_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI30_RTI_CLK"},
	{293, 8, "DEV_RTI30_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI30_RTI_CLK"},
	{293, 9, "DEV_RTI30_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI30_RTI_CLK"},
	{294, 0, "DEV_RTI31_VBUSP_CLK", "Input clock"},
	{294, 1, "DEV_RTI31_RTI_CLK", "Input muxed clock"},
	{294, 2, "DEV_RTI31_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI31_RTI_CLK"},
	{294, 3, "DEV_RTI31_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI31_RTI_CLK"},
	{294, 4, "DEV_RTI31_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI31_RTI_CLK"},
	{294, 5, "DEV_RTI31_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI31_RTI_CLK"},
	{294, 6, "DEV_RTI31_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI31_RTI_CLK"},
	{294, 7, "DEV_RTI31_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI31_RTI_CLK"},
	{294, 8, "DEV_RTI31_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI31_RTI_CLK"},
	{294, 9, "DEV_RTI31_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI31_RTI_CLK"},
	{145, 0, "DEV_SA2_CPSW_PSILSS0_MAIN_CLK", "Input clock"},
	{145, 1, "DEV_SA2_CPSW_PSILSS0_MAIN_2_CLK", "Input clock"},
	{297, 0, "DEV_SA2_UL0_PKA_IN_CLK", "Input clock"},
	{297, 1, "DEV_SA2_UL0_X1_CLK", "Input clock"},
	{297, 2, "DEV_SA2_UL0_X2_CLK", "Input clock"},
	{365, 0, "DEV_SERDES_10G0_CLK", "Input clock"},
	{365, 1, "DEV_SERDES_10G0_CMN_REFCLK_M", "Input clock"},
	{365, 1, "DEV_SERDES_10G0_CMN_REFCLK_M", "Output clock"},
	{365, 2, "DEV_SERDES_10G0_CMN_REFCLK_P", "Input clock"},
	{365, 2, "DEV_SERDES_10G0_CMN_REFCLK_P", "Output clock"},
	{365, 3, "DEV_SERDES_10G0_CORE_REF_CLK", "Input muxed clock"},
	{365, 4, "DEV_SERDES_10G0_CORE_REF_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_SERDES_10G0_CORE_REF_CLK"},
	{365, 5, "DEV_SERDES_10G0_CORE_REF_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_SERDES_10G0_CORE_REF_CLK"},
	{365, 6, "DEV_SERDES_10G0_CORE_REF_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT4_CLK", "Parent input clock option to DEV_SERDES_10G0_CORE_REF_CLK"},
	{365, 7, "DEV_SERDES_10G0_CORE_REF_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT4_CLK", "Parent input clock option to DEV_SERDES_10G0_CORE_REF_CLK"},
	{365, 9, "DEV_SERDES_10G0_IP1_LN0_REFCLK", "Output clock"},
	{365, 10, "DEV_SERDES_10G0_IP1_LN0_RXCLK", "Output clock"},
	{365, 11, "DEV_SERDES_10G0_IP1_LN0_RXFCLK", "Output clock"},
	{365, 12, "DEV_SERDES_10G0_IP1_LN0_TXCLK", "Input clock"},
	{365, 13, "DEV_SERDES_10G0_IP1_LN0_TXFCLK", "Output clock"},
	{365, 14, "DEV_SERDES_10G0_IP1_LN0_TXMCLK", "Output clock"},
	{365, 15, "DEV_SERDES_10G0_IP1_LN1_REFCLK", "Output clock"},
	{365, 16, "DEV_SERDES_10G0_IP1_LN1_RXCLK", "Output clock"},
	{365, 17, "DEV_SERDES_10G0_IP1_LN1_RXFCLK", "Output clock"},
	{365, 18, "DEV_SERDES_10G0_IP1_LN1_TXCLK", "Input clock"},
	{365, 19, "DEV_SERDES_10G0_IP1_LN1_TXFCLK", "Output clock"},
	{365, 20, "DEV_SERDES_10G0_IP1_LN1_TXMCLK", "Output clock"},
	{365, 21, "DEV_SERDES_10G0_IP1_LN2_REFCLK", "Output clock"},
	{365, 22, "DEV_SERDES_10G0_IP1_LN2_RXCLK", "Output clock"},
	{365, 23, "DEV_SERDES_10G0_IP1_LN2_RXFCLK", "Output clock"},
	{365, 24, "DEV_SERDES_10G0_IP1_LN2_TXCLK", "Input muxed clock"},
	{365, 25, "DEV_SERDES_10G0_IP1_LN2_TXCLK_PARENT_K3_DSS_EDP_MAIN_0_PHY_LN2_TXCLK", "Parent input clock option to DEV_SERDES_10G0_IP1_LN2_TXCLK"},
	{365, 26, "DEV_SERDES_10G0_IP1_LN2_TXCLK_PARENT_K3_DSS_EDP_MAIN_0_PHY_LN0_TXCLK", "Parent input clock option to DEV_SERDES_10G0_IP1_LN2_TXCLK"},
	{365, 27, "DEV_SERDES_10G0_IP1_LN2_TXFCLK", "Output clock"},
	{365, 28, "DEV_SERDES_10G0_IP1_LN2_TXMCLK", "Output clock"},
	{365, 29, "DEV_SERDES_10G0_IP1_LN3_REFCLK", "Output clock"},
	{365, 30, "DEV_SERDES_10G0_IP1_LN3_RXCLK", "Output clock"},
	{365, 31, "DEV_SERDES_10G0_IP1_LN3_RXFCLK", "Output clock"},
	{365, 32, "DEV_SERDES_10G0_IP1_LN3_TXCLK", "Input muxed clock"},
	{365, 33, "DEV_SERDES_10G0_IP1_LN3_TXCLK_PARENT_K3_DSS_EDP_MAIN_0_PHY_LN3_TXCLK", "Parent input clock option to DEV_SERDES_10G0_IP1_LN3_TXCLK"},
	{365, 34, "DEV_SERDES_10G0_IP1_LN3_TXCLK_PARENT_K3_DSS_EDP_MAIN_0_PHY_LN1_TXCLK", "Parent input clock option to DEV_SERDES_10G0_IP1_LN3_TXCLK"},
	{365, 35, "DEV_SERDES_10G0_IP1_LN3_TXFCLK", "Output clock"},
	{365, 36, "DEV_SERDES_10G0_IP1_LN3_TXMCLK", "Output clock"},
	{365, 37, "DEV_SERDES_10G0_IP2_LN0_REFCLK", "Output clock"},
	{365, 38, "DEV_SERDES_10G0_IP2_LN0_RXCLK", "Output clock"},
	{365, 39, "DEV_SERDES_10G0_IP2_LN0_RXFCLK", "Output clock"},
	{365, 40, "DEV_SERDES_10G0_IP2_LN0_TXCLK", "Input clock"},
	{365, 41, "DEV_SERDES_10G0_IP2_LN0_TXFCLK", "Output clock"},
	{365, 42, "DEV_SERDES_10G0_IP2_LN0_TXMCLK", "Output clock"},
	{365, 43, "DEV_SERDES_10G0_IP2_LN1_REFCLK", "Output clock"},
	{365, 44, "DEV_SERDES_10G0_IP2_LN1_RXCLK", "Output clock"},
	{365, 45, "DEV_SERDES_10G0_IP2_LN1_RXFCLK", "Output clock"},
	{365, 46, "DEV_SERDES_10G0_IP2_LN1_TXCLK", "Input clock"},
	{365, 47, "DEV_SERDES_10G0_IP2_LN1_TXFCLK", "Output clock"},
	{365, 48, "DEV_SERDES_10G0_IP2_LN1_TXMCLK", "Output clock"},
	{365, 49, "DEV_SERDES_10G0_IP2_LN2_REFCLK", "Output clock"},
	{365, 50, "DEV_SERDES_10G0_IP2_LN2_RXCLK", "Output clock"},
	{365, 51, "DEV_SERDES_10G0_IP2_LN2_RXFCLK", "Output clock"},
	{365, 52, "DEV_SERDES_10G0_IP2_LN2_TXCLK", "Input clock"},
	{365, 53, "DEV_SERDES_10G0_IP2_LN2_TXFCLK", "Output clock"},
	{365, 54, "DEV_SERDES_10G0_IP2_LN2_TXMCLK", "Output clock"},
	{365, 55, "DEV_SERDES_10G0_IP2_LN3_REFCLK", "Output clock"},
	{365, 56, "DEV_SERDES_10G0_IP2_LN3_RXCLK", "Output clock"},
	{365, 57, "DEV_SERDES_10G0_IP2_LN3_RXFCLK", "Output clock"},
	{365, 58, "DEV_SERDES_10G0_IP2_LN3_TXCLK", "Input clock"},
	{365, 59, "DEV_SERDES_10G0_IP2_LN3_TXFCLK", "Output clock"},
	{365, 60, "DEV_SERDES_10G0_IP2_LN3_TXMCLK", "Output clock"},
	{365, 67, "DEV_SERDES_10G0_IP3_LN1_REFCLK", "Output clock"},
	{365, 68, "DEV_SERDES_10G0_IP3_LN1_RXCLK", "Output clock"},
	{365, 69, "DEV_SERDES_10G0_IP3_LN1_RXFCLK", "Output clock"},
	{365, 70, "DEV_SERDES_10G0_IP3_LN1_TXCLK", "Input clock"},
	{365, 71, "DEV_SERDES_10G0_IP3_LN1_TXFCLK", "Output clock"},
	{365, 72, "DEV_SERDES_10G0_IP3_LN1_TXMCLK", "Output clock"},
	{365, 79, "DEV_SERDES_10G0_IP3_LN3_REFCLK", "Output clock"},
	{365, 80, "DEV_SERDES_10G0_IP3_LN3_RXCLK", "Output clock"},
	{365, 81, "DEV_SERDES_10G0_IP3_LN3_RXFCLK", "Output clock"},
	{365, 82, "DEV_SERDES_10G0_IP3_LN3_TXCLK", "Input clock"},
	{365, 83, "DEV_SERDES_10G0_IP3_LN3_TXFCLK", "Output clock"},
	{365, 84, "DEV_SERDES_10G0_IP3_LN3_TXMCLK", "Output clock"},
	{365, 85, "DEV_SERDES_10G0_IP4_LN0_REFCLK", "Output clock"},
	{365, 86, "DEV_SERDES_10G0_IP4_LN0_RXCLK", "Output clock"},
	{365, 87, "DEV_SERDES_10G0_IP4_LN0_RXFCLK", "Output clock"},
	{365, 88, "DEV_SERDES_10G0_IP4_LN0_TXCLK", "Input clock"},
	{365, 89, "DEV_SERDES_10G0_IP4_LN0_TXFCLK", "Output clock"},
	{365, 90, "DEV_SERDES_10G0_IP4_LN0_TXMCLK", "Output clock"},
	{365, 91, "DEV_SERDES_10G0_IP4_LN1_REFCLK", "Output clock"},
	{365, 92, "DEV_SERDES_10G0_IP4_LN1_RXCLK", "Output clock"},
	{365, 93, "DEV_SERDES_10G0_IP4_LN1_RXFCLK", "Output clock"},
	{365, 94, "DEV_SERDES_10G0_IP4_LN1_TXCLK", "Input clock"},
	{365, 95, "DEV_SERDES_10G0_IP4_LN1_TXFCLK", "Output clock"},
	{365, 96, "DEV_SERDES_10G0_IP4_LN1_TXMCLK", "Output clock"},
	{365, 97, "DEV_SERDES_10G0_IP4_LN2_REFCLK", "Output clock"},
	{365, 98, "DEV_SERDES_10G0_IP4_LN2_RXCLK", "Output clock"},
	{365, 99, "DEV_SERDES_10G0_IP4_LN2_RXFCLK", "Output clock"},
	{365, 100, "DEV_SERDES_10G0_IP4_LN2_TXCLK", "Input clock"},
	{365, 101, "DEV_SERDES_10G0_IP4_LN2_TXFCLK", "Output clock"},
	{365, 102, "DEV_SERDES_10G0_IP4_LN2_TXMCLK", "Output clock"},
	{365, 103, "DEV_SERDES_10G0_IP4_LN3_REFCLK", "Output clock"},
	{365, 104, "DEV_SERDES_10G0_IP4_LN3_RXCLK", "Output clock"},
	{365, 105, "DEV_SERDES_10G0_IP4_LN3_RXFCLK", "Output clock"},
	{365, 106, "DEV_SERDES_10G0_IP4_LN3_TXCLK", "Input clock"},
	{365, 107, "DEV_SERDES_10G0_IP4_LN3_TXFCLK", "Output clock"},
	{365, 108, "DEV_SERDES_10G0_IP4_LN3_TXMCLK", "Output clock"},
	{365, 130, "DEV_SERDES_10G0_TAP_TCK", "Input clock"},
	{42, 0, "DEV_STM0_CORE_CLK", "Input clock"},
	{42, 1, "DEV_STM0_VBUSP_CLK", "Input clock"},
	{42, 2, "DEV_STM0_ATB_CLK", "Input clock"},
	{63, 0, "DEV_TIMER0_TIMER_PWM", "Output clock"},
	{63, 1, "DEV_TIMER0_TIMER_TCLK_CLK", "Input muxed clock"},
	{63, 2, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{63, 3, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{63, 4, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT8_CLK", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{63, 5, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{63, 6, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{63, 7, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{63, 8, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{63, 9, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{63, 10, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{63, 11, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{63, 12, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{63, 13, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{63, 14, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{63, 15, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{63, 16, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{63, 18, "DEV_TIMER0_TIMER_HCLK_CLK", "Input clock"},
	{64, 1, "DEV_TIMER1_TIMER_TCLK_CLK", "Input muxed clock"},
	{64, 2, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT1", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{64, 3, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_0_TIMER_PWM", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{64, 18, "DEV_TIMER1_TIMER_HCLK_CLK", "Input clock"},
	{73, 0, "DEV_TIMER10_TIMER_PWM", "Output clock"},
	{73, 1, "DEV_TIMER10_TIMER_TCLK_CLK", "Input muxed clock"},
	{73, 2, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{73, 3, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{73, 4, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT8_CLK", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{73, 5, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{73, 6, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{73, 7, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{73, 8, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{73, 9, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{73, 10, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{73, 11, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{73, 12, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{73, 13, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{73, 14, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{73, 15, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{73, 16, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{73, 18, "DEV_TIMER10_TIMER_HCLK_CLK", "Input clock"},
	{74, 1, "DEV_TIMER11_TIMER_TCLK_CLK", "Input muxed clock"},
	{74, 2, "DEV_TIMER11_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT11", "Parent input clock option to DEV_TIMER11_TIMER_TCLK_CLK"},
	{74, 3, "DEV_TIMER11_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_10_TIMER_PWM", "Parent input clock option to DEV_TIMER11_TIMER_TCLK_CLK"},
	{74, 18, "DEV_TIMER11_TIMER_HCLK_CLK", "Input clock"},
	{75, 0, "DEV_TIMER12_TIMER_PWM", "Output clock"},
	{75, 1, "DEV_TIMER12_TIMER_TCLK_CLK", "Input muxed clock"},
	{75, 2, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{75, 3, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{75, 4, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT8_CLK", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{75, 5, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{75, 6, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{75, 7, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{75, 8, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{75, 9, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{75, 10, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{75, 11, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{75, 12, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{75, 13, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{75, 14, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{75, 15, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{75, 16, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{75, 18, "DEV_TIMER12_TIMER_HCLK_CLK", "Input clock"},
	{76, 1, "DEV_TIMER13_TIMER_TCLK_CLK", "Input muxed clock"},
	{76, 2, "DEV_TIMER13_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT13", "Parent input clock option to DEV_TIMER13_TIMER_TCLK_CLK"},
	{76, 3, "DEV_TIMER13_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_12_TIMER_PWM", "Parent input clock option to DEV_TIMER13_TIMER_TCLK_CLK"},
	{76, 18, "DEV_TIMER13_TIMER_HCLK_CLK", "Input clock"},
	{77, 0, "DEV_TIMER14_TIMER_PWM", "Output clock"},
	{77, 1, "DEV_TIMER14_TIMER_TCLK_CLK", "Input muxed clock"},
	{77, 2, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{77, 3, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{77, 4, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT8_CLK", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{77, 5, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{77, 6, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{77, 7, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{77, 8, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{77, 9, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{77, 10, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{77, 11, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{77, 12, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{77, 13, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{77, 14, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{77, 15, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{77, 16, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{77, 18, "DEV_TIMER14_TIMER_HCLK_CLK", "Input clock"},
	{78, 1, "DEV_TIMER15_TIMER_TCLK_CLK", "Input muxed clock"},
	{78, 2, "DEV_TIMER15_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT15", "Parent input clock option to DEV_TIMER15_TIMER_TCLK_CLK"},
	{78, 3, "DEV_TIMER15_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_14_TIMER_PWM", "Parent input clock option to DEV_TIMER15_TIMER_TCLK_CLK"},
	{78, 18, "DEV_TIMER15_TIMER_HCLK_CLK", "Input clock"},
	{79, 0, "DEV_TIMER16_TIMER_PWM", "Output clock"},
	{79, 1, "DEV_TIMER16_TIMER_TCLK_CLK", "Input muxed clock"},
	{79, 2, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT16", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{79, 3, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_MAIN_TIMER16_AFS_SEL_OUT0", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{79, 34, "DEV_TIMER16_TIMER_HCLK_CLK", "Input clock"},
	{80, 1, "DEV_TIMER17_TIMER_TCLK_CLK", "Input muxed clock"},
	{80, 2, "DEV_TIMER17_TIMER_TCLK_CLK_PARENT_MAIN_TIMER17_AFS_EN_OUT0", "Parent input clock option to DEV_TIMER17_TIMER_TCLK_CLK"},
	{80, 3, "DEV_TIMER17_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_16_TIMER_PWM", "Parent input clock option to DEV_TIMER17_TIMER_TCLK_CLK"},
	{80, 34, "DEV_TIMER17_TIMER_HCLK_CLK", "Input clock"},
	{81, 0, "DEV_TIMER18_TIMER_PWM", "Output clock"},
	{81, 1, "DEV_TIMER18_TIMER_TCLK_CLK", "Input muxed clock"},
	{81, 2, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT18", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{81, 3, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_MAIN_TIMER18_AFS_SEL_OUT0", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{81, 34, "DEV_TIMER18_TIMER_HCLK_CLK", "Input clock"},
	{82, 1, "DEV_TIMER19_TIMER_TCLK_CLK", "Input muxed clock"},
	{82, 2, "DEV_TIMER19_TIMER_TCLK_CLK_PARENT_MAIN_TIMER19_AFS_EN_OUT0", "Parent input clock option to DEV_TIMER19_TIMER_TCLK_CLK"},
	{82, 3, "DEV_TIMER19_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_18_TIMER_PWM", "Parent input clock option to DEV_TIMER19_TIMER_TCLK_CLK"},
	{82, 34, "DEV_TIMER19_TIMER_HCLK_CLK", "Input clock"},
	{65, 0, "DEV_TIMER2_TIMER_PWM", "Output clock"},
	{65, 1, "DEV_TIMER2_TIMER_TCLK_CLK", "Input muxed clock"},
	{65, 2, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{65, 3, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{65, 4, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT8_CLK", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{65, 5, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{65, 6, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{65, 7, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{65, 8, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{65, 9, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{65, 10, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{65, 11, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{65, 12, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{65, 13, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{65, 14, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{65, 15, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{65, 16, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{65, 18, "DEV_TIMER2_TIMER_HCLK_CLK", "Input clock"},
	{66, 1, "DEV_TIMER3_TIMER_TCLK_CLK", "Input muxed clock"},
	{66, 2, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT3", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{66, 3, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_2_TIMER_PWM", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{66, 18, "DEV_TIMER3_TIMER_HCLK_CLK", "Input clock"},
	{67, 0, "DEV_TIMER4_TIMER_PWM", "Output clock"},
	{67, 1, "DEV_TIMER4_TIMER_TCLK_CLK", "Input muxed clock"},
	{67, 2, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{67, 3, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{67, 4, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT8_CLK", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{67, 5, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{67, 6, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{67, 7, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{67, 8, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{67, 9, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{67, 10, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{67, 11, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{67, 12, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{67, 13, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{67, 14, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{67, 15, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{67, 16, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{67, 18, "DEV_TIMER4_TIMER_HCLK_CLK", "Input clock"},
	{68, 1, "DEV_TIMER5_TIMER_TCLK_CLK", "Input muxed clock"},
	{68, 2, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT5", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{68, 3, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_4_TIMER_PWM", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{68, 18, "DEV_TIMER5_TIMER_HCLK_CLK", "Input clock"},
	{69, 0, "DEV_TIMER6_TIMER_PWM", "Output clock"},
	{69, 1, "DEV_TIMER6_TIMER_TCLK_CLK", "Input muxed clock"},
	{69, 2, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{69, 3, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{69, 4, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT8_CLK", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{69, 5, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{69, 6, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{69, 7, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{69, 8, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{69, 9, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{69, 10, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{69, 11, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{69, 12, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{69, 13, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{69, 14, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{69, 15, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{69, 16, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{69, 18, "DEV_TIMER6_TIMER_HCLK_CLK", "Input clock"},
	{70, 1, "DEV_TIMER7_TIMER_TCLK_CLK", "Input muxed clock"},
	{70, 2, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT7", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{70, 3, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_6_TIMER_PWM", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{70, 18, "DEV_TIMER7_TIMER_HCLK_CLK", "Input clock"},
	{71, 0, "DEV_TIMER8_TIMER_PWM", "Output clock"},
	{71, 1, "DEV_TIMER8_TIMER_TCLK_CLK", "Input muxed clock"},
	{71, 2, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{71, 3, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{71, 4, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT8_CLK", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{71, 5, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{71, 6, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{71, 7, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{71, 8, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{71, 9, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{71, 10, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{71, 11, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{71, 12, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{71, 13, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{71, 14, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{71, 15, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{71, 16, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{71, 18, "DEV_TIMER8_TIMER_HCLK_CLK", "Input clock"},
	{72, 1, "DEV_TIMER9_TIMER_TCLK_CLK", "Input muxed clock"},
	{72, 2, "DEV_TIMER9_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT9", "Parent input clock option to DEV_TIMER9_TIMER_TCLK_CLK"},
	{72, 3, "DEV_TIMER9_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_8_TIMER_PWM", "Parent input clock option to DEV_TIMER9_TIMER_TCLK_CLK"},
	{72, 18, "DEV_TIMER9_TIMER_HCLK_CLK", "Input clock"},
	{124, 0, "DEV_TIMESYNC_INTRTR0_INTR_CLK", "Input clock"},
	{146, 2, "DEV_UART0_VBUSP_CLK", "Input clock"},
	{146, 3, "DEV_UART0_FCLK_CLK", "Input clock"},
	{350, 2, "DEV_UART1_VBUSP_CLK", "Input clock"},
	{350, 3, "DEV_UART1_FCLK_CLK", "Input clock"},
	{351, 2, "DEV_UART2_VBUSP_CLK", "Input clock"},
	{351, 3, "DEV_UART2_FCLK_CLK", "Input clock"},
	{352, 2, "DEV_UART3_VBUSP_CLK", "Input clock"},
	{352, 3, "DEV_UART3_FCLK_CLK", "Input clock"},
	{353, 2, "DEV_UART4_VBUSP_CLK", "Input clock"},
	{353, 3, "DEV_UART4_FCLK_CLK", "Input clock"},
	{354, 2, "DEV_UART5_VBUSP_CLK", "Input clock"},
	{354, 3, "DEV_UART5_FCLK_CLK", "Input clock"},
	{355, 2, "DEV_UART6_VBUSP_CLK", "Input clock"},
	{355, 3, "DEV_UART6_FCLK_CLK", "Input clock"},
	{356, 2, "DEV_UART7_VBUSP_CLK", "Input clock"},
	{356, 3, "DEV_UART7_FCLK_CLK", "Input clock"},
	{357, 2, "DEV_UART8_VBUSP_CLK", "Input clock"},
	{357, 3, "DEV_UART8_FCLK_CLK", "Input clock"},
	{358, 2, "DEV_UART9_VBUSP_CLK", "Input clock"},
	{358, 3, "DEV_UART9_FCLK_CLK", "Input clock"},
	{360, 1, "DEV_USB0_PIPE_RXFCLK", "Input muxed clock"},
	{360, 2, "DEV_USB0_PIPE_RXFCLK_PARENT_WIZ16B8M4CT2_MAIN_0_IP3_LN3_RXFCLK", "Parent input clock option to DEV_USB0_PIPE_RXFCLK"},
	{360, 3, "DEV_USB0_PIPE_RXFCLK_PARENT_WIZ16B8M4CT2_MAIN_0_IP3_LN1_RXFCLK", "Parent input clock option to DEV_USB0_PIPE_RXFCLK"},
	{360, 4, "DEV_USB0_USB2_APB_PCLK_CLK", "Input clock"},
	{360, 5, "DEV_USB0_PIPE_TXCLK", "Output clock"},
	{360, 7, "DEV_USB0_PIPE_TXFCLK", "Input muxed clock"},
	{360, 8, "DEV_USB0_PIPE_TXFCLK_PARENT_WIZ16B8M4CT2_MAIN_0_IP3_LN3_TXFCLK", "Parent input clock option to DEV_USB0_PIPE_TXFCLK"},
	{360, 9, "DEV_USB0_PIPE_TXFCLK_PARENT_WIZ16B8M4CT2_MAIN_0_IP3_LN1_TXFCLK", "Parent input clock option to DEV_USB0_PIPE_TXFCLK"},
	{360, 10, "DEV_USB0_PIPE_REFCLK", "Input muxed clock"},
	{360, 11, "DEV_USB0_PIPE_REFCLK_PARENT_WIZ16B8M4CT2_MAIN_0_IP3_LN3_REFCLK", "Parent input clock option to DEV_USB0_PIPE_REFCLK"},
	{360, 12, "DEV_USB0_PIPE_REFCLK_PARENT_WIZ16B8M4CT2_MAIN_0_IP3_LN1_REFCLK", "Parent input clock option to DEV_USB0_PIPE_REFCLK"},
	{360, 13, "DEV_USB0_PCLK_CLK", "Input clock"},
	{360, 15, "DEV_USB0_CLK_LPM_CLK", "Input clock"},
	{360, 16, "DEV_USB0_USB2_REFCLOCK_CLK", "Input muxed clock"},
	{360, 17, "DEV_USB0_USB2_REFCLOCK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_USB0_USB2_REFCLOCK_CLK"},
	{360, 18, "DEV_USB0_USB2_REFCLOCK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_USB0_USB2_REFCLOCK_CLK"},
	{360, 19, "DEV_USB0_PIPE_RXCLK", "Input muxed clock"},
	{360, 20, "DEV_USB0_PIPE_RXCLK_PARENT_WIZ16B8M4CT2_MAIN_0_IP3_LN3_RXCLK", "Parent input clock option to DEV_USB0_PIPE_RXCLK"},
	{360, 21, "DEV_USB0_PIPE_RXCLK_PARENT_WIZ16B8M4CT2_MAIN_0_IP3_LN1_RXCLK", "Parent input clock option to DEV_USB0_PIPE_RXCLK"},
	{360, 22, "DEV_USB0_ACLK_CLK", "Input clock"},
	{360, 23, "DEV_USB0_BUF_CLK", "Input clock"},
	{360, 25, "DEV_USB0_USB2_TAP_TCK", "Input clock"},
	{360, 26, "DEV_USB0_PIPE_TXMCLK", "Input muxed clock"},
	{360, 27, "DEV_USB0_PIPE_TXMCLK_PARENT_WIZ16B8M4CT2_MAIN_0_IP3_LN3_TXMCLK", "Parent input clock option to DEV_USB0_PIPE_TXMCLK"},
	{360, 28, "DEV_USB0_PIPE_TXMCLK_PARENT_WIZ16B8M4CT2_MAIN_0_IP3_LN1_TXMCLK", "Parent input clock option to DEV_USB0_PIPE_TXMCLK"},
	{361, 0, "DEV_VPAC0_LDC0_CLK_CLK", "Input clock"},
	{361, 1, "DEV_VPAC0_NF_CLK_CLK", "Input clock"},
	{361, 2, "DEV_VPAC0_MAIN_CLK", "Input muxed clock"},
	{361, 3, "DEV_VPAC0_MAIN_CLK_PARENT_HSDIV1_16FFT_MAIN_25_HSDIVOUT1_CLK", "Parent input clock option to DEV_VPAC0_MAIN_CLK"},
	{361, 4, "DEV_VPAC0_MAIN_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_VPAC0_MAIN_CLK"},
	{361, 5, "DEV_VPAC0_VISS0_CLK_CLK", "Input clock"},
	{361, 6, "DEV_VPAC0_PSIL_LEAF_CLK", "Input clock"},
	{361, 7, "DEV_VPAC0_MSC_CLK", "Input clock"},
	{362, 0, "DEV_VUSR_DUAL0_V0_RXFL_CLK", "Output clock"},
	{362, 1, "DEV_VUSR_DUAL0_VUSRX_LN0_TXFCLK", "Input clock"},
	{362, 2, "DEV_VUSR_DUAL0_V0_CLK", "Input clock"},
	{362, 3, "DEV_VUSR_DUAL0_V1_TXPM_CLK", "Output clock"},
	{362, 4, "DEV_VUSR_DUAL0_VUSRX_LN1_TXMCLK", "Input clock"},
	{362, 5, "DEV_VUSR_DUAL0_V1_TXFL_CLK", "Input clock"},
	{362, 6, "DEV_VUSR_DUAL0_VUSRX_LN0_RXCLK", "Input clock"},
	{362, 7, "DEV_VUSR_DUAL0_VUSRX_LN2_RXFCLK", "Input clock"},
	{362, 8, "DEV_VUSR_DUAL0_VUSRX_LN2_REFCLK", "Input clock"},
	{362, 9, "DEV_VUSR_DUAL0_VUSRX_LN3_RXCLK", "Input clock"},
	{362, 10, "DEV_VUSR_DUAL0_VUSRX_LN1_RXFCLK", "Input clock"},
	{362, 11, "DEV_VUSR_DUAL0_VUSRX_LN0_REFCLK", "Input clock"},
	{362, 12, "DEV_VUSR_DUAL0_VUSRX_LN1_TXCLK", "Output clock"},
	{362, 13, "DEV_VUSR_DUAL0_VUSRX_LN3_RXFCLK", "Input clock"},
	{362, 14, "DEV_VUSR_DUAL0_VUSRX_LN3_TXCLK", "Output clock"},
	{362, 15, "DEV_VUSR_DUAL0_VUSRX_LN3_TXMCLK", "Input clock"},
	{362, 16, "DEV_VUSR_DUAL0_VUSRX_LN3_TXFCLK", "Input clock"},
	{362, 17, "DEV_VUSR_DUAL0_VUSRX_LN0_TXCLK", "Output clock"},
	{362, 18, "DEV_VUSR_DUAL0_V1_CLK", "Input clock"},
	{362, 19, "DEV_VUSR_DUAL0_V0_TXFL_CLK", "Input clock"},
	{362, 20, "DEV_VUSR_DUAL0_VUSRX_LN0_RXFCLK", "Input clock"},
	{362, 21, "DEV_VUSR_DUAL0_VUSRX_LN2_RXCLK", "Input clock"},
	{362, 22, "DEV_VUSR_DUAL0_V0_TXPM_CLK", "Output clock"},
	{362, 23, "DEV_VUSR_DUAL0_V0_RXPM_CLK", "Input clock"},
	{362, 24, "DEV_VUSR_DUAL0_VUSRX_LN1_REFCLK", "Input clock"},
	{362, 25, "DEV_VUSR_DUAL0_V1_RXPM_CLK", "Input clock"},
	{362, 26, "DEV_VUSR_DUAL0_V1_RXFL_CLK", "Output clock"},
	{362, 27, "DEV_VUSR_DUAL0_VUSRX_LN2_TXCLK", "Output clock"},
	{362, 28, "DEV_VUSR_DUAL0_VUSRX_LN2_TXFCLK", "Input clock"},
	{362, 29, "DEV_VUSR_DUAL0_VUSRX_LN0_TXMCLK", "Input clock"},
	{362, 30, "DEV_VUSR_DUAL0_VUSRX_LN2_TXMCLK", "Input clock"},
	{362, 31, "DEV_VUSR_DUAL0_VUSRX_LN1_TXFCLK", "Input clock"},
	{362, 32, "DEV_VUSR_DUAL0_VUSRX_LN3_REFCLK", "Input clock"},
	{362, 33, "DEV_VUSR_DUAL0_VUSRX_LN1_RXCLK", "Input clock"},
	{151, 0, "DEV_WKUP_DDPA0_DDPA_CLK", "Input clock"},
	{104, 0, "DEV_WKUP_ESM0_CLK", "Input clock"},
	{115, 0, "DEV_WKUP_GPIO0_MMR_CLK", "Input clock"},
	{116, 0, "DEV_WKUP_GPIO1_MMR_CLK", "Input clock"},
	{125, 0, "DEV_WKUP_GPIOMUX_INTRTR0_INTR_CLK", "Input clock"},
	{304, 0, "DEV_WKUP_HSM0_DAP_CLK", "Input clock"},
	{223, 0, "DEV_WKUP_I2C0_PORSCL", "Output clock"},
	{223, 1, "DEV_WKUP_I2C0_PISYS_CLK", "Input muxed clock"},
	{223, 2, "DEV_WKUP_I2C0_PISYS_CLK_PARENT_HSDIV4_16FFT_MCU_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_WKUP_I2C0_PISYS_CLK"},
	{223, 3, "DEV_WKUP_I2C0_PISYS_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_WKUP_I2C0_PISYS_CLK"},
	{223, 4, "DEV_WKUP_I2C0_CLK", "Input clock"},
	{223, 5, "DEV_WKUP_I2C0_PISCL", "Input clock"},
	{147, 0, "DEV_WKUP_J7AM_WAKEUP_16FF0_PLL_CTRL_WKUP_CLK24_CLK", "Input clock"},
	{147, 1, "DEV_WKUP_J7AM_WAKEUP_16FF0_WKUP_RCOSC_12P5M_CLK", "Output clock"},
	{147, 2, "DEV_WKUP_J7AM_WAKEUP_16FF0_WKUP_RCOSC_32K_CLK", "Output clock"},
	{123, 0, "DEV_WKUP_PORZ_SYNC0_CLK_12M_RC_CLK", "Input clock"},
	{126, 0, "DEV_WKUP_PSC0_SLOW_CLK", "Input clock"},
	{126, 1, "DEV_WKUP_PSC0_CLK", "Input clock"},
	{359, 2, "DEV_WKUP_UART0_VBUSP_CLK", "Input clock"},
	{359, 3, "DEV_WKUP_UART0_FCLK_CLK", "Input muxed clock"},
	{359, 4, "DEV_WKUP_UART0_FCLK_CLK_PARENT_WKUP_USART_CLKSEL_OUT0", "Parent input clock option to DEV_WKUP_UART0_FCLK_CLK"},
	{359, 5, "DEV_WKUP_UART0_FCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_WKUP_UART0_FCLK_CLK"},
	{180, 0, "DEV_WKUP_VTM0_FIX_REF_CLK", "Input clock"},
	{180, 1, "DEV_WKUP_VTM0_FIX_REF2_CLK", "Input clock"},
	{180, 2, "DEV_WKUP_VTM0_VBUSP_CLK", "Input clock"},
};
