/* ----- core/multsntrup1013, derived from supercop/crypto_core/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *core_multsntrup1013_checksums[] = {
  "bb44732592ee7d27c6e0890312f5d24a549c18dc5a96e228dd1ad2144634967d",
  "a9055126814af236349885adb167762de5c9b3e19f351de5e14abd91a5fc759f",
} ;

static void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
#define crypto_core_OUTPUTBYTES ntruprime_core_multsntrup1013_OUTPUTBYTES
#define crypto_core_INPUTBYTES ntruprime_core_multsntrup1013_INPUTBYTES
#define crypto_core_KEYBYTES ntruprime_core_multsntrup1013_KEYBYTES
#define crypto_core_CONSTBYTES ntruprime_core_multsntrup1013_CONSTBYTES

static void *storage_core_multsntrup1013_h;
static unsigned char *test_core_multsntrup1013_h;
static void *storage_core_multsntrup1013_n;
static unsigned char *test_core_multsntrup1013_n;
static void *storage_core_multsntrup1013_k;
static unsigned char *test_core_multsntrup1013_k;
static void *storage_core_multsntrup1013_c;
static unsigned char *test_core_multsntrup1013_c;
static void *storage_core_multsntrup1013_h2;
static unsigned char *test_core_multsntrup1013_h2;
static void *storage_core_multsntrup1013_n2;
static unsigned char *test_core_multsntrup1013_n2;
static void *storage_core_multsntrup1013_k2;
static unsigned char *test_core_multsntrup1013_k2;
static void *storage_core_multsntrup1013_c2;
static unsigned char *test_core_multsntrup1013_c2;

#define precomputed_core_multsntrup1013_NUM 4

static const unsigned char precomputed_core_multsntrup1013_h[precomputed_core_multsntrup1013_NUM][crypto_core_OUTPUTBYTES] = {
  {66,253,51,255,24,13,194,10,32,247,209,255,144,253,195,12,4,250,246,6,165,245,126,2,200,7,11,12,168,249,21,255,23,4,211,244,250,4,234,7,41,2,176,12,57,252,113,3,243,8,144,6,150,251,152,243,110,248,52,10,173,10,179,7,201,251,228,250,92,5,215,13,242,253,118,244,230,251,138,13,175,244,176,2,141,242,28,242,113,242,168,5,47,2,79,5,253,2,11,13,134,249,195,13,32,243,43,251,22,255,44,9,66,2,133,2,29,252,192,3,103,243,209,243,198,250,134,7,171,13,8,10,183,5,52,253,253,253,230,9,84,12,195,2,139,253,123,246,163,2,167,244,246,245,158,5,17,246,86,242,127,2,64,248,41,1,172,248,164,2,212,243,213,4,85,8,25,252,191,11,133,10,121,247,169,7,27,5,171,6,67,252,109,252,3,251,58,251,132,242,246,5,59,9,139,13,111,243,32,246,118,253,182,249,97,6,253,249,226,242,174,252,179,7,35,251,134,245,38,6,119,253,10,2,232,247,19,245,188,255,122,7,247,0,93,6,107,252,192,247,161,243,119,4,158,251,209,7,32,243,237,10,229,0,236,242,175,13,209,12,18,253,7,0,253,255,167,12,43,12,209,4,73,8,182,253,253,254,115,255,121,249,94,1,233,245,16,13,94,9,241,249,217,1,113,252,10,11,30,244,172,247,121,9,94,3,226,7,243,13,129,247,211,243,15,249,157,5,137,248,145,11,134,2,158,0,79,4,201,4,183,5,151,251,115,243,14,251,4,0,201,6,236,246,88,255,95,253,120,246,243,255,23,6,184,249,123,245,70,11,202,255,40,7,119,253,232,254,9,247,69,13,74,250,116,2,126,252,15,248,66,1,0,243,171,246,127,12,105,244,87,253,216,5,216,10,187,4,113,10,192,4,152,9,138,247,74,10,183,245,23,6,187,0,229,245,167,248,70,9,9,1,159,255,133,4,157,247,190,252,63,12,117,249,200,13,102,249,255,247,96,249,162,4,184,251,80,1,96,251,198,8,102,252,142,9,172,9,208,243,203,10,202,248,161,251,114,7,94,250,73,243,209,10,116,245,44,11,95,242,49,251,87,9,222,9,195,9,148,4,218,252,51,246,193,3,193,250,116,243,132,254,29,5,82,4,2,251,177,2,120,11,100,252,54,254,21,3,96,2,53,12,32,254,77,245,235,9,198,8,197,11,197,8,120,248,82,251,186,3,153,255,127,12,241,247,165,1,174,243,83,246,121,13,78,8,217,242,151,250,129,1,119,9,153,248,103,250,119,254,43,251,38,242,239,12,129,247,88,5,142,244,89,2,111,4,97,249,11,4,15,10,52,10,137,246,174,253,162,249,148,13,125,9,46,12,229,245,114,2,232,9,150,8,213,5,67,8,101,253,13,13,87,2,63,8,139,10,206,243,120,255,76,247,248,9,169,5,171,12,105,12,190,10,148,5,91,255,53,243,140,6,177,245,206,7,202,7,113,8,102,244,220,246,91,253,51,249,52,4,55,6,189,7,152,250,87,6,83,246,163,245,15,11,64,6,211,4,239,4,80,253,200,247,144,10,29,247,129,13,213,6,186,254,39,10,188,248,52,6,159,251,20,249,238,13,220,250,134,2,150,1,182,255,226,8,124,3,30,254,241,252,173,252,57,252,206,244,122,9,104,5,81,2,65,246,121,1,100,3,39,10,11,245,42,11,147,251,226,244,219,7,137,250,97,5,27,6,235,0,87,12,16,5,138,10,123,243,180,8,4,253,99,3,215,6,98,245,33,4,220,12,85,5,241,255,193,8,130,6,117,2,230,253,209,8,132,1,65,250,164,247,51,251,171,244,207,0,165,5,109,243,14,6,90,7,231,11,176,255,155,2,148,2,209,243,92,248,198,251,182,6,70,248,248,253,66,243,38,1,101,5,197,255,255,251,136,247,245,244,233,7,123,252,168,9,20,13,25,9,165,254,174,242,246,3,232,255,207,249,0,249,250,254,239,246,38,251,22,2,234,9,3,252,156,3,249,245,6,243,128,242,125,10,46,0,138,2,215,245,141,11,75,5,207,4,54,1,180,12,232,6,3,242,218,9,156,252,80,253,47,0,44,5,166,248,38,255,141,251,12,1,20,3,0,14,98,247,187,12,17,8,31,253,208,0,144,0,11,253,247,250,100,7,51,1,149,252,247,249,214,243,170,0,255,247,232,250,112,11,143,248,47,249,77,248,125,3,246,250,61,0,114,254,114,253,203,3,65,11,12,246,70,10,251,8,8,9,248,255,143,7,35,245,6,8,91,8,82,0,167,2,48,9,196,8,242,3,188,6,186,11,145,10,17,3,108,246,89,9,7,9,45,5,102,6,15,1,100,11,251,254,32,251,236,243,184,245,43,244,17,3,233,246,184,2,74,0,112,11,203,254,164,249,20,3,190,242,218,11,253,241,131,9,231,252,25,2,86,249,126,5,77,13,121,246,175,7,68,7,216,250,237,251,50,244,73,10,40,251,69,251,40,249,1,249,29,255,141,244,184,243,127,7,243,242,221,251,123,245,60,6,46,5,38,246,65,251,115,243,146,8,80,250,99,253,2,2,55,253,55,249,33,4,141,242,9,251,184,5,236,254,64,12,149,243,91,8,190,0,217,248,52,249,167,254,15,249,20,251,166,247,44,9,25,253,210,10,13,9,182,242,201,9,93,7,7,251,90,246,0,4,191,254,156,10,68,247,231,247,130,249,183,249,206,11,62,13,97,2,94,13,245,242,44,250,146,246,139,254,65,0,70,243,34,246,124,251,100,1,242,246,207,249,217,251,240,245,148,252,238,249,55,2,184,3,61,249,214,11,9,245,70,6,204,249,134,254,209,252,108,249,38,254,152,6,35,10,116,253,15,7,63,250,33,3,230,250,80,6,136,255,47,3,158,9,230,250,217,255,64,4,133,252,128,254,168,8,180,253,140,249,27,5,221,8,100,247,46,12,139,6,26,3,119,7,219,243,237,243,229,252,135,254,141,3,229,255,162,247,201,12,166,8,21,254,116,10,160,249,183,0,27,6,26,10,161,6,66,246,59,11,111,3,158,244,92,10,209,3,58,254,58,249,95,13,41,247,71,1,89,248,100,9,206,9,106,0,78,2,165,247,135,13,71,247,221,250,67,12,237,1,67,2,140,243,10,7,10,250,46,244,83,11,178,12,188,251,147,0,120,253,20,245,33,249,207,11,115,13,10,245,42,5,243,245,157,250,201,248,116,253,117,254,89,13,108,0,216,12,52,250,6,2,154,249,149,0,168,248,10,0,104,245,31,243,74,246,91,10,123,254,90,6,229,4,58,9,207,246,59,7,243,251,11,242,134,6,162,245,101,6,156,6,77,255,122,6,141,6,216,4,27,13,114,244,54,1,250,4,165,244,193,4,58,253,81,245,217,254,38,243,141,9,238,249,225,2,190,13,198,11,230,253,243,5,39,1,118,3,12,9,36,13,95,2,216,8,223,255,119,254,197,249,208,251,111,251,90,247,178,243,129,252,4,249,213,244,139,1,186,10,153,244,78,246,25,250,56,245,209,7,202,246,232,249,177,245,70,247,234,12,147,5,139,11,126,243,186,250,119,4,161,1,143,7,189,12,6,250,32,13,70,1,126,4,134,245,45,4,215,4,99,255,239,11,28,9,170,0,164,252,218,248,16,255,169,250,84,13,219,4,19,243,50,1,122,247,60,3,174,1,213,251,237,249,100,1,239,249,43,254,249,243,126,8,160,11,171,3,16,254,117,249,70,253,4,14,246,255,24,6,250,251,245,249,10,255,162,254,253,244,213,255,38,11,172,10,83,248,249,251,175,253,247,255,49,242,30,2,243,1,237,251,7,10,164,10,10,247,156,253,189,3,152,253,160,6,219,248,239,7,29,5,159,249,67,0,211,12,46,8,51,242,240,254,144,0,116,11,85,252,52,245,120,245,31,246,218,11,214,3,93,0,158,255,82,243,125,1,214,248,193,3,208,7,231,247,208,251,128,244,255,244,239,4,90,9,106,5,131,255,26,249,134,4,95,250,131,246,190,246,184,7,116,3,147,251,85,250,60,253,221,8,137,9,56,244,116,8,125,243,111,12,1,10,34,254,198,249,192,252,169,242,16,252,87,0,57,244,91,7,64,8,202,5,133,242,78,0,162,11,18,255,84,9,196,0,31,10,136,6,15,251,39,253,176,249,19,13,194,12,223,243,236,4,143,253,109,254,213,12,18,13,155,247,68,251,2,253,216,244,251,245,148,10,95,250,228,246,166,1,146,251,169,250,55,249,145,244,3,250,104,242,62,6,153,3,133,8,209,2,173,13,61,12,111,8,50,242,216,7,209,251,208,247,9,13,237,251,54,253,76,242,106,9,107,242,158,0,133,4,60,7,58,5,228,7,255,12,250,252,209,242,64,249,210,255,114,243,106,242,101,2,127,12,69,2,244,251,57,244,246,245,41,246,89,13,183,252,75,2,6,12,88,250,36,253,53,254,71,2,84,3,180,254,23,0,87,252,150,243,106,0,59,13},
  {210,242,230,248,137,250,178,3,202,9,27,11,143,245,236,1,255,253,117,246,15,6,205,252,134,248,209,8,110,253,226,3,79,9,102,254,237,253,92,248,75,243,105,250,87,5,157,6,175,245,159,3,241,13,223,2,49,253,19,5,150,253,27,247,89,1,169,13,190,6,237,244,189,5,112,254,42,243,217,247,63,7,233,244,220,250,84,251,45,251,202,9,18,254,28,11,178,255,20,11,99,0,180,11,46,13,54,254,202,2,146,254,174,247,12,255,179,5,222,4,65,10,159,246,175,248,118,250,111,6,85,1,183,248,222,244,205,254,250,8,240,10,41,253,94,249,233,251,185,4,188,250,7,0,137,244,65,3,186,10,221,7,65,255,132,255,240,0,92,249,103,2,90,254,192,9,61,243,172,244,183,7,220,2,56,249,247,4,196,244,191,11,169,248,253,246,77,242,212,249,229,253,246,251,25,250,158,247,175,1,110,4,55,6,187,248,154,9,125,249,51,243,192,11,226,13,240,8,144,242,24,7,29,11,161,1,35,251,181,255,242,247,65,2,121,2,5,2,80,250,249,7,239,0,17,245,217,7,85,255,241,253,228,252,174,254,249,247,101,4,12,7,209,255,16,246,19,13,107,246,48,4,163,2,187,2,48,4,212,10,18,1,167,247,232,7,8,249,51,0,152,251,232,5,89,5,183,3,8,250,197,5,230,251,245,10,22,11,234,0,67,8,82,9,185,13,77,8,151,10,54,244,153,4,83,10,142,245,155,9,22,10,124,0,229,253,21,0,57,249,70,2,193,242,173,249,100,246,248,12,122,255,53,251,218,244,27,3,236,8,184,250,53,12,83,5,42,250,161,11,75,255,128,245,251,11,105,7,75,245,201,255,13,242,216,249,117,13,144,254,193,5,255,254,127,12,183,255,233,3,86,5,126,246,36,244,150,251,44,7,70,255,168,254,175,3,29,10,117,3,185,246,116,255,231,5,129,246,225,8,50,250,174,246,60,249,84,1,27,248,50,0,33,244,78,1,156,248,94,249,183,13,225,7,235,13,159,4,27,8,42,7,123,1,80,255,132,255,97,244,151,245,89,6,114,250,235,5,4,243,179,249,89,8,61,3,67,252,57,0,144,251,59,3,254,9,114,247,240,4,143,254,54,253,170,13,69,247,239,251,239,245,231,254,229,251,98,0,59,1,183,253,1,9,49,242,244,248,238,10,69,249,9,0,117,249,52,2,210,6,236,242,38,0,180,3,141,253,15,5,36,9,212,9,255,247,108,10,182,246,185,5,163,12,137,5,208,253,86,243,167,0,90,246,192,250,154,255,27,12,9,249,40,248,64,248,189,245,87,5,106,12,110,9,231,9,220,253,146,243,91,11,25,250,234,4,247,12,100,8,39,11,63,5,221,243,66,6,33,242,73,6,12,6,169,245,182,3,160,6,103,11,122,249,193,12,179,8,215,249,196,5,35,252,163,250,202,4,15,2,116,0,70,253,54,6,55,6,100,1,168,0,91,245,226,6,8,249,69,253,89,249,88,246,40,253,103,254,200,10,129,10,179,246,138,13,187,3,71,11,63,255,150,244,3,12,55,0,83,1,143,8,39,5,234,6,166,249,255,3,118,9,29,11,87,249,61,248,234,0,17,253,134,12,87,251,157,6,138,13,205,252,201,248,67,250,196,245,219,248,5,2,127,244,16,1,54,9,162,253,2,13,172,4,216,5,99,246,90,244,160,251,47,10,48,253,64,12,167,4,14,9,97,243,32,249,105,3,52,252,129,12,22,3,189,255,161,247,104,243,168,4,229,11,41,254,39,12,223,252,119,250,139,251,164,10,41,253,129,245,67,10,251,5,130,253,115,244,114,5,99,3,119,1,121,248,189,255,249,0,161,242,86,246,194,253,106,11,122,244,90,251,241,2,101,254,42,4,109,11,138,244,167,254,140,245,23,13,195,8,203,244,26,248,202,251,235,253,128,11,176,7,28,11,88,255,218,246,119,250,106,9,166,246,248,12,152,0,105,242,52,13,194,251,2,242,166,7,140,243,178,5,90,1,102,246,214,255,77,243,142,242,84,247,152,5,64,245,224,248,127,4,28,251,196,2,252,2,202,254,171,244,176,11,62,12,173,5,221,247,213,245,202,248,157,246,50,12,236,247,214,1,84,7,60,253,16,245,213,242,37,247,112,252,40,6,206,255,38,248,216,8,82,7,23,5,149,8,102,249,110,11,244,12,226,7,117,242,64,244,30,12,218,251,182,8,44,7,93,3,239,249,217,243,66,9,118,250,255,247,118,0,140,1,234,251,59,2,111,12,155,248,195,245,141,5,64,5,92,7,58,253,120,12,251,10,54,2,246,7,196,242,69,247,45,245,22,244,69,11,114,243,73,11,247,251,230,252,24,247,9,242,230,249,111,4,45,13,117,250,197,247,81,244,49,4,254,0,50,253,154,251,220,254,236,2,19,0,67,254,208,4,132,246,32,242,252,7,6,251,50,246,131,242,227,242,176,6,232,244,69,243,105,251,153,13,92,252,123,1,195,251,225,1,139,13,110,249,185,245,170,3,64,10,138,248,22,13,115,247,107,246,235,6,28,9,181,248,115,9,158,253,38,254,237,6,215,251,129,245,153,5,181,5,31,242,113,6,58,8,184,10,240,7,139,242,132,4,130,244,25,8,12,245,51,5,242,247,225,250,249,8,221,2,31,251,183,12,215,7,144,242,137,252,60,2,65,3,125,247,203,243,97,248,148,6,243,244,106,249,192,3,17,3,53,6,243,254,91,7,10,2,233,255,63,245,57,4,107,245,65,255,26,2,5,9,34,249,31,253,255,252,150,4,11,4,52,5,139,4,208,7,205,7,236,253,45,13,113,12,190,7,158,5,169,6,41,251,251,247,15,12,99,11,44,4,40,6,16,1,24,252,35,243,96,8,225,7,70,242,22,242,241,251,237,6,57,11,152,255,25,8,54,2,179,9,222,12,106,1,203,0,74,8,223,10,34,253,213,249,110,7,137,254,74,9,243,6,161,245,253,248,58,249,237,6,137,0,166,248,203,8,237,8,3,13,139,247,158,13,177,0,244,13,26,9,119,9,255,248,67,252,146,9,36,7,151,253,196,252,183,245,122,255,213,0,55,10,101,7,198,250,46,255,128,249,116,11,248,9,175,251,73,13,173,11,28,247,94,254,231,243,208,249,159,12,154,250,104,6,194,251,139,6,0,3,120,2,87,253,36,253,224,13,210,2,14,6,225,244,208,8,64,243,0,9,112,6,213,242,47,254,249,242,82,247,24,245,209,6,49,12,48,5,50,251,206,0,96,3,63,243,147,4,39,255,255,7,166,11,164,243,113,0,238,248,96,2,174,249,147,252,41,2,181,8,114,253,155,10,89,10,252,3,85,244,183,6,72,248,137,253,20,0,23,7,75,255,32,8,103,242,25,251,8,7,251,251,245,245,132,9,32,7,66,6,134,13,43,252,114,12,22,9,175,4,149,246,35,5,90,243,252,6,197,253,187,245,36,242,73,246,255,8,9,10,92,0,254,3,119,247,46,255,200,254,254,7,7,244,49,3,208,252,244,12,88,6,75,242,155,9,99,251,182,253,195,242,194,254,99,0,84,7,109,255,193,242,225,242,159,253,76,247,191,13,63,249,215,2,249,244,10,251,170,245,88,254,143,253,140,13,26,2,65,5,79,251,119,247,101,3,209,10,72,6,9,4,192,249,160,255,149,250,29,1,194,7,107,12,210,247,96,11,196,248,74,4,129,246,24,9,56,7,48,12,67,13,36,253,25,249,51,243,116,242,195,252,74,242,208,249,142,7,249,9,151,253,236,254,57,248,127,1,140,245,87,11,192,253,182,11,249,244,255,253,147,9,32,252,234,246,201,253,197,11,84,243,84,10,2,253,34,13,155,255,33,5,80,253,51,243,156,4,213,13,126,253,85,2,182,243,153,0,40,4,65,11,46,250,112,11,230,245,118,253,138,7,170,248,32,12,89,243,144,8,241,251,67,254,15,254,193,11,100,245,78,8,127,11,144,2,202,9,28,6,170,252,215,2,228,254,202,10,12,242,165,13,116,255,186,11,20,246,180,247,86,245,143,7,86,4,71,6,13,247,203,6,102,3,223,11,73,0,109,5,233,250,60,249,226,11,22,246,204,8,163,254,75,11,69,254,10,13,70,2,195,3,117,11,99,250,163,245,141,6,4,7,18,251,30,246,193,246,132,246,150,0,166,1,63,7,187,251,169,249,221,248,254,246,8,2,3,250,221,8,233,242,176,5,13,243,209,2,204,253,125,1,113,250,77,242,76,251,17,249,214,5,74,0,3,249,200,13,27,248,103,11,184,254,153,253,163,9,68,247,58,253,84,4,25,251,155,4,120,6,160,3,182,244,112,242,68,12,11,6,41,242,115,4,189,10,147,247,193,246,165,248,22,255,221,0,196,245,98,245,199,249,181,252,203,245,193,7,204,255,117,246,120,9,109,254,63,8,150,8,151,255,229,13,232,251,124,242,2,252,179,8,198,1,52,1,35,5,205,1},
  {210,7,191,250,125,246,69,249,230,4,123,249,113,247,231,3,224,249,149,1,208,245,230,249,85,12,86,1,40,9,7,251,155,11,169,246,0,7,47,255,249,254,122,245,166,8,155,5,226,248,216,248,198,4,16,246,160,1,83,250,183,5,10,6,154,11,107,243,136,250,52,250,205,253,15,255,239,10,57,248,191,6,146,253,176,248,180,5,70,243,161,254,149,245,54,250,105,245,75,11,203,252,146,244,76,5,112,246,195,249,61,8,54,9,232,8,251,4,15,252,205,7,217,4,236,255,187,250,105,10,153,255,140,12,141,247,68,10,109,247,80,252,196,6,140,12,146,4,125,13,74,251,226,9,23,1,61,9,83,246,219,249,0,1,182,248,111,252,81,3,205,253,204,13,244,4,194,250,237,9,77,251,151,246,5,250,40,252,55,242,18,9,123,6,108,243,195,249,9,6,69,4,164,245,87,247,252,241,118,1,140,5,232,2,102,247,197,7,72,253,236,249,78,245,108,8,71,249,101,2,69,255,228,255,21,1,13,243,47,249,117,3,74,11,220,242,64,247,245,248,149,243,216,1,180,6,214,6,152,5,67,5,138,6,215,0,61,8,80,11,33,4,59,248,249,255,178,13,219,254,191,252,251,243,66,4,103,6,55,253,80,13,178,248,147,247,7,253,162,244,126,251,97,250,131,9,231,1,222,244,199,245,83,10,162,7,72,4,193,247,231,249,107,11,222,8,30,244,202,10,60,7,32,7,49,9,93,248,53,247,137,8,1,253,85,248,208,243,78,254,194,249,129,13,249,245,84,10,32,5,155,247,100,250,50,242,21,250,104,5,24,3,191,2,255,2,215,11,5,253,183,243,62,250,72,7,232,251,126,7,250,251,5,13,23,244,128,11,74,250,59,12,231,254,6,252,209,246,61,251,14,255,41,3,212,4,55,7,8,244,130,253,187,243,29,250,89,242,236,11,24,249,191,252,79,4,83,0,192,1,228,243,68,246,17,2,207,255,81,253,1,244,171,2,207,254,134,10,237,7,227,248,184,7,151,245,52,8,194,1,55,0,194,253,106,8,242,248,18,5,156,249,252,3,229,250,89,12,212,9,32,251,233,249,22,10,143,245,178,245,219,11,46,5,118,5,107,242,65,1,238,245,211,247,40,253,167,5,225,11,250,249,25,3,142,2,118,7,66,12,1,4,67,4,172,245,158,4,153,7,17,250,61,242,58,9,125,248,199,1,70,247,3,249,201,243,177,12,14,13,54,251,151,253,220,243,5,252,0,254,45,1,138,245,254,246,249,4,69,254,203,5,31,242,225,242,109,0,182,247,147,250,175,10,123,5,217,244,135,5,151,10,27,251,204,7,100,243,18,13,47,3,206,1,198,7,48,250,190,11,6,250,77,2,238,242,87,243,198,249,156,13,187,5,169,255,46,247,68,11,159,11,136,4,208,7,118,253,195,13,205,246,100,254,118,8,205,252,193,249,47,245,61,248,145,244,206,2,5,11,251,243,44,0,31,245,239,8,57,247,223,5,229,1,186,13,80,2,22,12,27,252,6,10,151,8,155,250,219,250,83,3,66,247,33,254,37,242,205,248,145,12,128,253,227,244,248,8,47,253,206,11,197,246,132,255,106,11,105,253,218,4,92,12,214,246,111,1,25,251,151,251,233,243,87,5,187,243,30,9,188,5,245,252,55,7,29,10,229,254,20,244,104,6,67,2,129,245,6,251,206,250,4,1,156,3,155,10,22,6,152,254,73,249,225,12,102,12,244,249,166,1,136,8,201,253,249,245,191,7,174,243,147,251,237,5,204,250,43,11,60,6,35,254,89,253,192,250,122,250,69,248,88,0,11,255,15,3,201,3,76,242,238,254,166,252,126,251,93,246,119,11,225,253,195,7,159,249,112,245,220,10,122,252,214,244,69,8,153,0,169,13,231,2,149,4,247,4,128,243,29,248,22,246,182,243,135,9,227,2,192,244,121,8,131,245,251,12,26,246,72,6,165,251,9,7,113,1,91,9,218,251,82,250,100,8,219,251,217,13,108,243,115,245,88,0,60,8,177,2,22,4,87,251,54,243,237,250,32,3,244,251,122,11,44,247,148,10,183,12,48,254,17,252,255,11,42,246,121,246,86,9,21,6,205,245,185,243,76,1,251,248,17,249,254,5,54,245,210,245,168,247,6,255,155,253,67,242,238,255,38,12,110,4,193,248,142,251,61,248,188,3,14,254,180,1,239,254,21,243,14,8,117,5,2,13,131,4,125,8,59,0,249,1,5,248,75,10,73,253,35,2,213,12,0,247,100,251,33,246,254,243,239,248,84,4,68,5,169,7,13,253,17,246,182,9,70,252,171,2,90,248,172,243,235,4,61,242,197,254,40,244,107,246,158,5,109,255,248,1,46,250,169,251,87,253,167,247,100,5,183,243,109,12,123,246,234,0,87,250,79,255,239,2,99,251,255,250,69,11,0,251,89,247,215,2,201,253,251,252,206,12,87,12,105,12,253,6,173,11,163,2,162,243,91,246,42,8,40,2,145,11,178,10,233,3,15,247,8,9,164,254,65,5,27,9,43,247,48,3,85,3,88,10,115,10,220,242,236,245,250,247,69,253,159,10,231,250,226,4,147,251,64,2,92,5,66,248,35,8,91,3,198,242,104,2,18,243,210,250,108,251,209,251,207,13,109,13,180,11,178,2,210,8,76,242,76,3,149,246,151,244,138,1,168,250,199,11,141,242,111,10,59,251,126,4,245,2,84,255,91,243,59,244,103,3,62,11,151,10,221,247,46,9,166,2,226,10,246,10,10,244,39,10,33,253,48,250,156,11,59,253,158,253,17,246,62,253,27,1,109,12,19,10,89,243,92,4,155,243,185,250,140,254,50,9,114,7,136,10,180,1,154,0,48,253,56,11,220,242,132,5,30,3,134,0,34,255,142,4,110,244,134,12,187,245,160,255,158,244,1,8,249,252,48,4,61,255,10,248,246,243,41,253,35,253,220,7,67,254,162,243,33,3,126,253,24,4,26,10,76,9,65,7,236,9,108,8,183,1,147,253,161,3,64,245,197,10,87,255,244,3,247,252,57,0,46,4,249,255,198,245,61,253,3,245,207,7,20,244,95,248,225,5,207,9,170,252,127,246,199,246,13,9,65,249,2,245,18,0,79,255,23,7,175,250,180,0,241,243,146,2,93,10,211,1,89,243,77,13,129,10,159,255,132,7,128,6,51,251,118,243,71,254,155,2,159,246,13,242,136,3,165,0,229,251,109,2,8,7,112,5,169,242,81,13,225,245,95,9,219,5,88,2,228,253,194,254,96,246,250,3,152,4,248,5,178,243,240,250,54,8,64,254,88,253,126,9,27,251,169,248,212,250,39,12,252,6,201,251,18,8,83,9,55,13,111,3,207,13,214,10,130,11,153,246,14,252,36,4,239,250,91,253,237,6,218,2,101,6,223,0,64,252,140,248,36,243,128,13,24,9,148,255,191,243,42,0,75,253,193,251,15,4,251,9,200,253,48,9,206,0,231,242,252,245,67,4,22,10,201,253,66,251,19,8,130,254,56,9,138,243,243,243,219,244,186,6,53,244,195,7,118,249,205,247,71,248,21,7,34,6,17,10,153,1,189,10,244,247,36,255,7,8,205,251,193,1,152,251,15,0,33,8,125,242,253,249,85,248,32,8,243,250,248,244,168,254,220,252,74,10,153,251,215,6,218,7,75,13,160,12,43,249,185,255,197,249,20,9,71,243,25,251,25,254,144,4,154,249,155,245,171,254,91,244,111,9,135,246,220,243,178,242,237,4,41,2,75,246,2,253,122,250,140,253,60,248,75,11,186,253,17,5,197,4,194,4,196,244,248,246,91,4,16,242,45,6,247,248,15,4,98,255,1,6,69,253,90,246,71,243,60,10,124,2,114,255,105,247,244,253,123,12,216,0,114,9,228,247,248,253,73,244,3,0,71,8,205,249,124,247,47,11,125,10,155,12,176,243,4,7,27,6,134,11,59,251,236,6,54,2,178,246,199,245,229,245,144,0,68,247,16,12,218,254,114,246,170,246,231,251,220,248,14,243,241,253,175,4,78,242,45,3,0,251,239,9,152,251,214,254,178,249,142,243,125,252,133,0,5,3,188,13,214,254,99,251,88,255,46,10,217,4,122,1,51,247,176,243,178,11,237,12,108,10,174,254,23,252,199,2,28,245,191,4,236,2,154,7,254,255,202,242,10,1,61,13,250,246,135,243,151,9,88,9,103,12,84,3,251,12,52,10,250,255,169,255,81,2,35,243,29,245,231,0,135,246,234,252,85,9,225,250,249,253,81,13,92,11,62,13,213,6,81,254,121,11,120,252,127,247,48,251,224,245,243,245,174,6,120,253,178,10,207,3,130,246,66,7,209,13,23,7,178,247,173,9,114,5,40,6,123,254,11,252,12,242,0,243,189,9,120,8,235,3,183,253,32,3,54,251,228,242,159,247,240,245,44,12,147,13,151,8,122,1,135,247,97,244,70,255,135,4,19,7,137,251,41,0,151,251,96,2,42,5},
  {208,4,42,7,147,243,160,11,238,11,136,4,74,5,254,3,194,9,176,242,223,253,245,254,40,9,87,247,214,252,151,248,28,4,145,9,250,249,245,3,72,10,213,8,140,9,43,8,109,11,56,6,153,249,140,11,152,247,18,250,35,254,235,245,83,13,27,9,93,246,113,251,68,244,26,5,249,12,90,4,1,3,242,251,71,6,148,0,79,242,133,251,71,244,152,245,106,247,243,254,168,10,218,255,254,252,197,11,138,248,250,11,167,10,41,10,8,12,98,0,192,13,9,249,95,242,134,245,145,12,62,242,186,246,13,242,82,247,208,5,188,11,177,10,173,3,75,10,107,252,105,249,221,243,103,249,176,1,193,250,33,1,37,246,173,245,37,250,233,6,188,8,62,3,64,8,75,11,139,245,33,8,92,0,193,8,106,254,235,245,97,247,135,12,187,254,130,254,13,2,204,11,102,0,92,0,103,255,124,253,138,3,118,7,116,245,216,9,15,1,248,3,232,6,88,0,108,252,186,253,55,255,201,9,252,249,100,10,10,0,242,10,187,244,226,6,142,254,219,254,13,242,150,1,166,253,62,0,101,4,161,245,58,248,2,3,240,5,181,13,44,254,111,12,213,253,23,3,13,249,218,8,139,255,74,7,235,8,16,250,143,247,58,8,174,13,7,13,144,255,12,3,195,242,19,247,169,252,33,253,124,250,4,249,173,5,178,8,195,253,60,2,165,243,146,242,205,245,68,252,233,0,189,1,111,10,125,242,61,2,105,255,165,247,109,12,204,249,33,12,175,251,149,7,149,6,30,5,189,242,239,248,60,8,175,0,228,13,231,244,2,246,187,255,131,252,157,243,121,6,146,12,174,9,44,6,37,0,51,13,100,250,209,252,128,244,238,13,232,248,142,251,96,246,129,10,236,248,227,0,64,4,188,254,53,2,252,5,55,7,107,7,221,243,104,2,183,11,26,245,63,2,230,250,54,6,238,4,220,248,98,4,242,0,192,249,109,11,107,255,191,253,4,1,107,245,8,5,28,244,19,0,182,242,217,4,190,254,177,250,86,4,77,3,186,9,186,245,234,6,29,255,2,13,31,253,126,3,130,3,25,0,18,12,255,12,184,245,175,251,43,11,36,251,210,6,178,11,217,251,105,7,60,242,191,253,42,250,253,9,139,247,163,12,20,0,132,244,145,246,151,253,124,8,89,242,125,254,79,249,85,11,243,11,235,12,121,13,94,6,81,9,181,4,30,253,255,1,6,3,241,6,107,249,103,2,40,1,41,253,105,249,184,4,131,246,106,11,254,10,129,3,96,6,98,1,190,245,254,247,136,243,35,253,46,254,20,245,90,245,214,7,167,247,6,0,105,13,221,11,189,255,162,255,253,7,153,251,125,247,190,4,183,242,75,252,3,242,232,12,100,1,7,0,224,254,216,12,89,246,229,255,157,10,147,254,148,5,142,249,115,0,181,3,152,254,207,1,215,247,244,2,59,3,105,247,168,13,245,0,255,254,73,9,115,251,216,255,216,254,38,11,205,11,34,0,60,1,76,251,222,3,92,13,73,248,222,242,221,7,159,9,118,1,75,2,98,251,110,251,106,8,19,242,107,242,132,254,34,7,32,12,220,8,40,247,107,2,130,9,176,255,232,1,95,9,106,243,15,7,106,4,185,243,67,250,7,10,190,250,121,255,217,254,134,7,201,8,101,4,169,5,142,246,206,249,76,12,157,0,212,7,18,9,230,254,136,255,207,242,154,5,141,11,43,1,179,242,187,10,129,11,197,253,3,248,9,250,205,12,86,254,51,251,45,13,27,243,192,12,224,247,254,0,150,6,59,249,8,4,139,2,184,1,226,13,114,245,124,13,252,4,117,5,143,12,165,11,0,255,144,253,174,3,200,254,48,2,72,12,214,248,122,1,3,250,6,2,130,10,192,9,236,4,215,9,139,2,37,12,182,252,55,251,241,245,85,242,139,2,136,9,70,9,119,255,144,246,46,6,4,10,154,248,7,9,21,0,111,246,77,11,156,254,74,253,16,2,23,12,155,2,154,253,201,0,85,245,46,0,188,248,207,10,8,8,218,8,12,7,164,252,37,9,135,244,5,4,56,248,84,2,185,11,143,6,47,4,234,253,109,252,63,251,155,2,212,13,13,2,222,253,240,255,57,251,241,11,192,11,166,251,90,252,109,9,102,250,94,245,247,4,240,0,24,3,177,3,172,12,84,251,184,12,180,248,45,2,13,243,251,13,160,3,1,251,87,248,195,3,81,9,161,1,61,248,150,13,50,244,118,9,146,243,52,3,0,14,235,243,17,242,211,6,83,246,63,243,141,245,55,4,90,0,73,245,143,11,89,245,24,1,30,248,193,251,133,0,231,4,50,10,45,252,157,12,255,4,34,253,62,13,180,4,29,249,216,254,69,245,76,5,50,10,148,245,99,246,135,251,226,10,102,4,255,4,162,254,65,251,94,5,135,251,105,250,91,250,106,11,137,248,62,251,32,251,252,7,13,252,233,13,183,11,192,12,251,2,37,10,90,250,113,244,208,2,5,248,30,254,42,1,183,6,173,7,182,6,234,12,161,8,135,247,11,5,51,6,18,0,122,11,127,10,75,242,249,6,43,2,103,242,198,12,133,1,215,12,178,248,107,255,197,0,89,255,227,11,116,11,55,10,50,253,46,4,62,255,208,13,108,9,161,250,60,249,176,246,108,4,113,10,129,12,206,10,137,0,86,7,146,3,73,5,219,0,220,243,199,2,3,249,105,6,208,245,53,13,92,7,164,252,47,255,0,242,101,252,177,6,90,13,78,252,114,4,138,1,1,2,155,246,34,249,171,2,21,3,124,11,75,245,239,9,80,247,31,244,89,254,1,250,202,243,10,7,253,12,107,3,135,1,140,10,14,13,238,10,94,8,250,247,93,242,50,0,17,11,20,255,124,246,89,10,181,255,81,252,19,244,68,6,161,246,186,3,201,12,140,245,71,4,101,9,244,249,41,252,183,247,176,255,184,247,151,5,38,243,210,11,125,254,119,242,193,254,253,0,26,11,87,9,32,10,166,1,118,4,224,11,146,1,6,247,167,250,174,0,33,255,84,10,108,249,82,4,193,8,158,5,217,250,240,3,169,12,150,249,99,3,12,247,215,9,19,254,224,251,78,10,113,9,35,247,108,249,152,8,92,244,113,8,15,0,146,252,146,9,85,4,79,3,23,253,238,10,93,247,80,245,95,243,168,253,149,7,6,242,207,255,171,10,82,254,237,243,156,4,60,5,20,245,174,249,16,251,143,3,151,11,98,13,100,2,153,0,33,5,123,6,127,10,73,6,10,2,212,244,82,11,205,255,153,242,188,13,93,2,224,248,85,244,122,242,25,245,192,5,195,251,254,242,7,8,118,251,203,1,125,243,87,249,46,2,212,12,51,255,130,249,17,243,153,242,81,3,104,250,84,1,128,0,103,255,131,0,252,13,100,5,253,254,230,8,38,6,208,8,121,245,228,254,16,254,165,246,193,242,232,244,117,7,112,7,87,254,177,8,38,251,80,246,72,244,242,2,134,242,31,4,95,11,68,8,93,253,24,242,96,4,38,253,21,6,137,6,65,11,124,4,22,247,183,7,25,244,41,251,128,245,110,248,84,248,233,13,218,243,66,9,146,2,251,11,190,1,5,247,223,255,175,2,190,248,177,13,198,245,61,242,29,243,234,7,227,1,78,242,38,245,151,248,90,255,57,245,72,6,216,5,110,251,44,245,97,8,22,5,103,5,130,253,93,0,233,243,27,13,157,13,164,253,116,2,246,254,245,255,133,1,237,255,255,12,83,252,170,2,197,7,228,254,216,4,197,247,176,5,133,247,235,0,151,0,67,249,165,242,98,5,18,4,200,5,78,6,153,246,15,12,240,10,163,244,226,253,85,8,179,243,226,10,209,7,242,247,114,4,200,255,195,5,173,254,192,9,153,254,177,243,119,242,130,13,23,244,51,248,217,11,39,7,142,247,165,8,99,8,133,5,254,242,182,8,48,253,43,13,53,251,76,246,145,8,22,7,207,0,226,2,65,4,197,9,85,13,35,4,205,242,161,1,57,242,35,247,181,253,158,247,159,243,18,12,149,251,32,10,69,13,24,0,118,3,0,9,37,10,249,246,3,244,163,250,39,2,38,7,5,245,102,4,80,254,57,1,185,5,183,251,117,3,203,7,119,245,31,244,182,2,161,254,177,245,6,7,208,11,157,248,208,248,8,2,74,243,58,244,126,2,13,9,75,13,150,9,68,7,213,13,192,244,233,11,197,5,92,6,11,6,212,7,92,244,114,243,113,250,216,12,109,248,224,8,249,251,126,249,164,242,158,12,71,7,153,5,164,10,90,1,169,249,68,254,228,254,193,5,248,9,100,245,51,1,228,5,92,8,56,4,192,13,53,9,7,9,57,242,144,251,20,242,177,242,61,242,92,246,94,249,61,255,170,255,114,247,215,2,92,13,196,247,248,9,206,255,182,249,254,255,171,248,233,13,14,12,143,10,218,243,51,8,167,6,202,254},
} ;

static const unsigned char precomputed_core_multsntrup1013_n[precomputed_core_multsntrup1013_NUM][crypto_core_INPUTBYTES] = {
  {194,119,188,234,1,93,198,243,83,169,5,241,253,123,222,240,89,6,115,195,241,88,132,151,207,39,133,65,120,63,158,62,109,102,152,59,224,76,132,42,197,96,149,190,163,112,7,206,26,4,115,243,215,169,158,101,77,145,172,148,164,38,134,184,223,21,9,115,92,149,83,139,69,209,190,224,16,51,45,173,236,164,242,54,241,105,8,41,118,103,202,18,65,212,179,172,189,224,74,235,131,118,239,213,246,234,247,54,136,26,236,202,136,236,237,29,161,72,74,130,36,29,55,48,214,97,162,33,229,232,31,175,56,235,151,2,218,122,125,92,226,223,23,104,141,17,43,0,216,208,58,62,228,239,124,62,220,36,248,172,19,49,214,243,128,65,60,162,227,240,12,170,145,143,125,127,6,155,90,70,85,143,176,187,223,99,138,229,104,243,232,110,152,49,44,62,163,16,136,217,6,209,36,220,224,203,51,228,64,255,225,53,9,35,236,175,26,236,223,56,173,255,153,232,170,35,210,123,199,116,201,183,148,224,53,110,111,203,175,230,250,3,112,240,22,206,107,15,210,59,58,125,78,247,83,60,106,152,165,102,77,185,240,184,140,131,220,66,63,108,219,190,42,13,63,57,86,203,38,104,218,197,10,217,76,5,53,234,101,178,10,88,94,57,101,233,220,83,252,16,191,12,144,31,18,92,175,239,84,193,33,220,113,102,217,192,48,190,143,208,215,31,13,238,192,26,10,227,29,106,189,65,116,47,127,247,5,73,95,203,27,148,17,41,204,94,122,49,106,53,158,1,50,174,242,86,164,4,28,58,168,111,139,97,44,122,89,157,248,80,99,47,65,38,119,189,211,33,189,166,107,190,107,44,57,167,49,40,185,153,157,239,196,181,213,178,208,240,93,81,87,31,58,217,107,0,146,37,251,118,139,175,119,243,156,112,47,246,73,238,45,25,245,227,203,138,172,193,9,119,113,250,61,238,98,88,101,135,9,135,182,15,131,26,73,97,46,87,174,104,115,190,212,115,236,255,132,144,133,159,197,190,174,156,180,12,6,103,112,187,134,38,176,70,89,50,31,174,220,222,182,180,74,23,170,10,57,31,122,130,110,9,131,108,133,227,105,133,159,46,54,120,0,73,208,250,228,92,83,186,233,199,222,208,143,65,243,159,176,3,78,60,104,6,196,105,243,144,139,255,36,36,206,177,128,98,3,112,209,167,254,215,78,217,27,126,47,153,183,47,136,148,218,210,101,53,3,228,42,119,231,93,199,59,1,203,175,53,225,71,10,184,41,200,123,18,87,83,208,102,241,206,71,169,10,61,64,134,52,79,71,54,67,140,183,250,164,132,38,87,29,179,185,211,107,223,183,129,5,225,49,28,165,199,231,125,243,99,46,231,74,24,73,137,1,56,65,28,201,203,58,209,255,133,56,202,152,77,29,87,83,184,110,32,29,142,232,146,210,168,78,120,126,129,12,112,168,129,14,47,15,80,121,175,245,196,240,246,19,18,190,130,85,231,24,19,94,45,73,201,143,139,139,90,24,159,185,60,86,222,74,86,179,100,7,184,91,245,160,185,179,196,249,83,176,214,36,20,121,165,135,76,251,98,173,30,168,105,188,129,164,247,89,147,213,52,242,38,205,224,158,41,96,184,80,141,8,53,235,105,210,129,227,54,135,212,64,57,0,137,6,202,13,141,136,167,175,252,152,65,201,84,192,254,225,227,197,72,100,9,165,69,164,153,4,33,132,83,130,1,46,163,212,180,240,202,81,3,127,98,96,190,26,230,133,42,69,225,232,94,68,241,60,115,0,190,72,142,174,87,155,196,33,70,119,217,108,193,181,165,48,229,27,154,9,46,55,132,46,21,64,22,15,5,237,227,174,194,173,35,133,61,223,20,108,144,66,72,32,159,175,175,155,244,177,219,141,135,46,175,216,51,251,196,254,168,93,54,49,255,61,210,165,213,145,26,239,240,168,166,208,31,18,100,19,133,85,128,51,29,248,239,57,12,62,238,208,86,33,129,8,109,169,181,169,209,56,32,33,85,132,180,207,72,63,72,197,61,191,22,76,254,99,78,49,51,128,16,104,4,173,33,159,11,198,207,114,108,116,213,132,72,178,22,252,121,149,15,48,120,25,145,237,106,194,85,174,9,229,250,43,67,221,97,136,86,196,135,93,202,200,40,211,169,180,10,128,182,176,148,240,27,234,106,116,221,122,255,217,118,92,79,31,239,13,6,123,57,128,41,48,70,31,162,252,53,57,133,114,138,79,128,71,132,218,129,63,6,195,127,49,196,120,102,62,27,213,154,42,213,90,73,100,171,130,228,195,137,134,94,111,114,41,76,110,62,75,44,49,100,142,23,134,2,227,213,33,188,34,101,44,107,180,43,207,75,93,193,215,133,218,1,227,211,25,78,28,71,80,255,137,64,21,59,231,55,206,141,165,149,162,95,1,151,44,172,10,3,164,133,206,166,255,0,77,148,69,46,214,142,138,67,243,137,225,19,209,209,78,58,169,124,18,222,185,93,215,25,20,249,108,37,95,185,210,136,28,254,107,69,51,249,38,168,83,58,118,178,30,64,83,45,197,215,234,52,77,105,173,165,222,107,41,170,211,242,236,194,42,4,36,224,221,62,82,55,151,150,133,74,197,11,38,64,168,250,119,246,246,150,238,119,159,132,48,114,5,137,85,0,212,251,124,178,99,172,180,68,36,149,240,66,190,169,231,163,135,82,72,251,81,237,122,81,226,212,5,235,248,170,235,132,218,77,192,195,33,215,65,255,107,143,198,12,212,26,18,254,255,44,50,117,229,170,157,250,171,190,174,60,190,172,3,41,86,27,248,227,229,1,214,239,231,22,245,123,61,138,120,233,61,249,100,147,55,132,180,220,39,86,154,56,137,135,56,142,43,156,201,215,192,119,154,45,236,164,194,157,178,203,86,109,117,213,140,228,206,4,169,151,118,69,165,25,47,123,77,187,118,225,157,196,243,144,17,240,131,23,161,13,84,217,121,52,127,22,180,209,53,28,174,191,86,85,14,140,177,197,197,199,223,38,89,92,250,58,53,16,97,198,175,88,137,100,59,246,163,154,208,103,50,195,98,117,162,193,203,184,105,109,160,42,122,206,85,153,61,80,72,30,132,214,194,214,156,171,136,65,49,202,101,205,164,25,139,245,204,122,205,17,45,13,198,58,217,148,201,20,90,29,71,95,255,61,90,101,169,127,10,101,189,117,38,11,211,68,102,101,69,130,231,107,19,166,179,4,92,245,135,67,62,135,71,21,188,50,223,135,233,228,94,196,49,185,74,23,247,235,130,67,138,9,111,32,84,247,17,177,195,140,96,148,174,72,185,158,16,252,172,217,80,181,17,47,68,189,30,67,200,71,211,30,205,24,118,230,147,64,109,160,119,183,118,217,63,157,158,52,61,58,248,121,140,88,111,23,38,193,212,241,228,89,166,255,89,13,142,15,41,182,75,169,137,190,79,240,166,244,112,212,129,245,255,17,152,9,196,255,255,107,237,40,82,211,185,157,107,35,52,64,29,21,213,121,143,139,27,196,84,131,132,184,158,6,246,95,12,127,232,145,74,164,22,151,81,177,184,235,99,148,177,31,45,113,255,14,105,18,219,169,231,173,3,26,235,165,4,248,157,215,59,208,224,102,6,144,220,176,54,173,51,220,74,29,120,244,56,64,63,241,98,37,54,168,152,42,4,175,142,209,197,138,171,149,184,39,197,90,119,116,149,254,209,155,170,89,47,161,25,122,55,253,160,220,79,0,226,51,153,158,162,119,37,86,114,133,23,190,151,237,39,207,35,218,28,44,38,222,185,230,122,30,118,173,163,179,33,69,248,189,53,8,105,99,100,124,41,4,22,27,227,176,141,95,181,67,118,208,18,116,250,193,204,126,54,80,243,114,189,15,253,134,80,52,143,211,200,172,230,96,241,54,68,216,201,213,184,232,49,42,20,195,246,135,232,149,208,249,182,18,154,220,197,50,116,123,164,156,142,134,215,26,101,7,18,62,86,169,124,54,174,59,150,243,251,223,221,101,186,107,119,207,178,25,65,14,37,252,28,179,62,147,139,234,150,234,2,130,171,188,207,189,136,176,240,86,231,69,211,139,27,18,224,103,212,89,191,141,5,242,60,21,5,34,142,100,63,12,206,135,66,44,116,255,175,32,151,248,138,209,197,188,206,92,205,138,195,205,87,24,57,188,183,22,87,32,142,13,36,193,10,168,236,244,99,134,224,250,200,59,178,133,84,191,109,205,212,104,166,216,32,207,62,127,78,241,220,233,186,3,179,85,77,140,119,235,248,50,118,242,235,15,110,243,168,49,154,122,157,18,173,84,229,151,145,184,140,143,122,32,111,103,12,11,56,99,28,101,236,223,72,82,63,57,165,240,228,73,131,124,36,233,128,99,77,255,188,214,51,197,139,146,51,221,228,195,50,42,41,157,242,1,17,70,102,219,92,70,236,198,108,136,141,201,39,222,97,143,160,59,231,40,115,90,47,100,226,172,210,173,67,163,235,43,43,193},
  {203,246,185,77,144,116,67,60,122,229,155,254,199,161,115,27,220,205,145,148,123,112,236,23,179,13,150,153,202,161,60,176,91,251,95,112,84,83,122,1,99,121,93,225,130,218,2,167,116,200,56,249,238,46,139,172,4,223,193,6,206,84,241,81,212,221,20,239,224,193,87,157,219,6,71,214,72,237,247,147,162,39,38,163,62,134,225,206,116,175,222,224,250,168,31,160,185,224,179,139,208,184,149,200,227,14,249,172,48,75,25,107,205,51,253,145,97,209,3,61,9,120,152,249,86,30,252,5,98,85,80,68,132,248,251,33,251,143,173,102,198,236,194,185,181,130,197,253,12,97,222,134,177,200,58,192,76,112,174,205,3,126,232,51,1,224,121,52,5,117,82,108,62,143,201,53,79,202,104,53,26,104,48,201,194,232,197,114,61,169,212,142,183,203,43,39,151,185,32,39,96,193,58,93,83,128,187,69,185,52,68,160,140,232,136,79,227,250,170,235,87,192,21,224,230,159,237,7,234,175,64,28,172,206,126,158,180,31,137,22,232,221,204,93,24,135,106,139,108,187,29,92,234,105,250,241,123,15,242,37,212,50,186,136,192,240,9,62,154,133,90,58,223,143,5,0,158,179,39,62,230,96,196,164,99,12,88,153,183,179,173,73,87,24,156,80,238,17,7,95,243,17,65,0,206,25,161,95,165,98,137,195,201,117,186,223,207,132,121,27,207,29,169,250,30,173,159,163,103,232,105,39,200,250,172,200,154,116,76,131,69,163,86,47,74,42,209,26,68,224,146,8,169,65,53,135,156,208,249,133,232,84,88,58,12,17,68,42,171,51,83,161,72,133,69,191,77,50,192,36,132,253,170,209,69,230,8,156,0,183,51,129,235,254,134,95,34,241,129,197,16,164,67,20,167,211,215,149,138,237,51,230,202,78,65,88,71,230,41,85,19,86,207,73,195,82,198,202,49,7,105,25,7,43,36,167,242,89,183,141,111,224,91,81,170,4,120,117,239,207,121,4,164,169,238,128,192,96,176,103,29,190,90,149,20,172,131,244,207,58,15,171,32,18,134,246,103,118,12,161,226,169,80,64,36,144,169,135,133,91,253,126,45,188,201,190,28,32,254,42,98,225,55,62,239,140,87,8,127,107,169,135,45,77,107,197,88,97,108,227,133,192,155,10,104,4,89,41,89,20,113,143,86,184,239,173,29,39,71,161,136,236,238,212,89,249,151,80,195,189,168,149,222,203,196,104,98,108,239,193,255,20,211,107,215,235,80,65,141,116,210,134,32,164,47,248,16,112,216,10,149,74,177,105,112,19,230,144,10,96,172,159,124,194,189,201,29,248,125,255,221,32,63,59,205,45,99,127,244,118,225,142,150,122,115,188,43,142,4,106,242,235,209,85,103,14,179,250,133,191,50,68,55,101,158,105,97,180,109,74,124,76,97,34,219,37,222,182,5,214,3,30,68,52,35,194,22,27,58,58,238,187,180,27,182,21,219,110,237,177,50,179,184,248,98,67,224,179,112,9,146,225,248,191,253,199,30,155,146,153,134,95,40,183,124,15,49,146,124,238,234,13,23,130,19,181,52,161,27,144,225,208,229,221,204,171,153,106,64,202,182,25,97,236,96,214,29,91,170,237,204,66,156,252,115,10,119,152,8,61,49,220,207,73,81,122,175,67,24,78,176,51,241,65,189,187,105,175,36,245,238,69,63,124,62,86,227,128,224,231,235,161,64,191,104,189,91,109,29,185,93,160,122,13,227,15,245,167,116,158,22,43,52,238,156,95,37,149,255,164,116,204,165,243,47,193,27,11,85,102,9,98,44,137,229,16,202,86,90,141,255,118,2,171,244,195,211,139,121,217,51,140,131,45,53,214,135,197,225,33,145,117,114,114,85,79,89,39,100,253,24,209,80,112,124,31,182,199,171,126,89,237,24,118,108,82,10,126,36,197,63,143,64,35,47,22,206,110,163,22,117,77,196,40,169,31,89,41,29,31,108,244,249,113,105,219,60,59,119,220,57,129,145,241,52,103,160,205,253,69,14,142,93,50,61,70,195,97,251,253,108,18,27,50,231,160,201,145,232,27,178,88,27,221,113,194,173,10,188,232,102,140,138,118,66,60,47,60,228,81,190,181,172,166,56,250,58,119,0,155,239,23,92,111,132,99,162,7,48,228,170,36,153,104,61,200,30,38,156,19,174,237,226,43,133,157,33,170,174,65,0,202,96,94,148,52,91,100,19,103,187,5,158,135,8,163,224,118,101,72,19,246,222,67,228,176,218,12,58,229,49,161,172,201,22,162,171,80,17,129,89,25,46,149,70,56,193,228,45,141,122,154,25,101,202,27,87,148,68,99,74,114,127,155,173,157,150,126,231,137,206,186,250,38,212,183,87,48,136,175,78,76,42,100,18,244,75,74,184,145,214,142,172,79,90,95,181,251,157,5,238,82,22,207,125,82,174,7,28,225,85,67,186,223,54,98,11,104,61,187,31,22,192,229,159,203,52,219,158,248,88,128,71,205,176,1,139,99,78,169,28,28,0,28,195,174,248,251,236,56,253,215,215,54,19,50,114,188,83,88,215,216,178,200,88,24,142,221,8,2,151,125,69,38,102,72,148,152,238,74,118,5,170,128,57,73,172,41,252,248,101,215,255,28,158,200,160,84,153,54,18,54,232,87,161,169,252,95,102,177,27,81,252,156,164,145,149,211,190,168,171,49,99,96,31,235,164,217,28,193,22,194,74,171,38,188,201,155,127,36,27,84,54,68,42,207,159,245,86,51,64,154,253,38,240,15,209,248,143,69,136,20,214,120,20,153,41,144,117,183,17,179,244,30,76,52,58,76,147,55,222,227,197,104,165,93,147,106,157,175,130,1,203,185,217,163,204,39,237,167,22,168,46,235,6,15,253,202,78,45,225,50,103,181,244,226,242,245,226,150,0,125,218,227,138,202,236,225,91,107,114,44,140,167,31,197,2,214,234,133,236,229,136,82,46,245,176,49,29,5,55,42,73,87,4,39,72,84,183,228,38,116,157,138,210,173,208,49,23,19,63,38,70,219,163,15,251,106,69,68,147,197,75,23,108,145,27,159,71,171,78,45,72,48,183,0,30,37,65,26,72,119,236,187,159,213,66,155,27,120,168,90,126,248,92,212,60,134,171,143,16,151,6,88,99,8,14,214,209,145,173,192,192,182,133,154,247,212,29,174,243,249,89,100,204,218,100,38,160,91,207,89,244,222,224,168,158,145,220,229,44,170,72,204,93,103,176,124,104,133,83,44,171,91,138,207,98,138,59,196,108,174,153,146,82,25,148,152,49,43,39,7,10,201,181,27,234,129,154,46,194,153,22,137,231,121,211,194,17,111,109,90,74,187,168,48,93,168,44,10,249,201,5,70,225,191,184,213,10,192,157,128,76,42,99,164,60,224,206,156,72,148,64,148,162,73,92,61,119,87,183,23,9,46,192,221,219,43,125,181,206,177,110,11,210,75,122,58,47,30,101,20,212,242,20,122,36,199,11,139,26,107,139,174,160,110,117,74,103,94,211,162,32,89,183,227,222,128,204,187,130,180,71,55,57,132,68,69,241,60,160,253,7,230,157,2,20,185,175,29,40,168,111,228,244,90,43,39,237,205,9,54,49,186,138,245,148,250,130,6,90,162,30,198,138,178,24,202,49,0,51,5,154,167,252,85,243,139,23,35,191,169,98,40,60,195,33,92,127,200,32,64,19,153,239,9,253,148,145,192,24,97,228,158,225,173,21,44,8,47,131,217,193,194,1,247,95,8,225,105,49,83,172,199,169,92,207,174,207,75,172,42,169,8,46,114,194,173,7,125,58,141,65,186,45,11,247,71,102,183,126,226,130,142,56,140,18,246,249,1,104,11,50,3,65,118,233,94,100,251,3,119,224,85,141,77,97,43,55,133,161,172,27,7,76,141,252,4,98,139,150,125,34,107,25,241,119,158,0,204,156,140,112,254,236,238,241,182,94,228,88,245,125,56,70,54,9,223,234,246,3,194,80,111,104,67,42,116,136,152,150,8,200,142,44,243,87,25,123,11,50,39,49,28,89,103,133,56,1,95,18,99,5,168,68,229,213,245,187,214,37,63,40,123,134,6,111,173,252,72,252,81,230,213,108,67,77,27,135,106,63,60,164,112,31,52,107,48,87,177,217,181,114,111,65,65,97,6,223,179,72,254,23,224,220,237,22,2,36,139,235,64,61,83,215,162,188,200,243,108,30,19,12,74,150,141,227,109,68,212,13,104,218,114,180,106,225,36,204,190,72,206,28,248,243,170,175,222,110,151,27,32,197,30,154,136,116,30,141,223,243,204,220,23,133,120,131,8,188,187,126,141,32,227,62,62,203,105,148,55,29,248,152,210,65,167,139,242,200,17,27,62,241,68,95,237,93,199,5,55,234,78,87,119,40,19,127,201,173,165,238,24,134,197,30,215,255,94,80,7,132,133,188,229,96,87,166,108,43,123,198,16,158,33,92,46,23,69,204,176,99,22,171,7,231,159,194,66,31,135,249,235,66,141,245,53},
  {48,253,66,185,192,135,121,134,113,159,227,142,115,149,49,191,13,159,247,61,45,192,242,5,174,180,73,87,17,231,2,16,245,160,213,203,12,78,76,32,126,113,247,105,165,225,158,160,136,105,228,91,208,35,204,16,42,101,244,54,147,37,157,136,93,46,178,152,151,37,52,227,247,121,95,11,93,254,97,176,195,98,46,243,237,61,163,83,233,51,207,98,138,16,186,167,208,253,15,186,171,50,78,47,232,129,255,143,235,245,151,105,65,222,0,157,110,204,58,221,149,18,25,146,197,196,77,67,8,3,226,234,37,178,242,4,138,253,50,50,59,252,144,10,92,176,64,77,65,149,57,40,246,185,156,174,203,79,11,1,127,129,45,91,210,188,92,10,73,109,235,76,230,77,224,93,222,15,35,98,219,91,205,192,31,45,208,57,242,178,70,41,129,192,82,242,248,202,107,220,25,149,196,87,128,70,193,141,227,39,163,139,228,147,165,153,232,97,143,218,37,237,46,112,132,33,88,95,206,119,235,90,59,229,71,222,234,178,241,154,1,85,118,219,110,114,133,201,157,137,71,18,169,91,56,32,12,219,219,150,166,163,153,184,178,96,179,231,27,211,179,237,118,121,50,232,113,122,134,115,115,229,105,84,116,89,140,20,121,83,12,31,208,36,30,78,213,58,86,216,97,185,240,86,255,78,131,87,21,149,231,131,158,128,41,83,177,244,206,216,250,89,106,39,85,177,191,218,170,123,66,236,149,137,130,82,102,114,228,222,129,49,32,107,65,122,40,193,36,171,39,101,14,136,63,57,125,101,206,26,223,32,16,155,17,153,5,241,94,7,189,203,241,90,140,235,23,191,235,91,166,160,176,166,18,216,116,246,32,116,60,170,249,109,116,32,48,233,70,168,161,113,3,83,75,40,232,151,129,254,59,228,39,26,158,35,89,168,87,25,173,19,168,13,235,48,133,230,86,132,79,28,234,100,142,55,46,159,124,253,191,61,90,120,54,222,71,4,204,118,95,48,252,143,79,24,147,74,111,107,88,57,114,182,108,242,198,133,229,152,159,137,3,200,86,111,203,181,57,225,9,93,70,26,228,134,173,206,107,43,107,46,158,205,194,219,145,221,118,193,108,165,115,115,34,174,193,76,1,90,103,96,66,186,219,57,169,85,120,160,138,40,5,44,12,12,183,151,172,93,111,36,27,186,54,106,135,141,245,28,114,13,52,64,239,255,152,222,173,14,26,226,13,222,113,73,96,53,3,15,239,98,96,72,169,150,222,157,13,214,228,71,170,62,66,127,159,39,115,182,139,249,13,192,14,187,134,34,2,38,31,115,28,156,216,220,15,107,210,127,216,179,116,233,114,183,115,153,49,70,74,26,104,133,61,70,110,174,132,82,11,67,246,3,95,49,21,247,235,83,37,175,76,88,40,73,36,73,177,159,84,254,236,226,205,207,197,162,21,212,211,25,188,195,244,231,138,40,153,19,146,186,210,9,49,207,61,196,166,10,30,117,210,130,27,53,20,118,68,212,73,133,43,153,73,154,119,208,227,159,63,6,98,7,204,105,2,181,254,252,99,42,121,132,198,126,221,38,200,74,242,207,205,213,80,42,235,186,206,57,134,100,53,248,78,186,63,148,180,10,208,117,195,151,72,132,241,154,173,193,39,143,4,214,247,22,252,0,241,48,22,195,62,199,13,18,2,158,38,101,133,204,63,213,228,167,102,164,254,254,140,240,133,96,157,18,178,49,39,31,193,212,82,3,67,49,222,29,38,164,248,146,242,20,251,192,233,6,21,231,163,87,103,251,238,239,8,165,248,206,34,1,43,231,150,111,190,184,74,168,146,63,11,245,215,79,111,240,143,77,119,52,204,246,231,130,155,48,180,17,207,101,140,129,146,181,80,156,148,99,21,33,13,232,254,26,77,13,236,143,60,144,24,86,190,216,47,12,114,30,146,150,154,141,104,234,221,6,37,55,205,188,39,245,225,87,247,217,67,91,195,200,189,176,254,241,130,114,208,43,144,78,233,135,113,84,119,230,45,41,61,236,172,42,111,93,217,108,238,239,67,41,51,38,25,30,58,229,71,21,126,80,189,212,204,181,27,196,69,253,39,235,165,188,148,39,242,54,188,49,213,240,79,227,33,246,75,52,138,156,14,32,135,91,41,218,86,126,89,219,29,69,50,251,10,22,67,114,203,185,99,192,109,243,191,28,219,162,219,197,198,220,144,106,133,214,124,112,26,112,47,141,251,68,159,185,105,234,219,117,175,64,156,165,219,96,84,248,61,147,108,192,194,47,221,41,209,241,13,203,133,228,253,86,28,27,88,75,242,198,18,29,61,56,30,5,182,211,7,44,167,79,222,102,131,178,40,121,24,71,188,21,177,248,41,87,142,69,254,187,213,52,7,4,189,175,46,71,20,246,147,13,41,6,110,87,98,236,158,163,238,72,133,181,227,186,40,250,193,95,162,107,239,69,249,17,137,95,114,144,33,36,74,52,96,58,15,11,156,206,71,132,171,8,144,163,66,190,75,207,20,56,172,109,210,3,8,39,64,28,139,235,144,107,39,193,34,84,52,34,159,253,101,90,8,69,131,239,113,211,130,7,133,226,251,105,253,124,76,115,254,217,170,198,250,198,124,108,170,78,202,6,71,120,68,167,146,220,96,80,208,8,117,111,217,198,189,154,78,37,203,62,41,247,238,1,46,96,181,229,52,50,84,31,46,96,152,27,229,233,243,20,129,9,200,249,187,85,90,223,209,190,216,235,160,106,155,76,101,153,70,100,16,76,170,75,138,10,5,168,194,203,28,190,55,147,3,231,219,215,24,28,101,92,164,51,188,190,19,154,134,189,188,77,240,211,205,188,9,207,220,31,32,108,253,64,251,45,68,72,97,39,11,134,188,144,215,143,238,252,255,4,241,20,204,33,184,99,220,41,239,17,10,213,15,50,85,32,195,52,162,50,166,213,162,55,106,197,99,192,236,89,67,129,34,247,143,153,148,209,81,200,226,236,148,72,168,62,208,148,164,166,100,126,74,90,33,182,180,17,250,144,55,228,143,162,33,156,113,53,232,212,100,57,139,163,127,0,69,76,62,184,116,114,90,160,53,57,186,55,158,44,232,120,231,222,68,185,111,233,185,75,130,124,230,185,182,158,16,206,164,108,37,202,138,33,148,41,74,251,143,254,27,192,100,170,255,104,234,24,223,91,181,96,234,51,101,172,161,21,68,79,139,156,228,59,240,250,74,171,170,227,196,60,241,140,95,180,157,207,39,110,180,161,99,92,190,147,211,98,71,254,111,61,78,129,248,177,0,150,178,45,200,165,0,149,53,175,82,76,66,103,195,66,39,201,167,249,56,161,144,12,108,183,229,188,6,211,241,200,165,215,131,81,202,81,16,179,100,188,43,99,104,234,161,128,13,41,47,17,13,171,95,254,97,75,99,115,213,123,57,102,194,183,182,123,2,230,5,34,51,155,54,29,178,200,192,0,89,47,115,59,93,172,64,171,228,196,64,43,131,201,145,140,206,134,41,160,51,80,93,226,122,241,132,200,16,22,25,54,172,219,206,36,220,243,189,235,198,86,188,254,5,213,107,105,122,99,200,212,200,197,103,198,40,197,4,112,254,87,242,96,11,155,249,75,244,33,178,73,59,42,67,112,226,91,190,197,85,106,10,10,223,44,185,149,74,74,145,255,224,86,0,194,218,46,188,224,21,143,168,2,0,135,159,249,12,160,23,138,125,133,156,218,203,244,244,200,235,18,62,65,82,196,59,191,124,146,85,205,158,187,44,85,202,120,141,195,19,72,35,221,204,18,161,87,237,80,184,2,6,71,92,7,174,2,124,236,30,116,46,112,93,208,31,243,47,7,221,112,222,210,8,53,153,106,86,99,190,90,190,72,215,138,211,98,102,208,158,124,202,55,98,119,195,176,252,236,38,182,190,29,218,210,47,32,134,230,58,133,135,236,13,214,64,188,38,166,226,144,76,224,208,47,95,202,125,56,111,71,222,15,118,180,204,182,67,66,75,194,198,223,187,247,235,187,84,186,3,226,187,218,52,64,33,74,78,118,63,168,169,211,167,62,20,72,12,195,148,80,66,80,113,128,247,54,126,27,110,147,207,39,163,155,229,193,74,36,39,112,203,84,178,240,165,13,114,119,62,255,55,78,161,216,112,146,38,183,64,29,67,66,234,192,122,177,22,189,216,47,52,89,120,154,210,1,141,221,59,148,226,140,52,140,116,49,45,173,97,47,131,23,158,3,238,50,80,165,104,105,1,205,67,149,118,43,99,29,62,81,240,206,68,26,113,58,71,192,36,79,6,13,166,231,121,194,111,246,165,148,152,188,43,151,82,199,169,198,247,241,190,146,49,180,162,65,29,111,149,121,245,28,62,156,236,100,165,229,71,148,84,187,111,144,219,138,85,243,154,57,174,36,40,158,88,187,243,112,36,230,67,88,17,86,197,50,132,210,10,146,246,238,143,241,38,13,118,72,41,132,37,230,199,108,246,138,4,187,22,15,25,244,155,224,247,129},
  {99,204,187,112,168,125,80,17,41,221,204,114,240,111,165,252,99,7,223,54,16,165,59,7,155,189,145,133,46,152,205,87,111,153,50,16,48,175,180,193,4,142,80,208,250,108,113,195,61,231,69,105,28,29,145,175,170,97,81,75,139,107,215,1,163,28,122,96,100,130,78,164,123,220,235,187,73,185,79,167,66,9,41,91,43,76,82,231,191,166,75,125,155,194,0,0,251,156,161,215,250,153,215,122,193,167,244,215,188,146,240,144,238,235,255,171,51,95,246,17,43,151,8,79,117,140,211,8,169,29,234,237,64,139,31,222,178,105,51,27,204,191,194,141,0,107,119,23,242,105,154,94,144,22,237,229,138,44,148,105,4,121,203,167,106,10,21,60,15,38,59,191,11,205,174,210,181,177,46,91,190,247,89,71,224,238,124,141,255,93,87,104,243,241,245,156,218,9,12,186,83,38,112,185,166,254,76,85,98,170,61,49,88,168,149,30,211,77,10,109,107,151,206,93,153,85,37,48,235,161,217,156,185,159,189,217,201,133,18,63,184,86,47,14,21,198,236,40,210,242,2,11,99,173,111,199,170,171,85,235,147,144,224,68,167,66,200,174,93,123,76,218,4,80,229,162,77,84,58,65,119,52,56,167,12,110,109,166,91,234,243,62,175,51,29,111,40,190,86,83,69,135,225,202,23,127,82,155,130,80,215,253,86,141,144,14,238,163,247,13,231,171,119,53,235,104,30,116,237,138,255,163,47,147,32,136,51,120,171,240,146,80,192,127,30,151,48,90,104,163,233,104,226,212,173,93,11,42,173,233,36,186,146,34,255,223,127,194,225,93,5,173,40,164,79,55,118,120,245,190,251,208,30,123,190,205,82,14,147,145,42,96,161,26,46,56,175,70,51,72,143,13,179,116,231,147,198,169,218,238,136,173,41,51,208,48,0,2,25,200,238,45,35,117,145,43,3,233,84,232,93,174,158,10,132,211,109,171,189,0,20,33,154,220,174,83,51,252,10,26,33,171,144,126,221,37,103,97,237,163,125,152,88,124,154,34,208,31,105,212,36,148,103,4,101,253,160,32,222,104,244,136,163,25,113,107,228,224,214,112,92,230,155,170,72,89,73,87,219,95,22,182,97,214,229,136,249,235,67,79,31,180,116,187,231,168,40,208,252,219,230,54,108,192,79,183,174,24,80,29,130,67,182,203,77,212,169,78,48,251,41,122,17,144,114,207,223,122,53,47,100,145,205,201,182,188,7,222,34,133,247,112,25,223,111,134,110,143,129,31,153,119,86,162,99,194,134,81,242,10,37,46,52,133,171,247,189,58,242,176,0,242,132,9,69,28,136,153,231,122,48,213,244,40,245,103,46,32,3,115,239,46,197,10,207,160,111,66,71,213,141,243,157,131,49,226,1,157,255,110,249,26,37,18,41,23,85,173,239,154,90,192,67,107,205,176,62,143,44,246,91,50,88,204,27,172,139,167,162,29,131,23,11,210,42,10,146,149,2,63,196,95,12,174,101,153,187,32,35,247,208,158,64,123,10,36,212,208,110,141,78,166,207,60,212,230,219,156,130,142,104,181,9,233,213,18,0,232,48,167,82,59,150,133,105,0,55,41,181,38,186,138,213,107,93,177,118,61,159,92,170,196,70,18,146,160,195,124,68,121,105,35,49,212,109,223,219,231,52,104,233,75,105,149,230,52,94,246,93,192,70,155,130,227,140,23,62,168,135,177,224,72,132,231,159,91,82,106,73,106,180,121,178,126,152,72,152,193,42,199,182,215,75,9,29,243,29,141,161,61,49,67,49,101,246,113,241,201,249,205,97,60,43,199,24,116,141,55,135,24,207,154,8,231,40,253,252,2,13,167,161,193,245,161,171,46,3,210,142,207,164,90,246,160,122,26,212,4,55,128,253,103,103,1,204,58,32,90,244,17,17,238,27,190,148,206,221,140,189,70,105,12,81,44,129,238,59,83,49,172,171,86,255,130,203,243,72,228,244,120,203,199,168,194,110,156,60,144,8,170,33,96,129,209,173,87,244,253,65,26,12,185,98,117,148,144,63,194,1,34,24,116,112,14,143,135,183,10,247,31,130,90,166,53,188,211,73,243,186,97,107,106,18,108,4,230,222,111,207,70,140,11,175,31,77,51,154,34,81,86,73,94,78,31,239,150,200,80,84,133,204,194,59,193,206,60,27,104,145,216,141,67,253,144,12,26,252,75,84,239,193,145,164,104,233,94,177,85,57,13,16,133,155,52,235,95,24,217,117,243,91,66,238,93,128,211,86,153,191,250,122,192,168,211,209,60,22,189,223,145,69,147,64,176,172,151,235,182,191,243,196,207,184,19,205,100,169,155,148,246,107,88,232,148,38,208,49,248,181,133,165,153,31,239,192,155,89,225,156,71,120,74,125,46,86,106,161,44,34,204,2,167,121,1,52,214,29,131,201,188,16,154,77,239,14,175,78,195,173,186,106,238,223,30,214,79,106,172,185,21,75,120,178,166,223,127,105,50,181,17,135,81,203,31,58,131,193,102,154,107,194,187,78,114,231,36,4,43,37,8,158,44,146,170,132,30,33,21,224,52,211,164,23,102,150,212,86,13,16,116,250,65,190,96,69,162,146,219,207,184,79,36,222,202,58,40,233,104,81,244,251,161,241,141,238,246,114,26,131,143,132,225,113,243,171,237,137,104,34,141,71,125,67,186,47,52,119,249,13,254,114,142,186,219,137,218,133,141,164,237,21,35,35,46,60,105,32,29,83,209,234,211,219,2,115,80,85,201,84,27,250,94,93,105,253,138,183,105,20,89,0,242,42,73,42,228,110,24,72,4,184,26,115,20,49,111,109,59,182,86,188,86,152,97,121,190,67,154,174,195,142,46,180,209,67,158,205,73,46,167,160,65,243,163,154,86,216,57,121,72,136,209,173,21,87,248,59,125,190,170,29,143,11,85,112,78,52,212,128,26,202,180,181,248,242,112,57,71,59,186,3,105,237,251,137,67,184,47,178,159,77,163,141,57,25,111,14,171,201,158,77,127,188,226,118,223,188,235,196,187,48,235,20,215,78,115,205,232,193,221,240,45,120,137,236,142,134,229,237,175,109,232,241,243,119,114,38,14,132,78,191,17,253,41,61,89,13,26,229,1,219,129,97,230,179,189,100,210,118,113,206,188,181,229,89,56,123,215,101,230,213,14,53,126,82,41,209,229,134,76,135,108,197,60,39,128,235,79,29,76,76,201,65,54,191,150,123,128,143,155,174,229,115,177,223,27,223,234,12,10,128,104,191,149,11,179,128,192,145,23,113,141,44,230,205,199,208,207,42,19,110,2,164,173,129,199,252,132,87,6,253,83,197,97,152,122,152,157,197,95,211,219,116,245,250,175,240,11,130,21,214,193,17,152,218,93,157,69,142,13,50,40,77,83,105,71,10,85,48,75,39,64,78,221,236,238,89,23,218,236,177,39,85,33,219,195,69,5,183,35,247,247,28,234,253,174,127,242,192,69,180,167,157,31,16,91,248,103,63,198,157,209,162,66,179,72,178,189,230,176,133,23,221,75,53,5,207,27,40,0,243,61,230,249,153,106,247,184,75,203,39,126,20,237,84,103,221,131,202,55,84,94,11,242,250,2,24,216,169,68,61,236,23,226,15,134,148,140,174,239,138,172,196,87,77,4,13,248,2,255,80,204,176,7,158,175,125,46,153,196,162,196,78,254,125,237,136,226,145,26,251,166,143,130,61,29,98,237,105,110,10,215,13,99,156,147,194,250,254,74,71,58,59,19,212,139,100,152,0,156,54,107,5,159,54,185,134,96,177,70,14,124,236,34,162,53,140,59,142,170,150,232,214,59,94,151,68,81,221,160,124,114,130,203,93,1,176,191,161,237,2,145,31,201,107,125,178,81,99,12,241,20,98,106,51,127,168,41,126,167,177,165,26,75,102,238,44,74,193,149,234,78,119,197,37,140,232,143,230,162,29,75,213,55,52,213,14,20,122,205,92,170,99,246,65,88,31,121,130,47,122,179,140,122,219,111,193,231,177,64,50,149,176,242,21,192,77,225,62,184,27,214,103,253,2,221,59,212,198,72,171,45,95,162,138,218,99,89,59,248,172,186,73,60,213,184,79,117,245,121,200,244,96,157,41,170,210,198,236,14,32,122,167,78,69,250,55,131,76,119,205,176,223,45,184,124,243,175,23,108,23,171,32,70,213,111,172,221,214,192,162,55,21,43,12,207,41,36,229,251,204,171,224,16,223,28,232,144,35,212,184,77,28,16,242,208,202,135,238,107,14,82,221,230,233,28,206,116,74,171,69,52,195,126,26,59,129,206,34,26,5,86,19,4,219,204,29,238,132,102,237,107,157,39,237,25,73,19,108,65,27,80,40,188,47,115,13,163,45,27,12,4,159,191,101,136,238,229,65,247,132,87,114,112,23,25,16,90,175,85,142,56,60,85,128,1,77,238,135,191,213,179,194,13,187,157,248,251,134,206,193,229,154,146,190,21,111,3,60,173,224,254,58,84,224,2,224,172,236,60,184,79,209,94,139,37},
} ;

static const unsigned char precomputed_core_multsntrup1013_k[precomputed_core_multsntrup1013_NUM][crypto_core_KEYBYTES] = {
  {0,1,-1,1,0,0,0,-1,1,0,0,0,1,0,0,-1,1,-1,0,0,0,-1,0,0,0,0,1,0,-1,1,0,1,0,-1,-1,0,-1,-1,-1,0,0,1,1,-1,-1,0,0,-1,1,-1,0,0,-1,-1,1,0,0,0,0,-1,0,1,0,0,1,-1,-1,0,0,-1,0,-1,1,0,1,1,1,1,0,0,-1,1,-1,0,0,1,0,0,0,0,1,0,1,0,-1,0,0,0,1,1,0,-1,-1,0,1,1,0,-1,-1,1,0,0,0,1,0,0,1,0,-1,-1,0,-1,-1,0,0,1,-1,1,0,-1,0,0,-1,1,0,1,1,1,1,0,0,-1,-1,0,0,-1,0,0,1,1,0,-1,1,0,0,0,1,0,0,1,1,-1,0,0,1,1,-1,-1,0,1,0,0,1,0,0,0,0,-1,0,0,1,-1,-1,0,0,-1,-1,1,1,1,0,0,-1,1,-1,1,0,0,0,0,0,-1,-1,1,1,0,1,0,0,-1,1,1,0,-1,-1,0,0,-1,1,-1,0,0,0,-1,0,1,-1,0,0,-1,1,1,0,0,0,1,0,0,0,0,0,0,-1,-1,0,0,0,0,0,1,0,1,-1,0,-1,-1,0,1,0,0,-1,1,0,0,0,0,0,1,0,0,1,0,0,1,-1,-1,0,-1,-1,1,1,1,0,0,-1,1,-1,-1,1,0,0,0,0,-1,-1,0,0,0,1,0,1,1,-1,1,0,0,0,-1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,0,1,1,-1,0,1,0,0,1,1,0,1,-1,0,1,0,0,0,1,0,1,0,0,-1,-1,-1,0,1,0,1,-1,0,0,0,0,1,1,0,0,0,1,1,-1,1,0,0,0,0,0,0,1,0,-1,1,0,0,1,0,0,0,-1,-1,-1,0,1,1,0,0,0,0,0,1,-1,0,1,0,-1,-1,0,-1,1,0,0,1,-1,-1,0,0,1,0,0,0,0,-1,0,1,0,0,0,0,0,-1,0,1,0,-1,-1,-1,0,0,0,0,-1,1,1,-1,0,0,0,1,0,1,1,0,0,0,0,1,1,0,0,1,0,1,0,1,-1,0,0,1,0,-1,0,0,0,0,0,-1,-1,-1,-1,1,1,0,0,-1,-1,-1,0,1,-1,1,-1,0,0,1,1,-1,1,1,-1,-1,1,0,0,1,0,-1,0,-1,0,-1,-1,-1,-1,1,1,0,0,1,0,0,0,1,-1,0,-1,1,0,-1,-1,0,-1,1,1,1,-1,0,0,0,0,0,0,1,1,-1,1,-1,1,1,1,0,1,1,0,-1,0,-1,1,1,0,-1,1,0,1,0,-1,0,-1,-1,1,0,1,0,-1,-1,0,1,1,-1,-1,1,0,0,-1,0,0,0,0,0,-1,0,0,-1,0,-1,0,1,1,1,1,-1,1,-1,0,1,1,1,1,0,-1,-1,-1,-1,0,1,0,-1,-1,-1,1,0,1,0,0,-1,0,1,0,1,0,-1,0,1,-1,0,0,0,1,0,-1,-1,0,0,0,0,0,0,1,0,0,1,1,-1,0,-1,0,-1,0,0,0,0,0,0,-1,0,0,-1,1,0,0,0,-1,0,0,0,-1,-1,0,1,0,0,1,0,1,1,-1,-1,-1,1,0,1,0,0,1,1,-1,1,1,-1,-1,1,-1,0,0,1,0,0,1,0,1,1,0,-1,0,0,0,0,0,0,0,0,-1,-1,0,0,0,-1,0,1,0,1,1,1,1,0,-1,0,0,-1,0,0,0,0,-1,1,0,-1,0,1,0,0,-1,0,-1,1,0,0,-1,-1,1,0,1,0,1,0,0,-1,0,0,1,0,-1,0,-1,0,0,-1,0,0,0,1,1,0,0,-1,0,-1,0,-1,0,-1,1,1,-1,1,0,-1,-1,-1,0,1,-1,0,0,0,0,0,0,1,1,0,-1,1,0,0,0,0,0,0,-1,0,-1,0,0,-1,1,1,0,0,1,0,0,1,-1,1,-1,0,0,0,0,1,-1,-1,1,1,0,-1,0,0,0,1,1,-1,0,0,-1,-1,0,-1,-1,1,0,0,0,0,1,0,-1,0,-1,-1,0,0,1,0,1,0,1,0,-1,0,0,0,-1,0,1,0,1,-1,0,1,1,0,1,1,0,0,0,1,1,-1,1,0,0,1,1,0,-1,0,1,-1,-1,0,1,1,-1,-1,-1,1,0,0,0,1,1,0,0,-1,0,-1,0,0,1,-1,1,1,0,1,1,-1,1,0,0,0,1,-1,1,0,-1,-1,0,-1,0,-1,0,0,1,1,0,1,1,-1,1,0,1,0,0,0,-1,0,0,0,0,0,0,0,-1,0,0,1,1,0,0,0,-1,1,1,-1,-1,0,1,-1,0,0,0,1,0,-1,1,0,-1,-1,1,-1,0,1,0,0,1,-1,1,-1,0,0,1,1,0,-1,-1,0,-1},
  {-1,0,0,0,1,0,0,0,-1,-1,0,1,0,1,0,-1,1,1,1,0,0,-1,0,0,0,0,-1,1,1,1,0,1,-1,0,-1,0,-1,1,1,-1,0,1,1,0,0,0,0,0,0,0,0,-1,1,0,-1,1,0,-1,0,0,0,1,1,1,-1,0,1,0,1,0,1,0,0,-1,0,1,1,0,-1,-1,-1,1,-1,0,0,0,1,0,0,0,1,0,0,-1,0,0,0,1,1,0,-1,-1,0,1,0,0,0,-1,0,1,-1,0,0,0,-1,0,-1,0,1,1,0,0,1,1,0,0,-1,-1,1,1,1,1,1,1,-1,0,1,1,1,1,1,1,0,0,1,0,0,0,1,-1,1,0,0,0,0,0,1,0,1,1,-1,0,-1,1,1,-1,1,0,1,-1,1,1,0,1,1,-1,0,-1,-1,1,1,0,0,0,-1,0,-1,1,0,0,0,0,0,-1,0,-1,0,0,0,0,0,1,0,1,0,1,0,1,0,-1,0,-1,-1,0,-1,0,1,1,0,1,0,-1,-1,0,1,0,1,0,1,-1,0,-1,1,1,0,1,0,0,-1,1,0,0,0,0,1,1,-1,-1,0,0,-1,1,-1,0,0,0,1,0,-1,-1,-1,-1,0,0,0,1,1,0,-1,-1,1,0,-1,1,-1,0,0,0,-1,0,1,0,1,0,0,-1,0,0,0,-1,0,0,1,-1,0,0,0,1,1,1,1,1,-1,0,-1,0,1,1,0,1,0,1,0,0,1,0,1,1,0,0,0,1,1,1,1,1,-1,0,1,-1,-1,-1,-1,0,0,0,0,-1,-1,-1,-1,1,0,1,-1,1,1,0,0,0,1,0,0,0,0,0,0,1,0,0,0,-1,1,-1,0,1,1,1,1,1,0,0,-1,0,0,-1,-1,0,0,-1,0,0,1,0,0,-1,-1,-1,0,0,0,0,0,-1,1,0,0,1,1,-1,-1,0,1,1,1,1,0,0,-1,1,0,0,1,-1,-1,0,1,0,1,-1,1,0,0,1,0,0,0,0,0,-1,-1,1,1,0,0,0,0,0,1,0,0,0,0,-1,0,0,1,0,1,0,-1,0,1,-1,-1,0,0,-1,1,-1,0,0,-1,-1,0,0,0,-1,0,-1,-1,-1,0,0,0,0,-1,0,1,-1,0,-1,0,1,0,0,0,0,-1,0,0,1,-1,0,-1,0,-1,0,0,0,0,-1,0,0,1,1,0,1,0,0,0,1,0,1,1,0,-1,0,-1,0,-1,1,0,1,-1,0,-1,-1,0,1,0,-1,0,1,-1,1,0,0,0,0,-1,0,-1,0,1,1,1,-1,0,0,0,0,-1,0,0,0,1,0,-1,-1,0,0,1,0,0,-1,1,0,-1,-1,0,0,0,1,0,0,-1,-1,-1,1,0,0,-1,0,-1,1,0,0,-1,1,1,0,0,0,0,0,-1,0,0,1,1,0,0,-1,0,1,0,-1,-1,-1,0,-1,-1,0,0,-1,0,-1,1,0,1,0,1,0,0,1,0,-1,0,0,0,-1,0,0,0,0,0,0,0,1,1,-1,-1,0,-1,0,1,1,-1,0,1,0,1,-1,0,0,0,0,-1,1,-1,1,1,1,-1,0,0,0,-1,0,1,1,0,1,0,-1,-1,0,-1,-1,-1,1,1,0,-1,1,1,0,1,-1,1,0,0,0,1,-1,0,1,0,0,-1,-1,-1,0,-1,0,0,0,0,-1,-1,-1,0,-1,0,0,0,0,1,0,-1,0,0,-1,1,-1,0,1,0,0,-1,-1,0,1,0,-1,-1,1,0,1,0,0,1,0,-1,1,-1,0,1,0,0,0,-1,1,0,0,0,1,0,0,0,-1,0,-1,-1,1,0,-1,1,0,1,0,-1,0,-1,0,1,0,0,0,0,1,1,0,1,0,0,0,0,1,0,-1,0,1,1,0,-1,1,-1,0,-1,0,-1,1,-1,0,1,0,1,0,0,0,-1,0,0,0,0,-1,0,-1,0,-1,-1,0,0,0,0,0,0,0,1,-1,0,1,1,0,1,0,-1,0,-1,0,0,1,0,0,1,0,-1,0,0,-1,-1,1,-1,0,0,0,1,-1,0,0,-1,-1,0,0,1,0,0,0,0,1,0,0,0,1,1,0,0,0,-1,1,1,0,0,1,0,1,1,1,0,0,1,-1,0,0,1,1,1,-1,1,-1,1,0,0,0,0,1,0,-1,-1,-1,-1,0,0,1,0,0,0,0,0,-1,0,1,0,-1,1,0,1,1,0,1,1,0,0,1,-1,0,-1,1,0,-1,0,0,0,0,0,0,1,0,0,-1,-1,1,1,0,0,-1,-1,1,-1,1,1,1,0,-1,-1,0,0,-1,-1,1,0,0,1,-1,1,-1,1,0,-1,0,0,0,1,0,0,1,0,1,-1,0,0,0,-1,-1,-1,-1,0,0,0,0,-1,0,0,0,-1,0,0,0,1,-1,0},
  {-1,0,-1,1,-1,-1,-1,0,1,0,0,-1,0,-1,0,0,-1,0,0,0,-1,-1,0,-1,-1,0,0,1,1,0,1,1,0,1,0,-1,0,-1,-1,1,-1,0,0,1,0,0,-1,-1,1,0,1,-1,0,1,-1,0,-1,-1,0,1,0,0,0,0,-1,-1,1,0,1,0,-1,0,-1,0,1,1,0,1,0,-1,-1,-1,-1,0,1,1,0,-1,-1,0,1,0,-1,1,0,1,1,1,0,0,-1,0,0,0,1,1,0,1,-1,0,0,0,-1,0,0,1,0,0,-1,0,0,-1,-1,0,0,0,0,0,1,0,-1,-1,1,-1,1,0,0,1,1,-1,-1,1,-1,1,-1,1,0,-1,-1,0,1,0,0,1,0,0,0,0,0,0,1,1,1,1,-1,0,0,0,0,0,1,-1,0,1,1,-1,-1,0,0,-1,0,0,1,0,0,0,1,0,0,-1,0,-1,1,0,0,-1,-1,0,-1,1,0,1,0,1,1,1,0,1,0,0,0,0,0,1,0,1,0,0,0,-1,0,0,1,-1,-1,0,0,1,-1,0,0,0,0,0,1,0,0,0,0,1,1,0,1,1,0,0,-1,0,0,0,0,1,-1,-1,0,0,-1,1,1,0,1,0,0,0,0,-1,-1,0,-1,1,0,-1,0,0,0,1,-1,1,-1,-1,0,1,1,-1,0,1,-1,0,-1,-1,0,0,1,0,1,-1,-1,1,-1,-1,0,0,-1,0,0,-1,-1,-1,1,1,0,0,-1,-1,-1,-1,-1,0,0,0,1,-1,-1,0,1,-1,0,0,-1,0,0,0,-1,1,0,-1,0,-1,0,1,0,1,0,0,-1,0,0,1,1,-1,-1,1,-1,0,0,0,0,-1,1,0,1,1,0,0,0,0,0,1,1,0,1,0,-1,0,1,-1,0,0,1,0,1,0,-1,0,-1,0,1,1,1,1,0,-1,0,0,-1,0,1,0,1,0,0,-1,1,-1,-1,0,-1,0,0,0,1,0,1,1,-1,-1,-1,0,0,0,0,0,1,1,1,0,0,1,0,-1,-1,-1,-1,0,0,1,1,-1,0,0,1,0,0,-1,1,1,0,-1,1,-1,1,0,1,0,-1,1,-1,0,0,-1,1,0,0,0,-1,0,-1,0,-1,0,1,-1,-1,0,0,1,0,0,0,-1,0,0,1,1,1,0,-1,-1,1,1,1,-1,0,0,0,1,1,0,0,0,0,-1,0,1,0,-1,0,0,0,0,-1,-1,1,0,0,0,1,-1,1,0,-1,0,1,0,0,0,0,-1,1,1,-1,-1,0,-1,1,1,0,-1,0,0,0,0,0,-1,-1,0,-1,1,-1,0,-1,1,1,0,1,0,0,-1,-1,0,0,1,0,0,0,0,-1,1,0,1,1,0,0,0,1,0,0,1,0,-1,0,-1,1,0,-1,0,0,-1,1,0,0,1,0,1,1,0,1,-1,1,1,0,-1,0,0,1,0,0,-1,0,0,0,1,0,-1,0,0,1,1,0,0,1,-1,0,0,-1,0,0,-1,1,-1,1,-1,0,1,0,0,-1,0,1,-1,-1,0,-1,0,0,-1,0,0,-1,0,0,1,0,-1,0,-1,0,0,-1,-1,-1,1,1,0,1,0,-1,0,-1,-1,0,0,1,0,-1,1,0,1,-1,0,0,0,0,0,-1,1,-1,0,-1,0,1,-1,1,-1,1,1,1,0,0,-1,1,1,0,-1,0,0,-1,0,0,0,1,-1,-1,0,0,1,-1,0,-1,-1,1,1,0,-1,1,0,0,0,-1,1,0,-1,1,-1,0,0,0,1,0,0,-1,1,0,-1,0,0,1,0,1,-1,1,0,-1,0,0,-1,-1,0,0,1,0,0,0,0,0,-1,0,0,0,1,0,0,-1,0,0,1,-1,0,0,-1,-1,0,0,-1,0,0,-1,0,1,0,-1,0,0,-1,1,-1,0,-1,-1,-1,1,0,0,0,0,0,1,-1,-1,-1,0,1,1,-1,0,0,0,1,0,1,-1,0,0,1,0,1,1,0,-1,1,1,1,0,0,0,0,-1,1,-1,1,0,-1,0,0,1,1,0,1,0,-1,0,0,1,1,0,0,-1,0,-1,0,-1,0,0,1,0,0,1,0,1,1,0,1,0,-1,0,0,-1,0,0,1,0,-1,1,-1,0,0,1,-1,1,0,0,0,-1,-1,0,0,-1,0,0,0,1,1,0,1,0,1,0,-1,0,0,-1,0,0,0,-1,0,1,0,0,0,0,0,0,0,0,1,0,0,-1,1,-1,0,-1,1,1,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,-1,1,0,1,0,1,-1,-1,0,1,0,-1,0,1,-1,0,0,0,0,-1,0,0,0,0,0,0,1,0,-1,1,1,0,1,0,-1,0,0,0,0,0,0,0,0,-1,-1,-1,0,-1,1,0,1,0,1,0,1,0,1,-1,-1,0,0,1},
  {1,-1,1,1,-1,0,0,0,0,1,0,0,1,1,0,0,0,0,0,-1,0,1,1,0,-1,-1,-1,-1,1,1,0,-1,0,0,0,1,-1,1,1,1,0,0,1,0,0,1,-1,0,1,1,1,0,1,0,0,1,0,1,0,0,1,-1,0,1,0,0,1,0,-1,0,-1,-1,0,1,0,0,1,1,0,0,1,-1,0,-1,1,-1,1,0,-1,0,0,1,0,0,0,1,1,1,0,0,-1,-1,1,-1,1,0,-1,-1,0,-1,0,0,0,1,1,-1,0,0,-1,1,-1,0,-1,0,0,0,0,0,0,0,0,1,0,-1,0,-1,0,1,0,1,-1,-1,0,0,0,0,-1,1,-1,0,1,1,0,0,0,1,0,0,0,-1,1,-1,1,-1,1,0,0,1,0,-1,-1,0,0,-1,0,0,0,0,1,1,1,1,-1,0,1,0,0,-1,0,-1,1,0,0,1,0,0,-1,-1,1,0,-1,0,-1,0,-1,0,-1,-1,1,-1,-1,0,0,1,0,0,1,0,-1,1,-1,1,1,-1,0,1,1,1,0,0,1,0,1,-1,1,0,0,0,0,0,-1,0,0,0,-1,0,0,-1,-1,-1,1,0,-1,1,0,-1,-1,0,1,1,0,1,0,0,0,-1,0,0,-1,0,0,0,-1,-1,0,1,-1,0,1,0,-1,1,-1,-1,0,0,1,1,0,0,1,0,1,0,0,0,1,0,-1,0,1,0,0,0,-1,0,-1,0,0,1,1,-1,-1,0,0,-1,1,1,0,1,0,0,1,0,0,-1,0,-1,0,1,-1,0,-1,-1,1,0,0,0,-1,0,0,-1,1,-1,0,0,-1,-1,0,0,0,-1,-1,1,0,1,0,0,0,1,1,0,1,1,0,-1,0,1,1,1,-1,0,0,0,-1,0,1,-1,-1,0,1,0,-1,0,0,1,-1,0,-1,1,0,0,0,1,-1,0,0,-1,1,0,0,0,-1,1,0,0,1,0,0,-1,0,0,1,-1,0,0,-1,-1,-1,1,0,-1,-1,1,1,1,-1,0,-1,0,0,-1,1,1,1,1,1,0,1,-1,1,1,0,-1,1,-1,0,0,0,-1,-1,1,0,0,1,-1,0,-1,-1,0,0,-1,1,-1,-1,0,1,0,0,0,0,0,1,-1,0,0,0,-1,0,1,0,0,-1,1,0,1,1,0,-1,0,1,-1,-1,0,1,0,-1,0,1,0,-1,0,0,0,0,0,0,0,0,1,0,0,0,1,1,0,0,1,1,1,-1,1,-1,0,-1,-1,-1,0,-1,1,0,0,0,0,-1,-1,0,1,1,0,0,0,0,-1,1,1,0,0,0,0,0,0,1,0,-1,1,1,-1,0,-1,-1,0,1,0,1,1,0,1,0,0,0,0,0,0,0,0,1,0,0,1,1,1,1,0,-1,0,0,0,0,0,-1,-1,0,0,-1,0,1,0,-1,0,0,1,-1,0,-1,1,1,1,1,0,0,1,0,-1,-1,0,0,0,0,0,1,0,-1,-1,1,1,0,0,0,0,-1,1,0,0,0,1,0,0,0,0,1,1,0,1,0,0,0,-1,0,1,0,0,-1,1,-1,-1,-1,0,0,0,1,0,0,-1,0,-1,-1,-1,0,0,0,0,-1,-1,-1,0,0,0,1,-1,0,-1,0,0,0,1,0,0,0,0,0,0,-1,0,0,-1,0,1,0,1,-1,1,0,1,1,1,0,0,-1,0,1,1,1,1,1,-1,0,-1,-1,-1,-1,1,-1,0,-1,0,0,-1,1,0,-1,0,1,0,1,0,0,-1,-1,0,-1,0,0,1,-1,0,0,-1,0,-1,0,0,1,-1,-1,1,-1,0,-1,1,1,1,0,0,1,-1,0,0,-1,0,0,0,1,-1,-1,1,0,0,0,1,0,0,1,0,1,0,0,0,1,0,0,-1,0,-1,0,0,0,1,0,1,0,0,0,-1,0,0,-1,0,-1,0,1,1,1,0,0,-1,0,0,0,1,0,0,0,-1,0,-1,0,0,-1,1,-1,1,1,0,0,0,0,0,0,0,1,0,-1,-1,1,-1,0,-1,0,0,1,1,-1,0,1,0,0,-1,0,1,0,0,-1,0,0,0,1,0,0,0,-1,0,0,0,0,0,0,-1,-1,0,0,0,0,0,0,0,0,0,-1,0,0,0,0,0,-1,0,0,1,0,1,0,1,0,1,1,0,1,-1,0,1,0,0,-1,0,-1,0,0,1,0,1,0,0,-1,1,1,1,1,-1,-1,0,0,0,-1,1,1,0,1,1,0,-1,0,-1,0,0,-1,0,0,0,1,-1,0,0,0,1,-1,-1,0,-1,-1,0,0,1,0,-1,0,0,-1,0,1,0,0,1,0,-1,1,1,0,0,0,-1,-1,0,0,1,0,-1,0,0,-1,-1,1,0,0,0,-1,-1,0,1,0,-1,0,1,0,-1,1,1,0,-1,0,1,1,0,1},
} ;

static const unsigned char precomputed_core_multsntrup1013_c[precomputed_core_multsntrup1013_NUM][crypto_core_CONSTBYTES] = {
  {},
  {},
  {},
  {},
} ;

static void test_core_multsntrup1013_impl(long long impl)
{
  unsigned char *h = test_core_multsntrup1013_h;
  unsigned char *n = test_core_multsntrup1013_n;
  unsigned char *k = test_core_multsntrup1013_k;
  unsigned char *c = test_core_multsntrup1013_c;
  unsigned char *h2 = test_core_multsntrup1013_h2;
  unsigned char *n2 = test_core_multsntrup1013_n2;
  unsigned char *k2 = test_core_multsntrup1013_k2;
  unsigned char *c2 = test_core_multsntrup1013_c2;
  long long hlen = crypto_core_OUTPUTBYTES;
  long long nlen = crypto_core_INPUTBYTES;
  long long klen = crypto_core_KEYBYTES;
  long long clen = crypto_core_CONSTBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_core_multsntrup1013_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_core = ntruprime_dispatch_core_multsntrup1013(impl);
    printf("core_multsntrup1013 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_multsntrup1013_implementation(impl),ntruprime_dispatch_core_multsntrup1013_compiler(impl));
  } else {
    crypto_core = ntruprime_core_multsntrup1013;
    printf("core_multsntrup1013 selected implementation %s compiler %s\n",ntruprime_core_multsntrup1013_implementation(),ntruprime_core_multsntrup1013_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 512;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(h2,h,hlen);
      input_prepare(n2,n,nlen);
      input_prepare(k2,k,klen);
      input_prepare(c2,c,clen);
      secret(n,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(h,n,k,c);
      public(n,nlen);
      public(k,klen);
      public(c,clen);
      public(h,hlen);
      checksum(h,hlen);
      output_compare(h2,h,hlen,"crypto_core");
      input_compare(n2,n,nlen,"crypto_core");
      input_compare(k2,k,klen,"crypto_core");
      input_compare(c2,c,clen,"crypto_core");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k2,klen);
      secret(c2,clen);
      crypto_core(h2,n2,k2,c2);
      public(n2,nlen);
      public(k2,klen);
      public(c2,clen);
      public(h2,hlen);
      if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_core is nondeterministic\n");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(n2,n2,k,c);
      public(n2,hlen);
      public(k,klen);
      public(c,clen);
      if (memcmp(n2,h,hlen) != 0) fail("failure: crypto_core does not handle n=h overlap\n");
      memcpy(n2,n,nlen);
      secret(n,nlen);
      secret(k2,klen);
      secret(c,clen);
      crypto_core(k2,n,k2,c);
      public(k2,hlen);
      public(n,nlen);
      public(c,clen);
      if (memcmp(k2,h,hlen) != 0) fail("failure: crypto_core does not handle k=h overlap\n");
      memcpy(k2,k,klen);
      secret(n,nlen);
      secret(k,klen);
      secret(c2,clen);
      crypto_core(c2,n,k,c2);
      public(c2,hlen);
      public(n,nlen);
      public(k,klen);
      if (memcmp(c2,h,hlen) != 0) fail("failure: crypto_core does not handle c=h overlap\n");
      memcpy(c2,c,clen);
    }
    checksum_expected(core_multsntrup1013_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_core_multsntrup1013_NUM;++precomp) {
    output_prepare(h2,h,crypto_core_OUTPUTBYTES);
    input_prepare(n2,n,crypto_core_INPUTBYTES);
    memcpy(n,precomputed_core_multsntrup1013_n[precomp],crypto_core_INPUTBYTES);
    memcpy(n2,precomputed_core_multsntrup1013_n[precomp],crypto_core_INPUTBYTES);
    input_prepare(k2,k,crypto_core_KEYBYTES);
    memcpy(k,precomputed_core_multsntrup1013_k[precomp],crypto_core_KEYBYTES);
    memcpy(k2,precomputed_core_multsntrup1013_k[precomp],crypto_core_KEYBYTES);
    input_prepare(c2,c,crypto_core_CONSTBYTES);
    memcpy(c,precomputed_core_multsntrup1013_c[precomp],crypto_core_CONSTBYTES);
    memcpy(c2,precomputed_core_multsntrup1013_c[precomp],crypto_core_CONSTBYTES);
    crypto_core(h,n,k,c);
    if (memcmp(h,precomputed_core_multsntrup1013_h[precomp],crypto_core_OUTPUTBYTES)) {
      fail("failure: crypto_core fails precomputed test vectors\n");
      printf("expected h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",((unsigned char *) precomputed_core_multsntrup1013_h[precomp])[pos]);
      printf("\n");
      printf("received h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",h[pos]);
      printf("\n");
    }
    output_compare(h2,h,crypto_core_OUTPUTBYTES,"crypto_core");
    input_compare(n2,n,crypto_core_INPUTBYTES,"crypto_core");
    input_compare(k2,k,crypto_core_KEYBYTES,"crypto_core");
    input_compare(c2,c,crypto_core_CONSTBYTES,"crypto_core");
  }
}

void test_core_multsntrup1013(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"multsntrup1013")) return;
  storage_core_multsntrup1013_h = callocplus(crypto_core_OUTPUTBYTES);
  test_core_multsntrup1013_h = aligned(storage_core_multsntrup1013_h,crypto_core_OUTPUTBYTES);
  if (crypto_core_OUTPUTBYTES > maxalloc) maxalloc = crypto_core_OUTPUTBYTES;
  storage_core_multsntrup1013_n = callocplus(crypto_core_INPUTBYTES);
  test_core_multsntrup1013_n = aligned(storage_core_multsntrup1013_n,crypto_core_INPUTBYTES);
  if (crypto_core_INPUTBYTES > maxalloc) maxalloc = crypto_core_INPUTBYTES;
  storage_core_multsntrup1013_k = callocplus(crypto_core_KEYBYTES);
  test_core_multsntrup1013_k = aligned(storage_core_multsntrup1013_k,crypto_core_KEYBYTES);
  if (crypto_core_KEYBYTES > maxalloc) maxalloc = crypto_core_KEYBYTES;
  storage_core_multsntrup1013_c = callocplus(crypto_core_CONSTBYTES);
  test_core_multsntrup1013_c = aligned(storage_core_multsntrup1013_c,crypto_core_CONSTBYTES);
  if (crypto_core_CONSTBYTES > maxalloc) maxalloc = crypto_core_CONSTBYTES;
  storage_core_multsntrup1013_h2 = callocplus(maxalloc);
  test_core_multsntrup1013_h2 = aligned(storage_core_multsntrup1013_h2,crypto_core_OUTPUTBYTES);
  storage_core_multsntrup1013_n2 = callocplus(maxalloc);
  test_core_multsntrup1013_n2 = aligned(storage_core_multsntrup1013_n2,crypto_core_INPUTBYTES);
  storage_core_multsntrup1013_k2 = callocplus(maxalloc);
  test_core_multsntrup1013_k2 = aligned(storage_core_multsntrup1013_k2,crypto_core_KEYBYTES);
  storage_core_multsntrup1013_c2 = callocplus(maxalloc);
  test_core_multsntrup1013_c2 = aligned(storage_core_multsntrup1013_c2,crypto_core_CONSTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("core_multsntrup1013 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_core_multsntrup1013();++impl)
      forked(test_core_multsntrup1013_impl,impl);
    ++test_core_multsntrup1013_h;
    ++test_core_multsntrup1013_n;
    ++test_core_multsntrup1013_k;
    ++test_core_multsntrup1013_c;
    ++test_core_multsntrup1013_h2;
    ++test_core_multsntrup1013_n2;
    ++test_core_multsntrup1013_k2;
    ++test_core_multsntrup1013_c2;
  }
  free(storage_core_multsntrup1013_c2);
  free(storage_core_multsntrup1013_k2);
  free(storage_core_multsntrup1013_n2);
  free(storage_core_multsntrup1013_h2);
  free(storage_core_multsntrup1013_c);
  free(storage_core_multsntrup1013_k);
  free(storage_core_multsntrup1013_n);
  free(storage_core_multsntrup1013_h);
}
#undef crypto_core_OUTPUTBYTES
#undef crypto_core_INPUTBYTES
#undef crypto_core_KEYBYTES
#undef crypto_core_CONSTBYTES

