/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.serializers.json;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.types.Attachments;
import com.paterva.maltego.typing.types.DateTime;
import com.paterva.maltego.typing.types.DisplayInformationCollection;
import com.paterva.maltego.typing.types.Overlays;
import java.awt.Color;
import java.util.Optional;
import java.util.stream.Stream;

public enum NeoSpecialProperty {
    VALUE("value", "Value", String.class, MaltegoEntity.class),
    DISPLAY_VALUE("displayValue", "Display Value", String.class, MaltegoEntity.class),
    BOOKMARK("bookmark", "Bookmark", Long.class, MaltegoEntity.class),
    NOTES("notes", "Notes", String.class, MaltegoEntity.class),
    SHOW_NOTES("showNotes", "Show Notes", Boolean.class, MaltegoEntity.class),
    WEIGHT("weight", "Weight", Long.class, MaltegoEntity.class),
    IMAGE("image", "Image", String.class, MaltegoEntity.class),
    DISPLAY_INFO("displayinfo", "Display Info", DisplayInformationCollection.class, MaltegoEntity.class),
    ATTACHMENTS("attachments", "Attachments", Attachments.class, MaltegoEntity.class),
    OVERLAYS("overlays", "overlays", Overlays.class, MaltegoEntity.class),
    LABEL("label", "Label", String.class, MaltegoLink.class),
    SHOW_LABEL("showLabel", "Show Label", Long.class, MaltegoLink.class),
    COLOR("color", "Color", Color.class, MaltegoLink.class),
    STYLE("style", "Style", Long.class, MaltegoLink.class),
    THICKNESS("thickness", "Thickness", Long.class, MaltegoLink.class),
    DESCRIPTION("description", "Description", String.class, MaltegoLink.class),
    TRANSFORM_ID("transformId", "Transform ID", String.class, MaltegoLink.class),
    TRANSFORM_NAME("transformName", "Transform Name", String.class, MaltegoLink.class),
    TRANSFORM_VERSION("transformVersion", "Transform Version", String.class, MaltegoLink.class),
    TRANSFORM_DATE("transformDate", "Transform Date", DateTime.class, MaltegoLink.class);

    private final String id;
    private final String displayName;
    private final Class type;
    private final Class target;

    public static Optional<NeoSpecialProperty> get(String name) {
        return Stream.of(NeoSpecialProperty.values()).filter(prop -> prop.getId().equals(name)).findAny();
    }

    private NeoSpecialProperty(String id, String displayName, Class type, Class target) {
        this.id = id;
        this.displayName = displayName;
        this.type = type;
        this.target = target;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Class getType() {
        return this.type;
    }

    public Class getTarget() {
        return this.target;
    }

    public DisplayDescriptor toDisplayDescriptor() {
        DisplayDescriptor dd = new DisplayDescriptor(this.getType(), this.getId(), this.getDisplayName());
        dd.setHidden(this != ATTACHMENTS);
        return dd;
    }
}

