/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.guided.tour.ui;

import com.maltego.guided.tour.TourStep;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public abstract class TourDialog
extends JDialog {
    private final Frame parent;
    private Component locationRelativeTo;
    private final ComponentListener parentFrameMovedListener = new ComponentAdapter(){

        @Override
        public void componentMoved(ComponentEvent e) {
            TourDialog.this.adjustLocation();
        }
    };
    private final ComponentListener componentResizedListener = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent e) {
            TourDialog.this.adjustLocation();
        }
    };

    public TourDialog(Frame frame) {
        super(frame);
        this.parent = frame;
        this.parent.addComponentListener(this.parentFrameMovedListener);
        this.setLocationOnComponent(this.parent);
        this.setUndecorated(true);
        this.getRootPane().setWindowDecorationStyle(0);
        this.setFocusTraversalPolicy(this.createEmptyFocusTraversalPolicy());
    }

    protected abstract Point getRelativeLocation();

    protected abstract void setTourStep(TourStep var1);

    protected final void setLocationOnComponent(Component c) {
        if (this.locationRelativeTo != null) {
            this.locationRelativeTo.removeComponentListener(this.componentResizedListener);
        }
        this.locationRelativeTo = c == null ? this.parent : c;
        this.locationRelativeTo.addComponentListener(this.componentResizedListener);
    }

    protected void adjustLocation() {
        Point location = this.getRelativeLocation();
        SwingUtilities.convertPointToScreen(location, this.locationRelativeTo);
        this.setLocation(location);
    }

    protected Frame getParentFrame() {
        return this.parent;
    }

    @Override
    public void dispose() {
        this.parent.removeComponentListener(this.parentFrameMovedListener);
        this.locationRelativeTo.removeComponentListener(this.componentResizedListener);
        super.dispose();
    }

    private FocusTraversalPolicy createEmptyFocusTraversalPolicy() {
        return new FocusTraversalPolicy(){

            @Override
            public Component getComponentAfter(Container aContainer, Component aComponent) {
                return null;
            }

            @Override
            public Component getComponentBefore(Container aContainer, Component aComponent) {
                return null;
            }

            @Override
            public Component getFirstComponent(Container aContainer) {
                return null;
            }

            @Override
            public Component getLastComponent(Container aContainer) {
                return null;
            }

            @Override
            public Component getDefaultComponent(Container aContainer) {
                return null;
            }
        };
    }
}

