/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.imex;

import com.paterva.maltego.automation.MachineDescriptor;
import com.paterva.maltego.automation.MachineRepository;
import com.paterva.maltego.automation.imex.MachineImporter;
import com.paterva.maltego.automation.imex.MachinesDiscoveryItems;
import com.paterva.maltego.discovery.DiscoveryContext;
import com.paterva.maltego.discovery.DiscoveryProvider;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.HubSeeds;
import com.paterva.maltego.seeds.api.registry.DefaultHubSeedRegistry;
import com.paterva.maltego.seeds.api.registry.HubSeedRegistry;
import com.paterva.maltego.seeds.api.registry.HubSeedSettings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openide.util.Exceptions;

class MachineDiscoveryProviderDelegate
implements DiscoveryProvider<MachinesDiscoveryItems> {
    private final Map<String, Map<String, MachineDescriptor>> machinesPerHubItem = new HashMap<String, Map<String, MachineDescriptor>>();
    private final DiscoveryProvider provider;
    private static final Logger LOG = Logger.getLogger(MachineDiscoveryProviderDelegate.class.getName());

    public MachineDiscoveryProviderDelegate(DiscoveryProvider provider) {
        this.provider = provider;
    }

    public MachinesDiscoveryItems getNewAndMerged(MachinesDiscoveryItems items) {
        List<MachineDescriptor> machines = items.getMachines();
        ArrayList<MachineDescriptor> newMachines = new ArrayList<MachineDescriptor>();
        MachineRepository repository = MachineRepository.getDefault();
        for (MachineDescriptor newMachine : machines) {
            try {
                MachineDescriptor oldMachine = repository.get(newMachine.getName());
                if (oldMachine != null && oldMachine.isCopy(newMachine)) continue;
                newMachines.add(newMachine);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return new MachinesDiscoveryItems(this.provider, newMachines, items.getContext());
    }

    public void apply(MachinesDiscoveryItems machines) {
        for (MachineDescriptor machine : machines.getMachines()) {
            machine.setReadOnly(true);
        }
        DiscoveryContext ctx = machines.getContext();
        String seedUrl = ctx.getSeedUrl();
        MachineImporter importer = new MachineImporter();
        LOG.log(Level.FINE, String.format("Associating %s machines with seed url: %s", machines.getMachines().size(), seedUrl));
        importer.apply(machines.getMachines(), seedUrl);
        if (seedUrl != null) {
            Map<String, MachineDescriptor> machinesForHubItem = this.machinesPerHubItem.get(seedUrl);
            if (machinesForHubItem == null) {
                machinesForHubItem = new HashMap<String, MachineDescriptor>();
                this.machinesPerHubItem.put(seedUrl, machinesForHubItem);
            }
            for (MachineDescriptor machine : machines.getMachines()) {
                machinesForHubItem.put(machine.getName(), machine);
            }
        }
        LOG.log(Level.FINE, String.format("Installed %s machines for hub seed url: %s", machines.getMachines().size(), seedUrl));
    }

    public void cleanup() {
        ArrayList<? extends MachineDescriptor> repoMachines;
        MachineRepository repo = MachineRepository.getDefault();
        for (Map.Entry<String, Map<String, MachineDescriptor>> entry : this.machinesPerHubItem.entrySet()) {
            String seedUrl = entry.getKey();
            try {
                Map<String, MachineDescriptor> machinesForHubItem = entry.getValue();
                repoMachines = new ArrayList<MachineDescriptor>(repo.getAll());
                for (MachineDescriptor machineDescriptor : repoMachines) {
                    if (!machineDescriptor.getHubItems().contains(seedUrl) || machinesForHubItem.containsKey(machineDescriptor.getName())) continue;
                    machineDescriptor.removeHubItem(seedUrl);
                    if (!machineDescriptor.getHubItems().isEmpty()) continue;
                    LOG.log(Level.FINE, String.format("Removing machine: %s for hub seed url: %s)", machineDescriptor.getName(), seedUrl));
                    repo.remove(machineDescriptor);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.machinesPerHubItem.clear();
        HubSeedRegistry hubSeedRegistry = DefaultHubSeedRegistry.getDefault();
        if (hubSeedRegistry.isOnline()) {
            HubSeeds seeds = hubSeedRegistry.getSeeds(false);
            ArrayList allInstalledHubItems = new ArrayList();
            HubSeedSettings settings = HubSeedSettings.getDefault();
            for (HubSeedDescriptor seed : seeds.getSeeds()) {
                if (!settings.isInstalled(seed)) continue;
                allInstalledHubItems.addAll(seed.getGrantedHubSeedUrls().stream().map(s -> s.getUrl()).collect(Collectors.toList()));
                LOG.log(Level.FINE, String.format("Detected: %s installed hub items", allInstalledHubItems.size()));
            }
            try {
                repoMachines = new ArrayList<MachineDescriptor>(repo.getAll());
                for (MachineDescriptor machineDescriptor : repoMachines) {
                    ArrayList<String> machineHubItems = new ArrayList<String>(machineDescriptor.getHubItems());
                    machineHubItems.removeAll(allInstalledHubItems);
                    for (String machineHubItem : machineHubItems) {
                        machineDescriptor.removeHubItem(machineHubItem);
                        if (!machineDescriptor.getHubItems().isEmpty()) continue;
                        LOG.log(Level.FINE, String.format("Removing machine: %s for hub seed: %s)", machineDescriptor.getName(), machineHubItem));
                        repo.remove(machineDescriptor);
                    }
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

