/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.ui.auth;

import com.maltego.cloud.CloudAuth;
import com.maltego.cloud.ui.auth.CloudAuthHtmlUtil;
import com.maltego.cloud.ui.auth.CloudAuthKeycloakInstalled;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.licensing.ui.LicenseWizardDisplayer;
import com.paterva.maltego.licensing.ui.product.ProductSelectionResult;
import com.paterva.maltego.licensing.ui.wizard.LicenseWizard;
import com.paterva.maltego.util.MaltegoUrl;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.Version;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLHandshakeException;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.ServerRequest;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.keycloak.util.TokenUtil;
import org.openide.modules.Places;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public class DefaultCloudAuth
extends CloudAuth {
    private static final String CLOUD_SYNC_URL = MaltegoUrl.getCurrent().getCloudSync();
    private static final String CLOUD_UI_URL = MaltegoUrl.getCurrent().getGotoVaultUi();
    private static final String CLOUD_CASES_URL = MaltegoUrl.getCurrent().getGotoVaultCases();
    private static final String CLOUD_CASES_TEXT = MaltegoUrl.getCurrent().getGotoVaultCasesText();
    private static final String KEYCLOAK_ISSUER_URL_PREFIX = MaltegoUrl.getCurrent().getAuthIssuerPrefix();
    private static final String KEYCLOAK_REALM = MaltegoUrl.getCurrent().getAuthRealm();
    private static final String KEYCLOAK_CLIENT_ID = MaltegoUrl.getCurrent().getAuthClientId();
    private static final String PREF_REFRESH_TOKEN = "maltego.auth.refresh.token";
    private static final int REFRESH_BUFFER_SECONDS = 90;
    private static final Logger LOG = Logger.getLogger(DefaultCloudAuth.class.getName());
    private String cloudSyncUrl = CLOUD_SYNC_URL;
    private String cloudUiUrl = CLOUD_UI_URL;
    private String cloudCasesUrl = CLOUD_CASES_URL;
    private String cloudCasesText = CLOUD_CASES_TEXT;
    private String keycloakIssuerUrlPrefix = KEYCLOAK_ISSUER_URL_PREFIX;
    private String keycloakRealm = KEYCLOAK_REALM;
    private String keycloakClientId = KEYCLOAK_CLIENT_ID;
    private boolean cloudAuthEnabled = false;
    private CloudAuthKeycloakInstalled authResult;
    private Instant nextTokenExpiration;
    private int refreshSeconds = 3600;
    private boolean startupIssue = false;
    private Timer timer;

    public void init(boolean showCloudCasesUrl) {
        this.readCloudDebugConfig();
        this.loadRefreshToken(showCloudCasesUrl);
    }

    public void setCloudAuthEnabled(boolean cloudAuthEnabled) {
        this.cloudAuthEnabled = cloudAuthEnabled;
    }

    public boolean isCloudAuthEnabled() {
        return this.cloudAuthEnabled || Version.getCurrent().isBetaBuild();
    }

    public String getCloudSyncUrl() {
        return this.cloudSyncUrl;
    }

    public String getCloudUiUrl() {
        return this.cloudUiUrl;
    }

    public String getCloudCasesUrl() {
        return this.cloudCasesUrl;
    }

    public boolean isAuthorized() {
        boolean authorized;
        this.printTokenSpecs(false);
        boolean bl = authorized = this.authResult != null && this.nextTokenExpiration != null && this.getAccessToken() != null;
        if (authorized) {
            if (!Instant.now().isBefore(this.nextTokenExpiration)) {
                LOG.log(Level.WARNING, "isAuthorized false: " + this.getProblemMessage(true));
                RefreshToken refreshToken = this.getRefreshToken();
                this.nextTokenExpiration = this.getNextTokenExpirationInstant(refreshToken, true);
                if (!Instant.now().isBefore(this.nextTokenExpiration)) {
                    LOG.log(Level.INFO, "Checking next token expiration of refresh token only");
                    this.nextTokenExpiration = this.getNextTokenExpirationInstant(refreshToken, false);
                }
                if (Instant.now().isBefore(this.nextTokenExpiration) && !this.getAccessToken().isActive()) {
                    LOG.log(Level.INFO, "Access isActive: false; Refresh exp: {0}", this.nextTokenExpiration);
                    if (LicenseManager.J()) {
                        this.loadRefreshToken(false);
                    }
                }
            }
        } else if (this.startupIssue && this.authResult == null && this.nextTokenExpiration == null && LicenseManager.J()) {
            LOG.log(Level.INFO, "Network was down on startup - trying to refresh token");
            this.loadRefreshToken(false);
            if (this.authResult != null && this.nextTokenExpiration != null) {
                this.startupIssue = false;
            }
        }
        return authorized && Instant.now().isBefore(this.nextTokenExpiration) && this.getAccessToken().isActive();
    }

    public String getProblemMessage(boolean log) {
        return this.printTokenSpecs(log);
    }

    public AccessToken getAccessToken() {
        return this.authResult.getToken();
    }

    public String getAccessTokenString() {
        return this.authResult.getTokenString();
    }

    public void login(boolean canResetRetriesForFailedRefresh, boolean useSystemBrowser, boolean showCloudCasesUrl, boolean enforceReAuthentication, boolean showOrgSelection) throws Exception {
        int retriesForFailedRefresh;
        if (this.isAuthorized()) {
            return;
        }
        boolean refreshSuccess = false;
        int n = retriesForFailedRefresh = canResetRetriesForFailedRefresh ? 2 : 0;
        if (this.nextTokenExpiration != null && Instant.now().isAfter(this.nextTokenExpiration)) {
            refreshSuccess = this.tryRefreshAccessToken(canResetRetriesForFailedRefresh, retriesForFailedRefresh);
        }
        if (!refreshSuccess) {
            this.loginToKeycloakWithBrowser(canResetRetriesForFailedRefresh, retriesForFailedRefresh, useSystemBrowser, showCloudCasesUrl, enforceReAuthentication, showOrgSelection);
            this.nextTokenExpiration = this.getNextTokenExpiration();
        }
    }

    public void logout(boolean silent) throws Exception {
        LOG.log(Level.INFO, "Logging out from Maltego ID. silent = {0}", silent);
        if (this.authResult == null) {
            LOG.log(Level.WARNING, "Maltego is not logged in yet!");
            return;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        try {
            this.authResult.logout(silent);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "logout(silent=" + silent + ") caused an error", e);
            throw e;
        }
        finally {
            LOG.info("Cleanup auth after logout");
            this.authResult = null;
            this.nextTokenExpiration = null;
            NbPreferences.forModule(((Object)((Object)this)).getClass()).remove(PREF_REFRESH_TOKEN);
        }
    }

    public void reset() throws Exception {
        if (this.authResult != null) {
            String refreshToken = NbPreferences.forModule(((Object)((Object)this)).getClass()).get(PREF_REFRESH_TOKEN, "");
            LOG.log(Level.FINE, "Loaded refresh token: {0}", refreshToken);
            if (!StringUtilities.isNullOrEmpty((String)refreshToken)) {
                LOG.info("Refreshing access token");
                this.authResult.refreshToken(refreshToken);
                LOG.info("Access token refreshed");
            }
        }
    }

    public String getAuthUrl(boolean showCloudCasesUrl, boolean enforceReAuthentication, boolean showOrgSelection) {
        String authUrl = null;
        try {
            this.authResult = this.createKeycloakClient(showCloudCasesUrl);
            authUrl = this.authResult.getLoginDesktopUrl(enforceReAuthentication, showOrgSelection);
        }
        catch (Exception ex) {
            NormalException.logStackTrace((Throwable)ex);
        }
        return authUrl;
    }

    public String getLogoutUrl() {
        if (this.authResult == null) {
            return null;
        }
        return this.authResult.getLogoutDesktopUrl(false);
    }

    private void scheduleRefresh(long expiresInSeconds, boolean canResetRetriesForFailedRefresh, int retriesForFailedRefresh) {
        String refreshToken = this.authResult.getRefreshToken();
        if (StringUtilities.isNullOrEmpty((String)refreshToken) || expiresInSeconds <= 0L) {
            return;
        }
        this.scheduleRefresh(refreshToken, expiresInSeconds, canResetRetriesForFailedRefresh, retriesForFailedRefresh);
    }

    private void scheduleRefresh(String refreshToken, long expiresInSeconds, final boolean canResetRetriesForFailedRefresh, final int retriesForFailedRefresh) {
        if (refreshToken == null || expiresInSeconds <= 0L) {
            return;
        }
        long delaySeconds = Math.min((long)this.refreshSeconds, expiresInSeconds - 90L);
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.timer = new Timer("Token Refresh", true);
        this.timer.schedule(new TimerTask(){
            final boolean localCanResetRetriesForFailedRefresh;
            final int localRetries;
            {
                this.localCanResetRetriesForFailedRefresh = canResetRetriesForFailedRefresh;
                this.localRetries = retriesForFailedRefresh;
            }

            @Override
            public void run() {
                boolean refreshSuccess = DefaultCloudAuth.this.tryRefreshAccessToken(this.localCanResetRetriesForFailedRefresh, this.localRetries);
                if (refreshSuccess || this.localRetries <= 0) {
                    boolean maltegoIdOnlineActivated;
                    boolean maltegoReachable = true;
                    if (!refreshSuccess && (maltegoReachable = LicenseManager.J())) {
                        DefaultCloudAuth.this.authResult = null;
                        DefaultCloudAuth.this.nextTokenExpiration = null;
                    }
                    DefaultCloudAuth.this.saveRefreshToken();
                    A licenseMode = LicenseManager.A().A(false);
                    boolean bl = maltegoIdOnlineActivated = licenseMode.U() && !licenseMode.S();
                    if (!refreshSuccess && maltegoReachable && (maltegoIdOnlineActivated || licenseMode.L())) {
                        DefaultCloudAuth.this.redoLogin();
                    }
                }
            }
        }, Math.max(1L, delaySeconds * 1000L));
    }

    private boolean tryRefreshAccessToken(boolean canResetRetriesForFailedRefresh, int retriesForFailedRefresh) {
        if (this.authResult != null) {
            try {
                this.refreshAccessToken(canResetRetriesForFailedRefresh);
                this.nextTokenExpiration = this.getNextTokenExpiration();
                return true;
            }
            catch (Exception ex) {
                String msg = ex.getMessage();
                boolean validCommsIssue = !StringUtilities.isNullOrEmpty((String)msg) && (msg.contains("timed out") || msg.contains("Connection reset"));
                validCommsIssue = validCommsIssue || !StringUtilities.isNullOrEmpty((String)msg) && msg.contains("Unable to tunnel through proxy. Proxy returns");
                validCommsIssue = validCommsIssue || ex instanceof SSLHandshakeException && !StringUtilities.isNullOrEmpty((String)msg) && msg.contains("PKIX path building failed");
                validCommsIssue = validCommsIssue || ex instanceof UnknownHostException || ex instanceof SocketTimeoutException || ex instanceof SocketException;
                LOG.log(Level.WARNING, "Token could not be refreshed: {0} - {1}", new Object[]{ex.getClass(), msg});
                if (retriesForFailedRefresh > 0 && validCommsIssue) {
                    LOG.log(Level.WARNING, "Scheduling token refresh");
                    this.scheduleRefresh(120L, canResetRetriesForFailedRefresh, retriesForFailedRefresh - 1);
                }
                return false;
            }
        }
        return false;
    }

    private void refreshAccessToken(boolean canResetRetriesForFailedRefresh) throws Exception {
        this.authResult.refreshToken();
        LOG.info("Access token refreshed");
        if (canResetRetriesForFailedRefresh) {
            this.scheduleRefresh(this.getExpiresIn(), true, 2);
        } else {
            this.scheduleRefresh(this.getExpiresIn(), false, 0);
        }
    }

    private void loginToKeycloakWithBrowser(boolean canResetRetriesForFailedRefresh, int retriesForFailedRefresh, boolean useSystemBrowser, boolean showCloudCasesUrl, boolean enforceReAuthentication, boolean showOrgSelection) throws Exception {
        CloudAuthKeycloakInstalled previousAuthResult = this.authResult;
        if (this.authResult != null) {
            this.authResult = null;
        }
        this.authResult = this.loginToKeycloak(previousAuthResult, useSystemBrowser, showCloudCasesUrl, enforceReAuthentication, showOrgSelection);
        String accessToken = this.authResult.getTokenString();
        this.saveRefreshToken();
        if (!StringUtilities.isNullOrEmpty((String)accessToken)) {
            LOG.info("Received access token");
            this.scheduleRefresh(this.getExpiresIn(), canResetRetriesForFailedRefresh, retriesForFailedRefresh);
        } else {
            LOG.severe("Did not receive access token");
        }
    }

    private CloudAuthKeycloakInstalled loginToKeycloak(CloudAuthKeycloakInstalled keycloak, boolean useSystemBrowser, boolean showCloudCasesUrl, boolean enforceReAuthentication, boolean showOrgSelection) throws Exception {
        if (keycloak == null || useSystemBrowser) {
            keycloak = this.createKeycloakClient(showCloudCasesUrl);
        }
        keycloak.loginDesktop(useSystemBrowser, enforceReAuthentication, showOrgSelection);
        return keycloak;
    }

    private void saveRefreshToken() {
        String refreshToken = "";
        if (this.authResult != null) {
            refreshToken = this.authResult.getRefreshToken();
        }
        LOG.log(Level.FINE, "Saving refresh token: {0}", refreshToken);
        NbPreferences.forModule(((Object)((Object)this)).getClass()).put(PREF_REFRESH_TOKEN, refreshToken);
    }

    private void loadRefreshToken(boolean showCloudCasesUrl) {
        try {
            String refreshToken = NbPreferences.forModule(((Object)((Object)this)).getClass()).get(PREF_REFRESH_TOKEN, "");
            LOG.log(Level.FINE, "Loaded refresh token: {0}", refreshToken);
            if (!StringUtilities.isNullOrEmpty((String)refreshToken)) {
                LOG.info("Refreshing access token");
                this.authResult = this.createKeycloakClient(showCloudCasesUrl);
                this.authResult.refreshToken(refreshToken);
                LOG.info("Access token refreshed");
                this.scheduleRefresh(this.getExpiresIn(), true, 2);
                this.nextTokenExpiration = this.getNextTokenExpiration();
            } else {
                boolean maltegoIdOnlineActivated;
                A licenseMode = LicenseManager.A().A(false);
                boolean bl = maltegoIdOnlineActivated = licenseMode.U() && !licenseMode.S();
                if (maltegoIdOnlineActivated || licenseMode.L()) {
                    this.redoLogin();
                }
            }
        }
        catch (ServerRequest.HttpFailure ex) {
            this.redoLogin(ex);
        }
        catch (Exception ex) {
            if (ex instanceof NullPointerException && !LicenseManager.J()) {
                this.startupIssue = true;
            }
            this.authResult = null;
            this.nextTokenExpiration = null;
            if (this.startupIssue) {
                NormalException.logStackTrace((Throwable)ex);
            }
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void redoLogin() {
        this.redoLogin(true);
    }

    private void redoLogin(ServerRequest.HttpFailure ex) {
        this.redoLogin(ex.getStatus() == 400);
    }

    private void redoLogin(boolean showWizard) {
        this.authResult = null;
        this.nextTokenExpiration = null;
        if (showWizard) {
            try {
                LicenseManager licMan = LicenseManager.A();
                A licenseMode = licMan.A(false);
                if (licenseMode.L()) {
                    LicenseWizard.setProductSelectionResult((ProductSelectionResult)ProductSelectionResult.RUN_CE);
                    LicenseWizardDisplayer.getDefault().run();
                } else if (licenseMode.U() && !licenseMode.S()) {
                    LicenseWizard.setProductSelectionResult((ProductSelectionResult)ProductSelectionResult.ACTIVATE_GATEWAY_MALTEGO_ID);
                    LicenseWizardDisplayer.getDefault().run();
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void readCloudDebugConfig() {
        File configFile = new File(Places.getUserDirectory(), "etc/cloud-debug.conf");
        try (FileInputStream in = new FileInputStream(configFile);){
            Properties properties = new Properties();
            properties.load(in);
            this.cloudSyncUrl = properties.getProperty("cloud-sync-url", CLOUD_SYNC_URL).trim();
            this.cloudUiUrl = properties.getProperty("cloud-ui-url", CLOUD_UI_URL).trim();
            this.cloudCasesUrl = properties.getProperty("cloud-cases-url", CLOUD_CASES_URL).trim();
            this.cloudCasesText = properties.getProperty("cloud-cases-text", CLOUD_CASES_TEXT).trim();
            this.keycloakIssuerUrlPrefix = properties.getProperty("keycloak-issuer-url-prefix", KEYCLOAK_ISSUER_URL_PREFIX).trim();
            this.keycloakRealm = properties.getProperty("keycloak-realm", KEYCLOAK_REALM).trim();
            this.keycloakClientId = properties.getProperty("keycloak-client-id", KEYCLOAK_CLIENT_ID).trim();
            String refreshSecondsStr = properties.getProperty("token-refresh-seconds", "").trim();
            if (!StringUtilities.isNullOrEmpty((String)refreshSecondsStr)) {
                try {
                    this.refreshSeconds = Integer.parseInt(refreshSecondsStr);
                }
                catch (NumberFormatException ex) {
                    LOG.log(Level.SEVERE, "Failed to parse token refresh seconds: {0}", refreshSecondsStr);
                }
            }
        }
        catch (FileNotFoundException ex) {
            LOG.log(Level.FINE, "Cannot open Cloud Debug config file", ex);
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Error opening Cloud Debug config file", ex);
        }
    }

    private CloudAuthKeycloakInstalled createKeycloakClient(boolean showCloudCasesUrl) throws Exception {
        this.readCloudDebugConfig();
        AdapterConfig adapterConfig = new AdapterConfig();
        adapterConfig.setRealm(this.keycloakRealm);
        adapterConfig.setAuthServerUrl(this.keycloakIssuerUrlPrefix);
        adapterConfig.setResource(this.keycloakClientId);
        adapterConfig.setPublicClient(true);
        adapterConfig.setUseResourceRoleMappings(true);
        adapterConfig.setPkce(true);
        adapterConfig.setDisableTrustManager(true);
        KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((AdapterConfig)adapterConfig);
        CloudAuthKeycloakInstalled keycloak = new CloudAuthKeycloakInstalled(deployment);
        keycloak.setIsMessageHTML(true);
        String successHtml = CloudAuthHtmlUtil.getAuthenticationCompleteHtml(showCloudCasesUrl, this.cloudCasesUrl, this.cloudCasesText);
        keycloak.setMessageLoginSuccess(successHtml);
        String logoutSuccessHtml = CloudAuthHtmlUtil.getLogoutCompleteHtml();
        keycloak.setMessageLogoutSuccess(logoutSuccessHtml);
        String errorHtml = CloudAuthHtmlUtil.getBrowserErrorHtml();
        keycloak.setMessageError(errorHtml);
        keycloak.setLocale(Locale.ENGLISH);
        return keycloak;
    }

    private RefreshToken getRefreshToken() {
        try {
            String refreshTokenString = this.authResult.getRefreshToken();
            RefreshToken refreshToken = TokenUtil.getRefreshToken((String)refreshTokenString);
            return refreshToken;
        }
        catch (Exception ex) {
            NormalException.logStackTrace((Throwable)ex);
            return null;
        }
    }

    private Instant getNextTokenExpirationInstant(RefreshToken refreshToken, boolean checkAccessToken) {
        try {
            Long accessTokenExp = checkAccessToken ? this.getAccessToken().getExp() * 1000L : Long.MAX_VALUE;
            return new Date(Math.min(accessTokenExp, refreshToken.getExp() * 1000L)).toInstant();
        }
        catch (Exception ex) {
            NormalException.logStackTrace((Throwable)ex);
            return this.getNextTokenExpiration();
        }
    }

    private Instant getNextTokenExpiration() {
        return Instant.now().plus(this.getExpiresIn(), ChronoUnit.SECONDS);
    }

    private long getExpiresIn() {
        return Math.min(this.authResult.getTokenResponse().getExpiresIn(), this.authResult.getTokenResponse().getRefreshExpiresIn());
    }

    private String printTokenSpecs(boolean forceLog) {
        if (!forceLog) {
            forceLog = this.isDebugging();
        }
        String msg = "";
        if (forceLog && this.authResult != null && this.getAccessToken() != null) {
            LOG.log(Level.FINEST, "============");
            LOG.log(Level.FINEST, "System UNIX time");
            long currentMillis = System.currentTimeMillis();
            LOG.log(Level.FINEST, "  date: {0}: {1}", new Object[]{currentMillis, new Date(currentMillis)});
            msg = msg + "System UNIX time: " + currentMillis;
            LOG.log(Level.FINEST, "-------------");
            LOG.log(Level.FINEST, "Access Token");
            Long exp = this.getAccessToken().getExp();
            LOG.log(Level.FINEST, "  exp (expiry time): {0}: {1}", new Object[]{exp, new Date(exp * 1000L)});
            msg = msg + "; Access exp: " + exp * 1000L;
            Long iat = this.getAccessToken().getIat();
            LOG.log(Level.FINEST, "  iat (issued at): {0}: {1}", new Object[]{iat, new Date(iat * 1000L)});
            Long authTime = this.getAccessToken().getAuth_time();
            LOG.log(Level.FINEST, "  auth_time: {0}: {1}", new Object[]{authTime, new Date(authTime * 1000L)});
            LOG.log(Level.FINEST, "  aud (audience): {0}", this.getAccessToken().getAudience());
            Long nbf = this.getAccessToken().getNbf();
            LOG.log(Level.FINEST, "  notBefore: {0}", nbf);
            Long lifespanSeconds = nbf == null ? this.getAccessToken().getExp() - this.getAccessToken().getIat() : this.getAccessToken().getExp() - nbf;
            LOG.log(Level.FINEST, "  access token lifespan (seconds): {0}", lifespanSeconds);
            LOG.log(Level.FINEST, "  access token lifespan (minutes): {0}", lifespanSeconds / 60L);
            LOG.log(Level.FINEST, "  access token expires in minutes: {0}", this.authResult.getTokenResponse().getExpiresIn() / 60L);
            if (this.isDevDebugging()) {
                LOG.log(Level.FINEST, "  email: {0}", this.getAccessToken().getEmail());
                LOG.log(Level.FINEST, "  azp (Authorized Parties): {0}", this.getAccessToken().getIssuedFor());
            }
            LOG.log(Level.FINEST, "  active: {0}", this.getAccessToken().isActive());
            msg = msg + ", active: " + this.getAccessToken().isActive();
            LOG.log(Level.FINEST, "  isExpired: {0}", this.getAccessToken().isExpired());
            msg = msg + ", isExpired: " + this.getAccessToken().isExpired();
            if (this.isDevDebugging()) {
                LOG.log(Level.FINEST, "  access token string : {0}", this.getAccessTokenString());
            }
            LOG.log(Level.FINEST, "-------------");
            LOG.log(Level.FINEST, "Refresh Token");
            String refreshTokenString = this.authResult.getRefreshToken();
            try {
                RefreshToken refreshToken = TokenUtil.getRefreshToken((String)refreshTokenString);
                exp = refreshToken.getExp();
                LOG.log(Level.FINEST, "  exp (expiry time): {0}: {1}", new Object[]{exp, new Date(exp * 1000L)});
                msg = msg + "; Refresh exp: " + exp * 1000L;
                iat = refreshToken.getIat();
                LOG.log(Level.FINEST, "  iat (issued at): {0}: {1}", new Object[]{iat, new Date(iat * 1000L)});
                nbf = refreshToken.getNbf();
                LOG.log(Level.FINEST, "  notBefore: {0}", nbf);
                lifespanSeconds = nbf == null ? refreshToken.getExp() - refreshToken.getIat() : refreshToken.getExp() - nbf;
                LOG.log(Level.FINEST, "  refresh token lifespan (seconds): {0}", lifespanSeconds);
                LOG.log(Level.FINEST, "  refresh token lifespan (minutes): {0}", lifespanSeconds / 60L);
                LOG.log(Level.FINEST, "  refresh token expires in minutes: {0}", this.authResult.getTokenResponse().getRefreshExpiresIn() / 60L);
                if (this.isDevDebugging()) {
                    LOG.log(Level.FINEST, "  azp (Authorized Parties): {0}", refreshToken.getIssuedFor());
                }
            }
            catch (JWSInputException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (this.isDevDebugging()) {
                LOG.log(Level.FINEST, "  refresh token string: {0}", refreshTokenString);
            }
        }
        return msg;
    }

    private boolean isDevDebugging() {
        return Version.getCurrent().isDevBuild() && this.isDebugging();
    }

    private boolean isDebugging() {
        return LOG.isLoggable(Level.FINEST);
    }
}

