/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.ui.open;

import com.maltego.cloud.CloudAuth;
import com.maltego.cloud.CloudGraph;
import com.maltego.cloud.CloudGraphRegistry;
import com.maltego.cloud.lock.CloudGraphQueryResult;
import com.maltego.cloud.lock.CloudGraphQueryState;
import com.maltego.cloud.lock.CloudGraphQueryUtils;
import com.maltego.cloud.ui.open.CloudGraphOpenAction;
import com.maltego.cloud.ui.open.OpenFromCloudController;
import com.paterva.maltego.certificates.HttpAgent;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreWriter;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.serializers.json.AttachmentDto;
import com.paterva.maltego.serializers.json.AttachmentsDto;
import com.paterva.maltego.serializers.json.NeoJsonReader;
import com.paterva.maltego.serializers.json.NeoSpecialProperty;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.types.Attachment;
import com.paterva.maltego.typing.types.Attachments;
import com.paterva.maltego.ui.graph.data.GraphDataUtils;
import com.paterva.maltego.ui.graph.data.RecentCloudGraphs;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.FileStore;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.ui.WindowUtil;
import com.paterva.maltego.util.ui.dialog.EditDialogDescriptor;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public class OpenFromCloudAction
extends SystemAction {
    private static final Logger LOG = Logger.getLogger(OpenFromCloudAction.class.getName());
    private static final boolean TEST_OPENED_FROM_NETBEANS = false;
    private final CloudAuth cloudAuth = CloudAuth.getDefault();
    private String cloudGraphId;
    private String cloudGraphVersion;
    private Boolean editable;

    public OpenFromCloudAction() {
        this.putValue("visible", false);
    }

    public String getName() {
        return "Open From Cloud";
    }

    protected String iconResource() {
        return "com/maltego/cloud/ui/save/SaveToCloud.png";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    void setCloudGraphId(String cloudGraphId) {
        this.cloudGraphId = cloudGraphId;
    }

    void setCloudGraphVersion(String cloudGraphVersion) {
        this.cloudGraphVersion = cloudGraphVersion;
    }

    void setEditable(Boolean editable) {
        this.editable = editable;
    }

    public void actionPerformed(ActionEvent event) {
        if (this.cloudAuth.isCloudAuthEnabled()) {
            if (this.cloudGraphId == null) {
                Objects.requireNonNull(this.cloudGraphId, "cloudGraphId must not be null");
                OpenFromCloudController controller = new OpenFromCloudController();
                EditDialogDescriptor descriptor = new EditDialogDescriptor(this.getName(), (WizardDescriptor.Panel)controller);
                DialogDisplayer displayer = DialogDisplayer.getDefault();
                if (DialogDescriptor.OK_OPTION.equals(displayer.notify((NotifyDescriptor)descriptor))) {
                    this.openFromCloud(controller.getCloudGraphId(), null, null, displayer, this.getName());
                }
            } else {
                String tmpId = this.cloudGraphId;
                this.cloudGraphId = null;
                String tmpVersion = this.cloudGraphVersion;
                this.cloudGraphVersion = null;
                Boolean tmpEditable = this.editable;
                this.editable = null;
                this.openFromCloud(tmpId, tmpEditable, tmpVersion, DialogDisplayer.getDefault(), this.getName());
            }
        }
    }

    private void openFromCloud(String cloudGraphIdString, Boolean editable, String cloudGraphVersion, DialogDisplayer displayer, String errorDialogTitle) {
        try {
            GraphID maltegoGraphID;
            Objects.requireNonNull(cloudGraphIdString, "cloudGraphId must not be null");
            GraphID cloudGraphID = GraphID.parse((String)cloudGraphIdString);
            if (Boolean.FALSE.equals(editable)) {
                GraphID maltegoVersionGraphID = CloudGraphRegistry.getDefault().getSameVersionOfCloudGraph(cloudGraphID, cloudGraphVersion);
                if (maltegoVersionGraphID != null) {
                    TopComponent topComponent = GraphDataUtils.getTopComponent((GraphID)maltegoVersionGraphID);
                    if (topComponent != null) {
                        topComponent.requestActive();
                        LOG.log(Level.WARNING, "Cloud graph version already open - cloud ID: {0}, open ID: {1}", new Object[]{cloudGraphID, maltegoVersionGraphID});
                        StatusDisplayer.getDefault().setStatusText("Cloud graph version already open");
                    } else {
                        LOG.log(Level.WARNING, "Cloud graph version - open tab not found - cloud ID: {0}, open but not found ID: {1}", new Object[]{cloudGraphID, maltegoVersionGraphID});
                        StatusDisplayer.getDefault().setStatusText("Cloud graph version - open tab not found");
                    }
                    return;
                }
                maltegoGraphID = GraphID.create();
                LOG.log(Level.INFO, "Cloud graph - opening copy as read-only - cloud ID: {0}, new ID: {1}", new Object[]{cloudGraphID, maltegoGraphID});
                StatusDisplayer.getDefault().setStatusText("Cloud graph - opening copy as read-only");
            } else {
                if (GraphStoreRegistry.getDefault().isExistingAndOpen(cloudGraphID)) {
                    TopComponent topComponent = GraphDataUtils.getTopComponent((GraphID)cloudGraphID);
                    if (topComponent != null) {
                        topComponent.requestActive();
                        LOG.log(Level.WARNING, "Cloud graph already open - cloud ID: {0}", cloudGraphID);
                        StatusDisplayer.getDefault().setStatusText("Cloud graph already open");
                    } else {
                        LOG.log(Level.WARNING, "Cloud graph - open tab not found - cloud open but not found ID: {0}", cloudGraphID);
                        StatusDisplayer.getDefault().setStatusText("Cloud graph - open tab not found");
                    }
                    return;
                }
                maltegoGraphID = cloudGraphID;
            }
            new Thread(() -> {
                try {
                    if (!this.cloudAuth.isAuthorized()) {
                        try {
                            this.cloudAuth.login(true, true, true, true, false);
                        }
                        catch (Exception ex) {
                            throw new Exception("Browser authentication failed" + (ex.getMessage() != null ? ": " + ex.getMessage() : ""));
                        }
                        if (!this.cloudAuth.isAuthorized()) {
                            String problemMessage = this.cloudAuth.getProblemMessage(true);
                            throw new Exception("Browser authentication failed - token invalid: " + problemMessage);
                        }
                    }
                    this.openFromCloud(maltegoGraphID, cloudGraphID, editable, cloudGraphVersion);
                }
                catch (Exception ex) {
                    SwingUtilities.invokeLater(() -> {
                        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)("Cloud graph could not open. " + ex.getMessage()));
                        msg.setMessageType(2);
                        msg.setTitle(errorDialogTitle);
                        displayer.notify((NotifyDescriptor)msg);
                        NormalException.logStackTrace((Throwable)ex);
                    });
                }
            }, "Open From Cloud").start();
        }
        catch (GraphStoreException ex) {
            SwingUtilities.invokeLater(() -> {
                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)("Error: " + ex.getClass().getSimpleName() + ": " + ex.getMessage()));
                msg.setMessageType(0);
                msg.setTitle(errorDialogTitle);
                displayer.notify((NotifyDescriptor)msg);
                NormalException.logStackTrace((Throwable)ex);
            });
        }
    }

    private void openFromCloud(GraphID maltegoGraphID, GraphID cloudGraphId, Boolean editable, String cloudGraphVersion) throws Exception {
        block22: {
            CloudGraphQueryState state;
            CloudGraphQueryResult queryResult;
            block21: {
                if (editable != null) break block21;
                queryResult = CloudGraphQueryUtils.lock((CloudAuth)this.cloudAuth, (GraphID)cloudGraphId);
                editable = false;
                state = queryResult.getQueryState();
                switch (state) {
                    case FAILED: 
                    case ERROR__GRAPH_DOES_NOT_EXIST_YET: {
                        LOG.log(Level.WARNING, state.getMsg() + " Cloud ID: {0}, open ID: {1}", new Object[]{cloudGraphId, maltegoGraphID});
                        throw new IllegalStateException(state.getMsg());
                    }
                    case GRAPH_EXISTS_AND_USER_HAS_LOCK: {
                        editable = true;
                        break;
                    }
                    case ERROR_LOCKPUT__GRAPH_EXISTS_BUT_USER_CANNOT_LOCK1: 
                    case LOCKPUT_GRAPH_EXISTS_BUT_USER_CANNOT_LOCK2: 
                    case GRAPH_EXISTS_BUT_ANOTHER_USER_HAS_LOCK: {
                        if (maltegoGraphID.equals((Object)cloudGraphId)) {
                            maltegoGraphID = GraphID.create();
                            break;
                        }
                        break block22;
                    }
                    default: {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                }
                break block22;
            }
            if (Boolean.TRUE.equals(editable)) {
                queryResult = CloudGraphQueryUtils.findGraph((CloudAuth)this.cloudAuth, (GraphID)cloudGraphId);
                editable = false;
                state = queryResult.getQueryState();
                switch (state) {
                    case FAILED: 
                    case ERROR__GRAPH_DOES_NOT_EXIST_YET: 
                    case GRAPH_EXISTS_BUT_ANOTHER_USER_HAS_LOCK: 
                    case FIND__GRAPH_EXISTS_BUT_NOT_LOCKED: {
                        LOG.log(Level.WARNING, state.getMsg() + " Cloud ID: {0}, open ID: {1}", new Object[]{cloudGraphId, maltegoGraphID});
                        throw new IllegalStateException(state.getMsg());
                    }
                    case GRAPH_EXISTS_AND_USER_HAS_LOCK: {
                        editable = true;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                }
            } else {
                queryResult = CloudGraphQueryUtils.findGraph((CloudAuth)this.cloudAuth, (GraphID)cloudGraphId);
                state = queryResult.getQueryState();
                switch (state) {
                    case FAILED: 
                    case ERROR__GRAPH_DOES_NOT_EXIST_YET: {
                        LOG.log(Level.WARNING, state.getMsg() + " Cloud ID: {0}, open ID: {1}", new Object[]{cloudGraphId, maltegoGraphID});
                        throw new IllegalStateException(state.getMsg());
                    }
                    case GRAPH_EXISTS_AND_USER_HAS_LOCK: 
                    case GRAPH_EXISTS_BUT_ANOTHER_USER_HAS_LOCK: 
                    case FIND__GRAPH_EXISTS_BUT_NOT_LOCKED: {
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                }
            }
        }
        NeoJsonReader reader = new NeoJsonReader(maltegoGraphID, cloudGraphId, editable.booleanValue(), cloudGraphVersion);
        try {
            this.downloadGraph(reader);
        }
        catch (Exception ex) {
            this.closeGraphStore(maltegoGraphID);
            throw ex;
        }
        if (!editable.booleanValue() && cloudGraphVersion != null) {
            reader.setGraphName(reader.getGraphName() + " v" + cloudGraphVersion.substring(cloudGraphVersion.length() - 12));
        }
        try {
            this.downloadAttachments(reader);
        }
        catch (Exception ex) {
            this.closeGraphStore(maltegoGraphID);
            throw ex;
        }
        SwingUtilities.invokeLater(() -> {
            try {
                WindowUtil.showWaitCursor();
                this.openGraph(reader);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                WindowUtil.hideWaitCursor();
            }
        });
    }

    private void closeGraphStore(GraphID maltegoGraphID) throws GraphStoreException {
        GraphLifeCycleManager.getDefault().fireGraphClosing(maltegoGraphID);
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(maltegoGraphID);
            if (graphStore != null && graphStore.isOpen()) {
                graphStore.close(true);
                GraphLifeCycleManager.getDefault().fireGraphClosed(maltegoGraphID);
            }
        }
        catch (GraphStoreException ex) {
            NormalException.logStackTrace((Throwable)ex);
        }
    }

    private void downloadGraph(NeoJsonReader reader) throws Exception {
        StatusDisplayer.getDefault().setStatusText("Syncing graph...");
        HttpAgent httpAgent = this.createHttpAgent(this.cloudAuth.getCloudSyncUrl() + "/graphs/" + reader.getCloudGraphID() + "/content/blob" + (reader.getCloudGraphVersion() == null ? "" : "?versionId=" + reader.getCloudGraphVersion()));
        httpAgent.setAcceptContentType("application/json");
        httpAgent.doGet();
        String response = this.readResponse(httpAgent);
        reader.readFromString(response);
    }

    private void downloadAttachments(NeoJsonReader reader) throws Exception {
        Map attachmentProps = reader.getAttachmentProperties();
        int attCount = attachmentProps.values().stream().mapToInt(atts -> atts.getAttachments().size()).sum();
        GraphDataStoreWriter dataStoreWriter = GraphStoreHelper.getGraphStore((GraphID)reader.getMaltegoGraphID()).getGraphDataStore().getDataStoreWriter();
        for (Map.Entry entry : attachmentProps.entrySet()) {
            MaltegoEntity entity = (MaltegoEntity)entry.getKey();
            AttachmentsDto attsDto = (AttachmentsDto)entry.getValue();
            int primary = attsDto.getPrimary();
            Attachments attachments = new Attachments();
            for (AttachmentDto attDto : attsDto.getAttachments()) {
                Attachment attachment = this.downloadAttachment(reader, attDto, attCount);
                attachments.add((Object)attachment);
                if (primary != attDto.getIndex()) continue;
                attachments.setPrimaryImage(attachment);
            }
            DisplayDescriptor attProp = NeoSpecialProperty.ATTACHMENTS.toDisplayDescriptor();
            entity.setValue((PropertyDescriptor)attProp, (Object)attachments);
            dataStoreWriter.updateEntity(entity);
            StatusDisplayer.getDefault().setStatusText("Downloaded graph");
        }
    }

    private Attachment downloadAttachment(NeoJsonReader reader, AttachmentDto attachment, int attachmentCount) throws Exception {
        int attachmentNum = attachment.getIndex();
        StatusDisplayer.getDefault().setStatusText("Syncing attachment " + (attachmentNum + 1) + "/" + attachmentCount);
        String filename = attachment.getFilename();
        String source = attachment.getSource();
        HttpAgent httpAgent = this.createHttpAgent(this.cloudAuth.getCloudSyncUrl() + "/graphs/" + reader.getCloudGraphID() + "/content/attachments/" + attachmentNum + (reader.getCloudGraphVersion() == null ? "" : "?versionId=" + reader.getCloudGraphVersion()));
        httpAgent.setAcceptContentType("text/plain");
        httpAgent.doGet();
        try (InputStream inputStream = httpAgent.getInputStream();){
            int id = FileStore.getDefault().add(inputStream, filename);
            Attachment attachment2 = new Attachment(id, new FastURL(source));
            return attachment2;
        }
    }

    private void openGraph(NeoJsonReader reader) {
        GraphID maltegoGraphID = reader.getMaltegoGraphID();
        GraphID cloudGraphID = reader.getCloudGraphID();
        String graphName = reader.getGraphName();
        CloudGraphOpenAction openAction = (CloudGraphOpenAction)SystemAction.get(CloudGraphOpenAction.class);
        openAction.setGraph(maltegoGraphID, graphName);
        openAction.performAction();
        CloudGraph cloudgraph = new CloudGraph(maltegoGraphID, cloudGraphID, reader.getCloudGraphVersion(), graphName, Boolean.valueOf(reader.isEditable()), null);
        if (maltegoGraphID.equals((Object)cloudGraphID)) {
            CloudGraphRegistry.getDefault().addCloudGraph(cloudGraphID, cloudgraph);
            RecentCloudGraphs.getDefault().addCloudGraph(cloudGraphID.toString(), graphName);
        } else {
            CloudGraphRegistry.getDefault().addVersionOfCloudGraph(maltegoGraphID, cloudgraph);
        }
    }

    private String readResponse(HttpAgent agent) throws IOException {
        StringBuilder response;
        try (BufferedReader in = new BufferedReader(new InputStreamReader(agent.getInputStream()));){
            String inputLine;
            response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
        }
        return response.toString();
    }

    private HttpAgent createHttpAgent(String urlStr) throws Exception {
        String accessToken = this.cloudAuth.getAccessTokenString();
        URL url = new URL(urlStr);
        HttpAgent httpAgent = new HttpAgent(url);
        httpAgent.setAccessToken(accessToken);
        return httpAgent;
    }
}

