/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.ui.save;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.maltego.cloud.CloudAuth;
import com.maltego.cloud.CloudGraph;
import com.maltego.cloud.CloudGraphRegistry;
import com.maltego.cloud.lock.CloudGraphQueryResult;
import com.maltego.cloud.lock.CloudGraphQueryState;
import com.maltego.cloud.lock.CloudGraphQueryUtils;
import com.paterva.maltego.certificates.rest.MultipartWriter;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.serializers.json.NeoJsonAttachments;
import com.paterva.maltego.serializers.json.NeoJsonAttachmentsFactory;
import com.paterva.maltego.serializers.json.NeoJsonWriter;
import com.paterva.maltego.typing.types.Attachment;
import com.paterva.maltego.ui.graph.actions.TopGraphAction;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import com.paterva.maltego.ui.graph.data.RecentCloudGraphs;
import com.paterva.maltego.ui.graph.util.GraphUtils;
import com.paterva.maltego.util.FileStore;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.ui.HtmlUIUtils;
import com.paterva.maltego.util.ui.components.LabelWithBackground;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FilenameUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.util.HelpCtx;
import org.openide.windows.TopComponent;

public class SaveToCloudAction
extends TopGraphAction {
    private static final Logger LOG = Logger.getLogger(SaveToCloudAction.class.getName());
    private final CloudAuth cloudAuth = CloudAuth.getDefault();
    private final CloudGraphRegistry cloudGraphRegistry = CloudGraphRegistry.getDefault();

    public SaveToCloudAction() {
        this.putValue("visible", this.cloudAuth.isCloudAuthEnabled());
    }

    public String getName() {
        return "Save To Cloud";
    }

    protected String iconResource() {
        return "com/maltego/cloud/ui/save/SaveToCloud.png";
    }

    protected boolean isEnabled(TopComponent tc) {
        GraphID graphID;
        boolean enabled = super.isEnabled(tc);
        if (enabled && this.cloudGraphRegistry.isCloudGraph(graphID = this.getTopGraphID()) && !this.cloudGraphRegistry.isEditable(graphID)) {
            enabled = false;
        }
        return enabled;
    }

    protected void actionPerformed(TopComponent tc) {
        if (this.cloudAuth.isCloudAuthEnabled()) {
            GraphID maltegoGraphID = this.getTopGraphID();
            try {
                this.save(maltegoGraphID, false);
            }
            catch (Exception ex) {
                this.displayErrorDialog("Cloud Graph could not be saved. ", maltegoGraphID, ex);
            }
        }
    }

    void save(GraphID maltegoGraphID, boolean saveInEDT) throws Exception {
        if (this.cloudAuth.isCloudAuthEnabled()) {
            if (maltegoGraphID == null) {
                return;
            }
            TopComponent topComponent = this.getTopComponent();
            String graphName = GraphUtils.getTopGraphName((TopComponent)topComponent, (String)"Cloud Graph");
            boolean save = true;
            if (!this.cloudGraphRegistry.isCloudGraph(maltegoGraphID)) {
                String saveToCloudResult = this.showSaveToCloudDialog(graphName);
                if (saveToCloudResult == null || saveToCloudResult.isEmpty()) {
                    save = false;
                } else {
                    graphName = saveToCloudResult;
                }
            } else if (!this.cloudGraphRegistry.isEditable(maltegoGraphID)) {
                throw new IllegalStateException("Graph is Read Only!");
            }
            if (save) {
                this.saveToCloudInBackground(maltegoGraphID, graphName, saveInEDT);
            }
        }
    }

    private String showSaveToCloudDialog(String graphName) {
        String saveOption = "Save To Cloud";
        String cancelOption = "Cancel";
        Object[] options = new Object[]{saveOption, cancelOption};
        String description = "<b>Do you want to save your graph to Cloud?</b><br><br>You will be prompted to log in with your Maltego ID in your system browser.<br>No Maltego account? <a href='" + this.cloudAuth.getCloudUiUrl() + "'>Create ID ></a>";
        String title = "Save To Cloud";
        JEditorPane htmlPane = HtmlUIUtils.getHtmlPane((String)description);
        htmlPane.setBackground(new JPanel().getBackground());
        JPanel formPane = new JPanel();
        formPane.setLayout(new GridBagLayout());
        LabelWithBackground graphNameLabel = new LabelWithBackground("Graph Name");
        JTextField graphNameField = new JTextField();
        graphNameField.setText(graphName);
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 18, 1, new Insets(15, 10, 15, 10), 0, 0);
        formPane.add((Component)graphNameLabel, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        formPane.add((Component)graphNameField, gbc);
        JPanel wrapperPane = new JPanel();
        wrapperPane.setLayout(new BoxLayout(wrapperPane, 1));
        wrapperPane.add(htmlPane);
        wrapperPane.add(formPane);
        DialogDescriptor dd = new DialogDescriptor((Object)wrapperPane, title, true, options, (Object)saveOption, 0, HelpCtx.DEFAULT_HELP, null);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        return dd.getValue().equals(saveOption) ? graphNameField.getText() : null;
    }

    private void saveToCloudInBackground(GraphID maltegoGraphID, String graphName, boolean saveInEDT) throws JsonProcessingException {
        NeoJsonAttachmentsFactory attsFactory = new NeoJsonAttachmentsFactory();
        Map attachments = attsFactory.getAttachments(maltegoGraphID);
        NeoJsonWriter jsonWriter = new NeoJsonWriter(maltegoGraphID, graphName, attachments);
        String graphJson = jsonWriter.writeToString();
        LOG.finer(graphJson);
        if (saveInEDT && SwingUtilities.isEventDispatchThread()) {
            this.saveToCloudInBackgroundStep(maltegoGraphID, graphJson, attachments, graphName, true);
        } else {
            new Thread(() -> this.saveToCloudInBackgroundStep(maltegoGraphID, graphJson, attachments, graphName, false), "Save To Cloud").start();
        }
    }

    private void saveToCloudInBackgroundStep(GraphID maltegoGraphID, String graphJson, Map<Guid, NeoJsonAttachments> attachments, String graphName, boolean saveInEDT) {
        try {
            boolean save = false;
            if (!this.cloudAuth.isAuthorized()) {
                try {
                    this.cloudAuth.login(true, true, true, true, false);
                }
                catch (Exception ex) {
                    throw new Exception("Browser authentication failed" + (ex.getMessage() != null ? ": " + ex.getMessage() : ""));
                }
                if (!this.cloudAuth.isAuthorized()) {
                    String problemMessage = this.cloudAuth.getProblemMessage(true);
                    if (saveInEDT && SwingUtilities.isEventDispatchThread()) {
                        this.displayErrorDialog("Cloud Graph \"" + graphName + "\" could not be saved - authentication token invalid: " + problemMessage, maltegoGraphID, null);
                    } else {
                        SwingUtilities.invokeLater(() -> this.displayErrorDialog("Cloud Graph \"" + graphName + "\" could not be saved - authentication token invalid: " + problemMessage, maltegoGraphID, null));
                    }
                } else {
                    save = true;
                }
            } else {
                save = true;
            }
            if (save) {
                this.saveToCloud(maltegoGraphID, graphJson, attachments, graphName);
                TopComponent topComponent = this.getTopComponent();
                GraphDataObject gdo = (GraphDataObject)topComponent.getLookup().lookup(GraphDataObject.class);
                gdo.setModified(false);
                gdo.rename(graphName);
                gdo.updateDisplayName();
                gdo.updateBackupData();
            }
        }
        catch (Exception ex) {
            if (saveInEDT && SwingUtilities.isEventDispatchThread()) {
                this.displayErrorDialog("Cloud Graph \"" + graphName + "\" could not be saved. ", maltegoGraphID, ex);
            }
            SwingUtilities.invokeLater(() -> this.displayErrorDialog("Cloud Graph \"" + graphName + "\" could not be saved. ", maltegoGraphID, ex));
        }
    }

    private void saveToCloud(GraphID maltegoGraphID, String graphJson, Map<Guid, NeoJsonAttachments> attachments, String graphName) throws Exception {
        CloudGraphQueryResult result = CloudGraphQueryUtils.findGraph((CloudAuth)this.cloudAuth, (GraphID)maltegoGraphID);
        CloudGraphQueryState state = result.getQueryState();
        switch (state) {
            case ERROR__GRAPH_DOES_NOT_EXIST_YET: {
                this.sendGraph(maltegoGraphID, graphJson, attachments, graphName, true);
                break;
            }
            case GRAPH_EXISTS_AND_USER_HAS_LOCK: {
                this.sendGraph(maltegoGraphID, graphJson, attachments, graphName, false);
                break;
            }
            case GRAPH_EXISTS_BUT_ANOTHER_USER_HAS_LOCK: 
            case FIND__GRAPH_EXISTS_BUT_NOT_LOCKED: 
            case FAILED: {
                LOG.log(Level.WARNING, state.getMsg() + " Graph ID: {0}, with name: {1}", new Object[]{maltegoGraphID, graphName});
                throw new IllegalStateException(state.getMsg());
            }
            default: {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        }
    }

    private void sendGraph(GraphID maltegoGraphID, String graphJson, Map<Guid, NeoJsonAttachments> attachments, String graphName, boolean post) throws Exception {
        URL url = new URL(this.cloudAuth.getCloudSyncUrl() + "/graphs/" + maltegoGraphID + "/content/blob");
        try (MultipartWriter writer = new MultipartWriter(url);){
            String accessToken = this.cloudAuth.getAccessTokenString();
            writer.getHttpAgent().setAccessToken(accessToken);
            writer.queueText("graph", graphName, graphJson);
            this.queueAttachments(writer, attachments);
            AtomicLong prevProgress = new AtomicLong(-1L);
            long totalBytes = writer.getTotalBytesToWrite();
            writer.setBytesWrittenCallback(bytesWritten -> {
                long progressPercent = (int)(100L * bytesWritten / totalBytes);
                if (progressPercent != prevProgress.getAndSet(progressPercent)) {
                    StatusDisplayer.getDefault().setStatusText("Save To Cloud - " + progressPercent + "%");
                }
            });
            String result = writer.send(post);
            LOG.log(Level.FINE, "Result: {0}", result);
            if (this.cloudGraphRegistry.isVersionOfCloudGraph(maltegoGraphID)) {
                this.cloudGraphRegistry.removeVersionOfCloudGraph(maltegoGraphID);
            }
            this.cloudGraphRegistry.addCloudGraph(maltegoGraphID, new CloudGraph(maltegoGraphID, graphName, Boolean.TRUE));
            RecentCloudGraphs.getDefault().addCloudGraph(maltegoGraphID.toString(), graphName);
        }
    }

    private void queueAttachments(MultipartWriter writer, Map<Guid, NeoJsonAttachments> attachments) throws IOException {
        for (NeoJsonAttachments atts : attachments.values()) {
            int attNum = atts.getFirstIndex();
            for (Attachment attachment : atts.getAttachments()) {
                int id = attachment.getId();
                File file = FileStore.getDefault().get(id);
                Path filePath = file.toPath();
                String filename = attachment.getFileName();
                String uploadFilename = this.getUploadFilename(filename, attNum++);
                writer.queueFile("attachments", uploadFilename, filePath);
            }
        }
    }

    private String getUploadFilename(String filename, int attNum) {
        String ext = FilenameUtils.getExtension((String)filename);
        if (!ext.isEmpty()) {
            ext = "." + ext;
        }
        return "att" + attNum + ext;
    }

    private void displayErrorDialog(String errorPrefix, GraphID cloudGraphId, Exception ex) {
        String errorMessage = ex == null ? errorPrefix : errorPrefix + ex.getMessage();
        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)errorMessage);
        msg.setMessageType(0);
        msg.setTitle(this.getName());
        DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
        LOG.log(Level.WARNING, "Graph {0}: {1}", new Object[]{cloudGraphId, errorMessage});
        if (ex != null) {
            NormalException.logStackTrace((Throwable)ex);
        }
    }
}

