/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.archive.mtz;

import com.paterva.maltego.util.Version;
import com.pinkmatter.pandora.ComparableVersion;
import java.util.Properties;
import org.openide.util.Utilities;

public class MtzVersion
extends Properties {
    public static final String MTZ_VERSION = "1.1";
    public static final String GRAPH_VERSION_GRAPHML = "1.1";
    public static final String GRAPH_VERSION_PANDORA = "1.3";
    private static final String PROP_MTZ_VERSION = "maltego.mtz.version";
    private static final String PROP_GRAPH_VERSION = "maltego.graph.version";
    private static final String PROP_PANDORA_VERSION = "maltego.pandora.version";

    public static MtzVersion getBase() {
        Version current = Version.getCurrent();
        MtzVersion version = new MtzVersion();
        version.put("maltego.client.name", System.getProperty("maltego.product-name", "Maltego"));
        version.put("maltego.client.version", current.toString(false, false, false));
        version.put("maltego.client.subtitle", current.getSubtitle());
        return version;
    }

    public static MtzVersion getCurrent() {
        MtzVersion version = MtzVersion.getBase();
        version.put(PROP_MTZ_VERSION, "1.1");
        version.put(PROP_GRAPH_VERSION, GRAPH_VERSION_PANDORA);
        version.put(PROP_PANDORA_VERSION, "1.4.4");
        return version;
    }

    public static MtzVersion getMTZ() {
        MtzVersion version = MtzVersion.getCurrent();
        version.put(PROP_MTZ_VERSION, "1.1");
        return version;
    }

    public static MtzVersion getMTGX() {
        MtzVersion version = MtzVersion.getMTZ();
        version.put(PROP_GRAPH_VERSION, "1.1");
        return version;
    }

    public static boolean isMtzVersionSupported(MtzVersion otherVersion) {
        return MtzVersion.compareVersions("1.1", MtzVersion.getMtzVersion(otherVersion)) >= 0;
    }

    public static boolean isGraphVersionSupported(MtzVersion otherVersion) {
        return MtzVersion.isGraphVersionSupported(MtzVersion.getGraphVersion(otherVersion));
    }

    public static boolean isGraphVersionSupported(String otherVersion) {
        return MtzVersion.compareVersions(GRAPH_VERSION_PANDORA, otherVersion) >= 0;
    }

    public static String getMtzVersion(MtzVersion version) {
        return version == null ? null : version.getProperty(PROP_MTZ_VERSION);
    }

    public static String getGraphVersion(MtzVersion version) {
        return version == null ? null : version.getProperty(PROP_GRAPH_VERSION);
    }

    static int compareVersions(String versionStrLeft, String versionStrRight) {
        if (Utilities.compareObjects((Object)versionStrLeft, (Object)versionStrRight)) {
            return 0;
        }
        if (versionStrLeft == null) {
            return -1;
        }
        if (versionStrRight == null) {
            return 1;
        }
        ComparableVersion versionLeft = new ComparableVersion(versionStrLeft);
        ComparableVersion versionRight = new ComparableVersion(versionStrRight);
        return versionLeft.compareTo(versionRight);
    }
}

