/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing;

import com.maltego.cloud.CloudAuth;
import com.paterva.maltego.certificates.HttpAgent;
import com.paterva.maltego.licensing.A;
import com.paterva.maltego.licensing.D;
import com.paterva.maltego.licensing.E;
import com.paterva.maltego.licensing.LicenseCheckFailedListener;
import com.paterva.maltego.licensing.json.MaltegoIdProductRestrictions;
import com.paterva.maltego.licensing.json.serialize.JsonLicenseResponse;
import com.paterva.maltego.licensing.mode.B;
import com.paterva.maltego.licensing.serialize.C;
import com.paterva.maltego.licensing.serialize.G;
import com.paterva.maltego.licensing.serialize.N;
import com.paterva.maltego.util.MaltegoUrl;
import com.paterva.maltego.util.StringUtilities;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public class LicenseManager {
    private static final Logger B = Logger.getLogger(LicenseManager.class.getName());
    private static final LicenseManager E = new LicenseManager();
    private static final String F = MaltegoUrl.getCurrent().getAuthIssuerPrefix();
    private static final String G = MaltegoUrl.getCurrent().getAuthRealm();
    private final ChangeSupport C = new ChangeSupport((Object)this);
    private final LicenseSettings D = new LicenseSettings();
    private boolean A = false;

    private LicenseManager() {
    }

    public static LicenseManager A() {
        return E;
    }

    public synchronized boolean A(boolean checkOnline, boolean checkTransformRunAllowed) {
        boolean valid;
        com.paterva.maltego.licensing.mode.A licenseMode = this.A(checkOnline);
        if (licenseMode.L()) {
            valid = CloudAuth.getDefault().isAuthorized();
            if (!valid) {
                this.C(false);
            }
        } else if (licenseMode.U()) {
            boolean authorised;
            boolean bl = valid = licenseMode.W() && licenseMode.T();
            if (valid && !licenseMode.S() && !(authorised = CloudAuth.getDefault().isAuthorized()) && LicenseManager.J()) {
                valid = false;
            }
        } else {
            boolean bl = valid = licenseMode.Q() || licenseMode.B() && licenseMode.P();
        }
        if (checkTransformRunAllowed) {
            valid = licenseMode.U() ? MaltegoIdProductRestrictions.isTransformRunAllowed(licenseMode) : com.paterva.maltego.licensing.A.A(licenseMode);
        }
        if (!valid) {
            Lookup.getDefault().lookupAll(LicenseCheckFailedListener.class).stream().forEach(LicenseCheckFailedListener::onLicenseCheckFailed);
        }
        return valid;
    }

    public synchronized com.paterva.maltego.licensing.mode.A A(boolean checkOnline) {
        com.paterva.maltego.licensing.mode.A licenseMode;
        long time;
        block13: {
            time = System.currentTimeMillis();
            licenseMode = null;
            try {
                String licenseKey;
                Optional<com.paterva.maltego.licensing.mode.A> licenseModeOpt;
                if (this.D.isFreeMode()) {
                    licenseMode = com.paterva.maltego.licensing.mode.A.A(time, this.D.isFreeOnline());
                    if (this.D.isFreeOnline()) {
                        this.D.setMayFallbackToLicenseKey(false);
                    }
                    break block13;
                }
                if (this.D.isGatewayMaltegoIdMode()) {
                    this.D.setMayFallbackToLicenseKey(false);
                    Optional<JsonLicenseResponse> activation = N.B().D();
                    if (activation.isPresent() && (licenseModeOpt = com.paterva.maltego.licensing.mode.B.B(time, activation.get(), checkOnline, this.D.isGatewayMaltegoIdOffline())).isPresent()) {
                        licenseMode = licenseModeOpt.get();
                        this.D.setGatewayMaltegoIdMode(true);
                    }
                    break block13;
                }
                if (!this.D.mayFallbackToLicenseKey()) break block13;
                Optional<D> license = com.paterva.maltego.licensing.serialize.C.F();
                if (!this.A && !license.isPresent()) {
                    this.A = true;
                    G reader = new G();
                    Optional<String> oldKey = reader.D();
                    if (oldKey.isPresent()) {
                        B.fine("Activating using old license key");
                        String oldLicKey = oldKey.get();
                        this.D.setLicenseKey(oldLicKey);
                        try {
                            license = com.paterva.maltego.licensing.mode.C.A(oldLicKey);
                        }
                        catch (Exception ex) {
                            B.log(Level.WARNING, "Error trying to activate with old key: {0}", ex.getMessage());
                            licenseMode = null;
                        }
                    }
                }
                if (license.isPresent() && (licenseModeOpt = com.paterva.maltego.licensing.mode.B.A(time, license.get(), checkOnline)).isPresent() && (licenseKey = (licenseMode = licenseModeOpt.get()).A().C()) != null) {
                    this.D.setMayFallbackToLicenseKey(true);
                    if (!licenseKey.equals(this.C())) {
                        this.D.setLicenseKey(licenseKey);
                    }
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                licenseMode = null;
            }
        }
        if (licenseMode == null) {
            licenseMode = com.paterva.maltego.licensing.mode.A.A(time);
        }
        com.paterva.maltego.licensing.mode.A licMode = licenseMode;
        B.fine(() -> "License Mode (" + (checkOnline ? "Online" : "Offline") + "): " + licMode.V());
        String branding = this.C(licMode);
        NbPreferences.root().put("maltego.branding.code", branding);
        this.B(licenseMode);
        return licenseMode;
    }

    public synchronized String D() {
        return System.getProperty("maltego.product-name", "Maltego");
    }

    public void B(com.paterva.maltego.licensing.mode.A licenseMode) {
        String productName = "Maltego";
        String productNameForUserAgent = "Maltego";
        String subscriptionPlan = "";
        if (licenseMode.B()) {
            E capability = licenseMode.J().J();
            productNameForUserAgent = productName = capability.F().trim();
            subscriptionPlan = capability.A();
        } else if (licenseMode.W()) {
            E capability = licenseMode.R().J();
            productName = capability.F().trim();
            subscriptionPlan = capability.A();
            productNameForUserAgent = productName + " " + subscriptionPlan;
        } else if (licenseMode.Q()) {
            productNameForUserAgent = productName = productName + (licenseMode.I() ? " Community Edition" : " CaseFile");
        }
        productNameForUserAgent = productNameForUserAgent.trim().replaceAll("[^a-zA-Z ]", "");
        System.setProperty("maltego.product-name", productName);
        System.setProperty("maltego.subscriptionPlan", subscriptionPlan);
        System.setProperty("maltego.product-name-for-user-agent", productNameForUserAgent);
    }

    public void C(boolean freeModeSet) {
        this.D.setFreeMode(freeModeSet);
    }

    public void B(boolean freeOnline) {
        this.D.setFreeOnline(freeOnline);
    }

    public void A(String licenseKey) {
        this.D.setLicenseKey(licenseKey != null ? licenseKey.toUpperCase() : "");
    }

    public String C() {
        return this.D.getLicenseKey();
    }

    public void I(boolean mayFallbackToLicenseKey) {
        this.D.setMayFallbackToLicenseKey(mayFallbackToLicenseKey);
    }

    public boolean I() {
        return this.D.mayFallbackToLicenseKey();
    }

    public void H(boolean gatewayMaltegoIdMode) {
        this.D.setGatewayMaltegoIdMode(gatewayMaltegoIdMode);
    }

    public void G(boolean gatewayMaltegoIdOffline) {
        this.D.setGatewayMaltegoIdOffline(gatewayMaltegoIdOffline);
    }

    public String F() {
        com.paterva.maltego.licensing.mode.A licenseMode = this.A(false);
        return this.G(licenseMode);
    }

    public String G(com.paterva.maltego.licensing.mode.A licenseMode) {
        CloudAuth cloudAuth;
        if ((licenseMode.L() || licenseMode.U()) && (cloudAuth = CloudAuth.getDefault()).isAuthorized()) {
            return cloudAuth.getAccessTokenString();
        }
        return null;
    }

    public static boolean G(String url) {
        URL parsedUrl;
        if (url == null) {
            return false;
        }
        try {
            parsedUrl = new URL(url);
        }
        catch (MalformedURLException ex) {
            return false;
        }
        String host = parsedUrl.getHost().toLowerCase();
        return host.endsWith(".maltego.com") || host.endsWith(".paterva.com") || host.equals("localhost") || host.equals("127.0.0.1");
    }

    public String H(String url) {
        boolean maltegoUrl = LicenseManager.G(url);
        if (!maltegoUrl) {
            return null;
        }
        return this.F();
    }

    public static boolean J() {
        try {
            URL url = new URL(F + "/realms/" + G + "/.well-known/openid-configuration");
            HttpAgent httpAgent = new HttpAgent(url);
            httpAgent.setConnectTimeout(8000);
            httpAgent.setReadTimeout(8000);
            httpAgent.doHead();
            return httpAgent.getResponseCode() == 200;
        }
        catch (IOException ex) {
            boolean validCommsIssue;
            Throwable cause = ex.getCause();
            String msg = cause == null ? null : cause.getMessage();
            boolean bl = validCommsIssue = !StringUtilities.isNullOrEmpty((String)msg) && (msg.contains("timed out") || msg.contains("Connection reset") || msg.contains("Error getting a response code for") || msg.contains("Network is unreachable (connect failed)") || msg.contains("PKIX path building failed") || msg.contains("Unable to tunnel through proxy. Proxy returns"));
            return !validCommsIssue && !(cause instanceof UnknownHostException) && !(cause instanceof SocketTimeoutException) && !(cause instanceof SocketException);
        }
    }

    public void A(ChangeListener listener) {
        this.C.addChangeListener(listener);
    }

    public void B(ChangeListener listener) {
        this.C.removeChangeListener(listener);
    }

    public void A(com.paterva.maltego.licensing.mode.A oldMode) {
        JsonLicenseResponse newLicense;
        JsonLicenseResponse oldLicense;
        com.paterva.maltego.licensing.mode.A newMode = this.A(false);
        boolean fire = false;
        if (oldMode.D() != newMode.D() || oldMode.Q() != newMode.Q() || oldMode.B() != newMode.B() || oldMode.W() != newMode.W()) {
            fire = true;
        } else if (oldMode.Q() && oldMode.I() != newMode.I()) {
            fire = true;
        } else if (oldMode.B()) {
            D oldLicense2 = oldMode.A();
            D newLicense2 = newMode.A();
            if (!(oldLicense2.H().equals(newLicense2.H()) && oldLicense2.C().equals(newLicense2.C()) && oldLicense2.I().equals(newLicense2.I()) && oldLicense2.J().equals(newLicense2.J()) && oldLicense2.B().equals(newLicense2.B()) && oldLicense2.E().equals(newLicense2.E()) && oldLicense2.D().equals(newLicense2.D()))) {
                fire = true;
            }
        } else if (oldMode.W() && !(oldLicense = oldMode.X()).equalInfoAndCapabilities(newLicense = newMode.X())) {
            fire = true;
        }
        B.log(Level.FINE, "Fire license change: {0}", fire);
        if (fire) {
            this.E();
        }
    }

    public void E() {
        this.C.fireChange();
    }

    public String B() {
        return this.C(this.A(false));
    }

    public String C(com.paterva.maltego.licensing.mode.A licenseMode) {
        String branding = "Unknown";
        if (licenseMode.W()) {
            branding = MaltegoIdProductRestrictions.getProductPlanPricingPlan(licenseMode);
            if ("CE".equals(branding) || "BASIC".equals(branding) || "PROFESSIONAL".equals(branding) || "ORGANIZATION".equals(branding)) {
                try {
                    if ("desktop.cemigration".equals(MaltegoIdProductRestrictions.getProductPlanTextId(licenseMode))) {
                        branding = "CE";
                    }
                }
                catch (Exception exception) {}
            } else {
                branding = "Unknown";
            }
        } else if (licenseMode.H()) {
            branding = "BT";
        } else if (licenseMode.Q()) {
            branding = licenseMode.I() ? "CE" : "CF";
        } else if (licenseMode.B()) {
            branding = licenseMode.E() ? "ONE" : (licenseMode.M() ? "XL" : "FULL");
        }
        return branding;
    }

    private class LicenseSettings {
        private static final String PREF_LICENSE_KEY = "maltego.licensing.key";
        private static final String PREF_FREE_MODE = "maltego.licensing.free.mode";
        private static final String PREF_FREE_ONLINE = "maltego.licensing.free.online";
        private static final String PREF_GATEWAY_MALTEGO_ID_MODE = "maltego.licensing.gateway.maltegoid.mode";
        private static final String PREF_GATEWAY_MALTEGO_ID_OFFLINE = "maltego.licensing.gateway.maltegoid.offline";
        private static final String PREF_MAY_FALLBACK_TO_LICENSE_KEY = "maltego.licensing.may.fallback.to.license.key";

        private LicenseSettings() {
        }

        public void setLicenseKey(String licenseKey) {
            this.getPrefs().put(PREF_LICENSE_KEY, licenseKey);
        }

        public String getLicenseKey() {
            return this.getPrefs().get(PREF_LICENSE_KEY, "");
        }

        public void setFreeMode(boolean freeModeSet) {
            this.getPrefs().putBoolean(PREF_FREE_MODE, freeModeSet);
        }

        public boolean isFreeMode() {
            return this.getPrefs().getBoolean(PREF_FREE_MODE, false);
        }

        public void setFreeOnline(boolean freeOnline) {
            this.getPrefs().putBoolean(PREF_FREE_ONLINE, freeOnline);
        }

        public boolean isFreeOnline() {
            return this.getPrefs().getBoolean(PREF_FREE_ONLINE, true);
        }

        public void setMayFallbackToLicenseKey(boolean mayFallbackToLicenseKey) {
            this.getRootPrefs().putBoolean(PREF_MAY_FALLBACK_TO_LICENSE_KEY, mayFallbackToLicenseKey);
        }

        public boolean mayFallbackToLicenseKey() {
            return this.getRootPrefs().getBoolean(PREF_MAY_FALLBACK_TO_LICENSE_KEY, true);
        }

        public void setGatewayMaltegoIdMode(boolean gatewayMaltegoIdModeSet) {
            this.getPrefs().putBoolean(PREF_GATEWAY_MALTEGO_ID_MODE, gatewayMaltegoIdModeSet);
        }

        public boolean isGatewayMaltegoIdMode() {
            return this.getPrefs().getBoolean(PREF_GATEWAY_MALTEGO_ID_MODE, false);
        }

        public void setGatewayMaltegoIdOffline(boolean gatewayMaltegoIdOffline) {
            this.getPrefs().putBoolean(PREF_GATEWAY_MALTEGO_ID_OFFLINE, gatewayMaltegoIdOffline);
        }

        public boolean isGatewayMaltegoIdOffline() {
            return this.getPrefs().getBoolean(PREF_GATEWAY_MALTEGO_ID_OFFLINE, false);
        }

        private Preferences getPrefs() {
            return NbPreferences.forModule(this.getClass());
        }

        private Preferences getRootPrefs() {
            return NbPreferences.root();
        }
    }
}

