/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.maltego.cloud.CloudAuth;
import com.paterva.maltego.certificates.HttpAgent;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.json.rest.SignatureService;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.licensing.rest.C;
import com.paterva.maltego.rest.MaltegoRestExchange;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.json.JsonHubEvent;
import com.paterva.maltego.util.MaltegoHelper;
import com.paterva.maltego.util.MaltegoUrl;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.Version;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

public class HubSeedRequests {
    private static final String THREAD_NAME = "Hub Install/Uninstall";
    private static final String HUB_INSTALL_URL = MaltegoUrl.getCurrent().getHubInstall();
    private static final String HUB_INSTALL_XML_ROOT = "MaltegoHubInstall";
    private static final String HUB_UNINSTALL_URL = MaltegoUrl.getCurrent().getHubUninstall();
    private static final String HUB_UNINSTALL_XML_ROOT = "MaltegoHubUninstall";
    private static final String HUB_NAME = "HubName";
    private static final String HUB_DISPLAY_NAME = "HubDisplayName";
    private static final String HUB_URL = "HubUrl";
    private static final String HUB_INSTALL_EVENT = "INSTALL";
    private static final String HUB_UNINSTALL_EVENT = "UNINSTALL";
    private static final int TIMEOUT_MILLIS = 15000;
    private static final ObjectMapper mapper = new ObjectMapper();

    public static void sendInstalled(HubSeedDescriptor hubItem) {
        HubSeedRequests.send(HUB_INSTALL_URL, HUB_INSTALL_XML_ROOT, hubItem, HUB_INSTALL_EVENT);
    }

    public static void sendUninstalled(HubSeedDescriptor hubItem) {
        HubSeedRequests.send(HUB_UNINSTALL_URL, HUB_UNINSTALL_XML_ROOT, hubItem, HUB_UNINSTALL_EVENT);
    }

    private static void send(String url, String xmlRoot, HubSeedDescriptor hubItem, String eventType) {
        Runnable runnable = () -> {
            try {
                A licenseMode = LicenseManager.A().A(false);
                if (licenseMode.U()) {
                    SignatureService signatureService = SignatureService.getInstance();
                    HttpAgent httpAgent = HubSeedRequests.createHttpAgent(CloudAuth.getDefault(), MaltegoUrl.getCurrent().getHubMaltegoIdEvent());
                    JsonHubEvent hubEvent = new JsonHubEvent(hubItem.getId(), hubItem.getName(), hubItem.getDisplayName(), hubItem.getGrantedHubSeedUrls().stream().map(el -> el.getUrl()).collect(Collectors.toList()), eventType, UUID.randomUUID().toString(), signatureService.getPublicKeyAsString(), MaltegoHelper.getJavaVersion(), httpAgent.getUserAgent().replace(Version.getCurrent().toString(false, false, false), Version.getCurrent().toString(false, true, false)), Long.toString(System.currentTimeMillis()));
                    String signedContent = signatureService.signMessage(mapper.writeValueAsString((Object)hubEvent));
                    httpAgent.doPost("text/plain", signedContent);
                    HubSeedRequests.getResponseBody(httpAgent, hubItem.getName(), eventType);
                } else {
                    Map entries = C.A();
                    entries.put(HUB_NAME, hubItem.getName());
                    entries.put(HUB_DISPLAY_NAME, hubItem.getDisplayName());
                    entries.put(HUB_URL, hubItem.getGrantedHubSeedUrls().isEmpty() ? null : hubItem.getGrantedHubSeedUrls().get(0).getUrl());
                    String accessToken = LicenseManager.A().F();
                    MaltegoRestExchange exchange = new MaltegoRestExchange(new URL(url), xmlRoot, entries, accessToken);
                    exchange.setCheckNonce(false);
                    exchange.sendRequest();
                }
            }
            catch (Exception ex) {
                NormalException.logStackTrace((Throwable)ex);
            }
        };
        Thread thread = new Thread(runnable, THREAD_NAME);
        thread.start();
    }

    private static HttpAgent createHttpAgent(CloudAuth cloudAuth, String urlStr) throws MalformedURLException {
        String accessToken = cloudAuth.getAccessTokenString();
        URL url = new URL(urlStr);
        HttpAgent httpAgent = new HttpAgent(url);
        httpAgent.setConnectTimeout(15000);
        httpAgent.setReadTimeout(15000);
        httpAgent.setAccessToken(accessToken);
        return httpAgent;
    }

    private static String getResponseBody(HttpAgent httpAgent, String hubitemName, String eventType) throws IOException, NormalException {
        int responseCode = httpAgent.getResponseCode();
        if (responseCode >= 200 && responseCode < 300) {
            return httpAgent.getContentAsString();
        }
        throw new NormalException("Hub event " + eventType + " request for hub " + hubitemName + " failed with code " + responseCode, false);
    }
}

