/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.format;

import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.table.TableIO;
import com.paterva.maltego.graph.table.format.LinkTableFormatter;
import com.paterva.maltego.typing.PropertyDescriptor;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class GroupLinkTypeFormat
extends LinkTableFormatter {
    List<String> displayHeader;

    public GroupLinkTypeFormat(TableIO table) {
        super(table);
    }

    @Override
    protected void createLinkHeader(MaltegoLink link) {
        if (this.linkHeader != null) {
            return;
        }
        int size = link.getProperties().size() + 3;
        this.properties = new LinkedHashSet(size);
        this.displayHeader = new ArrayList<String>(size);
        this.linkHeader = new ArrayList(size + this.offset);
        this.displayHeader.add("Maltego Link");
        this.displayHeader.add("Source Entity ID");
        this.displayHeader.add("Target Entity ID");
        this.addRow(this.displayHeader);
        this.linkHeader.add(LINK_START_ID);
        this.linkHeader.add("SourceEntityID");
        this.linkHeader.add("TargetEntityID");
        this.addRow(this.linkHeader);
    }

    @Override
    protected void updateHeader(MaltegoLink link) {
        this.createLinkHeader(link);
        if (!this.properties.addAll(link.getProperties())) {
            return;
        }
        for (PropertyDescriptor property : this.properties) {
            if (this.linkHeader.contains(property.getName())) continue;
            this.displayHeader.add(property.getDisplayName());
            this.linkHeader.add(property.getName());
        }
    }
}

