/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui.laf;

import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.licensing.ui.LicenseModeColor;
import com.paterva.maltego.util.Version;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Window;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import org.openide.windows.WindowManager;

public class LicenseLookAndFeelUpdater {
    private static final Logger LOG = Logger.getLogger(LicenseLookAndFeelUpdater.class.getName());
    private static final String TITLE_BAR_COLOR = "title-bar-color";

    public static void init() {
        LicenseManager.A().A(LicenseLookAndFeelUpdater::updateLookAndFeel);
        LicenseLookAndFeelUpdater.updateLookAndFeel(null);
    }

    private static void updateLookAndFeel(ChangeEvent evt) {
        SwingUtilities.invokeLater(() -> {
            Window[] windows;
            A licenseMode = LicenseManager.A().A(false);
            LOG.log(Level.FINE, "License - Updating Look & Feel ({0})", licenseMode.V());
            LicenseLookAndFeelUpdater.updateTitleBar(licenseMode);
            for (Window window : windows = Frame.getWindows()) {
                window.invalidate();
                window.validate();
                window.repaint();
            }
        });
    }

    public static void updateTitleBar(A licenseMode) {
        Color titleBarColor = LicenseModeColor.get(licenseMode);
        UIManager.getLookAndFeelDefaults().replace(TITLE_BAR_COLOR, titleBarColor);
        System.setProperty("maltego.titlebar.isMaltegoIdPlan", licenseMode.U() ? "true" : "false");
        JFrame frame = (JFrame)WindowManager.getDefault().getMainWindow();
        if (frame != null) {
            frame.setTitle(Version.getCurrent().toString(true, false, true));
        }
    }
}

