/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui.wizard;

import com.maltego.cloud.CloudAuth;
import com.paterva.maltego.licensing.E;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.licensing.ui.manager.LicenseManagerController;
import com.paterva.maltego.licensing.ui.product.ProductSelectionAction;
import com.paterva.maltego.licensing.ui.product.ProductSelectionResult;
import com.paterva.maltego.licensing.ui.wizard.LicenseWizardIterator;
import com.paterva.maltego.seeds.api.HubSeeds;
import com.paterva.maltego.seeds.api.registry.HubSeedRegistry;
import com.paterva.maltego.seeds.api.registry.HubSeedSettings;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.dialog.AbstractWizardSegment;
import com.paterva.maltego.util.ui.dialog.WizardSegment;
import com.paterva.maltego.util.ui.dialog.WizardUtilities;
import java.awt.Image;
import java.util.prefs.Preferences;
import org.openide.WizardDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbPreferences;
import org.openide.util.actions.SystemAction;

public class LicenseWizard {
    private static final String PREF_SHOWN = "maltego.wizard.first-run.shown";
    private static ProductSelectionResult result;
    private static boolean showing;

    public static void setProductSelectionResult(ProductSelectionResult result) {
        LicenseWizard.result = result;
    }

    public static Image getDescriptionImage() {
        return ImageUtilities.loadImage((String)"Key48.png");
    }

    public static WizardSegment createSegment(int position) {
        LicenseWizardSegment segment = null;
        if (result != null && !LicenseManagerController.isShowing() && !ProductSelectionAction.isShowing()) {
            segment = new LicenseWizardSegment(position, result == ProductSelectionResult.OFFLINE || result == ProductSelectionResult.OFFLINE_GATEWAY_MALTEGO_ID, false);
            segment.initialize(new WizardDescriptor((WizardDescriptor.Iterator)new WizardDescriptor.ArrayIterator()));
            if (segment.getIterator().current() == null) {
                segment = null;
                showing = false;
            }
        }
        return segment;
    }

    public static boolean isShowing() {
        return showing;
    }

    public static boolean showOfflineWizard() {
        return LicenseWizard.showWizard(true, false);
    }

    public static boolean showLoginWizard() {
        return LicenseWizard.showWizard(false, true);
    }

    private static boolean showWizard(boolean offlineActivation, boolean loginOnly) {
        boolean showed = false;
        if (!(showing || LicenseManagerController.isShowing() || ProductSelectionAction.isShowing())) {
            LicenseWizardSegment licenseWizardSegment = new LicenseWizardSegment(0, offlineActivation, loginOnly);
            licenseWizardSegment.initialize(new WizardDescriptor((WizardDescriptor.Iterator)new WizardDescriptor.ArrayIterator()));
            if (licenseWizardSegment.getIterator().current() == null) {
                licenseWizardSegment = null;
                showing = false;
            } else {
                WizardUtilities.runWizard((WizardSegment)licenseWizardSegment);
                showed = true;
            }
        }
        result = null;
        return showed;
    }

    public static boolean hasShown() {
        return LicenseWizard.getPrefs().getBoolean(PREF_SHOWN, false);
    }

    private static void setShown(boolean shown) {
        LicenseWizard.getPrefs().putBoolean(PREF_SHOWN, shown);
    }

    private static Preferences getPrefs() {
        return NbPreferences.forModule(LicenseWizard.class);
    }

    static {
        showing = false;
    }

    private static class LicenseWizardSegment
    extends AbstractWizardSegment {
        private final LicenseWizardIterator<WizardDescriptor> iterator = new LicenseWizardIterator();
        private final boolean offlineActivation;
        private final boolean loginOnly;

        public LicenseWizardSegment(int position, boolean offlineActivation, boolean loginOnly) {
            super(position);
            this.offlineActivation = offlineActivation;
            this.loginOnly = loginOnly;
        }

        public WizardDescriptor.Panel[] getPanels() {
            return this.iterator.getPanels();
        }

        public WizardDescriptor.Iterator getIterator() {
            return this.iterator;
        }

        public void initialize(WizardDescriptor descriptor) {
            showing = true;
            try {
                boolean noSelection = result == ProductSelectionResult.NO_SELECTION;
                LicenseManager licMan = LicenseManager.A();
                A licenseMode = licMan.A(false);
                descriptor.putProperty("licensing.no-selection", (Object)noSelection);
                descriptor.putProperty("licensing.key", (Object)licMan.C());
                descriptor.putProperty("licensing.install-hub-item", (Object)this.shouldInstallHubItem(licenseMode));
                if (noSelection) {
                    descriptor.putProperty("licensing.activation.offline", (Object)false);
                    descriptor.putProperty("licensing.licensed", (Object)licenseMode.B());
                    descriptor.putProperty("licensing.online", (Object)licenseMode.L());
                    descriptor.putProperty("licensing.login.only", (Object)false);
                    descriptor.putProperty("licensing.gateway-maltego-id", (Object)licenseMode.W());
                } else {
                    descriptor.putProperty("licensing.activation.offline", (Object)this.offlineActivation);
                    descriptor.putProperty("licensing.licensed", (Object)(this.offlineActivation || result == ProductSelectionResult.ACTIVATE ? 1 : 0));
                    descriptor.putProperty("licensing.online", (Object)(result == ProductSelectionResult.RUN_CE ? 1 : 0));
                    descriptor.putProperty("licensing.login.only", (Object)this.loginOnly);
                    descriptor.putProperty("licensing.gateway-maltego-id", (Object)(result == ProductSelectionResult.ACTIVATE_GATEWAY_MALTEGO_ID || result == ProductSelectionResult.SWITCH_ORG || result == ProductSelectionResult.OFFLINE_GATEWAY_MALTEGO_ID ? 1 : 0));
                    descriptor.putProperty("licensing.switch-org.maltegoId", (Object)(result == ProductSelectionResult.SWITCH_ORG ? 1 : 0));
                }
                this.iterator.initialize(descriptor);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public void handleCancel(WizardDescriptor descriptor) {
            super.handleCancel(descriptor);
            LicenseWizard.setShown(true);
            showing = false;
            boolean switchOrg = Boolean.TRUE.equals(descriptor.getProperty("licensing.switch-org.maltegoId"));
            if (switchOrg) {
                try {
                    CloudAuth.getDefault().reset();
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                LicenseManager licMan = LicenseManager.A();
                A licenseMode = licMan.A(false);
                if (licenseMode.L() || licenseMode.U()) {
                    if (StringUtilities.isNullOrEmpty((String)licMan.G(licenseMode))) {
                        licMan.C(false);
                        licMan.B(false);
                        licMan.H(false);
                        licMan.G(false);
                        licMan.I(false);
                        licMan.A(licenseMode);
                    }
                } else {
                    this.checkUnknown();
                }
            }
        }

        public void handleFinish(WizardDescriptor descriptor) {
            LicenseWizard.setShown(true);
            A oldMode = LicenseManager.A().A(false);
            String licenseKey = (String)descriptor.getProperty("licensing.key");
            boolean licensed = (Boolean)descriptor.getProperty("licensing.licensed");
            boolean freeOnline = (Boolean)descriptor.getProperty("licensing.online");
            boolean gatewayMaltegoId = (Boolean)descriptor.getProperty("licensing.gateway-maltego-id");
            LicenseManager licMan = LicenseManager.A();
            licMan.A(licenseKey);
            licMan.C(!licensed && !gatewayMaltegoId);
            licMan.B(freeOnline && !gatewayMaltegoId);
            licMan.H(gatewayMaltegoId);
            licMan.G(gatewayMaltegoId && this.offlineActivation);
            if (gatewayMaltegoId) {
                A licenseMode = LicenseManager.A().A(false);
                if (licenseMode != null && licenseMode.U() && licenseMode.X() != null) {
                    E capability = licenseMode.R().J();
                    com.paterva.maltego.licensing.free.A.B((long)capability.H());
                    com.paterva.maltego.licensing.free.A.A((long)capability.G());
                }
                licMan.I(false);
            } else if (licensed) {
                licMan.I(true);
            } else if (freeOnline) {
                licMan.I(false);
            }
            licMan.A(oldMode);
            showing = false;
            this.checkUnknown();
        }

        private void checkUnknown() {
            LicenseManager licMan = LicenseManager.A();
            A licenseMode = licMan.A(false);
            if (licenseMode.D()) {
                ((ProductSelectionAction)SystemAction.get(ProductSelectionAction.class)).actionPerformed(null);
            }
        }

        public String[] getContentPaneData() {
            return this.iterator.getContentData();
        }

        private boolean shouldInstallHubItem(A licenseMode) {
            if (result == ProductSelectionResult.ACTIVATE && !licenseMode.B() || result == ProductSelectionResult.ACTIVATE_GATEWAY_MALTEGO_ID && !licenseMode.W()) {
                return true;
            }
            HubSeeds seeds = HubSeedRegistry.getDefault().getSeeds(false);
            HubSeedSettings hubSeedSettings = HubSeedSettings.getDefault();
            return !seeds.getSeeds().stream().anyMatch(seed -> hubSeedSettings.isInstalled(seed));
        }
    }
}

