/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.finder.wizard;

import com.paterva.maltego.transform.descriptor.TransformSeed;
import com.paterva.maltego.transform.discovery.DiscoveryException;
import com.paterva.maltego.transform.discovery.DiscoveryResult;
import com.paterva.maltego.transform.discovery.ProgressCallback;
import com.paterva.maltego.transform.discovery.TransformFinder;
import com.paterva.maltego.transform.discovery.TransformServerDetail;
import com.paterva.maltego.transform.discovery.TransformServerFinder;
import com.paterva.maltego.transform.discovery.TransformServerListing;
import com.paterva.maltego.transform.discovery.TransformServerReference;
import com.paterva.maltego.transform.finder.DiscoverySettings;
import com.paterva.maltego.transform.finder.wizard.FailurePanel;
import com.paterva.maltego.transform.finder.wizard.ProgressHandleAdapter;
import com.paterva.maltego.transform.finder.wizard.UpdateFetchPanel;
import com.paterva.maltego.transform.finder.wizard.UpdateFetchText;
import com.paterva.maltego.transform.finder.wizard.UpdateTransformsFetchController;
import com.paterva.maltego.util.ui.dialog.PassFailProgressController;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.WizardDescriptor;
import org.openide.util.ImageUtilities;

public class InitialUpdateController
extends PassFailProgressController<DiscoveryResult<TransformServerListing>, UpdateFetchPanel, FailurePanel> {
    public InitialUpdateController() {
        this.setName("Download Data Sources");
        this.setDescription("A summary of the progress to fetch items from the chosen Data Sources is shown below.");
        this.setImage(ImageUtilities.loadImage((String)"com/paterva/maltego/transform/finder/wizard/TransformSeed.png".replace(".png", "48.png")));
    }

    protected DiscoveryResult<TransformServerListing> doProcessing(WizardDescriptor descriptor, ProgressHandle handle) throws DiscoveryException {
        TransformServerFinder transformServerFinder = TransformServerFinder.getDefault();
        TransformFinder transformFinder = TransformFinder.getDefault();
        ProgressHandleAdapter progress = new ProgressHandleAdapter(handle);
        TransformSeed[] selectedSeeds = (TransformSeed[])descriptor.getProperty("transformSeeds");
        if (selectedSeeds == null || selectedSeeds.length == 0) {
            return null;
        }
        DiscoveryResult references = transformServerFinder.findServers(selectedSeeds, (ProgressCallback)progress);
        Exception[] errors = references.getErrors();
        if (errors != null && errors.length > 0) {
            throw new DiscoveryException((Throwable)errors[0]);
        }
        if (references.getData() == null || ((TransformServerReference[])references.getData()).length == 0) {
            throw new DiscoveryException("No transforms were found");
        }
        descriptor.putProperty("transformReferences", (Object)references);
        DiscoveryResult details = transformServerFinder.getDetails((TransformServerReference[])references.getData(), (ProgressCallback)progress);
        if (details.getData() == null || ((TransformServerDetail[])details.getData()).length == 0) {
            throw new DiscoveryException("No transform servers could be contacted");
        }
        DiscoveryResult listings = transformFinder.listTransforms((TransformServerDetail[])details.getData(), (ProgressCallback)progress);
        if (listings.getData() == null || ((TransformServerListing[])listings.getData()).length == 0) {
            throw new DiscoveryException("No transform servers could be contacted");
        }
        descriptor.putProperty("transformListings", (Object)listings);
        return listings;
    }

    protected void storeSettings(WizardDescriptor settings) {
    }

    protected UpdateFetchPanel createPassComponent() {
        return new UpdateFetchPanel();
    }

    protected FailurePanel createFailComponent() {
        return new FailurePanel();
    }

    protected void pass(WizardDescriptor descriptor, UpdateFetchPanel component, DiscoveryResult<TransformServerListing> result) {
        if (result == null) {
            component.setNoSeeds();
        } else {
            UpdateFetchText urt = new UpdateFetchText();
            component.setText(urt.get((TransformServerListing[])result.getData()));
            component.setDuplicateTransforms(UpdateTransformsFetchController.getDuplicateTransforms((TransformServerListing[])result.getData()));
        }
        DiscoverySettings.setDiscoveryComplete(true);
    }

    protected void fail(FailurePanel component, Exception e) {
        if (e == null) {
            component.setError(null);
        } else {
            component.setError(e.getMessage());
        }
    }
}

