/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.nodes;

import com.paterva.maltego.transform.descriptor.Status;
import com.paterva.maltego.transform.descriptor.StatusItem;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformRepository;
import com.paterva.maltego.transform.descriptor.TransformRepositoryRegistry;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.descriptor.TransformServerRegistry;
import com.paterva.maltego.transform.manager.nodes.StatusItemNode;
import com.paterva.maltego.transform.manager.nodes.TransformNode;
import com.paterva.maltego.transform.manager.nodes.TransformProperties;
import com.paterva.maltego.util.repository.RepositoryEvent;
import com.paterva.maltego.util.repository.RepositoryListener;
import java.awt.Image;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.ImageUtilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.InstanceContent;

public class TasNode
extends StatusItemNode {
    public TasNode(TransformServerInfo tas) {
        this(tas, new InstanceContent());
    }

    private TasNode(TransformServerInfo tas, InstanceContent content) {
        super(Children.create((ChildFactory)new TasTransformChildFactory(tas), (boolean)false), (StatusItem)tas, content, true);
    }

    public Image getIcon(int type) {
        Image main = ImageUtilities.loadImage((String)"com/paterva/maltego/transform/manager/resources/TAS.png");
        Status status = this.getStatus();
        switch (status) {
            case Disabled: {
                Image disbaled = ImageUtilities.loadImage((String)"com/paterva/maltego/transform/manager/resources/Disabled10.png");
                return ImageUtilities.mergeImages((Image)main, (Image)disbaled, (int)6, (int)6);
            }
            case RequiresKey: {
                Image key = ImageUtilities.loadImage((String)"com/paterva/maltego/transform/manager/resources/Key10.png");
                return ImageUtilities.mergeImages((Image)main, (Image)key, (int)6, (int)6);
            }
        }
        return main;
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public boolean canDestroy() {
        return false;
    }

    public void destroy() throws IOException {
        TransformServerRegistry.getDefault().remove(((TransformServerInfo)this.getLookup().lookup(TransformServerInfo.class)).getUrl());
        super.destroy();
    }

    public Action[] getActions(boolean context) {
        return new SystemAction[0];
    }

    @Override
    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = sheet.get("properties");
        set.put((Node.Property)new TransformProperties.HubItems((Node)this));
        return sheet;
    }

    private static class TasTransformChildFactory
    extends ChildFactory<TransformDefinition>
    implements RepositoryListener {
        private TransformServerInfo _tas;

        public TasTransformChildFactory(TransformServerInfo tas) {
            this._tas = tas;
            TransformRepository repo = TransformRepositoryRegistry.getDefault().getRepository(this._tas.getDefaultRepository());
            repo.addRepositoryListener((RepositoryListener)WeakListeners.create(RepositoryListener.class, (EventListener)((Object)this), (Object)repo));
        }

        protected boolean createKeys(List<TransformDefinition> fill) {
            TransformRepositoryRegistry registry = TransformRepositoryRegistry.getDefault();
            TransformRepository remote = registry.getRepository(this._tas.getDefaultRepository());
            if (remote != null) {
                for (String name : this._tas.getTransforms()) {
                    TransformDefinition transform = remote.get(name);
                    if (transform == null) continue;
                    fill.add(transform);
                }
            }
            Collections.sort(fill, new Comparator<TransformDefinition>(){

                @Override
                public int compare(TransformDefinition o1, TransformDefinition o2) {
                    return o1.getDisplayName().compareTo(o2.getDisplayName());
                }
            });
            return true;
        }

        protected Node createNodeForKey(TransformDefinition key) {
            return new TransformNode.ReadOnly(key, false);
        }

        protected Node createWaitNode() {
            AbstractNode wait = new AbstractNode(Children.LEAF);
            wait.setDisplayName("Getting transforms...");
            return wait;
        }

        public void onItemAdded(RepositoryEvent evt) {
            this.refresh(true);
        }

        public void onItemChanged(RepositoryEvent evt) {
            this.refresh(true);
        }

        public void onItemRemoved(RepositoryEvent evt) {
            this.refresh(true);
        }
    }
}

