/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v3.api;

import com.maltego.tx3.java.api.execution.RunState;
import com.maltego.tx3.java.api.execution.TransformRunRequest;
import com.maltego.tx3.java.api.execution.TransformRunResponse;
import com.maltego.tx3.java.api.execution.TransformRunResult;
import com.maltego.tx3.java.api.execution.TransformRunStatus;
import com.paterva.maltego.transform.protocol.api.ProxyException;
import com.paterva.maltego.transform.protocol.v3.api.CallbackV3;
import com.paterva.maltego.transform.protocol.v3.api.TransformRunResultCache;
import com.paterva.maltego.transform.protocol.v3.api.proxy.V3HttpProxy;
import com.paterva.maltego.transform.runner.api.TraceContextId;
import com.paterva.maltego.transform.runner.api.TransformRunException;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import java.time.Instant;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class RemoteTransformRunnerV3 {
    private static final Logger LOG = Logger.getLogger(RemoteTransformRunnerV3.class.getName());
    private static final RequestProcessor PROCESSOR = new RequestProcessor("V3 Transform Server", 10, true);
    private static final long RESULT_CHECK_INTERMISSION_DURATION_MS = 1000L;
    private static final int EVENT_FETCH_SIZE = 50;
    private final String transformId;
    private final V3HttpProxy proxy;
    private final TransformRunRequest runRequest;
    private final String maltegoApiKey;
    private TransformRunResultCache resultCache;

    public RemoteTransformRunnerV3(String transformId, V3HttpProxy proxy, TransformRunRequest runRequest, String maltegoApiKey) {
        this.transformId = transformId;
        this.proxy = proxy;
        this.runRequest = runRequest;
        this.maltegoApiKey = maltegoApiKey;
    }

    public Cancellable run(CallbackV3 cb) {
        Runnable runnable = () -> {
            int currentEventPointer = 0;
            String runId = null;
            this.resultCache = new TransformRunResultCache();
            TraceContextId traceContextId = TraceContextId.create();
            try {
                LOG.log(Level.FINE, "Sending run request for: {0} with trace context id: {1}", new Object[]{this.transformId, traceContextId});
                TransformRunResponse runResponse = this.proxy.doTransform(this.transformId, this.runRequest, this.maltegoApiKey, traceContextId);
                TransformRunState runState = this.determineRunState(runResponse, cb, currentEventPointer);
                if (runState != TransformRunState.EMPTY_RESULTS) {
                    TransformRunResult runResult = runResponse.getResult();
                    runId = runResult.getRunId();
                    LOG.log(Level.INFO, "Transform run started for: {0} with run id: {1} [{2}] and trace context id: {3}", new Object[]{this.transformId, runId, runState.name(), traceContextId});
                    currentEventPointer = this.handleRunResponseAndIncrementEventPointer(runResponse, cb, runState, runId, currentEventPointer, traceContextId);
                    boolean cancelledByUser = cb.isCancelled();
                    while (!runState.isComplete() && !cancelledByUser) {
                        LOG.log(Level.FINE, "Fetching results for: {0} with run id: {1} [{2}] and trace context id: {3}", new Object[]{this.transformId, runId, runState.name(), traceContextId});
                        runResponse = this.proxy.getTransformResults(currentEventPointer, 50, this.transformId, runId, this.maltegoApiKey, traceContextId);
                        runState = this.determineRunState(runResponse, cb, currentEventPointer);
                        LOG.log(Level.FINE, "Results fetched for: {0} with run id: {1} [{2}] and trace context id: {3}", new Object[]{this.transformId, runId, runState.name(), traceContextId});
                        currentEventPointer = this.handleRunResponseAndIncrementEventPointer(runResponse, cb, runState, runId, currentEventPointer, traceContextId);
                        if (runState == TransformRunState.RUNNING_WAITING_FOR_RESULTS) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ex) {
                                break;
                            }
                        }
                        cancelledByUser = cb.isCancelled();
                    }
                } else {
                    this.handleRunResponseAndIncrementEventPointer(runResponse, cb, runState, runId, currentEventPointer, traceContextId);
                }
                if (runId != null) {
                    this.delete(runId, traceContextId);
                }
            }
            catch (Exception ex) {
                String errorMessage = runId != null ? String.format("An error ocurred during the execution of Transform: %s with Run ID: %s and trace context ID: %s", this.transformId, runId, traceContextId) : String.format("An error ocurred during the execution of Transform: %s and Trace Context ID: %s", this.transformId, traceContextId);
                LOG.log(Level.SEVERE, errorMessage);
                cb.exception(ex, Instant.now());
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                if (runId != null) {
                    this.delete(runId, traceContextId);
                }
            }
        };
        return PROCESSOR.post(runnable);
    }

    private void delete(String runId, TraceContextId traceContextId) {
        traceContextId = TraceContextId.resetSpanId((TraceContextId)traceContextId);
        try {
            LOG.log(Level.FINE, "Delete request sent for: {0} with run id: {1} and trace context id: {2}", new Object[]{this.transformId, runId, traceContextId});
            this.proxy.deleteTransformRun(this.transformId, runId, this.maltegoApiKey, traceContextId);
            LOG.log(Level.INFO, "Delete request success for: {0} with run id: {1} and trace context id: {2}", new Object[]{this.transformId, runId, traceContextId});
        }
        catch (ProxyException | TransformRunException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private int handleRunResponseAndIncrementEventPointer(TransformRunResponse response, CallbackV3 cb, TransformRunState runState, String runId, int currentEventPointer, TraceContextId traceContextId) throws TransformRunException, TypeInstantiationException {
        Instant responseTime = Instant.now();
        TransformRunResult result = response.getResult();
        traceContextId = TraceContextId.resetSpanId((TraceContextId)traceContextId);
        switch (runState) {
            case COMPLETED_WITH_RESULTS_AVAILABLE: 
            case RUNNING_WITH_RESULTS_AVAILABLE: {
                currentEventPointer += result.getEvents().size();
                cb.resultReceived(response, this.resultCache, this.transformId, runId, traceContextId);
                break;
            }
            case RUNNING_WAITING_FOR_RESULTS: {
                cb.resultReceived(response, this.resultCache, this.transformId, runId, traceContextId);
                break;
            }
            case CANCELLED: 
            case FAILED: 
            case COMPLETED: 
            case ENTITY_LIMIT_REACHED: 
            case EMPTY_RESULTS: {
                cb.resultReceived(response, this.resultCache, this.transformId, runId, traceContextId);
                cb.completed(this.resultCache.getAddedEntityCount(), responseTime);
            }
        }
        return currentEventPointer;
    }

    private TransformRunState determineRunState(TransformRunResponse response, CallbackV3 cb, int currentEventPointer) {
        TransformRunResult result = response.getResult();
        if (result == null) {
            return TransformRunState.EMPTY_RESULTS;
        }
        TransformRunStatus status = response.getStatus();
        boolean resultsAvailable = RemoteTransformRunnerV3.checkResultsAvailable(result, currentEventPointer);
        if (this.entityLimitReached(cb)) {
            return TransformRunState.ENTITY_LIMIT_REACHED;
        }
        if (RemoteTransformRunnerV3.isFailed(result) || RemoteTransformRunnerV3.statusContainsErrorCode(status)) {
            return TransformRunState.FAILED;
        }
        if (RemoteTransformRunnerV3.isCompleted(result) && (!resultsAvailable || result.getEvents().size() < 50)) {
            return TransformRunState.COMPLETED;
        }
        if (RemoteTransformRunnerV3.isCompleted(result) && resultsAvailable) {
            return TransformRunState.COMPLETED_WITH_RESULTS_AVAILABLE;
        }
        if (RemoteTransformRunnerV3.isRunning(result) && resultsAvailable) {
            return TransformRunState.RUNNING_WITH_RESULTS_AVAILABLE;
        }
        if (RemoteTransformRunnerV3.isRunning(result) && !resultsAvailable) {
            return TransformRunState.RUNNING_WAITING_FOR_RESULTS;
        }
        if (RemoteTransformRunnerV3.isCancelled(result)) {
            return TransformRunState.CANCELLED;
        }
        if (response.getResult() != null) {
            LOG.log(Level.WARNING, "Transform {0} with run id {1} reached a indeterminate state, this should never happen.", new Object[]{this.transformId, response.getResult().getRunId()});
        }
        return TransformRunState.RUNNING_WITH_RESULTS_AVAILABLE;
    }

    private static boolean statusContainsErrorCode(TransformRunStatus status) {
        int statusCode = status.getCode();
        return statusCode < 200 || statusCode > 209;
    }

    private static boolean isFailed(TransformRunResult result) {
        if (result == null) {
            return true;
        }
        return result.getState().equals((Object)RunState.FAILED);
    }

    private static boolean isRunning(TransformRunResult result) {
        return result.getState().equals((Object)RunState.INITIALIZED) || result.getState().equals((Object)RunState.RUNNING);
    }

    private static boolean isCompleted(TransformRunResult result) {
        return result.getState().equals((Object)RunState.COMPLETED);
    }

    private static boolean isCancelled(TransformRunResult result) {
        return result.getState().equals((Object)RunState.CANCELED);
    }

    private static boolean checkResultsAvailable(TransformRunResult result, long eventPointer) {
        return eventPointer < result.getEventCount();
    }

    private boolean entityLimitReached(CallbackV3 cb) {
        return cb.limitReached(this.resultCache.getAddedEntityCount());
    }

    static enum TransformRunState {
        EMPTY_RESULTS,
        RUNNING_WITH_RESULTS_AVAILABLE,
        RUNNING_WAITING_FOR_RESULTS,
        COMPLETED_WITH_RESULTS_AVAILABLE,
        FAILED,
        COMPLETED,
        CANCELLED,
        WAITING_FOR_PROMPT_RESPONSE,
        ENTITY_LIMIT_REACHED;


        public boolean isComplete() {
            return this == COMPLETED || this == CANCELLED || this == FAILED || this == EMPTY_RESULTS || this == ENTITY_LIMIT_REACHED;
        }
    }
}

