/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v3.api;

import com.maltego.tx3.java.api.execution.Entity;
import com.maltego.tx3.java.api.execution.Link;
import com.maltego.tx3.java.api.execution.StatusMessage;
import com.maltego.tx3.java.api.execution.TransformRunChoicePromptEvent;
import com.maltego.tx3.java.api.execution.TransformRunEntityEvent;
import com.maltego.tx3.java.api.execution.TransformRunInputPromptEvent;
import com.maltego.tx3.java.api.execution.TransformRunLinkEvent;
import com.maltego.tx3.java.api.execution.TransformRunMultiChoicePromptEvent;
import com.maltego.tx3.java.api.execution.TransformRunStatusMessageEvent;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.transform.protocol.v3.api.RemoteTransformAdapterV3;
import com.paterva.maltego.transform.protocol.v3.api.TransformRunResultPage;
import com.paterva.maltego.transform.protocol.v3.api.V3ProtocolTranslator;
import com.paterva.maltego.transform.protocol.v3.api.prompts.TransformPromptCallback;
import com.paterva.maltego.transform.protocol.v3.api.prompts.TransformPromptContext;
import com.paterva.maltego.transform.protocol.v3.api.prompts.TransformPromptHandler;
import com.paterva.maltego.transform.runner.api.TraceContextId;
import com.paterva.maltego.transform.runner.api.TransformResult;
import com.paterva.maltego.transform.runner.api.TransformRunContext;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import com.paterva.maltego.typing.types.DateTime;
import com.paterva.maltego.util.Args;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.openide.util.Lookup;

public class TransformRunResultProcessor {
    private static final Logger LOG = Logger.getLogger(RemoteTransformAdapterV3.class.getName());
    private final TransformRunContext ctx;
    private final DateTime transformRunDate = new DateTime();
    private final TransformRunResultPage page = new TransformRunResultPage();
    private final Set<Entity> addedEntities = new HashSet<Entity>();
    private final TransformPromptHandler promptHandler;
    private final String transformId;
    private final String runId;

    TransformRunResultProcessor(TransformRunContext ctx, String transformId, String runId) {
        this.ctx = ctx;
        this.ctx.getTransformsContext().disablePopupErrors();
        this.promptHandler = (TransformPromptHandler)Lookup.getDefault().lookup(TransformPromptHandler.class);
        this.transformId = transformId;
        this.runId = runId;
    }

    protected TransformRunResultPage done() {
        return this.page;
    }

    protected void handle(TransformRunEntityEvent entityEvent) throws TypeInstantiationException {
        switch (entityEvent.getEventType()) {
            case ADD: {
                this.handleEntityAdded(entityEvent.getEntity());
                break;
            }
            case UPDATE: {
                this.handleEntityUpdated(entityEvent.getEntity());
                break;
            }
            case DELETE: {
                this.handleEntityRemoved(entityEvent.getEntity());
                break;
            }
            default: {
                LOG.warning(String.format("%s is not supported at the moment", entityEvent.getEventType()));
            }
        }
    }

    protected void handle(TransformRunLinkEvent linkEvent) {
        switch (linkEvent.getEventType()) {
            case ADD: {
                this.handleLinkAdded(linkEvent.getLink());
                break;
            }
            case DELETE: {
                this.handleLinkDeleted(linkEvent.getLink());
                break;
            }
            default: {
                LOG.warning(String.format("%s is not supported at the moment", linkEvent.getEventType()));
            }
        }
    }

    protected void handle(TransformRunStatusMessageEvent messageEvent) {
        switch (messageEvent.getEventType()) {
            case ADD: {
                this.handleStatusMessageAdded(messageEvent.getStatusMessage());
                break;
            }
            default: {
                LOG.warning(String.format("%s is not supported at the moment", messageEvent.getEventType()));
            }
        }
    }

    protected void handle(TransformRunChoicePromptEvent choicePrompt, TransformPromptCallback promptCallback, TraceContextId traceContextId) {
        Args.notNull((Object)choicePrompt.getId(), (String)"id");
        Args.notNull((Object)choicePrompt.getMessage(), (String)"message");
        Args.notNullOrEmpty((Collection)choicePrompt.getOptions(), (String)"options");
        TransformPromptContext context = new TransformPromptContext(choicePrompt.getId(), this.ctx.getTransform().getDisplayName(), this.transformId, this.runId, traceContextId);
        this.promptHandler.process(choicePrompt, context, promptCallback);
    }

    protected void handle(TransformRunMultiChoicePromptEvent multiChoicePrompt, TransformPromptCallback promptCallback, TraceContextId traceContextId) {
        Args.notNull((Object)multiChoicePrompt.getId(), (String)"id");
        Args.notNull((Object)multiChoicePrompt.getMessage(), (String)"message");
        Args.notNullOrEmpty((Collection)multiChoicePrompt.getControls(), (String)"controls");
        TransformPromptContext context = new TransformPromptContext(multiChoicePrompt.getId(), this.ctx.getTransform().getDisplayName(), this.transformId, this.runId, traceContextId);
        this.promptHandler.process(multiChoicePrompt, context, promptCallback);
    }

    protected void handle(TransformRunInputPromptEvent inputPrompt, TransformPromptCallback promptCallback, TraceContextId traceContextId) {
        Args.notNull((Object)inputPrompt.getId(), (String)"id");
        Args.notNull((Object)inputPrompt.getMessage(), (String)"message");
        Args.notNullOrEmpty((Collection)inputPrompt.getInputs(), (String)"inputs");
        TransformPromptContext context = new TransformPromptContext(inputPrompt.getId(), this.ctx.getTransform().getDisplayName(), this.transformId, this.runId, traceContextId);
        this.promptHandler.process(inputPrompt, context, promptCallback);
    }

    private void handleStatusMessageAdded(StatusMessage statusMessage) {
        TransformResult result = null;
        switch (statusMessage.getType()) {
            case INFO: {
                result = TransformResult.info((String)statusMessage.getText(), (int)statusMessage.getProgress());
                break;
            }
            case WARNING: {
                result = TransformResult.warning((String)statusMessage.getText());
                break;
            }
            case ERROR: {
                result = TransformResult.nonInterruptingError((String)statusMessage.getText(), (int)statusMessage.getCode());
                break;
            }
            default: {
                LOG.warning(() -> "Unsupported status message type received: " + statusMessage.getState());
            }
        }
        if (result != null) {
            this.ctx.getCallback().resultReceived(result);
        }
    }

    private void handleEntityAdded(Entity entity) throws TypeInstantiationException {
        this.addedEntities.add(entity);
        EntityFactory factory = this.ctx.getEntityFactory();
        EntityRegistry entityRegistry = this.ctx.getEntityRegistry();
        MaltegoEntity maltegoEntity = V3ProtocolTranslator.translate(entity, factory, entityRegistry);
        this.page.addNewEntity(maltegoEntity);
    }

    private void handleEntityUpdated(Entity entity) {
        this.page.updateEntity(entity);
    }

    private void handleEntityRemoved(Entity entity) {
        EntityID entityId = EntityID.parse((String)entity.getId());
        this.page.deleteEntity(entityId);
    }

    private void handleLinkAdded(Link link) {
        MaltegoLink maltegoLink = V3ProtocolTranslator.translate(link, this.ctx.getLinkFactory(), this.ctx.getTransform(), this.transformRunDate);
        EntityID sourceEntityId = EntityID.parse((String)link.getSourceId());
        EntityID targetEntityId = EntityID.parse((String)link.getTargetId());
        if (maltegoLink.isReversed().booleanValue()) {
            this.page.addNewLink(maltegoLink, targetEntityId, sourceEntityId);
        } else {
            this.page.addNewLink(maltegoLink, sourceEntityId, targetEntityId);
        }
    }

    private void handleLinkDeleted(Link link) {
        LinkID linkId = LinkID.parse((String)link.getId());
        this.page.deleteLink(linkId);
    }

    public Set<Entity> getAddedEntities() {
        return this.addedEntities;
    }
}

