/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.common;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.RolloverActionListener;
import org.pushingpixels.flamingo.internal.ui.common.BasicCommandButtonUI;
import org.pushingpixels.flamingo.internal.utils.KeyTipRenderingUtilities;

public class BasicCommandMenuButtonUI
extends BasicCommandButtonUI {
    protected MouseListener rolloverMenuMouseListener;

    public static ComponentUI createUI(JComponent c) {
        return new BasicCommandMenuButtonUI();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.rolloverMenuMouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (BasicCommandMenuButtonUI.this.commandButton.isEnabled()) {
                    int modifiers = 0;
                    AWTEvent currentEvent = EventQueue.getCurrentEvent();
                    if (currentEvent instanceof InputEvent) {
                        modifiers = ((InputEvent)currentEvent).getModifiers();
                    } else if (currentEvent instanceof ActionEvent) {
                        modifiers = ((ActionEvent)currentEvent).getModifiers();
                    }
                    BasicCommandMenuButtonUI.this.fireRolloverActionPerformed(new ActionEvent(this, 1001, BasicCommandMenuButtonUI.this.commandButton.getActionModel().getActionCommand(), EventQueue.getMostRecentEventTime(), modifiers));
                    BasicCommandMenuButtonUI.this.processPopupAction();
                }
            }
        };
        this.commandButton.addMouseListener(this.rolloverMenuMouseListener);
    }

    @Override
    protected void uninstallListeners() {
        this.commandButton.removeMouseListener(this.rolloverMenuMouseListener);
        this.rolloverMenuMouseListener = null;
        super.uninstallListeners();
    }

    protected void fireRolloverActionPerformed(ActionEvent e) {
        RolloverActionListener[] listeners = (RolloverActionListener[])this.commandButton.getListeners(RolloverActionListener.class);
        for (int i = listeners.length - 1; i >= 0; --i) {
            listeners[i].actionPerformed(e);
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        JCommandMenuButton menuButton = (JCommandMenuButton)c;
        super.update(g, c);
        KeyTipRenderingUtilities.renderMenuButtonKeyTips(g, menuButton, this.layoutManager);
    }
}

