/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.graph.state;

import com.paterva.maltego.chatapi.conn.ConnectionException;
import com.paterva.maltego.chatapi.conn.ConnectionHandler;
import com.paterva.maltego.chatapi.conn.ConnectionInfo;
import com.paterva.maltego.chatapi.conn.ConnectionInitiationCallback;
import com.paterva.maltego.chatapi.conn.ConnectionStatus;
import com.paterva.maltego.chatapi.conn.ConnectionStatusEvent;
import com.paterva.maltego.chatapi.conn.ConnectionStatusListener;
import com.paterva.maltego.chatapi.msg.LogMessageLevel;
import com.paterva.maltego.collab.CollaborationException;
import com.paterva.maltego.collab.Participant;
import com.paterva.maltego.collab.ParticipantEvent;
import com.paterva.maltego.collab.ParticipantPresence;
import com.paterva.maltego.collab.PayloadCollection;
import com.paterva.maltego.collab.RxHandler;
import com.paterva.maltego.collab.TxHandler;
import com.paterva.maltego.collab.graph.GraphProvider;
import com.paterva.maltego.collab.graph.GraphSnapshot;
import com.paterva.maltego.collab.graph.state.AbstractConnectionState;
import com.paterva.maltego.collab.graph.state.AbstractStateMachine;
import com.paterva.maltego.collab.graph.state.ParticipantPool;
import com.paterva.maltego.collab.graph.state.RxQueue;
import com.paterva.maltego.collab.graph.state.StateBlocked;
import com.paterva.maltego.collab.graph.state.StateConnected;
import com.paterva.maltego.collab.graph.state.StateDisconnecting;
import com.paterva.maltego.collab.graph.state.StateInitSession;
import com.paterva.maltego.collab.graph.state.StateNew;
import com.paterva.maltego.collab.graph.state.StateOffline;
import com.paterva.maltego.collab.graph.state.TxQueue;
import com.paterva.maltego.collab.session.CollaborationMessageListener;
import com.paterva.maltego.collab.session.CollaborationParticipantListener;
import com.paterva.maltego.collab.session.CollaborationPayloadListener;
import com.paterva.maltego.collab.session.CollaborationSession;
import com.paterva.maltego.collab.session.CollaborationSessionInfo;
import com.paterva.maltego.collab.session.CollaborationSessionListener;
import com.paterva.maltego.collab.session.CollaborationSessionManager;
import com.paterva.maltego.collab.session.SessionID;
import com.paterva.maltego.collab.session.SessionIDListener;
import com.paterva.maltego.util.NormalException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Utilities;

public class ConnectionController
extends AbstractStateMachine<AbstractConnectionState, ConnectionException>
implements TxHandler,
ConnectionHandler {
    private static final Logger LOG = Logger.getLogger(ConnectionController.class.getName());
    private CollaborationSession _session;
    private CollaborationSessionInfo _info;
    private RxHandler _rx;
    private final TxHandler _tx;
    private final LinkedList<ConnectionStatusListener> _listeners = new LinkedList();
    private final LinkedList<SessionIDListener> _sessionIdlisteners = new LinkedList();
    private ConnectionStatus _status = ConnectionStatus.None;
    private AbstractConnectionState _initialState;
    private GraphProvider _graphProvider;
    private final RxQueue _liveQueue;
    private final RxQueue _historyQueue;
    private final TxQueue _localQueue;
    private String _lastTransactionID = null;
    private final GraphProvider EMPTY_GRAPH_PROVIDER = new EmptyGraphProvider();
    private boolean _reconnect;
    private SessionID _sessionID;
    private volatile boolean _wasManualDisconnect = false;
    private MessageListener _msgListener;

    public ConnectionController() {
        super(new StateNew());
        this._tx = new SessionAdapter();
        this._liveQueue = new RxQueue();
        this._historyQueue = new RxQueue();
        this._localQueue = new TxQueue();
        this._graphProvider = this.EMPTY_GRAPH_PROVIDER;
    }

    public void setRxHandler(RxHandler delegate) {
        this._rx = new TransactionRecorder(delegate);
    }

    public RxHandler getRxHandler() {
        return this._rx;
    }

    public synchronized void setGraphProvider(GraphProvider graphProvider) {
        this._graphProvider = graphProvider;
    }

    public synchronized GraphProvider getGraphProvider() {
        return this._graphProvider;
    }

    public void connect(ConnectionInfo info, ConnectionInitiationCallback cb) throws ConnectionException {
        if (this.getConnectionStatus() == ConnectionStatus.None) {
            this._reconnect = false;
            this._info = (CollaborationSessionInfo)info;
            this._initialState = new StateNew();
            this.createNewSession(cb);
            this.run(new StateInitSession(), cb);
            if (cb.isCancelled()) {
                this.closeSessionSafely();
            }
        } else {
            throw new IllegalStateException("Connect can only be called when no connection has been established");
        }
    }

    public void reconnect(ConnectionInitiationCallback cb) throws ConnectionException {
        if (this.getConnectionStatus() == ConnectionStatus.Offline) {
            this._reconnect = true;
            this._initialState = new StateOffline();
            this.createNewSession(cb);
            this.run(new StateInitSession(), cb);
            if (cb.isCancelled()) {
                this.closeSessionSafely();
            }
        } else {
            throw new IllegalStateException("Connect can only be called when offline");
        }
    }

    private void createNewSession(ConnectionInitiationCallback cb) throws ConnectionException {
        if (this._session != null) {
            this._session.removeCollaborationMessageListener(this._msgListener);
            this._msgListener = null;
        }
        this._session = this.createSession(cb);
        if (this._session != null) {
            this._msgListener = new MessageListener();
            this._session.addCollaborationMessageListener(this._msgListener);
        }
    }

    AbstractConnectionState getInitialState() {
        return this._initialState;
    }

    public void disconnect() throws ConnectionException {
        if (!ConnectionStatus.isConnected((ConnectionStatus)this.getConnectionStatus())) {
            throw new IllegalStateException("Disconnect can only be called when connected");
        }
        this.run(new StateDisconnecting(), new EmptyCallback());
    }

    public void setBlocked(boolean blocked) throws ConnectionException {
        if (blocked && this._status == ConnectionStatus.Connected) {
            this.run(new StateBlocked(), new EmptyCallback());
        } else if (!blocked && this._status == ConnectionStatus.Blocked) {
            this.run(new StateConnected(), new EmptyCallback());
        }
    }

    public ConnectionStatus getConnectionStatus() {
        return this._status;
    }

    private void fireConnectionStatusChanged(ConnectionStatus old, ConnectionStatus status) {
        LOG.fine(String.format("** %s -> %s", old, status));
        if (status == ConnectionStatus.Connected) {
            this.setWasManualDisconnect(false);
        }
        ConnectionStatusEvent evt = new ConnectionStatusEvent(old, status);
        if (this._sessionID != null) {
            evt.setSessionCreatorID(this._sessionID.getCreatorID());
            evt.setSessionStartDate(this._sessionID.getStartTime());
        }
        for (ConnectionStatusListener listener : this._listeners) {
            listener.statusChanged(evt);
        }
    }

    private void fireSessionIDChanged(SessionID oldSessionID, SessionID newSessionID) {
        for (SessionIDListener sessionIDListener : this._sessionIdlisteners) {
            sessionIDListener.sessionIDChanged(newSessionID);
        }
    }

    private void setConnectionStatus(ConnectionStatus status) {
        if (this._status != status) {
            ConnectionStatus old = this._status;
            this._status = status;
            if (this._status == ConnectionStatus.Connected) {
                this._initialState = new StateOffline();
            }
            this.fireConnectionStatusChanged(old, status);
        }
    }

    @Override
    protected void onStateChanged(AbstractConnectionState previous, AbstractConnectionState current) {
        this.setConnectionStatus(current.getConnectionStatus());
    }

    public void addConnectionStatusListener(ConnectionStatusListener listener) {
        this._listeners.add(listener);
    }

    public void removeConnectionStatusListener(ConnectionStatusListener listener) {
        this._listeners.remove(listener);
    }

    public void addSessionIDListener(SessionIDListener listener) {
        this._sessionIdlisteners.add(listener);
    }

    public void removeSessionIDListener(SessionIDListener listener) {
        this._sessionIdlisteners.remove(listener);
    }

    @Override
    public void updateStatus(ParticipantPresence presence, String message) throws CollaborationException {
        ((AbstractConnectionState)this.getCurrentState()).updateStatus(presence, message);
    }

    @Override
    public void sendPayload(String to, String xml) throws CollaborationException {
        ((AbstractConnectionState)this.getCurrentState()).sendPayload(to, xml);
    }

    private void handleServerEvent(PayloadCollection payloads) {
        try {
            ((AbstractConnectionState)this.getCurrentState()).payloadsReceived(payloads);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void handleSessionDropped(Exception e) {
        ((AbstractConnectionState)this.getCurrentState()).sessionDropped(e);
    }

    private void handleSessionIDChange(SessionID id) {
        ((AbstractConnectionState)this.getCurrentState()).sessionIDChanged(id);
    }

    private void handleParticipantEvent(ParticipantEvent e) {
        try {
            ((AbstractConnectionState)this.getCurrentState()).participantEventReceived(e);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    private CollaborationSession createSession(ConnectionInitiationCallback cb) throws ConnectionException {
        CollaborationSession session;
        if (this._info == null) {
            throw new ConnectionException("Reconnect can only be called after the initial session has been established", false);
        }
        CollaborationSessionManager factory = CollaborationSessionManager.getDefault();
        try {
            session = factory.createSession(this._info, cb);
        }
        catch (CollaborationException ex) {
            throw new ConnectionException((NormalException)ex);
        }
        PayloadListener payloadListener = new PayloadListener();
        session.addPayloadListener("*", payloadListener);
        session.addParticipantListener(new ParticipantListener());
        session.addSessionListener(new SessionListener());
        return session;
    }

    void openSession(ConnectionInitiationCallback cb) throws CollaborationException {
        if (((AbstractConnectionState)this.getCurrentState()).getConnectionStatus() != ConnectionStatus.Connecting) {
            throw new IllegalStateException("Init session can only be called from the connecting state");
        }
        CollaborationSessionManager factory = CollaborationSessionManager.getDefault();
        factory.openSession(this._session, cb);
    }

    void configureSession(ConnectionInitiationCallback cb) throws CollaborationException {
        if (((AbstractConnectionState)this.getCurrentState()).getConnectionStatus() != ConnectionStatus.Connecting) {
            throw new IllegalStateException("Configure session can only be called from the connecting state");
        }
        CollaborationSessionManager factory = CollaborationSessionManager.getDefault();
        factory.configureSession(this._session, cb);
    }

    void sendSessionID(ConnectionInitiationCallback cb) throws CollaborationException {
        if (((AbstractConnectionState)this.getCurrentState()).getConnectionStatus() != ConnectionStatus.Connecting) {
            throw new IllegalStateException("Session ID can only be sent from the connecting state");
        }
        CollaborationSessionManager factory = CollaborationSessionManager.getDefault();
        String sessionID = this._sessionID != null ? this._sessionID.getID() : SessionID.createRandomID();
        factory.sendSessionID(this._session, sessionID, cb);
    }

    void closeSession() throws CollaborationException {
        if (((AbstractConnectionState)this.getCurrentState()).getConnectionStatus() != ConnectionStatus.Disconnecting) {
            throw new IllegalStateException("Init session can only be called from the connecting state");
        }
        CollaborationSessionManager factory = CollaborationSessionManager.getDefault();
        factory.closeSession(this._session);
    }

    private void closeSessionSafely() {
        if (this._session != null) {
            try {
                this.setWasManualDisconnect(true);
                if (((AbstractConnectionState)this.getCurrentState()).getConnectionStatus() != ConnectionStatus.Disconnecting) {
                    CollaborationSessionManager factory = CollaborationSessionManager.getDefault();
                    factory.closeSession(this._session);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public SessionID getSessionID() {
        return this._sessionID;
    }

    public void setSessionID(SessionID id) {
        if (!Utilities.compareObjects((Object)this._sessionID, (Object)id)) {
            SessionID oldSessionID = this._sessionID;
            this._sessionID = id;
            this.fireSessionIDChanged(oldSessionID, this._sessionID);
        }
    }

    public CollaborationSessionInfo getSessionInfo() {
        return this._info;
    }

    TxHandler getTxHandler() {
        return this._tx;
    }

    TxQueue getLocalQueue() {
        return this._localQueue;
    }

    ParticipantPool getParticipants() {
        return new ParticipantPool(this._session.getOtherParticipants());
    }

    RxQueue getLiveQueue() {
        return this._liveQueue;
    }

    RxQueue getHistoryQueue() {
        return this._historyQueue;
    }

    String getLastAppliedTransactionID() {
        return this._lastTransactionID;
    }

    boolean isReconnect() {
        return this._reconnect;
    }

    Participant getMe() {
        return this._session.getMe();
    }

    public boolean wasManualDisconnect() {
        return this._wasManualDisconnect;
    }

    public void setWasManualDisconnect(boolean wasManualDisconnect) {
        this._wasManualDisconnect = wasManualDisconnect;
    }

    public boolean isDebugMode() {
        return this._info != null ? this._info.isDebugSession() : false;
    }

    public boolean isKeyValid() {
        return this._session.isKeyValid();
    }

    public boolean isVersionValid() {
        return this._session.isVersionValid();
    }

    @Override
    protected void handleException(Exception e) {
        if (e instanceof ConnectionException) {
            this.handleError((ConnectionException)((Object)e), new StateDisconnecting());
        } else {
            this.handleError(new ConnectionException((Throwable)e, true), new StateDisconnecting());
        }
    }

    private class MessageListener
    implements CollaborationMessageListener {
        private MessageListener() {
        }

        @Override
        public void message(LogMessageLevel level, String message) {
            ((AbstractConnectionState)ConnectionController.this.getCurrentState()).showMessage(level, message);
        }
    }

    private static class EmptyCallback
    implements ConnectionInitiationCallback {
        private EmptyCallback() {
        }

        public void progress(LogMessageLevel level, String message, int percent) {
        }

        public void progress(LogMessageLevel level, String message) {
        }

        public boolean isCancelled() {
            return false;
        }

        public void debug(String message) {
            LOG.fine(message);
        }
    }

    private class PayloadListener
    implements CollaborationPayloadListener {
        private PayloadListener() {
        }

        @Override
        public void payloadReceived(PayloadCollection payloads) {
            ConnectionController.this.handleServerEvent(payloads);
        }
    }

    private class TransactionRecorder
    implements RxHandler {
        private final RxHandler _delegate;

        public TransactionRecorder(RxHandler delegate) {
            this._delegate = delegate;
        }

        @Override
        public void payloadsReceived(PayloadCollection payloads) throws CollaborationException {
            if (!payloads.isEmpty()) {
                ConnectionController.this._lastTransactionID = payloads.last().getID();
                this._delegate.payloadsReceived(payloads);
            }
        }

        @Override
        public void participantEventReceived(ParticipantEvent event) throws CollaborationException {
            this._delegate.participantEventReceived(event);
        }

        @Override
        public void showMessage(LogMessageLevel level, String message) {
            this._delegate.showMessage(level, message);
        }
    }

    private class SessionListener
    implements CollaborationSessionListener {
        private SessionListener() {
        }

        @Override
        public void connectionDropped(Exception e) {
            LOG.log(Level.FINE, "Connection dropped {0}", e);
            ConnectionController.this.handleSessionDropped(e);
        }

        @Override
        public void sessionIDChanged(SessionID id) {
            ConnectionController.this.handleSessionIDChange(id);
        }
    }

    private class SessionAdapter
    implements TxHandler {
        private SessionAdapter() {
        }

        @Override
        public void sendPayload(String to, String xml) throws CollaborationException {
            ConnectionController.this._session.sendPayloadXml(to, xml);
        }

        @Override
        public void updateStatus(ParticipantPresence presence, String message) throws CollaborationException {
            ConnectionController.this._session.updateStatus(presence, message);
        }
    }

    private class ParticipantListener
    implements CollaborationParticipantListener {
        private ParticipantListener() {
        }

        @Override
        public void participantEventReceived(ParticipantEvent evt) {
            ConnectionController.this.handleParticipantEvent(evt);
        }
    }

    private static class EmptyGraphProvider
    implements GraphProvider {
        private EmptyGraphProvider() {
        }

        @Override
        public boolean hasGraph() {
            return false;
        }

        @Override
        public GraphSnapshot createSnapshot() {
            throw new UnsupportedOperationException("Not supported on non-existent graph.");
        }

        @Override
        public void merge(PayloadCollection payloads) {
            throw new UnsupportedOperationException("Not supported on non-existent graph.");
        }

        @Override
        public void replace(PayloadCollection payloads) {
            throw new UnsupportedOperationException("Not supported on non-existent graph.");
        }

        @Override
        public void sendInitialGraph() {
            throw new UnsupportedOperationException("Not supported on non-existent graph.");
        }

        @Override
        public void addToResolverQueue(Collection<String> transactions) {
            throw new UnsupportedOperationException("Not supported on non-existent graph.");
        }

        @Override
        public void resetResolver() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

