/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.tx3.java.api.execution;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.maltego.tx3.java.api.execution.Entity;
import com.maltego.tx3.java.api.execution.Graph;
import com.maltego.tx3.java.api.execution.Metadata;
import com.maltego.tx3.java.api.execution.TransformRunExecutionContext;
import com.maltego.tx3.java.api.execution.TransformRunInput;
import com.maltego.tx3.java.api.execution.TransformRunSetting;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TransformRunRequest {
    private final TransformRunInput input;
    private final int limit;
    private final List<TransformRunSetting> transformSettings;
    private final TransformRunExecutionContext runExecutionContext;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public TransformRunRequest(@JsonProperty(value="input") TransformRunInput input, @JsonProperty(value="limit") int limits, @JsonProperty(value="transformSettings") List<TransformRunSetting> transformSettings, @JsonProperty(value="runExecutionContext") TransformRunExecutionContext runExecutionContext) {
        this.input = input;
        this.limit = limits;
        this.transformSettings = null == transformSettings ? new ArrayList<TransformRunSetting>() : transformSettings;
        this.runExecutionContext = runExecutionContext;
    }

    public TransformRunInput getInput() {
        return this.input;
    }

    public int getLimit() {
        return this.limit;
    }

    public List<TransformRunSetting> getTransformSettings() {
        return this.transformSettings;
    }

    public TransformRunExecutionContext getTransformRunExecutionContext() {
        return this.runExecutionContext;
    }

    public static RequestBuilder builder(Graph graph) {
        return new RequestBuilder(graph);
    }

    public static RequestBuilder builder(List<Entity> entities) {
        return new RequestBuilder(entities);
    }

    public static class RequestBuilder {
        private final TransformRunInput input;
        private int limits = 12;
        private List<TransformRunSetting> settings = new ArrayList<TransformRunSetting>();
        private TransformRunExecutionContext runContext;

        public RequestBuilder(Graph graph) {
            Metadata metadata = new Metadata(graph.getEntityTypesStat(), graph.getEntityCount(), graph.getLinkCount(), graph.getRootEntityCount());
            this.input = new TransformRunInput(metadata, graph);
        }

        public RequestBuilder(List<Entity> entities) {
            Graph graph = new Graph(entities);
            Metadata metadata = new Metadata(graph.getEntityTypesStat(), graph.getEntityCount(), graph.getLinkCount(), graph.getRootEntityCount());
            this.input = new TransformRunInput(metadata, graph);
        }

        public RequestBuilder limits(int limits) {
            this.limits = limits;
            return this;
        }

        public RequestBuilder settings(List<TransformRunSetting> settings) {
            this.settings = settings;
            return this;
        }

        public RequestBuilder runContext(TransformRunExecutionContext runContext) {
            this.runContext = runContext;
            return this;
        }

        public TransformRunRequest build() {
            return new TransformRunRequest(this.input, this.limits, this.settings, this.runContext);
        }
    }
}

