/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.core;

import com.paterva.maltego.core.GenericPart;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import java.awt.Color;
import org.openide.util.Utilities;

public class GenericLink
extends GenericPart<LinkID>
implements MaltegoLink {
    private String _propNameShowLabel;
    private String _propNameColor;
    private String _propNameStyle;
    private String _propNameThickness;
    private Boolean _reversed;

    public GenericLink(LinkID id) {
        super(id);
    }

    public GenericLink(LinkID id, String type) {
        super(id, type);
    }

    public GenericLink(LinkID id, String type, PropertyDescriptorCollection collection) {
        super(id, type, collection);
    }

    public GenericLink(MaltegoLink link) {
        super(link);
        if (link instanceof GenericLink) {
            GenericLink original = (GenericLink)link;
            this._propNameShowLabel = original._propNameShowLabel;
            this._propNameColor = original._propNameColor;
            this._propNameStyle = original._propNameStyle;
            this._propNameThickness = original._propNameThickness;
            this._reversed = original._reversed;
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        return this.createClone();
    }

    @Override
    public GenericLink createCopy() {
        return this.createCopy(LinkID.create());
    }

    public GenericLink createCopy(LinkID id) {
        GenericLink link = new GenericLink(this);
        link.setId(id);
        return link;
    }

    @Override
    public GenericLink createClone() {
        return new GenericLink(this);
    }

    @Override
    public boolean isCopy(MaltegoPart<LinkID> part) {
        if (part instanceof GenericLink) {
            GenericLink genericLink = (GenericLink)part;
            if (!Utilities.compareObjects((Object)this._reversed, (Object)genericLink._reversed)) {
                return false;
            }
        } else {
            return false;
        }
        return super.isCopy(part);
    }

    @Override
    public PropertyDescriptor getShowLabelProperty() {
        return this.getSpecialProperty(this._propNameShowLabel);
    }

    @Override
    public void setShowLabelProperty(PropertyDescriptor property) {
        boolean mustFire;
        if (property == null) {
            mustFire = this._propNameShowLabel != null;
            this._propNameShowLabel = null;
        } else {
            mustFire = !property.getName().equals(this._propNameShowLabel);
            this._propNameShowLabel = property.getName();
        }
        if (mustFire) {
            this.firePropertyChange("show-label");
        }
    }

    @Override
    public int getShowLabel() {
        Object value = this.getSpecialPropertyValue(this._propNameShowLabel);
        return value != null ? (Integer)value : 0;
    }

    @Override
    public void setShowLabel(int value) {
        if (this._propNameShowLabel == null) {
            this._propNameShowLabel = "show-label";
        }
        if (value >= 0 && value < MaltegoLink.ShowLabel.length) {
            this.setSpecialPropertyValue(this._propNameShowLabel, value);
        }
    }

    @Override
    public PropertyDescriptor getColorProperty() {
        return this.getSpecialProperty(this._propNameColor);
    }

    @Override
    public void setColorProperty(PropertyDescriptor property) {
        boolean mustFire;
        if (property == null) {
            mustFire = this._propNameColor != null;
            this._propNameColor = null;
        } else {
            mustFire = !property.getName().equals(this._propNameColor);
            this._propNameColor = property.getName();
        }
        if (mustFire) {
            this.firePropertyChange("color");
        }
    }

    @Override
    public Color getColor() {
        Color color = (Color)this.getSpecialPropertyValue(this._propNameColor);
        return color;
    }

    @Override
    public void setColor(Color value) {
        if (this._propNameColor == null) {
            this._propNameColor = "color";
        }
        this.setSpecialPropertyValue(this._propNameColor, value);
    }

    @Override
    public PropertyDescriptor getStyleProperty() {
        return this.getSpecialProperty(this._propNameStyle);
    }

    @Override
    public void setStyleProperty(PropertyDescriptor property) {
        boolean mustFire;
        if (property == null) {
            mustFire = this._propNameStyle != null;
            this._propNameStyle = null;
        } else {
            mustFire = !property.getName().equals(this._propNameStyle);
            this._propNameStyle = property.getName();
        }
        if (mustFire) {
            this.firePropertyChange("style");
        }
    }

    @Override
    public Integer getStyle() {
        return (Integer)this.getSpecialPropertyValue(this._propNameStyle);
    }

    @Override
    public void setStyle(Integer value) {
        if (this._propNameStyle == null) {
            this._propNameStyle = "style";
        }
        this.setSpecialPropertyValue(this._propNameStyle, value);
    }

    @Override
    public PropertyDescriptor getThicknessProperty() {
        return this.getSpecialProperty(this._propNameThickness);
    }

    @Override
    public void setThicknessProperty(PropertyDescriptor property) {
        boolean mustFire;
        if (property == null) {
            mustFire = this._propNameThickness != null;
            this._propNameThickness = null;
        } else {
            mustFire = !property.getName().equals(this._propNameThickness);
            this._propNameThickness = property.getName();
        }
        if (mustFire) {
            this.firePropertyChange("thickness");
        }
    }

    @Override
    public Integer getThickness() {
        return (Integer)this.getSpecialPropertyValue(this._propNameThickness);
    }

    @Override
    public void setThickness(Integer value) {
        if (this._propNameThickness == null) {
            this._propNameThickness = "thickness";
        }
        this.setSpecialPropertyValue(this._propNameThickness, value);
    }

    @Override
    public Boolean isReversed() {
        return this._reversed;
    }

    @Override
    public void setReversed(Boolean wasReversed) {
        this._reversed = wasReversed;
    }
}

