


(define (read-file-name)
  (let skip ((c (peek-char)))
    (if (char-whitespace? c) (begin (read-char) (skip (peek-char)))))
  (list->string 
   (let loop ((c (read-char)))
    (if (or (eof-object? c) (char=? c #\newline) (char-whitespace? c))
	'()
	(cons c (loop (read-char)))))))


(define (run-mpc)
  (display "File: ")
  (let ((name (read-file-name)))
    (display name) (newline)
    (parse-file name)))

(mload "mpc.scm")
(run-mpc)
(exit)
