---
name: Adapter Removal
url: https://github.com/mikkelschubert/adapterremoval
description: >
  Removes adapter sequences and trims low quality bases from the 3' end of reads.
  Overlapping paired-ended reads can be merged into consensus sequences
  and adapter sequence can be found for paired-ended data if not known.
---

This program searches for and removes remnant adapter sequences from High-Throughput
Sequencing (HTS) data and (optionally) trims low quality bases from the 3' end of
reads following adapter removal. AdapterRemoval can analyze both single end and
paired end data, and can be used to merge overlapping paired-ended reads into
(longer) consensus sequences. Additionally, the AdapterRemoval may be used to
recover a consensus adapter sequence for paired-ended data, for which this
information is not available.

The adapterRemoval module parses `*.settings` logs generated by
[Adapter Removal](https://github.com/mikkelschubert/adapterremoval),
a tool for rapid adapter trimming, identification, and read merging.

supported setting file results:

- `single end`
- `paired end noncollapsed`
- `paired end collapsed`
