/*
 * Decompiled with CFR 0.152.
 */
package ork.plugins;

import cqure.repeng.ReportObject;
import cqure.repeng.ReportTree;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import ork.Account;
import ork.CommonValuesDB;
import ork.Logger;
import ork.OracleDBConnection;
import ork.ScannerConfig;
import ork.ServerResult;
import ork.plugins.PluginHelper;
import ork.plugins.PluginIface;

public class GetPrivilegesForAccounts
implements PluginIface {
    private CommonValuesDB m_oDB;
    private ServerResult m_oRes = null;
    private Logger m_oLogger = new Logger();
    private String m_sServer = null;
    private String m_sSID = null;
    private int m_nPort = -1;
    private ScannerConfig m_oConfig = null;
    private ReportTree m_oTree = null;

    public void setCommonValuesDB(CommonValuesDB oDB) {
        this.m_oDB = oDB;
    }

    public void setServerResult(ServerResult oRes) {
        this.m_oRes = oRes;
    }

    public void setLogger(Logger oLogger) {
        this.m_oLogger = oLogger;
    }

    public void setParameters(Object o) {
    }

    public void setConfig(ScannerConfig o) {
        this.m_oConfig = o;
    }

    public void setReportTree(ReportTree o) {
        this.m_oTree = o;
    }

    public GetPrivilegesForAccounts(ServerResult oRes) {
        this.m_oRes = oRes;
        this.m_nPort = this.m_oRes.getPort();
        this.m_sServer = this.m_oRes.getServer();
    }

    private boolean getAccountPrivilegesAsAdmin(String sSID) {
        PluginHelper oHelper = new PluginHelper(this.m_oRes, this.m_oLogger, this.m_oTree);
        String sSQL = "SELECT grantee, granted_role from dba_role_privs ORDER BY grantee";
        OracleDBConnection oDBConn = null;
        Connection oConn = null;
        Statement oStmt = null;
        ResultSet oRs = null;
        ReportObject oRo = null;
        String sPath = null;
        String sPrivs = null;
        String sRole = null;
        Vector oAccountVector = null;
        boolean bDone = false;
        Account oA = null;
        Vector<String> oRoleVec = null;
        oAccountVector = this.m_oRes.getAccountList().getOpenAccountsForSID(sSID);
        if (oAccountVector == null) {
            return false;
        }
        int i = 0;
        while (i < oAccountVector.size()) {
            block12: {
                oA = (Account)oAccountVector.get(i);
                oDBConn = new OracleDBConnection(this.m_sServer, this.m_nPort, sSID);
                this.m_oLogger.debug("[-] GetPrivilegesForAccounts() user:" + oA.getUsername() + ",pw:" + oA.getPassword() + ", sid: " + sSID);
                oDBConn.setUser(oA.getUsername());
                oDBConn.setPassword(oA.getPassword());
                oDBConn.login();
                oConn = oDBConn.getConnection();
                if (oConn == null) {
                    this.m_oLogger.debug("[x] getAccountRolesAsAdmin(\"" + sSID + "\") failed to connect.");
                } else {
                    try {
                        oStmt = oConn.createStatement();
                        oRs = oStmt.executeQuery(sSQL);
                        oRoleVec = new Vector<String>();
                        while (oRs != null && oRs.next()) {
                            sPath = String.valueOf(this.m_sServer) + "/" + sSID + "/Accounts/" + oRs.getString("grantee");
                            sRole = oRs.getString("granted_role");
                            oRo = this.m_oTree.findReportItem(sPath);
                            if (oRo != null) {
                                sPrivs = (String)oRo.getProperty("Privileges");
                                sPrivs = sPrivs != null ? String.valueOf(sPrivs) + "," + sRole : sRole;
                                oRo.addProperty("Privileges", sPrivs);
                            }
                            oRoleVec.add(sRole);
                            oA.setRoles(oRoleVec);
                            this.m_oRes.getAccountList().addAccountForSID(sSID, oA);
                            bDone = true;
                        }
                        if (oRs != null) {
                            oRs.close();
                        }
                        if (oStmt != null) {
                            oStmt.close();
                        }
                        if (oConn != null) {
                            oConn.close();
                        }
                        if (bDone) {
                            return true;
                        }
                    }
                    catch (SQLException e) {
                        if (e.getErrorCode() == 942) break block12;
                        this.m_oLogger.debug("[x] Plugin: GetPrivilegesForAccounts failed in getAccountRolesAsAdmin()");
                        this.m_oLogger.debug("[x] Error msg: " + e.getMessage());
                    }
                }
            }
            ++i;
        }
        return true;
    }

    private boolean getPrivilegesForEachAccount(String sSID) {
        Account oA = null;
        Vector oAccountVector = null;
        Vector<String> oRoleVec = null;
        OracleDBConnection oDBConn = null;
        String sSQL = "SELECT granted_role FROM user_role_privs";
        String sPath = null;
        String sPrivs = null;
        oAccountVector = this.m_oRes.getAccountList().getOpenAccountsForSID(sSID);
        if (oAccountVector == null) {
            return false;
        }
        int i = 0;
        while (i < oAccountVector.size()) {
            oA = (Account)oAccountVector.get(i);
            oDBConn = new OracleDBConnection(this.m_sServer, this.m_nPort, sSID);
            this.m_oLogger.debug("[-] GetPrivilegesForAccounts() user:" + oA.getUsername() + ",pw:" + oA.getPassword() + ", sid: " + sSID);
            oDBConn.setUser(oA.getUsername());
            oDBConn.setPassword(oA.getPassword());
            oDBConn.login();
            Connection oConn = oDBConn.getConnection();
            if (oConn != null) {
                try {
                    Statement oStmt = oConn.createStatement();
                    ResultSet oRs = oStmt.executeQuery(sSQL);
                    oRoleVec = new Vector<String>();
                    while (oRs != null && oRs.next()) {
                        String sRole = oRs.getString("granted_role");
                        sPath = String.valueOf(this.m_sServer) + "/" + sSID + "/Accounts/" + oA.getUsername();
                        ReportObject oRo = this.m_oTree.findReportItem(sPath);
                        if (oRo != null) {
                            sPrivs = (String)oRo.getProperty("Privileges");
                            sPrivs = sPrivs != null ? String.valueOf(sPrivs) + "," + sRole : sRole;
                            oRo.addProperty("Privileges", sPrivs);
                        }
                        oRoleVec.add(oRs.getString("granted_role"));
                    }
                    if (oRs != null) {
                        oRs.close();
                    }
                    if (oStmt != null) {
                        oStmt.close();
                    }
                    if (oDBConn != null) {
                        oDBConn.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                if (oRoleVec.size() > 0) {
                    oA.setRoles((Vector)oRoleVec);
                    this.m_oRes.getAccountList().addAccountForSID(sSID, oA);
                }
            }
            ++i;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public int scan() {
        oSIDList = this.m_oRes.getSIDList();
        sSID = null;
        if (oSIDList.size() >= 1) ** GOTO lbl9
        return -1;
lbl-1000:
        // 1 sources

        {
            if (sSID.toLowerCase().indexOf("extproc") != -1 || this.getAccountPrivilegesAsAdmin(sSID)) continue;
            this.m_oLogger.debug("[x] Plugin: GetPrivilegesForAccounts failed retrieving roles using getAccountRolesAsAdmin (" + sSID + ")");
            this.getPrivilegesForEachAccount(sSID);
lbl9:
            // 3 sources

            ** while ((sSID = oSIDList.getNextSID()) != null)
        }
lbl10:
        // 1 sources

        return 0;
    }
}

